/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.action.TerminalPromptEditorActionHandler;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalMoveCaretActionHandler;", "Lorg/jetbrains/plugins/terminal/action/TerminalPromptEditorActionHandler;", "moveToStart", "", "<init>", "(Z)V", "executeAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.terminal"})
final class TerminalMoveCaretActionHandler
extends TerminalPromptEditorActionHandler {
    private final boolean moveToStart;

    public TerminalMoveCaretActionHandler(boolean moveToStart) {
        super(false, 1, null);
        this.moveToStart = moveToStart;
    }

    @Override
    public void executeAction(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        TerminalPromptModel terminalPromptModel = TerminalDataContextUtils.INSTANCE.getTerminalPromptModel(editor);
        if (terminalPromptModel == null) {
            throw new IllegalStateException("TerminalPromptModel should be in the context".toString());
        }
        TerminalPromptModel promptModel = terminalPromptModel;
        int lineIndex = editor.offsetToLogicalPosition((int)editor.getCaretModel().getOffset()).line;
        int newOffset = this.moveToStart ? Math.max(editor.getDocument().getLineStartOffset(lineIndex), promptModel.getCommandStartOffset()) : editor.getDocument().getLineEndOffset(lineIndex);
        ActionsKt.runWriteAction(() -> TerminalMoveCaretActionHandler.executeAction$lambda$0(editor, newOffset));
    }

    private static final Unit executeAction$lambda$0(Editor $editor, int $newOffset) {
        $editor.getCaretModel().moveToOffset($newOffset);
        return Unit.INSTANCE;
    }
}

