/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.history;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.ui.ScrollingUtil;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.history.CommandSearchPresenter;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/block/history/CommandSearchSelectNextHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "originalHandler", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabledForCaret", "", "intellij.terminal"})
public final class CommandSearchSelectNextHandler
extends EditorActionHandler {
    @NotNull
    private final EditorActionHandler originalHandler;

    public CommandSearchSelectNextHandler(@NotNull EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        this.originalHandler = originalHandler;
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        LookupImpl lookup;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)editor);
        LookupImpl lookupImpl = lookup = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
        boolean bl = lookupImpl != null ? CommandSearchPresenter.Companion.isTerminalCommandSearch((Lookup)lookupImpl) : false;
        if (bl) {
            ScrollingUtil.moveUp((JList)lookup.getList(), (int)0);
            lookup.markSelectionTouched();
            lookup.refreshUi(false, true);
        } else {
            this.originalHandler.execute(editor, caret, dataContext);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (TerminalDataContextUtils.INSTANCE.isPromptEditor(editor)) {
            boolean bl;
            LookupEx lookupEx = LookupManager.getActiveLookup((Editor)editor);
            if (lookupEx != null) {
                if (CommandSearchPresenter.Companion.isTerminalCommandSearch((Lookup)lookupEx)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
        }
        if (!this.originalHandler.isEnabled(editor, caret, dataContext)) return false;
        return true;
    }
}

