/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.ui;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterFreePainterAreaState;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.CharacterGrid;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jediterm.core.Color;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.ui.AwtTransformers;
import com.jediterm.terminal.util.CharUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.output.TextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.TextStyleAdapter;
import org.jetbrains.plugins.terminal.block.ui.TerminalColorScheme;
import org.jetbrains.plugins.terminal.block.ui.TerminalContrastRatio;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.session.TerminalGridSize;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J%\u0010\u0016\u001a\u00020\u00132\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0018\"\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0014\u0010%\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010'\u001a\u00020(H\u0007J\"\u0010)\u001a\u00020\u000f2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001dJ\u001c\u00102\u001a\u000203*\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0007J\u0012\u00109\u001a\u00020:*\u0002062\u0006\u0010;\u001a\u00020\u001dJ \u0010<\u001a\u00020:2\u0006\u0010=\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u0014\u0010>\u001a\u000208*\u0002042\u0006\u0010?\u001a\u000208H\u0002J\u0018\u0010@\u001a\u00020:2\u0006\u0010=\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0018\u0010A\u001a\u00020:2\u0006\u0010=\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u001a\u0010B\u001a\u0004\u0018\u00010:2\u0006\u0010=\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0018\u0010C\u001a\u00020:2\u0006\u0010=\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0018\u0010D\u001a\u00020:2\u0006\u0010=\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0016\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u001d2\u0006\u00105\u001a\u000206J\u001e\u0010H\u001a\u00020:2\u0006\u0010I\u001a\u00020:2\u0006\u0010J\u001a\u00020:2\u0006\u00107\u001a\u000200J\u001e\u0010K\u001a\u00020:2\u0006\u0010I\u001a\u00020:2\u0006\u0010J\u001a\u00020:2\u0006\u00107\u001a\u000200J\u001e\u0010L\u001a\u00020:2\u0006\u0010I\u001a\u00020:2\u0006\u0010J\u001a\u00020:2\u0006\u00107\u001a\u000200J\u000e\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020OJ\u0006\u0010R\u001a\u00020\u001dR\u000e\u0010P\u001a\u00020QX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020QX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\u001dX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020\u001dX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lorg/jetbrains/plugins/terminal/block/ui/TerminalUiUtils;", "", "<init>", "()V", "createOutputEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "installContextMenu", "", "installPopupMenu", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getPopupMenuGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "concatGroups", "groups", "", "([Lcom/intellij/openapi/actionSystem/ActionGroup;)Lcom/intellij/openapi/actionSystem/ActionGroup;", "createSingleShortcutSet", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "keyCode", "", "modifiers", "calculateTerminalSize", "Lorg/jetbrains/plugins/terminal/session/TerminalGridSize;", "componentSize", "Ljava/awt/Dimension;", "charSize", "Ljava/awt/geom/Dimension2D;", "getComponentSizeInitializedFuture", "Ljava/util/concurrent/CompletableFuture;", "component", "Ljava/awt/Component;", "cancelFutureByTimeout", "future", "timeoutMillis", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "toFloatAndScale", "", "value", "toTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "Lcom/jediterm/terminal/TextStyle;", "palette", "Lcom/intellij/terminal/TerminalColorPalette;", "requiredContrast", "Lorg/jetbrains/plugins/terminal/block/ui/TerminalContrastRatio;", "getAwtForegroundByIndex", "Ljava/awt/Color;", "colorIndex", "getResultForeground", "style", "getEffectiveContrastRatio", "base", "getEffectiveForegroundOrDefault", "getEffectiveBackgroundOrDefault", "getEffectiveBackgroundNoDefault", "toForeground", "toBackground", "plainAttributesProvider", "Lorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;", "foregroundColorIndex", "ensureContrastRatio", "bgColor", "fgColor", "reduceLuminance", "increaseLuminance", "shouldIgnoreContrastAdjustment", "char", "", "NEW_TERMINAL_OUTPUT_CAPACITY_KB", "", "getDefaultMaxOutputLength", "TERMINAL_OUTPUT_CONTEXT_MENU", "GREEN_COLOR_INDEX", "YELLOW_COLOR_INDEX", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalUiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,727:1\n1#2:728\n18#3:729\n*S KotlinDebug\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtils\n*L\n178#1:729\n*E\n"})
public final class TerminalUiUtils {
    @NotNull
    public static final TerminalUiUtils INSTANCE = new TerminalUiUtils();
    @NotNull
    public static final String NEW_TERMINAL_OUTPUT_CAPACITY_KB = "new.terminal.output.capacity.kb";
    @NotNull
    private static final String TERMINAL_OUTPUT_CONTEXT_MENU = "Terminal.OutputContextMenu";
    public static final int GREEN_COLOR_INDEX = 2;
    public static final int YELLOW_COLOR_INDEX = 3;

    private TerminalUiUtils() {
    }

    @NotNull
    public final EditorImpl createOutputEditor(@NotNull Document document, @NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, boolean installContextMenu) {
        EditorSettings editorSettings;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        UndoUtil.disableUndoFor((Document)document);
        Editor editor = EditorFactory.getInstance().createEditor(document, project, EditorKind.CONSOLE);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editor2 = (EditorImpl)editor;
        editor2.setScrollToCaret(false);
        editor2.setRendererMode(true);
        EditorModificationUtil.setShowReadOnlyHint((Editor)((Editor)editor2), (boolean)false);
        editor2.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        editor2.getScrollPane().setHorizontalScrollBarPolicy(31);
        editor2.getGutterComponentEx().setPaintBackground(false);
        editor2.getGutterComponentEx().setRightFreePaintersAreaState(EditorGutterFreePainterAreaState.HIDE);
        editor2.getContentComponent().setDropTarget(null);
        TerminalColorScheme terminalColorScheme = new TerminalColorScheme();
        editor2.setColorsScheme((EditorColorsScheme)terminalColorScheme);
        editor2.putUserData(TerminalColorScheme.Companion.getKEY(), (Object)terminalColorScheme);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable editorDisposable = disposable;
        EditorUtil.disposeWithEditor((Editor)((Editor)editor2), (Disposable)editorDisposable);
        MessageBusConnection $this$createOutputEditor_u24lambda_u240 = ApplicationManager.getApplication().getMessageBus().connect(editorDisposable);
        boolean bl = false;
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        $this$createOutputEditor_u24lambda_u240.subscribe(topic, arg_0 -> TerminalUiUtils.createOutputEditor$lambda$0$0(terminalColorScheme, arg_0));
        EditorSettings $this$createOutputEditor_u24lambda_u241 = editorSettings = editor2.getSettings();
        boolean bl2 = false;
        $this$createOutputEditor_u24lambda_u241.setShowingSpecialChars(false);
        $this$createOutputEditor_u24lambda_u241.setLineNumbersShown(false);
        $this$createOutputEditor_u24lambda_u241.setGutterIconsShown(false);
        $this$createOutputEditor_u24lambda_u241.setRightMarginShown(false);
        $this$createOutputEditor_u24lambda_u241.setFoldingOutlineShown(false);
        $this$createOutputEditor_u24lambda_u241.setCaretRowShown(false);
        $this$createOutputEditor_u24lambda_u241.setAdditionalLinesCount(0);
        $this$createOutputEditor_u24lambda_u241.setAdditionalColumnsCount(0);
        $this$createOutputEditor_u24lambda_u241.setAdditionalPageAtBottom(false);
        $this$createOutputEditor_u24lambda_u241.setBlockCursor(true);
        $this$createOutputEditor_u24lambda_u241.setWhitespacesShown(false);
        $this$createOutputEditor_u24lambda_u241.setUseCustomSoftWrapIndent(false);
        TerminalUiUtilsKt.applyFontSettings(editor2, settings);
        CharacterGrid characterGrid = editor2.getCharacterGrid();
        if (characterGrid == null) {
            boolean bl3 = false;
            String string = "The editor did not switch into the grid mode";
            throw new IllegalStateException(string.toString());
        }
        CharacterGrid editorGrid = characterGrid;
        editorGrid.setDoubleWidthCharacterStrategy(TerminalUiUtils::createOutputEditor$lambda$3);
        if (installContextMenu) {
            this.installPopupMenu((EditorEx)editor2);
        }
        return editor2;
    }

    private final void installPopupMenu(EditorEx editor) {
        editor.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(editor){
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
            }

            public ActionGroup getActionGroup(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return TerminalUiUtils.access$getPopupMenuGroup(TerminalUiUtils.INSTANCE, this.$editor, event);
            }
        });
    }

    private final ActionGroup getPopupMenuGroup(EditorEx editor, EditorMouseEvent event) {
        HyperlinkInfo info;
        ThreadingAssertions.assertEventDispatchThread();
        HyperlinkInfo $this$asSafely$iv = info = EditorHyperlinkSupport.get((Editor)((Editor)editor)).getHyperlinkInfoByEvent(event);
        boolean $i$f$asSafely = false;
        HyperlinkInfo hyperlinkInfo = $this$asSafely$iv;
        if (!(hyperlinkInfo instanceof HyperlinkWithPopupMenuInfo)) {
            hyperlinkInfo = null;
        }
        HyperlinkWithPopupMenuInfo hyperlinkWithPopupMenuInfo = (HyperlinkWithPopupMenuInfo)hyperlinkInfo;
        ActionGroup customPopupMenuGroup = hyperlinkWithPopupMenuInfo != null ? hyperlinkWithPopupMenuInfo.getPopupMenuGroup(event.getMouseEvent()) : null;
        AnAction anAction = ActionManager.getInstance().getAction(TERMINAL_OUTPUT_CONTEXT_MENU);
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup defaultPopupMenuGroup = (ActionGroup)anAction;
        ActionGroup[] actionGroupArray = new ActionGroup[]{customPopupMenuGroup, defaultPopupMenuGroup};
        return this.concatGroups(actionGroupArray);
    }

    private final ActionGroup concatGroups(ActionGroup ... groups) {
        Iterable iterable = ArraysKt.filterNotNull((Object[])groups);
        Collection collection = new ArrayList();
        int n = 0;
        for (Object t : iterable) {
            List list;
            int n2;
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ActionGroup actionGroup = (ActionGroup)t;
            int index = n2;
            boolean bl = false;
            if (index == 0) {
                list = CollectionsKt.listOf((Object)group);
            } else {
                Object[] objectArray = new AnAction[2];
                Intrinsics.checkNotNullExpressionValue((Object)Separator.create(), (String)"create(...)");
                objectArray[1] = group;
                list = CollectionsKt.listOf((Object[])objectArray);
            }
            CollectionsKt.addAll((Collection)collection, (Iterable)list);
        }
        List separatedGroups = (List)collection;
        return (ActionGroup)new DefaultActionGroup(separatedGroups);
    }

    @NotNull
    public final ShortcutSet createSingleShortcutSet(int keyCode, int modifiers) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        return (ShortcutSet)new CustomShortcutSet(keyStroke);
    }

    @NotNull
    public final TerminalGridSize calculateTerminalSize(@NotNull Dimension componentSize, @NotNull Dimension2D charSize) {
        Intrinsics.checkNotNullParameter((Object)componentSize, (String)"componentSize");
        Intrinsics.checkNotNullParameter((Object)charSize, (String)"charSize");
        double width = (double)componentSize.width / charSize.getWidth();
        double height = (double)componentSize.height / charSize.getHeight();
        return TerminalUiUtilsKt.access$ensureTermMinimumSize(new TerminalGridSize((int)width, (int)height));
    }

    @RequiresEdt
    @NotNull
    public final CompletableFuture<?> getComponentSizeInitializedFuture(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Dimension size = component2.getSize();
        if (size.width > 0 || size.height > 0) {
            CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        if (!UIUtil.isShowing((Component)component2, (boolean)false)) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(new IllegalStateException("component should be showing"));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
        CompletableFuture<Unit> componentResizedFuture = new CompletableFuture<Unit>();
        ComponentAdapter resizedListener2 = new ComponentAdapter(componentResizedFuture){
            final /* synthetic */ CompletableFuture<Unit> $componentResizedFuture;
            {
                this.$componentResizedFuture = $componentResizedFuture;
            }

            public void componentResized(ComponentEvent e) {
                this.$componentResizedFuture.complete(Unit.INSTANCE);
            }
        };
        component2.addComponentListener(resizedListener2);
        componentResizedFuture.whenComplete((arg_0, arg_1) -> TerminalUiUtils.getComponentSizeInitializedFuture$lambda$1((arg_0, arg_1) -> TerminalUiUtils.getComponentSizeInitializedFuture$lambda$0(component2, resizedListener2, arg_0, arg_1), arg_0, arg_1));
        return componentResizedFuture;
    }

    public final void cancelFutureByTimeout(@NotNull CompletableFuture<?> future, long timeoutMillis, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(future, (String)"future");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parentDisposable);
        Runnable request = () -> TerminalUiUtils.cancelFutureByTimeout$lambda$0(future, timeoutMillis);
        alarm.addRequest(request, timeoutMillis, ModalityState.any());
        Disposer.register((Disposable)((Disposable)alarm), () -> TerminalUiUtils.cancelFutureByTimeout$lambda$1(future));
        future.whenComplete((arg_0, arg_1) -> TerminalUiUtils.cancelFutureByTimeout$lambda$3((arg_0, arg_1) -> TerminalUiUtils.cancelFutureByTimeout$lambda$2(alarm, arg_0, arg_1), arg_0, arg_1));
    }

    public final float toFloatAndScale(int value) {
        return JBUIScale.scale((float)value);
    }

    @ApiStatus.Internal
    @NotNull
    public final TextAttributes toTextAttributes(@NotNull TextStyle $this$toTextAttributes, @NotNull TerminalColorPalette palette, @NotNull TerminalContrastRatio requiredContrast) {
        TextAttributes textAttributes;
        Intrinsics.checkNotNullParameter((Object)$this$toTextAttributes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        Intrinsics.checkNotNullParameter((Object)requiredContrast, (String)"requiredContrast");
        TextAttributes attr = textAttributes = new TextAttributes();
        boolean bl = false;
        attr.setBackgroundColor(INSTANCE.getEffectiveBackgroundNoDefault($this$toTextAttributes, palette));
        attr.setForegroundColor(INSTANCE.getResultForeground($this$toTextAttributes, palette, requiredContrast));
        if ($this$toTextAttributes.hasOption(TextStyle.Option.BOLD)) {
            attr.setFontType(attr.getFontType() | 1);
        }
        if ($this$toTextAttributes.hasOption(TextStyle.Option.ITALIC)) {
            attr.setFontType(attr.getFontType() | 2);
        }
        if ($this$toTextAttributes.hasOption(TextStyle.Option.UNDERLINED)) {
            attr.withAdditionalEffect(EffectType.LINE_UNDERSCORE, attr.getForegroundColor());
        }
        return textAttributes;
    }

    @NotNull
    public final java.awt.Color getAwtForegroundByIndex(@NotNull TerminalColorPalette $this$getAwtForegroundByIndex, int colorIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getAwtForegroundByIndex, (String)"<this>");
        Color color = (0 <= colorIndex ? colorIndex < 16 : false) ? $this$getAwtForegroundByIndex.getForeground(TerminalColor.index((int)colorIndex)) : $this$getAwtForegroundByIndex.getDefaultForeground();
        Intrinsics.checkNotNull((Object)color);
        Color color2 = color;
        java.awt.Color color3 = AwtTransformers.toAwtColor((Color)color2);
        Intrinsics.checkNotNull((Object)color3);
        return color3;
    }

    private final java.awt.Color getResultForeground(TextStyle style, TerminalColorPalette palette, TerminalContrastRatio requiredContrast) {
        java.awt.Color bg = this.getEffectiveBackgroundOrDefault(style, palette);
        java.awt.Color fg = this.getEffectiveForegroundOrDefault(style, palette);
        java.awt.Color dimmedFg = style.hasOption(TextStyle.Option.DIM) ? new java.awt.Color((fg.getRed() + bg.getRed()) / 2, (fg.getGreen() + bg.getGreen()) / 2, (fg.getBlue() + bg.getBlue()) / 2, fg.getAlpha()) : fg;
        TerminalContrastRatio contrast = this.getEffectiveContrastRatio(style, requiredContrast);
        if (Intrinsics.areEqual((Object)contrast, (Object)TerminalContrastRatio.Companion.getMIN_VALUE())) {
            return dimmedFg;
        }
        return this.ensureContrastRatio(bg, dimmedFg, contrast.getValue());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final TerminalContrastRatio getEffectiveContrastRatio(TextStyle $this$getEffectiveContrastRatio, TerminalContrastRatio base) {
        TerminalContrastRatio terminalContrastRatio;
        TerminalColor effectiveFg = $this$getEffectiveContrastRatio.hasOption(TextStyle.Option.INVERSE) ? $this$getEffectiveContrastRatio.getBackground() : $this$getEffectiveContrastRatio.getForeground();
        TerminalColor effectiveBg = $this$getEffectiveContrastRatio.hasOption(TextStyle.Option.INVERSE) ? $this$getEffectiveContrastRatio.getForeground() : $this$getEffectiveContrastRatio.getBackground();
        TerminalColor terminalColor = effectiveFg;
        boolean bl = terminalColor != null ? !terminalColor.isIndexed() : false;
        if (bl) {
            TerminalColor terminalColor2 = effectiveBg;
            boolean bl2 = terminalColor2 != null ? !terminalColor2.isIndexed() : false;
            if (bl2) {
                terminalContrastRatio = TerminalContrastRatio.Companion.getMIN_VALUE();
                return terminalContrastRatio;
            }
        }
        if ($this$getEffectiveContrastRatio.hasOption(TextStyle.Option.DIM)) {
            terminalContrastRatio = TerminalContrastRatio.Companion.ofFloat(base.getValue() / (float)2);
            return terminalContrastRatio;
        }
        terminalContrastRatio = base;
        return terminalContrastRatio;
    }

    private final java.awt.Color getEffectiveForegroundOrDefault(TextStyle style, TerminalColorPalette palette) {
        return style.hasOption(TextStyle.Option.INVERSE) ? this.toBackground(style, palette) : this.toForeground(style, palette);
    }

    private final java.awt.Color getEffectiveBackgroundOrDefault(TextStyle style, TerminalColorPalette palette) {
        return style.hasOption(TextStyle.Option.INVERSE) ? this.toForeground(style, palette) : this.toBackground(style, palette);
    }

    private final java.awt.Color getEffectiveBackgroundNoDefault(TextStyle style, TerminalColorPalette palette) {
        java.awt.Color color;
        if (style.hasOption(TextStyle.Option.INVERSE)) {
            color = this.toForeground(style, palette);
        } else {
            TerminalColor terminalColor = style.getBackground();
            if (terminalColor != null) {
                TerminalColor it = terminalColor;
                boolean bl = false;
                color = AwtTransformers.toAwtColor((Color)palette.getBackground(it));
            } else {
                color = null;
            }
        }
        return color;
    }

    private final java.awt.Color toForeground(TextStyle style, TerminalColorPalette palette) {
        TerminalColor terminalColor;
        block3: {
            block2: {
                terminalColor = style.getForeground();
                if (terminalColor == null) break block2;
                TerminalColor it = terminalColor;
                boolean bl = false;
                Color color = palette.getForeground(it);
                terminalColor = color;
                if (color != null) break block3;
            }
            terminalColor = palette.getDefaultForeground();
        }
        TerminalColor color = terminalColor;
        java.awt.Color color2 = AwtTransformers.toAwtColor((Color)color);
        Intrinsics.checkNotNull((Object)color2);
        return color2;
    }

    private final java.awt.Color toBackground(TextStyle style, TerminalColorPalette palette) {
        TerminalColor terminalColor;
        block3: {
            block2: {
                terminalColor = style.getBackground();
                if (terminalColor == null) break block2;
                TerminalColor it = terminalColor;
                boolean bl = false;
                Color color = palette.getBackground(it);
                terminalColor = color;
                if (color != null) break block3;
            }
            terminalColor = palette.getDefaultBackground();
        }
        TerminalColor color = terminalColor;
        java.awt.Color color2 = AwtTransformers.toAwtColor((Color)color);
        Intrinsics.checkNotNull((Object)color2);
        return color2;
    }

    @NotNull
    public final TextAttributesProvider plainAttributesProvider(int foregroundColorIndex, @NotNull TerminalColorPalette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new TextStyleAdapter(new TextStyle(new TerminalColor(foregroundColorIndex), null), palette, false, 4, null);
    }

    @NotNull
    public final java.awt.Color ensureContrastRatio(@NotNull java.awt.Color bgColor, @NotNull java.awt.Color fgColor, float requiredContrast) {
        java.awt.Color reducedColor;
        double reducedColorRatio;
        java.awt.Color increasedColor;
        double increasedColorRatio;
        java.awt.Color increasedColor2;
        double increasedColorRatio2;
        java.awt.Color reducedColor2;
        double reducedColorRatio2;
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        Intrinsics.checkNotNullParameter((Object)fgColor, (String)"fgColor");
        double current = ColorUtil.getContrast((java.awt.Color)fgColor, (java.awt.Color)bgColor);
        if (current >= (double)requiredContrast) {
            return fgColor;
        }
        double bgLuminance = ColorUtil.getLuminance((java.awt.Color)bgColor);
        double fgLuminance = ColorUtil.getLuminance((java.awt.Color)fgColor);
        java.awt.Color color = fgLuminance < bgLuminance ? ((reducedColorRatio2 = ColorUtil.getContrast((java.awt.Color)(reducedColor2 = this.reduceLuminance(bgColor, fgColor, requiredContrast)), (java.awt.Color)bgColor)) < (double)requiredContrast ? (reducedColorRatio2 > (increasedColorRatio2 = ColorUtil.getContrast((java.awt.Color)(increasedColor2 = this.increaseLuminance(bgColor, fgColor, requiredContrast)), (java.awt.Color)bgColor)) ? reducedColor2 : increasedColor2) : reducedColor2) : ((increasedColorRatio = ColorUtil.getContrast((java.awt.Color)(increasedColor = this.increaseLuminance(bgColor, fgColor, requiredContrast)), (java.awt.Color)bgColor)) < (double)requiredContrast ? (increasedColorRatio > (reducedColorRatio = ColorUtil.getContrast((java.awt.Color)(reducedColor = this.reduceLuminance(bgColor, fgColor, requiredContrast)), (java.awt.Color)bgColor)) ? increasedColor : reducedColor) : increasedColor);
        return color;
    }

    @NotNull
    public final java.awt.Color reduceLuminance(@NotNull java.awt.Color bgColor, @NotNull java.awt.Color fgColor, float requiredContrast) {
        int fgBlue;
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        Intrinsics.checkNotNullParameter((Object)fgColor, (String)"fgColor");
        double contrast = ColorUtil.getContrast((java.awt.Color)fgColor, (java.awt.Color)bgColor);
        int fgRed = fgColor.getRed();
        int fgGreen = fgColor.getGreen();
        for (fgBlue = fgColor.getBlue(); contrast < (double)requiredContrast && (fgRed > 0 || fgGreen > 0 || fgBlue > 0); fgRed -= (int)Math.ceil((double)fgRed * 0.1), fgGreen -= (int)Math.ceil((double)fgGreen * 0.1), fgBlue -= (int)Math.ceil((double)fgBlue * 0.1)) {
            java.awt.Color color = new java.awt.Color(fgRed, fgGreen, fgBlue);
            contrast = ColorUtil.getContrast((java.awt.Color)color, (java.awt.Color)bgColor);
        }
        return new java.awt.Color(fgRed, fgGreen, fgBlue);
    }

    @NotNull
    public final java.awt.Color increaseLuminance(@NotNull java.awt.Color bgColor, @NotNull java.awt.Color fgColor, float requiredContrast) {
        int fgBlue;
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        Intrinsics.checkNotNullParameter((Object)fgColor, (String)"fgColor");
        double contrast = ColorUtil.getContrast((java.awt.Color)fgColor, (java.awt.Color)bgColor);
        int fgRed = fgColor.getRed();
        int fgGreen = fgColor.getGreen();
        for (fgBlue = fgColor.getBlue(); contrast < (double)requiredContrast && (fgRed < 255 || fgGreen < 255 || fgBlue < 255); fgRed += (int)Math.ceil((double)(255 - fgRed) * 0.1), fgGreen += (int)Math.ceil((double)(255 - fgGreen) * 0.1), fgBlue += (int)Math.ceil((double)(255 - fgBlue) * 0.1)) {
            java.awt.Color color = new java.awt.Color(fgRed, fgGreen, fgBlue);
            contrast = ColorUtil.getContrast((java.awt.Color)color, (java.awt.Color)bgColor);
        }
        return new java.awt.Color(fgRed, fgGreen, fgBlue);
    }

    public final boolean shouldIgnoreContrastAdjustment(char c) {
        char c2 = c;
        return ('\ue0a4' <= c2 ? c2 < '\ue0d7' : false) ? true : ('\u2500' <= c2 ? c2 < '\u25a0' : false);
    }

    public final int getDefaultMaxOutputLength() {
        return RangesKt.coerceIn((int)AdvancedSettings.Companion.getInt(NEW_TERMINAL_OUTPUT_CAPACITY_KB), (int)1, (int)10240) * 1024;
    }

    private static final void createOutputEditor$lambda$0$0(TerminalColorScheme $terminalColorScheme, EditorColorsScheme it) {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        $terminalColorScheme.setGlobalScheme$intellij_terminal(editorColorsScheme);
    }

    private static final boolean createOutputEditor$lambda$3(int codePoint) {
        return CharUtils.isDoubleWidthCharacter((int)codePoint, (boolean)false);
    }

    private static final Unit getComponentSizeInitializedFuture$lambda$0(Component $component, getComponentSizeInitializedFuture.resizedListener.1 $resizedListener, Unit unit, Throwable throwable) {
        $component.removeComponentListener($resizedListener);
        return Unit.INSTANCE;
    }

    private static final void getComponentSizeInitializedFuture$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cancelFutureByTimeout$lambda$1$0(CompletableFuture $future) {
        $future.completeExceptionally(new IllegalStateException("parent disposed"));
        return Unit.INSTANCE;
    }

    private static final void cancelFutureByTimeout$lambda$0(CompletableFuture $future, long $timeoutMillis) {
        $future.completeExceptionally(new IllegalStateException("Terminal component layout is timed out (>" + $timeoutMillis + "ms)"));
    }

    private static final void cancelFutureByTimeout$lambda$1(CompletableFuture $future) {
        if (!$future.isDone()) {
            ActionsKt.invokeLater((ModalityState)ModalityState.any(), () -> TerminalUiUtils.cancelFutureByTimeout$lambda$1$0($future));
        }
    }

    private static final Unit cancelFutureByTimeout$lambda$2(Alarm $alarm, Object object, Throwable throwable) {
        Disposer.dispose((Disposable)((Disposable)$alarm));
        return Unit.INSTANCE;
    }

    private static final void cancelFutureByTimeout$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ ActionGroup access$getPopupMenuGroup(TerminalUiUtils $this, EditorEx editor, EditorMouseEvent event) {
        return $this.getPopupMenuGroup(editor, event);
    }
}

