/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.runner;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import com.pty4j.windows.conpty.WinConPtyProcess;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalStartupKt;
import org.jetbrains.plugins.terminal.util.ShellIntegration;
import org.jetbrains.plugins.terminal.util.ShellNameUtil;
import org.jetbrains.plugins.terminal.util.ShellType;

@ApiStatus.Internal
public final class LocalShellIntegrationInjector {
    @VisibleForTesting
    public static final String IJ_ZSH_DIR = "JETBRAINS_INTELLIJ_ZSH_DIR";
    private static final Logger LOG = Logger.getInstance(LocalShellIntegrationInjector.class);
    private static final String LOGIN_SHELL = "LOGIN_SHELL";
    private static final String JEDITERM_USER_RCFILE = "JEDITERM_USER_RCFILE";
    @VisibleForTesting
    public static final String ZDOTDIR = "ZDOTDIR";
    private static final String IJ_COMMAND_HISTORY_FILE_ENV = "__INTELLIJ_COMMAND_HISTFILE__";
    private static final String BASH_RCFILE_OPTION = "--rcfile";
    private static final String SHELL_INTEGRATIONS_DIR_NAME = "shell-integrations";

    @NotNull
    public static ShellStartupOptions injectShellIntegration(@NotNull ShellStartupOptions options, boolean isGenOneTerminal, boolean isGenTwoTerminal) {
        String remoteRcFilePath;
        if (options == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(0);
        }
        List<String> shellCommand = options.getShellCommand();
        String shellExe = (String)ContainerUtil.getFirstItem(shellCommand);
        if (shellCommand == null || shellExe == null) {
            ShellStartupOptions shellStartupOptions = options;
            if (shellStartupOptions == null) {
                LocalShellIntegrationInjector.$$$reportNull$$$0(1);
            }
            return shellStartupOptions;
        }
        ArrayList<String> arguments = new ArrayList<String>(shellCommand.subList(1, shellCommand.size()));
        Map<String, String> envs = ShellStartupOptionsKt.createEnvVariablesMap(options.getEnvVariables());
        ShellIntegration integration = null;
        ArrayList<String> resultCommand = new ArrayList<String>();
        resultCommand.add(shellExe);
        String shellName = PathUtil.getFileName((String)shellExe);
        Path rcFile = LocalShellIntegrationInjector.findRCFile(shellName);
        EelDescriptor eelDescriptor = TerminalStartupKt.findEelDescriptor(options.getWorkingDirectory(), shellCommand);
        String string = remoteRcFilePath = rcFile != null ? LocalShellIntegrationInjector.transferAndGetRemotePath(rcFile, eelDescriptor) : null;
        if (remoteRcFilePath != null) {
            boolean addBlocksIntegration = LocalShellIntegrationInjector.supportsBlocksShellIntegration(shellName, eelDescriptor);
            if (ShellNameUtil.isBash(shellName) || SystemInfo.isMac && shellName.equals("sh")) {
                LocalShellIntegrationInjector.addBashRcFileArgument(envs, arguments, resultCommand, remoteRcFilePath);
                boolean loginShell = arguments.removeAll(LocalTerminalDirectRunner.LOGIN_CLI_OPTIONS);
                LocalShellIntegrationInjector.setLoginShellEnv(envs, loginShell);
                LocalShellIntegrationInjector.setCommandHistoryFile(options, envs, eelDescriptor);
                integration = new ShellIntegration(ShellType.BASH, addBlocksIntegration);
            } else if (ShellNameUtil.isZshName(shellName)) {
                String originalZDotDir = envs.get(ZDOTDIR);
                if (StringUtil.isNotEmpty((String)originalZDotDir)) {
                    envs.put("JETBRAINS_INTELLIJ_ORIGINAL_ZDOTDIR", originalZDotDir);
                }
                String intellijZDotDir = PathUtil.getParentPath((String)remoteRcFilePath);
                envs.put(ZDOTDIR, intellijZDotDir);
                envs.put(IJ_ZSH_DIR, PathUtil.getParentPath((String)intellijZDotDir));
                integration = new ShellIntegration(ShellType.ZSH, addBlocksIntegration);
            } else if (shellName.equals("fish")) {
                resultCommand.add("--init-command=source " + CommandLineUtil.posixQuote((String)remoteRcFilePath));
                integration = new ShellIntegration(ShellType.FISH, addBlocksIntegration);
            } else if (ShellNameUtil.isPowerShell(shellName)) {
                resultCommand.addAll(arguments);
                arguments.clear();
                resultCommand.addAll(List.of("-NoExit", "-ExecutionPolicy", "Bypass", "-File", remoteRcFilePath));
                integration = new ShellIntegration(ShellType.POWERSHELL, addBlocksIntegration);
            }
        }
        if ((isGenOneTerminal || isGenTwoTerminal) && integration != null && integration.getCommandBlocks()) {
            String commandBlocksOption = isGenOneTerminal ? "INTELLIJ_TERMINAL_COMMAND_BLOCKS" : "INTELLIJ_TERMINAL_COMMAND_BLOCKS_REWORKED";
            envs.put(commandBlocksOption, "1");
            envs.put("FIG_TERM", "1");
            envs.put("PROCESS_LAUNCHED_BY_CW", "1");
            envs.put("PROCESS_LAUNCHED_BY_Q", "1");
        }
        resultCommand.addAll(arguments);
        ShellStartupOptions shellStartupOptions = options.builder().shellCommand(resultCommand).envVariables(envs).shellIntegration(integration).build();
        if (shellStartupOptions == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(2);
        }
        return shellStartupOptions;
    }

    @Nullable
    private static Path findRCFile(@NotNull String shellName) {
        String rcfile;
        if (shellName == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(3);
        }
        switch (shellName) {
            case "bash": 
            case "sh": {
                String string = "shell-integrations/bash/bash-integration.bash";
                break;
            }
            case "zsh": {
                String string = "shell-integrations/zsh/zdotdir/.zshenv";
                break;
            }
            case "fish": {
                String string = "shell-integrations/fish/fish-integration.fish";
                break;
            }
            default: {
                String string = rcfile = null;
            }
        }
        if (rcfile == null && ShellNameUtil.isPowerShell(shellName)) {
            rcfile = "shell-integrations/powershell/powershell-integration.ps1";
        }
        if (rcfile != null) {
            try {
                return LocalShellIntegrationInjector.findAbsolutePath(rcfile);
            }
            catch (Exception e) {
                LOG.warn("Unable to find " + rcfile + " configuration file", (Throwable)e);
            }
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    public static Path findAbsolutePath(@NotNull String relativePath) throws IOException {
        Path result2;
        if (relativePath == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(4);
        }
        if (!Files.isRegularFile(result2 = PluginManagerCore.isRunningFromSources() ? PluginPathManager.getPluginHome((String)"terminal").toPath().resolve("resources").resolve(relativePath) : (AppMode.isRunningFromDevBuild() ? PluginPathManager.getPluginHome((String)"terminal").toPath().resolve(relativePath) : Optional.ofNullable(PluginPathManager.getPluginResource(LocalShellIntegrationInjector.class, (String)relativePath)).orElseThrow(() -> new IOException("Cannot find " + relativePath)).toPath()), new LinkOption[0])) {
            throw new IOException("Cannot find " + relativePath + ": " + String.valueOf(result2) + " is not a file");
        }
        Path path = result2;
        if (path == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(5);
        }
        return path;
    }

    private static void setLoginShellEnv(@NotNull Map<String, String> envs, boolean loginShell) {
        if (envs == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(6);
        }
        if (loginShell) {
            envs.put(LOGIN_SHELL, "1");
        }
    }

    @Nullable
    private static String transferAndGetRemotePath(@NotNull Path localFileOrDir, @NotNull EelDescriptor eelDescriptor) {
        if (localFileOrDir == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(7);
        }
        if (eelDescriptor == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(8);
        }
        if (eelDescriptor == LocalEelDescriptor.INSTANCE) {
            return localFileOrDir.toString();
        }
        Path baseDirectory = LocalShellIntegrationInjector.findUpShellIntegrationBaseDirectory(localFileOrDir);
        if (baseDirectory == null) {
            return null;
        }
        try {
            String relativePath = baseDirectory.relativize(localFileOrDir).toString();
            Instant started = Instant.now();
            Path remoteBaseDirectory = EelPathUtils.transferLocalContentToRemote((Path)baseDirectory, (EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Temporary(eelDescriptor));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Transferred shell integration files to remote (" + eelDescriptor.getName() + ") in " + Duration.between(started, Instant.now()).toMillis() + "ms: " + String.valueOf(baseDirectory) + " -> " + String.valueOf(remoteBaseDirectory));
            }
            return EelNioBridgeServiceKt.asEelPath((Path)remoteBaseDirectory.resolve(relativePath)).toString();
        }
        catch (Exception e) {
            LOG.warn("Unable to transfer shell integration (" + String.valueOf(baseDirectory) + ") to remote (" + eelDescriptor.getName() + ")", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Path findUpShellIntegrationBaseDirectory(@NotNull Path shellIntegrationFile) {
        Path parent;
        if (shellIntegrationFile == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(9);
        }
        Path f = shellIntegrationFile;
        for (parent = f.getParent(); parent != null && !NioFiles.getFileName((Path)parent).equals(SHELL_INTEGRATIONS_DIR_NAME); parent = parent.getParent()) {
            f = parent;
        }
        if (parent == null) {
            LOG.warn("Unable to find shell integration directory for " + String.valueOf(shellIntegrationFile));
            return null;
        }
        return f;
    }

    private static void addBashRcFileArgument(Map<String, String> envs, List<String> arguments, List<String> result2, @NotNull String rcFilePath) {
        if (rcFilePath == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(10);
        }
        result2.add(BASH_RCFILE_OPTION);
        result2.add(rcFilePath);
        int idx = arguments.indexOf(BASH_RCFILE_OPTION);
        if (idx >= 0) {
            arguments.remove(idx);
            if (idx < arguments.size()) {
                String userRcFile = OSAgnosticPathUtil.expandUserHome((String)arguments.get(idx));
                if (!userRcFile.equals(rcFilePath)) {
                    envs.put(JEDITERM_USER_RCFILE, userRcFile);
                }
                arguments.remove(idx);
            }
        }
    }

    private static void setCommandHistoryFile(@NotNull ShellStartupOptions startupOptions, @NotNull Map<String, String> envs, @NotNull EelDescriptor eelDescriptor) {
        Path commandHistoryFile;
        if (startupOptions == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(11);
        }
        if (envs == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(12);
        }
        if (eelDescriptor == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(13);
        }
        if (eelDescriptor != LocalEelDescriptor.INSTANCE) {
            return;
        }
        Function0<Path> commandHistoryFileProvider = startupOptions.getCommandHistoryFileProvider();
        Path path = commandHistoryFile = commandHistoryFileProvider != null ? (Path)commandHistoryFileProvider.invoke() : null;
        if (commandHistoryFile != null) {
            envs.put(IJ_COMMAND_HISTORY_FILE_ENV, commandHistoryFile.toString());
            ShellTerminalWidget widget = LocalShellIntegrationInjector.getShellTerminalWidget(startupOptions);
            if (widget != null) {
                widget.setCommandHistoryFilePath(commandHistoryFile.toString());
            }
        }
    }

    @Nullable
    private static ShellTerminalWidget getShellTerminalWidget(@Nullable ShellStartupOptions options) {
        TerminalWidget widget = options != null ? options.getWidget() : null;
        return widget != null ? ShellTerminalWidget.asShellJediTermWidget(widget) : null;
    }

    public static boolean supportsBlocksShellIntegration(@NotNull String shellName, @NotNull EelDescriptor eelDescriptor) {
        if (shellName == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(14);
        }
        if (eelDescriptor == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(15);
        }
        return LocalShellIntegrationInjector.isCommandBlockShellIntegrationAvailable(shellName, eelDescriptor) && LocalShellIntegrationInjector.isSystemCompatibleWithCommandBlocks(eelDescriptor);
    }

    private static boolean isCommandBlockShellIntegrationAvailable(@NotNull String shellName, @NotNull EelDescriptor eelDescriptor) {
        if (shellName == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(16);
        }
        if (eelDescriptor == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(17);
        }
        return shellName.equals("bash") || eelDescriptor == LocalEelDescriptor.INSTANCE && OS.CURRENT == OS.macOS && shellName.equals("sh") || shellName.equals("zsh") || shellName.equals("fish") && Registry.is((String)"terminal.new.ui.fish", (boolean)false) || ShellNameUtil.isPowerShell(shellName);
    }

    private static boolean isSystemCompatibleWithCommandBlocks(@NotNull EelDescriptor eelDescriptor) {
        if (eelDescriptor == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(18);
        }
        if (!EelPlatformKt.isWindows((EelOsFamily)eelDescriptor.getOsFamily())) {
            return true;
        }
        return eelDescriptor == LocalEelDescriptor.INSTANCE && LocalPtyOptions.shouldUseWinConPty() && WinConPtyProcess.isBundledConPtyLibraryLoaded();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/runner/LocalShellIntegrationInjector";
                break;
            }
            case 3: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileOrDir";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eelDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellIntegrationFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rcFilePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/runner/LocalShellIntegrationInjector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "injectShellIntegration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "injectShellIntegration";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findRCFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAbsolutePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setLoginShellEnv";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "transferAndGetRemotePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findUpShellIntegrationBaseDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addBashRcFileArgument";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCommandHistoryFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "supportsBlocksShellIntegration";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCommandBlockShellIntegrationAvailable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSystemCompatibleWithCommandBlocks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5 -> new IllegalStateException(string);
        };
    }
}

