/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.codeinsight;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonStringLiteral;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u000b\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a7\u0010\u000e\u001a\u0015\u0012\u0004\u0012\u00020\u0010\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\f\u0018\u00010\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0007\"\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"INF_LITERAL", "", "MINUS_INF_LITERAL", "NAN_LITERAL", "VALID_ESCAPE", "Lkotlin/text/Regex;", "getVALID_ESCAPE$annotations", "()V", "VALID_NUMBER_LITERAL", "VALID_HEX_ESCAPE", "INVALID_NUMERIC_ESCAPE", "getErrorForNumericLiteral", "Lcom/intellij/codeInspection/util/InspectionMessage;", "literalText", "getErrorForStringFragment", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/util/TextRange;", "fragment", "stringLiteral", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonStringLiteral;", "getStringError", "fragmentText", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonLiteralChecksKt {
    @NotNull
    public static final String INF_LITERAL = "Infinity";
    @NotNull
    public static final String MINUS_INF_LITERAL = "-Infinity";
    @NotNull
    public static final String NAN_LITERAL = "NaN";
    @NotNull
    private static final Regex VALID_ESCAPE = new Regex("\\\\([\"\\\\/bfnrt]|u[0-9a-fA-F]{4})");
    @NotNull
    private static final Regex VALID_NUMBER_LITERAL = new Regex("-?(0|[1-9][0-9]*)(\\.[0-9]+)?([eE][+-]?[0-9]+)?");
    @NotNull
    private static final Regex VALID_HEX_ESCAPE = new Regex("\\\\(x[0-9a-fA-F]{2})");
    @NotNull
    private static final Regex INVALID_NUMERIC_ESCAPE = new Regex("\\\\[1-9]");

    private static /* synthetic */ void getVALID_ESCAPE$annotations() {
    }

    @Nullable
    public static final String getErrorForNumericLiteral(@NotNull String literalText) {
        Intrinsics.checkNotNullParameter((Object)literalText, (String)"literalText");
        return !Intrinsics.areEqual((Object)INF_LITERAL, (Object)literalText) && !Intrinsics.areEqual((Object)MINUS_INF_LITERAL, (Object)literalText) && !Intrinsics.areEqual((Object)NAN_LITERAL, (Object)literalText) && !VALID_NUMBER_LITERAL.matches((CharSequence)literalText) ? JsonBundle.message((String)"syntax.error.illegal.floating.point.literal", (Object[])new Object[0]) : null;
    }

    @Nullable
    public static final Pair<TextRange, String> getErrorForStringFragment(@NotNull Pair<TextRange, String> fragment, @NotNull MongoDBJsonStringLiteral stringLiteral) {
        String text;
        Intrinsics.checkNotNullParameter(fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)stringLiteral, (String)"stringLiteral");
        String fragmentText = (String)fragment.second;
        Intrinsics.checkNotNull((Object)fragmentText);
        if (StringsKt.startsWith$default((String)fragmentText, (String)"\\", (boolean)false, (int)2, null) && fragmentText.length() > 1 && StringsKt.endsWith$default((String)fragmentText, (String)"\n", (boolean)false, (int)2, null)) {
            String string = fragmentText.substring(1, fragmentText.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (StringUtil.isEmptyOrSpaces((String)string)) {
                return null;
            }
        }
        if (StringsKt.startsWith$default((String)fragmentText, (String)"\\x", (boolean)false, (int)2, null) && VALID_HEX_ESCAPE.matches((CharSequence)fragmentText)) {
            return null;
        }
        if (!VALID_ESCAPE.matches((CharSequence)fragmentText) && !INVALID_NUMERIC_ESCAPE.matches((CharSequence)fragmentText)) {
            return null;
        }
        if (fragmentText.chars().anyMatch(MongoDBJsonLiteralChecksKt::getErrorForStringFragment$lambda$0) && new TextRange(0, (text = stringLiteral.getText()).length()).contains((TextRange)fragment.first)) {
            int startOffset = ((TextRange)fragment.first).getStartOffset();
            Intrinsics.checkNotNull((Object)text);
            String string = text.substring(startOffset, ((TextRange)fragment.first).getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String part = string;
            char[] cArray = part.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] array = cArray;
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                char c = array[i];
                if (Intrinsics.compare((int)c, (int)31) > 0) continue;
                TextRange textRange = new TextRange(startOffset + i, startOffset + i + 1);
                Object[] objectArray = new Object[1];
                String string2 = Integer.toHexString(c | 0x10000);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(...)");
                String string3 = string2;
                int n2 = 1;
                String string4 = string3.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                objectArray[0] = "\\u" + string4;
                return Pair.create((Object)textRange, (Object)JsonBundle.message((String)"syntax.error.control.char.in.string", (Object[])objectArray));
            }
        }
        Object object = fragment.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        String error = MongoDBJsonLiteralChecksKt.getStringError((String)object);
        return error == null ? null : Pair.create((Object)fragment.first, (Object)error);
    }

    private static final String getStringError(String fragmentText) {
        return StringsKt.startsWith$default((String)fragmentText, (String)"\\", (boolean)false, (int)2, null) && fragmentText.length() > 1 && !VALID_ESCAPE.matches((CharSequence)fragmentText) ? (StringsKt.startsWith$default((String)fragmentText, (String)"\\u", (boolean)false, (int)2, null) ? JsonBundle.message((String)"syntax.error.illegal.unicode.escape.sequence", (Object[])new Object[0]) : JsonBundle.message((String)"syntax.error.illegal.escape.sequence", (Object[])new Object[0])) : null;
    }

    private static final boolean getErrorForStringFragment$lambda$0(int c) {
        return c <= 31;
    }
}

