/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.intentions;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.dialects.mongo.MongoDialect;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceBundle;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H$J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH$J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J\"\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u0007H$J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J \u0010!\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020 H\u0002J&\u0010%\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u000e\u0010(\u001a\u0004\u0018\u00010\u0007*\u00020\tH\u0004J\u0016\u0010)\u001a\u0004\u0018\u00010\u0007*\u00020\t2\u0006\u0010*\u001a\u00020\u0007H\u0004J\u0014\u0010+\u001a\u00020\u0012*\u00020\t2\u0006\u0010*\u001a\u00020\u0007H\u0004J\u0012\u0010,\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a8\u0006-"}, d2={"Lcom/intellij/persistence/mongodb/json/intentions/MongoDBJsonQueryConsoleProvider;", "Lcom/intellij/database/script/PersistenceConsoleProvider;", "<init>", "()V", "getSupportedLanguage", "Lcom/intellij/lang/Language;", "getCollectionName", "", "uAnnotation", "Lorg/jetbrains/uast/UAnnotation;", "generateQuery", "collectionName", "getQueryParameters", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "query", "hasRunners", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "psiElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getRunners", "Lcom/intellij/database/script/PersistenceConsoleProvider$Runner;", "insertQuery", "", "project", "Lcom/intellij/openapi/project/Project;", "consolePsiFile", "Lcom/intellij/psi/PsiFile;", "replaceParametersWithPlaceholders", "offset", "", "psiFile", "findDatasourceAndSchema", "Lcom/intellij/database/psi/DbDataSource;", "Lcom/intellij/database/model/DasNamespace;", "getValue", "getStringAttributeValue", "attribute", "getBooleanAttributeValue", "generateQueryForTest", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nMongoDBJsonQueryConsoleProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoDBJsonQueryConsoleProvider.kt\ncom/intellij/persistence/mongodb/json/intentions/MongoDBJsonQueryConsoleProvider\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,164:1\n24#2:165\n24#2:166\n*S KotlinDebug\n*F\n+ 1 MongoDBJsonQueryConsoleProvider.kt\ncom/intellij/persistence/mongodb/json/intentions/MongoDBJsonQueryConsoleProvider\n*L\n160#1:165\n71#1:166\n*E\n"})
public abstract class MongoDBJsonQueryConsoleProvider
extends PersistenceConsoleProvider {
    @NotNull
    protected abstract Language getSupportedLanguage();

    @Nullable
    protected abstract String getCollectionName(@NotNull UAnnotation var1);

    @Nullable
    protected abstract String generateQuery(@NotNull String var1, @NotNull UAnnotation var2);

    @NotNull
    protected abstract List<Pair<String, TextRange>> getQueryParameters(@NotNull String var1);

    public boolean hasRunners(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return false;
    }

    public boolean hasRunners(@NotNull PsiElement psiElement, @Nullable Editor editor) {
        boolean bl;
        UMethod uMethod;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiFile psiFile = (PsiFile)PsiTreeUtil.getTopmostParentOfType((PsiElement)psiElement, PsiFile.class);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        if (!Intrinsics.areEqual((Object)psiFile2.getLanguage(), (Object)this.getSupportedLanguage())) {
            return false;
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)InjectedLanguageManager.getInstance((Project)psiFile2.getProject()).getInjectionHost((PsiElement)psiFile2)));
        if (uElement == null || (uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)uElement, UMethod.class, (boolean)false, (int)2, null)) == null) {
            return false;
        }
        UMethod uMethod2 = uMethod;
        uElement = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)uMethod2), UClass.class, (boolean)false, (int)2, null);
        if (uElement != null) {
            UElement uClass = uElement;
            boolean bl2 = false;
            bl = uClass.isInterface() && !uClass.isAnnotationType();
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiElement psiElement, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Triple triple = (Triple)ReadAction.nonBlocking(() -> MongoDBJsonQueryConsoleProvider.getRunners$lambda$0(project2, psiElement, this)).withDocumentsCommitted(psiElement.getProject()).inSmartMode(psiElement.getProject()).executeSynchronously();
        if (triple == null) {
            return CollectionsKt.emptyList();
        }
        Triple triple2 = triple;
        DbDataSource datasource = (DbDataSource)triple2.component1();
        DasNamespace schema = (DasNamespace)triple2.component2();
        String query = (String)triple2.component3();
        PersistenceConsoleProvider.Runner runner = DatabaseRunners.createDataSourceConsolesRunner((DbDataSource)datasource, arg_0 -> MongoDBJsonQueryConsoleProvider.getRunners$lambda$2(arg_0 -> MongoDBJsonQueryConsoleProvider.getRunners$lambda$1(project2, datasource, schema, this, psiElement, query, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)runner, (String)"createDataSourceConsolesRunner(...)");
        PersistenceConsoleProvider.Runner runner2 = runner;
        return CollectionsKt.listOf((Object)runner2);
    }

    private final void insertQuery(Project project, PsiFile consolePsiFile, String query) {
        if (consolePsiFile == null) {
            return;
        }
        Document consoleDocument = consolePsiFile.getViewProvider().getDocument();
        int consoleOffset = consoleDocument.getTextLength();
        Object textToInsert = consoleOffset == 0 ? query : "\n\n" + query;
        WriteCommandAction.runWriteCommandAction((Project)project, (String)PersistenceBundle.message("mongodb.json.insert.query.command", new Object[0]), null, () -> MongoDBJsonQueryConsoleProvider.insertQuery$lambda$0(consoleDocument, consoleOffset, (String)textToInsert), (PsiFile[])new PsiFile[0]);
        PsiDocumentManager.getInstance((Project)project).performForCommittedDocument(consoleDocument, () -> MongoDBJsonQueryConsoleProvider.insertQuery$lambda$1(consoleOffset, this, query, consolePsiFile));
    }

    private final void replaceParametersWithPlaceholders(String query, int offset, PsiFile psiFile) {
        Editor editor = PsiEditorUtil.findEditor((PsiElement)((PsiElement)psiFile));
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)PersistenceBundle.message("mongodb.json.replace.placeholder", new Object[0]), null, () -> MongoDBJsonQueryConsoleProvider.replaceParametersWithPlaceholders$lambda$0(psiFile, this, query, offset, editor2, project2), (PsiFile[])new PsiFile[0]);
    }

    private final Pair<DbDataSource, DasNamespace> findDatasourceAndSchema(Project project, String collectionName) {
        for (DbDataSource dataSource : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            DasTable table;
            DasNamespace schema;
            if (!(dataSource.getDatabaseDialect() instanceof MongoDialect) || (schema = DasUtil.getNamespace((DasObject)((DasObject)(table = (DasTable)DasUtil.getTables((DasDataSource)((DasDataSource)dataSource)).find(arg_0 -> MongoDBJsonQueryConsoleProvider.findDatasourceAndSchema$lambda$1(arg_0 -> MongoDBJsonQueryConsoleProvider.findDatasourceAndSchema$lambda$0(collectionName, arg_0), arg_0)))))) == null) continue;
            return TuplesKt.to((Object)dataSource, (Object)schema);
        }
        return null;
    }

    @Nullable
    protected final String getValue(@NotNull UAnnotation $this$getValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getValue, (String)"<this>");
        return this.getStringAttributeValue($this$getValue, "value");
    }

    @Nullable
    protected final String getStringAttributeValue(@NotNull UAnnotation $this$getStringAttributeValue, @NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)$this$getStringAttributeValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        UExpression uExpression = $this$getStringAttributeValue.findDeclaredAttributeValue(attribute);
        return uExpression != null ? UastUtils.evaluateString((UExpression)uExpression) : null;
    }

    protected final boolean getBooleanAttributeValue(@NotNull UAnnotation $this$getBooleanAttributeValue, @NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)$this$getBooleanAttributeValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        UExpression uExpression = $this$getBooleanAttributeValue.findDeclaredAttributeValue(attribute);
        Object object = uExpression != null ? uExpression.evaluate() : null;
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return bl != null ? bl : false;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @Nullable
    public final String generateQueryForTest(@NotNull PsiElement psiElement) {
        UAnnotation uAnnotation;
        block5: {
            block4: {
                void $this$getParentOfType_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
                UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)InjectedLanguageManager.getInstance((Project)psiElement.getProject()).getInjectionHost(psiElement)));
                if (uElement == null) break block4;
                UElement uElement2 = uElement;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                uAnnotation = (UAnnotation)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UAnnotation.class, (boolean)strict$iv);
                if (uAnnotation != null) break block5;
            }
            return null;
        }
        UAnnotation uAnnotation2 = uAnnotation;
        String string = this.getCollectionName(uAnnotation2);
        if (string == null) {
            return null;
        }
        String collectionName = string;
        return this.generateQuery(collectionName, uAnnotation2);
    }

    private static final PsiFile getRunners$lambda$1$0(Project $project, VirtualFile $consoleVFile) {
        return PsiManager.getInstance((Project)$project).findFile($consoleVFile);
    }

    private static final Unit getRunners$lambda$1$1(MongoDBJsonQueryConsoleProvider this$0, PsiElement $psiElement, String $query, PsiFile psiFile) {
        Project project = $psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this$0.insertQuery(project, psiFile, $query);
        return Unit.INSTANCE;
    }

    private static final void getRunners$lambda$1$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Triple getRunners$lambda$0(Project $project, PsiElement $psiElement, MongoDBJsonQueryConsoleProvider this$0) {
        Pair<DbDataSource, DasNamespace> pair;
        block7: {
            block6: {
                void $this$getParentOfType_u24default$iv;
                UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)InjectedLanguageManager.getInstance((Project)$project).getInjectionHost($psiElement)));
                if (uElement == null) break block6;
                UElement uElement2 = uElement;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                pair = (Pair<DbDataSource, DasNamespace>)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UAnnotation.class, (boolean)strict$iv);
                if (pair != null) break block7;
            }
            return null;
        }
        Pair<DbDataSource, DasNamespace> uAnnotation = pair;
        String string = this$0.getCollectionName((UAnnotation)uAnnotation);
        if (string == null) {
            return null;
        }
        String collectionName = string;
        Pair<DbDataSource, DasNamespace> pair2 = this$0.findDatasourceAndSchema($project, collectionName);
        if (pair2 == null) {
            return null;
        }
        pair = pair2;
        DbDataSource datasource = (DbDataSource)pair.component1();
        DasNamespace schema = (DasNamespace)pair.component2();
        String string2 = this$0.generateQuery(collectionName, (UAnnotation)uAnnotation);
        if (string2 == null) {
            return null;
        }
        String query = string2;
        return new Triple((Object)datasource, (Object)schema, (Object)query);
    }

    private static final Unit getRunners$lambda$1(Project $project, DbDataSource $datasource, DasNamespace $schema, MongoDBJsonQueryConsoleProvider this$0, PsiElement $psiElement, String $query, VirtualFile consoleVFile) {
        DatabaseEditorHelper.openConsoleForFile((Project)$project, (DasDataSource)((DasDataSource)$datasource), (DasNamespace)$schema, (VirtualFile)consoleVFile);
        Object[] objectArray = new Object[]{this$0};
        ReadAction.nonBlocking(() -> MongoDBJsonQueryConsoleProvider.getRunners$lambda$1$0($project, consoleVFile)).coalesceBy(objectArray).finishOnUiThread(ModalityState.current(), arg_0 -> MongoDBJsonQueryConsoleProvider.getRunners$lambda$1$2(arg_0 -> MongoDBJsonQueryConsoleProvider.getRunners$lambda$1$1(this$0, $psiElement, $query, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        return Unit.INSTANCE;
    }

    private static final void getRunners$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void insertQuery$lambda$0(Document $consoleDocument, int $consoleOffset, String $textToInsert) {
        $consoleDocument.insertString($consoleOffset, (CharSequence)$textToInsert);
    }

    private static final void insertQuery$lambda$1(int $consoleOffset, MongoDBJsonQueryConsoleProvider this$0, String $query, PsiFile $consolePsiFile) {
        int offset = $consoleOffset == 0 ? 0 : $consoleOffset + 2;
        this$0.replaceParametersWithPlaceholders($query, offset, $consolePsiFile);
    }

    private static final void replaceParametersWithPlaceholders$lambda$0(PsiFile $psiFile, MongoDBJsonQueryConsoleProvider this$0, String $query, int $offset, Editor $editor, Project $project) {
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)$psiFile);
        Iterator iterator = ((Iterable)this$0.getQueryParameters($query)).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            Pair param = (Pair)iterator.next();
            String paramText = (String)param.component1();
            TextRange range = (TextRange)param.component2();
            templateBuilder.replaceRange(range.shiftRight($offset), "VAR" + idx, (Expression)new ConstantNode(paramText), true);
        }
        $editor.getCaretModel().moveToOffset(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)$psiFile)));
        TemplateManager.getInstance((Project)$project).startTemplate($editor, templateBuilder.buildInlineTemplate(), (TemplateEditingListener)new TemplateEditingAdapter($editor, $offset){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ int $offset;
            {
                this.$editor = $editor;
                this.$offset = $offset;
            }

            public void templateFinished(Template template, boolean brokenOff) {
                Intrinsics.checkNotNullParameter((Object)template, (String)"template");
                this.$editor.getCaretModel().moveToOffset(this.$offset);
            }
        });
    }

    private static final boolean findDatasourceAndSchema$lambda$0(String $collectionName, DasTable table) {
        return Intrinsics.areEqual((Object)((DasNamed)table).getName(), (Object)$collectionName);
    }

    private static final boolean findDatasourceAndSchema$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

