/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.util;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.SelectionModelWithViewRows;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u0001*\u0004\u0018\u00010\u0004H\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u0004H\u0000\u00a8\u0006\u0007"}, d2={"hasTableWithSelection", "", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "hasVisibleSelection", "Lcom/intellij/database/datagrid/DataGrid;", "selectedRowsCount", "", "intellij.database.impl"})
public final class TableSelectionUtilsKt {
    public static final boolean hasTableWithSelection(@NotNull AnActionEvent $this$hasTableWithSelection) {
        Intrinsics.checkNotNullParameter((Object)$this$hasTableWithSelection, (String)"<this>");
        DataGrid dataGrid = GridUtil.getDataGrid((DataContext)$this$hasTableWithSelection.getDataContext());
        if (dataGrid == null) {
            return false;
        }
        DataGrid grid = dataGrid;
        Editor editor2 = (Editor)$this$hasTableWithSelection.getData(CommonDataKeys.EDITOR);
        return editor2 == null && TableSelectionUtilsKt.hasVisibleSelection(grid);
    }

    public static final boolean hasVisibleSelection(@Nullable DataGrid $this$hasVisibleSelection) {
        if ($this$hasVisibleSelection == null) {
            return false;
        }
        if ($this$hasVisibleSelection.getVisibleColumnCount() == 0) {
            return false;
        }
        return TableSelectionUtilsKt.selectedRowsCount($this$hasVisibleSelection) > 0;
    }

    public static final int selectedRowsCount(@Nullable DataGrid $this$selectedRowsCount) {
        if ($this$selectedRowsCount == null) {
            return 0;
        }
        SelectionModel selectionModel = $this$selectedRowsCount.getSelectionModel();
        SelectionModelWithViewRows selectionModelWithViewRows = selectionModel instanceof SelectionModelWithViewRows ? (SelectionModelWithViewRows)selectionModel : null;
        if (selectionModelWithViewRows == null) {
            return 0;
        }
        SelectionModelWithViewRows selectionModel2 = selectionModelWithViewRows;
        return selectionModel2.selectedViewRowsCount();
    }
}

