/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.migration.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.migration.ConsolesMigrationManagerImpl;
import com.intellij.database.console.migration.view.CheckBoxNode;
import com.intellij.database.console.migration.view.ConsoleNode;
import com.intellij.database.console.migration.view.ConsolesMigrationChoosingTreeKt;
import com.intellij.database.console.migration.view.DataSourceNode;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/console/migration/view/ConsolesMigrationChoosingTree;", "Lcom/intellij/ui/CheckboxTree;", "migrationInfo", "Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo;", "rootNode", "Lcom/intellij/ui/CheckedTreeNode;", "<init>", "(Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo;Lcom/intellij/ui/CheckedTreeNode;)V", "consolesToMigrate", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "allConsoles", "", "", "updateConsoleStatus", "", "node", "addConsoleSelectionListener", "listener", "Lcom/intellij/database/console/migration/view/ConsolesMigrationChoosingTree$ConsoleSelectedListener;", "CheckBoxCellRenderer", "ConsoleSelectedListener", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nConsolesMigrationChoosingTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsolesMigrationChoosingTree.kt\ncom/intellij/database/console/migration/view/ConsolesMigrationChoosingTree\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,165:1\n221#2:166\n222#2:170\n1068#3:167\n1915#3,2:168\n383#4,7:171\n*S KotlinDebug\n*F\n+ 1 ConsolesMigrationChoosingTree.kt\ncom/intellij/database/console/migration/view/ConsolesMigrationChoosingTree\n*L\n35#1:166\n35#1:170\n39#1:167\n39#1:168,2\n78#1:171,7\n*E\n"})
public final class ConsolesMigrationChoosingTree
extends CheckboxTree {
    @NotNull
    private final Map<LocalDataSource, List<VirtualFile>> consolesToMigrate;
    @NotNull
    private final Map<LocalDataSource, List<VirtualFile>> allConsoles;

    /*
     * WARNING - void declaration
     */
    public ConsolesMigrationChoosingTree(@NotNull ConsolesMigrationManagerImpl.MigrationInfo migrationInfo, @NotNull CheckedTreeNode rootNode) {
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        super((CheckboxTree.CheckboxTreeCellRenderer)new CheckBoxCellRenderer(), rootNode, new CheckboxTreeBase.CheckPolicy(true, true, true, true, false, 16, null));
        this.consolesToMigrate = migrationInfo.getConsolesToMigrate();
        this.allConsoles = migrationInfo.getAllConsoles();
        String string = DatabaseBundle.message((String)"separator.project.data.sources", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        CheckBoxNode projectDataSourceNode = new CheckBoxNode(string, null, null, 4, null);
        String string2 = DatabaseBundle.message((String)"separator.global.data.sources", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        CheckBoxNode globalDataSourceNode = new CheckBoxNode(string2, null, null, 4, null);
        Map<LocalDataSource, List<VirtualFile>> $this$forEach$iv = this.allConsoles;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<LocalDataSource, List<VirtualFile>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Map.Entry<LocalDataSource, List<VirtualFile>> element$iv;
            Map.Entry<LocalDataSource, List<VirtualFile>> entry = element$iv = iterator.next();
            boolean bl = false;
            LocalDataSource dataSource = entry.getKey();
            List<VirtualFile> files2 = entry.getValue();
            String string3 = dataSource.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            DataSourceNode dataSourceNode = new DataSourceNode(string3, dataSource.getIcon());
            if (dataSource.isGlobal()) {
                globalDataSourceNode.add((MutableTreeNode)((Object)dataSourceNode));
            } else {
                projectDataSourceNode.add((MutableTreeNode)((Object)dataSourceNode));
            }
            Iterable $this$sortedBy$iv = files2;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    VirtualFile it = (VirtualFile)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (VirtualFile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                void node;
                ConsoleNode consoleNode;
                VirtualFile it = (VirtualFile)element$iv2;
                boolean bl2 = false;
                String string4 = it.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getNameWithoutExtension(...)");
                ConsoleNode consoleNode2 = consoleNode = new ConsoleNode(string4, dataSource.getIcon(), it, dataSource);
                DataSourceNode dataSourceNode2 = dataSourceNode;
                boolean bl3 = false;
                List<VirtualFile> list = this.consolesToMigrate.get(dataSource);
                node.setChecked(list != null ? list.contains(it) : false);
                dataSourceNode2.add((MutableTreeNode)((Object)consoleNode));
            }
            ConsolesMigrationChoosingTreeKt.access$evaluateNodeState(dataSourceNode);
        }
        if (globalDataSourceNode.getChildCount() != 0) {
            rootNode.add((MutableTreeNode)((Object)globalDataSourceNode));
        }
        if (projectDataSourceNode.getChildCount() != 0) {
            rootNode.add((MutableTreeNode)((Object)projectDataSourceNode));
        }
        this.addCheckboxTreeListener(new CheckboxTreeListener(){

            public void nodeStateChanged(CheckedTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.updateConsoleStatus(node);
            }
        });
        this.setModel(new DefaultTreeModel((TreeNode)rootNode));
        this.setRootVisible(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2 && (row = this.getRowForLocation(e.getX(), e.getY())) != -1) {
                    if (this.isExpanded(row)) {
                        this.collapseRow(row);
                    } else {
                        this.expandRow(row);
                    }
                }
            }
        });
        TreeUtil.expandAll((JTree)((JTree)((Object)this)));
    }

    public /* synthetic */ ConsolesMigrationChoosingTree(ConsolesMigrationManagerImpl.MigrationInfo migrationInfo, CheckedTreeNode checkedTreeNode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string = DatabaseBundle.message((String)"all.data.sources", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            checkedTreeNode = new CheckBoxNode(string, null, null, 4, null);
        }
        this(migrationInfo, checkedTreeNode);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateConsoleStatus(CheckedTreeNode node) {
        block4: {
            LocalDataSource dataSource;
            ConsoleNode node2;
            block3: {
                Object object;
                void $this$getOrPut$iv;
                ConsoleNode consoleNode = node instanceof ConsoleNode ? (ConsoleNode)node : null;
                if (consoleNode == null) {
                    return;
                }
                node2 = consoleNode;
                dataSource = node2.getDataSource();
                if (!node2.isChecked()) break block3;
                Map<LocalDataSource, List<VirtualFile>> map2 = this.consolesToMigrate;
                LocalDataSource key$iv = dataSource;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(node2.getConsoleVirtualFile());
                break block4;
            }
            List<VirtualFile> list = this.consolesToMigrate.get(dataSource);
            if (list == null) break block4;
            list.remove(node2.getConsoleVirtualFile());
        }
    }

    public final void addConsoleSelectionListener(@NotNull ConsoleSelectedListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.addTreeSelectionListener(arg_0 -> ConsolesMigrationChoosingTree.addConsoleSelectionListener$lambda$0(listener2, arg_0));
    }

    private static final void addConsoleSelectionListener$lambda$0(ConsoleSelectedListener $listener, TreeSelectionEvent it) {
        Object object = it.getPath().getLastPathComponent();
        ConsoleNode consoleNode = object instanceof ConsoleNode ? (ConsoleNode)((Object)object) : null;
        if (consoleNode == null) {
            return;
        }
        ConsoleNode node = consoleNode;
        TreeNode treeNode = node.getParent();
        Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type com.intellij.database.console.migration.view.CheckBoxNode");
        $listener.onConsoleSelected(((CheckBoxNode)((Object)treeNode)).getLabel(), node.getLabel(), node.getConsoleVirtualFile());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/console/migration/view/ConsolesMigrationChoosingTree$CheckBoxCellRenderer;", "Lcom/intellij/ui/CheckboxTree$CheckboxTreeCellRenderer;", "<init>", "()V", "label", "Lcom/intellij/ui/components/JBLabel;", "getLabel", "()Lcom/intellij/ui/components/JBLabel;", "customizeRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.database.impl"})
    private static final class CheckBoxCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        @NotNull
        private final JBLabel label = new JBLabel();

        public CheckBoxCellRenderer() {
            super(false, true);
            this.setLayout(new BoxLayout((Container)((Object)this), 0));
            this.removeAll();
            this.add((Component)this.getThreeStateCheckBox());
            this.add(Box.createHorizontalStrut(JBUI.scale((int)4)));
            this.add((Component)this.label);
            this.add(Box.createHorizontalStrut(JBUI.scale((int)28)));
            this.add(Box.createHorizontalGlue());
            this.getThreeStateCheckBox().setMaximumSize(this.myCheckbox.getPreferredSize());
        }

        @NotNull
        public final JBLabel getLabel() {
            return this.label;
        }

        public void customizeRenderer(@NotNull JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CheckBoxNode checkBoxNode = value instanceof CheckBoxNode ? (CheckBoxNode)((Object)value) : null;
            if (checkBoxNode == null) {
                return;
            }
            CheckBoxNode node = checkBoxNode;
            this.getThreeStateCheckBox().setVisible(true);
            this.getThreeStateCheckBox().setFocusable(true);
            node.setSavedState(ConsolesMigrationChoosingTreeKt.access$evaluateNodeState(node));
            ThreeStateCheckBox threeStateCheckBox = this.getThreeStateCheckBox();
            ThreeStateCheckBox.State state = node.getSavedState();
            Intrinsics.checkNotNull((Object)state);
            threeStateCheckBox.setState(state);
            this.label.setText(node.getLabel());
            this.label.setIcon(node.getIcon());
            this.label.setMaximumSize(this.label.getPreferredSize());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/console/migration/view/ConsolesMigrationChoosingTree$ConsoleSelectedListener;", "", "onConsoleSelected", "", "dataSourceName", "", "fileName", "consoleVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.database.impl"})
    public static interface ConsoleSelectedListener {
        public void onConsoleSelected(@NotNull String var1, @NotNull String var2, @NotNull VirtualFile var3);
    }
}

