/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.runConfiguration;

import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.database.console.runConfiguration.DatabaseScriptTextRunProfileState;
import com.intellij.database.util.DbeTierUtilCore;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunner;", "Lcom/intellij/execution/runners/ProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "<init>", "()V", "getRunnerId", "", "canRun", "", "executorId", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "intellij.database.impl"})
public final class DatabaseScriptRunner
implements ProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "databaseScriptRunRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return !DbeTierUtilCore.isFreeTier() && Intrinsics.areEqual((Object)"Run", (Object)executorId) && profile instanceof DatabaseScriptRunConfiguration;
    }

    public void execute(@NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfileState runProfileState = environment.getState();
        if (runProfileState == null) {
            return;
        }
        RunProfileState state = runProfileState;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ExecutionManager.Companion.getInstance(project).startRunProfile(environment, () -> DatabaseScriptRunner.execute$lambda$0(state, environment, this));
    }

    private static final Promise execute$lambda$0(RunProfileState $state, ExecutionEnvironment $environment, DatabaseScriptRunner this$0) {
        RunContentDescriptor runContentDescriptor;
        FileDocumentManager.getInstance().saveAllDocuments();
        ExecutionResult executionResult = $state.execute($environment.getExecutor(), (ProgramRunner)this$0);
        if (executionResult != null) {
            ExecutionResult executionResult2 = executionResult;
            boolean bl = false;
            if ($state instanceof DatabaseScriptTextRunProfileState) {
                ProcessHandler processHandler = executionResult2.getProcessHandler();
                JPanel jPanel = new JPanel();
                runContentDescriptor = new RunContentDescriptor(processHandler, jPanel){

                    public boolean isHiddenContent() {
                        return true;
                    }
                };
            } else {
                runContentDescriptor = DefaultProgramRunnerKt.showRunContent((ExecutionResult)executionResult2, (ExecutionEnvironment)$environment);
            }
        } else {
            runContentDescriptor = null;
        }
        RunContentDescriptor descriptor2 = runContentDescriptor;
        return Promises.resolvedPromise(descriptor2);
    }
}

