/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.run.ui.grid.GridColorSchemeUtil;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbTableCollectionEditor<E extends BasicElement, T>
extends DbVisualEditorBase<E, DbCollectionModelState<T>> {
    private final ListTableModel<T> myItems;
    protected final TableView<T> myTable;
    private final JComponent myComponent;

    protected DbTableCollectionEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbCollectionModelState<T>> model, boolean addRemove) {
        if (controller == null) {
            DbTableCollectionEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbTableCollectionEditor.$$$reportNull$$$0(1);
        }
        super(controller, model);
        this.myItems = new ListTableModel<T>(this.createColumns().toList().toArray(ColumnInfo.EMPTY_ARRAY)){

            public void addRow() {
                this.addRow(((DbCollectionModelState)DbTableCollectionEditor.this.getState()).getItemFactory().createItem(null));
            }
        };
        this.myTable = new TableView(this.myItems);
        DbTableCollectionEditor.setUpColorsFromGridScheme(this.myTable);
        String title = this.getTitle();
        if (title == null) {
            title = this.getModelTitle();
        }
        this.myTable.getEmptyText().setText(DatabaseBundle.message((String)"status.text.no", (Object[])new Object[]{title}));
        this.myItems.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                DbTableCollectionEditor.this.onTableModelChanged();
            }
        });
        if (addRemove) {
            this.myComponent = this.createDecorator().createPanel();
        } else {
            this.myTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)150, (int)150));
            this.myComponent = ScrollPaneFactory.createScrollPane(this.myTable, (boolean)false);
        }
        ActionGroup contextMenu = this.createContextMenu();
        if (contextMenu != null) {
            PopupHandler.installPopupMenu(this.myTable, (ActionGroup)contextMenu, (String)"popup");
        }
    }

    @Override
    public boolean unregister(boolean keepModel) {
        if (!super.unregister(keepModel)) {
            return false;
        }
        this.myTable.stopEditing();
        return true;
    }

    @NotNull
    protected ToolbarDecorator createDecorator() {
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myTable).setPreferredSize((Dimension)JBUI.size((int)150, (int)150));
        if (toolbarDecorator == null) {
            DbTableCollectionEditor.$$$reportNull$$$0(2);
        }
        return toolbarDecorator;
    }

    public static void setUpColorsFromGridScheme(@NotNull JTable table) {
        if (table == null) {
            DbTableCollectionEditor.$$$reportNull$$$0(3);
        }
        GridColorSchemeUtil.setUpTableColors((JTable)table, (GridColorsScheme)new GridColorsScheme(false, DataGridAppearanceSettings.getSettings()));
    }

    @Nullable
    protected ActionGroup createContextMenu() {
        return null;
    }

    protected void onTableModelChanged() {
        this.modified();
    }

    protected abstract JBIterable<ColumnInfo<T, ?>> createColumns();

    @Override
    protected void applyImpl() {
        this.setItemsToState(this.getItems());
    }

    @NotNull
    public List<T> getItems() {
        List list = this.myItems.getItems();
        if (list == null) {
            DbTableCollectionEditor.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected void setItemsToState(@NotNull List<T> items) {
        if (items == null) {
            DbTableCollectionEditor.$$$reportNull$$$0(5);
        }
        ((DbCollectionModelState)this.getState()).setItems(items);
    }

    @Override
    protected void resetImpl() {
        this.setItems(this.extractItemsFromState());
    }

    protected void setItems(List<T> items) {
        List selection = this.myTable.getSelectedObjects();
        this.myItems.setItems(items);
        this.myTable.setSelection((Collection)selection);
    }

    @NotNull
    protected List<T> extractItemsFromState() {
        return new ArrayList(((DbCollectionModelState)this.getState()).getItems());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            DbTableCollectionEditor.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.LARGE;
        if (fieldSize == null) {
            DbTableCollectionEditor.$$$reportNull$$$0(7);
        }
        return fieldSize;
    }

    @Override
    public boolean isEmpty() {
        return this.myItems.getRowCount() == 0;
    }

    @Override
    public boolean isVertical() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbTableCollectionEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbTableCollectionEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDecorator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setUpColorsFromGridScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setItemsToState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

