/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.queryFiles.QueryFileUtilsKt;
import com.intellij.database.dataSource.DataSourceStorageScope;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileUtils;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FileColorManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 \u0013*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\t\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nR\u001c\u0010\u0006\u001a\u00028\u0000X\u0084.\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/view/DatabaseColorManager;", "T", "Lcom/intellij/database/view/DatabaseColorManager$SharedColors;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "<init>", "()V", "myState", "getMyState", "()Lcom/intellij/database/view/DatabaseColorManager$SharedColors;", "setMyState", "(Lcom/intellij/database/view/DatabaseColorManager$SharedColors;)V", "Lcom/intellij/database/view/DatabaseColorManager$SharedColors;", "getState", "loadState", "", "state", "ColorChangeListener", "CachedColor", "ColorSettings", "Companion", "Shared", "Local", "Global", "SharedColors", "LocalColors", "intellij.database.impl"})
public class DatabaseColorManager<T extends SharedColors>
implements PersistentStateComponent<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected T myState;
    @JvmField
    @NotNull
    public static final Logger LOG;
    @JvmField
    @NotNull
    public static final Topic<ColorChangeListener> COLOR_CHANGE_TOPIC;
    @NotNull
    private static final Key<CachedColor> COLOR_KEY;
    @NotNull
    private static final Object ourLock;
    @NotNull
    private static final SimpleModificationTracker ourModificationTracker;

    @NotNull
    protected final T getMyState() {
        T t = this.myState;
        if (t != null) {
            return t;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"myState");
        return null;
    }

    protected final void setMyState(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.myState = t;
    }

    @NotNull
    public T getState() {
        return this.getMyState();
    }

    public void loadState(@NotNull T state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        this.setMyState(state);
    }

    @JvmStatic
    private static final DatabaseColorManager<LocalColors> getLocalColorManager(Project project) {
        return DatabaseColorManager.Companion.getLocalColorManager(project);
    }

    @JvmStatic
    private static final DatabaseColorManager<SharedColors> getSharedColorManager(Project project) {
        return DatabaseColorManager.Companion.getSharedColorManager(project);
    }

    @JvmStatic
    private static final DatabaseColorManager<SharedColors> getGlobalColorManager() {
        return DatabaseColorManager.Companion.getGlobalColorManager();
    }

    @JvmStatic
    public static final boolean useColorsInDatabaseExplorer(@NotNull Project project) {
        return Companion.useColorsInDatabaseExplorer(project);
    }

    @JvmStatic
    public static final boolean useColorsInEditor(@NotNull Project project) {
        return Companion.useColorsInEditor(project);
    }

    @JvmStatic
    public static final boolean useColorsInEditorTabs(@NotNull Project project) {
        return Companion.useColorsInEditorTabs(project);
    }

    @JvmStatic
    public static final boolean useColorsInToolbars(@NotNull Project project) {
        return Companion.useColorsInToolbars(project);
    }

    @JvmStatic
    @Nullable
    public static final Color getColor(@NotNull Project project, @Nullable VirtualFile file) {
        return Companion.getColor(project, file);
    }

    @JvmStatic
    @Nullable
    public static final Color getColor(@Nullable DbElement element) {
        return Companion.getColor(element);
    }

    @JvmStatic
    public static final void setColorId(@NotNull DbElement element, @Nullable String colorID, boolean recursively, boolean isShared) {
        Companion.setColorId(element, colorID, recursively, isShared);
    }

    @JvmStatic
    public static final void setColorIdForGlobalDataSource(@NotNull DbElement element, @Nullable String colorId, boolean recursively) {
        Companion.setColorIdForGlobalDataSource(element, colorId, recursively);
    }

    @JvmStatic
    @Nullable
    public static final Color getColor(@NotNull Project project, @Nullable DasDataSource dataSource) {
        return Companion.getColor(project, dataSource);
    }

    @JvmStatic
    @NonNls
    @Nullable
    public static final String getColorId(@Nullable DbElement element, @Nullable Ref<Boolean> sharedRef) {
        return Companion.getColorId(element, sharedRef);
    }

    @JvmStatic
    public static final void changeDsScopeToGlobal(@NotNull Project p, @NotNull LocalDataSource ds) {
        Companion.changeDsScopeToGlobal(p, ds);
    }

    @JvmStatic
    public static final void changeDsScopeToProject(@NotNull Project p, @NotNull LocalDataSource ds) {
        Companion.changeDsScopeToProject(p, ds);
    }

    @JvmStatic
    private static final boolean isGlobal(DasDataSource ds) {
        return DatabaseColorManager.Companion.isGlobal(ds);
    }

    @JvmStatic
    @NotNull
    public static final ColorSettings getSettings(@NotNull Project project) {
        return Companion.getSettings(project);
    }

    @JvmStatic
    public static final void setSettings(@NotNull Project project, @NotNull ColorSettings settings) {
        Companion.setSettings(project, settings);
    }

    static {
        Logger logger = Logger.getInstance(DatabaseColorManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        COLOR_CHANGE_TOPIC = new Topic("Color changed", ColorChangeListener.class);
        Key key = Key.create((String)"COLOR_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        COLOR_KEY = key;
        ourLock = new Object();
        ourModificationTracker = new SimpleModificationTracker();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/DatabaseColorManager$CachedColor;", "", "color", "Ljava/awt/Color;", "modCount", "", "<init>", "(Ljava/awt/Color;J)V", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "getModCount", "()J", "setModCount", "(J)V", "intellij.database.impl"})
    private static final class CachedColor {
        @Nullable
        private Color color;
        private long modCount;

        public CachedColor(@Nullable Color color, long modCount) {
            this.color = color;
            this.modCount = modCount;
        }

        public /* synthetic */ CachedColor(Color color, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                color = null;
            }
            if ((n & 2) != 0) {
                l = 0L;
            }
            this(color, l);
        }

        @Nullable
        public final Color getColor() {
            return this.color;
        }

        public final void setColor(@Nullable Color color) {
            this.color = color;
        }

        public final long getModCount() {
            return this.modCount;
        }

        public final void setModCount(long l) {
            this.modCount = l;
        }

        public CachedColor() {
            this(null, 0L, 3, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/view/DatabaseColorManager$ColorChangeListener;", "", "onChanged", "", "intellij.database.impl"})
    public static interface ColorChangeListener {
        public void onChanged();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/view/DatabaseColorManager$ColorSettings;", "", "useColors", "", "inExplorer", "inEditor", "inEditorTabs", "inToolbars", "<init>", "(ZZZZZ)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
    public static final class ColorSettings {
        @JvmField
        public final boolean useColors;
        @JvmField
        public final boolean inExplorer;
        @JvmField
        public final boolean inEditor;
        @JvmField
        public final boolean inEditorTabs;
        @JvmField
        public final boolean inToolbars;

        public ColorSettings(boolean useColors, boolean inExplorer, boolean inEditor, boolean inEditorTabs, boolean inToolbars) {
            this.useColors = useColors;
            this.inExplorer = inExplorer;
            this.inEditor = inEditor;
            this.inEditorTabs = inEditorTabs;
            this.inToolbars = inToolbars;
        }

        public final boolean component1() {
            return this.useColors;
        }

        public final boolean component2() {
            return this.inExplorer;
        }

        public final boolean component3() {
            return this.inEditor;
        }

        public final boolean component4() {
            return this.inEditorTabs;
        }

        public final boolean component5() {
            return this.inToolbars;
        }

        @NotNull
        public final ColorSettings copy(boolean useColors, boolean inExplorer, boolean inEditor, boolean inEditorTabs, boolean inToolbars) {
            return new ColorSettings(useColors, inExplorer, inEditor, inEditorTabs, inToolbars);
        }

        public static /* synthetic */ ColorSettings copy$default(ColorSettings colorSettings, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, Object object) {
            if ((n & 1) != 0) {
                bl = colorSettings.useColors;
            }
            if ((n & 2) != 0) {
                bl2 = colorSettings.inExplorer;
            }
            if ((n & 4) != 0) {
                bl3 = colorSettings.inEditor;
            }
            if ((n & 8) != 0) {
                bl4 = colorSettings.inEditorTabs;
            }
            if ((n & 0x10) != 0) {
                bl5 = colorSettings.inToolbars;
            }
            return colorSettings.copy(bl, bl2, bl3, bl4, bl5);
        }

        @NotNull
        public String toString() {
            return "ColorSettings(useColors=" + this.useColors + ", inExplorer=" + this.inExplorer + ", inEditor=" + this.inEditor + ", inEditorTabs=" + this.inEditorTabs + ", inToolbars=" + this.inToolbars + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.useColors);
            result2 = result2 * 31 + Boolean.hashCode(this.inExplorer);
            result2 = result2 * 31 + Boolean.hashCode(this.inEditor);
            result2 = result2 * 31 + Boolean.hashCode(this.inEditorTabs);
            result2 = result2 * 31 + Boolean.hashCode(this.inToolbars);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColorSettings)) {
                return false;
            }
            ColorSettings colorSettings = (ColorSettings)other;
            if (this.useColors != colorSettings.useColors) {
                return false;
            }
            if (this.inExplorer != colorSettings.inExplorer) {
                return false;
            }
            if (this.inEditor != colorSettings.inEditor) {
                return false;
            }
            if (this.inEditorTabs != colorSettings.inEditorTabs) {
                return false;
            }
            return this.inToolbars == colorSettings.inToolbars;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0003J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u001c\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010#H\u0007J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010$\u001a\u0004\u0018\u00010%H\u0007J/\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020%2\r\u0010(\u001a\t\u0018\u00010)\u00a2\u0006\u0002\b*2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u001cH\u0007J'\u0010-\u001a\u00020'2\u0006\u0010$\u001a\u00020%2\r\u0010.\u001a\t\u0018\u00010)\u00a2\u0006\u0002\b*2\u0006\u0010+\u001a\u00020\u001cH\u0007J$\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020)2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)02H\u0002J\u0018\u00103\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020)2\u0006\u00104\u001a\u00020)H\u0002J\u001c\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u00152\b\u00105\u001a\u0004\u0018\u000106H\u0007J$\u00107\u001a\u0004\u0018\u00010)2\b\u0010$\u001a\u0004\u0018\u00010%2\u000e\u00108\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u000109H\u0007J\u0010\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020%H\u0002J\u001e\u0010:\u001a\u00020'2\u0006\u0010<\u001a\u00020\u00152\f\u0010=\u001a\b\u0012\u0004\u0012\u00020)0>H\u0002J>\u0010?\u001a\u00020'2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)022\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)022\f\u0010=\u001a\b\u0012\u0004\u0012\u00020)0>H\u0002J\u0018\u0010B\u001a\u00020\u001c2\u0006\u00100\u001a\u00020)2\u0006\u0010C\u001a\u00020)H\u0002J\u0018\u0010D\u001a\u00020'2\u0006\u0010<\u001a\u00020\u00152\u0006\u0010E\u001a\u00020FH\u0007J\u0018\u0010G\u001a\u00020'2\u0006\u0010<\u001a\u00020\u00152\u0006\u0010E\u001a\u00020FH\u0007J\u0010\u0010H\u001a\u00020\u001c2\u0006\u0010E\u001a\u000206H\u0003J\u0017\u0010I\u001a\t\u0018\u00010)\u00a2\u0006\u0002\b*2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010J\u001a\u00020)2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010K\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010K\u001a\u00020'2\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u00122\f\u0010M\u001a\b\u0012\u0004\u0012\u00020)0NH\u0002J*\u0010K\u001a\u00020'2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)022\f\u0010O\u001a\b\u0012\u0004\u0012\u00020)0NH\u0002J\u0010\u0010P\u001a\u00020Q2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010R\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010S\u001a\u00020QH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/intellij/database/view/DatabaseColorManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "COLOR_CHANGE_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/database/view/DatabaseColorManager$ColorChangeListener;", "COLOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/view/DatabaseColorManager$CachedColor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "ourLock", "ourModificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "getLocalColorManager", "Lcom/intellij/database/view/DatabaseColorManager;", "Lcom/intellij/database/view/DatabaseColorManager$LocalColors;", "project", "Lcom/intellij/openapi/project/Project;", "getSharedColorManager", "Lcom/intellij/database/view/DatabaseColorManager$SharedColors;", "getGlobalColorManager", "getModCount", "", "useColorsInDatabaseExplorer", "", "useColorsInEditor", "useColorsInEditorTabs", "useColorsInToolbars", "getColor", "Ljava/awt/Color;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "element", "Lcom/intellij/database/psi/DbElement;", "setColorId", "", "colorID", "", "Lorg/jetbrains/annotations/NonNls;", "recursively", "isShared", "setColorIdForGlobalDataSource", "colorId", "clearChildren", "elementId", "colors", "", "isChild", "parent", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "getColorId", "sharedRef", "Lcom/intellij/openapi/util/Ref;", "changeScopeToGlobal", "e", "p", "pred", "Ljava/util/function/Predicate;", "moveColorEntry", "from", "to", "belongsToDs", "dsId", "changeDsScopeToGlobal", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "changeDsScopeToProject", "isGlobal", "getColorIdForGlobalDataSource", "getElementId", "cleanupColors", "manager", "existingRoots", "", "roots", "getSettings", "Lcom/intellij/database/view/DatabaseColorManager$ColorSettings;", "setSettings", "settings", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final DatabaseColorManager<LocalColors> getLocalColorManager(Project project) {
            Object object = project.getService(Local.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DatabaseColorManager)object;
        }

        @JvmStatic
        private final DatabaseColorManager<SharedColors> getSharedColorManager(Project project) {
            Object object = project.getService(Shared.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DatabaseColorManager)object;
        }

        @JvmStatic
        private final DatabaseColorManager<SharedColors> getGlobalColorManager() {
            Object object = ApplicationManager.getApplication().getService(Global.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DatabaseColorManager)object;
        }

        private final long getModCount() {
            return ourModificationTracker.getModificationCount() + UISettings.Companion.getInstance().getState().getModificationCount();
        }

        @JvmStatic
        public final boolean useColorsInDatabaseExplorer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LocalColors state = (LocalColors)this.getLocalColorManager(project).getState();
            return state.useColors && state.inDatabaseView;
        }

        @JvmStatic
        public final boolean useColorsInEditor(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LocalColors state = (LocalColors)this.getLocalColorManager(project).getState();
            return state.useColors && state.useInEditor;
        }

        @JvmStatic
        public final boolean useColorsInEditorTabs(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LocalColors state = (LocalColors)this.getLocalColorManager(project).getState();
            return state.useColors && state.inEditorTabs;
        }

        @JvmStatic
        public final boolean useColorsInToolbars(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LocalColors state = (LocalColors)this.getLocalColorManager(project).getState();
            return state.useColors && state.useInToolbars;
        }

        @JvmStatic
        @Nullable
        public final Color getColor(@NotNull Project project, @Nullable VirtualFile file) {
            DbElement dbElement;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (file == null) {
                return null;
            }
            if (DbImplUtil.isDatabaseVirtualFile((VirtualFile)file)) {
                DbElement tableOrView = DbImplUtilCore.findElement((Project)project, (VirtualFile)file);
                dbElement = tableOrView;
                if (dbElement == null) {
                    dbElement = (DbElement)DbImplUtilCore.findDataSource((Project)project, (VirtualFile)file);
                }
            } else {
                boolean isConsoleFile = DbVFSUtils.isConsoleFile((VirtualFile)file);
                JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
                if (console == null) {
                    dbElement = (DbElement)ReadAction.compute(() -> Companion.getColor$lambda$0(isConsoleFile, project, file));
                } else {
                    DbDataSource dataSource = DbImplUtilCore.getDbDataSource((Project)project, (DasDataSource)((DasDataSource)console.getDataSource()));
                    ObjectPath path = console.getCurrentNamespace();
                    if (dataSource == null || path == null) {
                        dbElement = (DbElement)dataSource;
                    } else {
                        DbElement e = DbSqlUtilCore.findElement((DbDataSource)dataSource, (ObjectPath)path);
                        dbElement = e;
                        if (dbElement == null) {
                            dbElement = (DbElement)dataSource;
                        }
                    }
                }
            }
            DbElement element = dbElement;
            return this.getColor(element);
        }

        @JvmStatic
        @Nullable
        public final Color getColor(@Nullable DbElement element) {
            if (element == null) {
                return null;
            }
            CachedColor info2 = (CachedColor)COLOR_KEY.get((UserDataHolder)element);
            long modificationCount = this.getModCount();
            if (info2 != null && info2.getModCount() != modificationCount) {
                info2 = null;
            }
            if (info2 == null) {
                Color c2;
                String colorName = this.getColorId(element, null);
                info2 = new CachedColor(null, 0L, 3, null);
                info2.setModCount(modificationCount);
                if (colorName != null && (c2 = FileColorManager.getInstance((Project)element.getProject()).getColor(colorName)) != null) {
                    info2.setColor(c2);
                }
                COLOR_KEY.set((UserDataHolder)element, (Object)info2);
            }
            return info2.getColor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @JvmStatic
        public final void setColorId(@NotNull DbElement element, @Nullable String colorID, boolean recursively, boolean isShared) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            var5_5 = DatabaseColorManager.access$getOurLock$cp();
            synchronized (var5_5) {
                block8: {
                    $i$a$-synchronized-DatabaseColorManager$Companion$setColorId$1 = false;
                    v0 = element.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
                    localColorManager = DatabaseColorManager.Companion.getLocalColorManager(v0);
                    local = localColorManager.getState();
                    v1 = element.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
                    shared = DatabaseColorManager.Companion.getSharedColorManager(v1).getState();
                    elementId = DatabaseColorManager.Companion.getElementId(element);
                    changed = shared.colors.remove(elementId) != null;
                    changed |= local.colors.remove(elementId) != null;
                    if (colorID == null) break block8;
                    sharedRef = Ref.create(null);
                    if (changed || !Intrinsics.areEqual((Object)colorID, (Object)DatabaseColorManager.Companion.getColorId(element, (Ref<Boolean>)sharedRef))) ** GOTO lbl-1000
                    v2 = sharedRef;
                    if (isShared == (v2 != null ? Intrinsics.areEqual((Object)v2.get(), (Object)true) : false)) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = doNotChange = false;
                    }
                    if (!doNotChange) {
                        changed = true;
                        colors = isShared != false ? shared : local;
                        colors.colors.put(elementId, colorID);
                    }
                }
                if (recursively) {
                    changed |= DatabaseColorManager.Companion.clearChildren(elementId, shared.colors);
                    changed |= DatabaseColorManager.Companion.clearChildren(elementId, local.colors);
                }
                if (changed) {
                    DatabaseColorManager.access$getOurModificationTracker$cp().incModificationCount();
                    DatabaseServiceViewContributor.refreshView(element.getProject());
                }
                var6_7 = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void setColorIdForGlobalDataSource(@NotNull DbElement element, @Nullable String colorId, boolean recursively) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Object object = ourLock;
            synchronized (object) {
                boolean bl = false;
                Companion.changeScopeToGlobal(element);
                Object state = Companion.getGlobalColorManager().getState();
                String elementId = Companion.getElementId(element);
                ((SharedColors)state).colors.remove(elementId);
                if (colorId != null && !Intrinsics.areEqual((Object)colorId, (Object)Companion.getColorIdForGlobalDataSource(element))) {
                    ((SharedColors)state).colors.put(elementId, colorId);
                }
                if (recursively) {
                    Companion.clearChildren(elementId, ((SharedColors)state).colors);
                }
                ourModificationTracker.incModificationCount();
                Unit unit = Unit.INSTANCE;
            }
        }

        private final boolean clearChildren(String elementId, Map<String, String> colors) {
            String string;
            int colonIndex = StringsKt.lastIndexOf$default((CharSequence)elementId, (char)':', (int)0, (boolean)false, (int)6, null);
            if (colonIndex == -1) {
                string = elementId;
            } else {
                String string2 = elementId.substring(0, colonIndex + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            String trimmedId = string;
            return colors.keySet().removeIf(arg_0 -> Companion.clearChildren$lambda$1(arg_0 -> Companion.clearChildren$lambda$0(trimmedId, arg_0), arg_0));
        }

        private final boolean isChild(String element, String parent2) {
            int idx = StringsKt.indexOf$default((CharSequence)element, (String)parent2, (int)0, (boolean)false, (int)6, null);
            return idx > 0 && element.charAt(idx - 1) == '/';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final Color getColor(@NotNull Project project, @Nullable DasDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = ourLock;
            synchronized (object) {
                block7: {
                    boolean bl = false;
                    if (dataSource != null) break block7;
                    Color color = null;
                    return color;
                }
                String string = dataSource.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
                String id = string;
                String colorName = null;
                if (Companion.isGlobal(dataSource)) {
                    colorName = ((SharedColors)DatabaseColorManager.Companion.getGlobalColorManager().getState()).colors.get(id);
                }
                if (colorName == null) {
                    colorName = (String)((LocalColors)DatabaseColorManager.Companion.getLocalColorManager((Project)project).getState()).colors.get(id);
                    String string2 = colorName;
                    if (string2 == null) {
                        string2 = ((SharedColors)DatabaseColorManager.Companion.getSharedColorManager((Project)project).getState()).colors.get(id);
                    }
                    colorName = string2;
                }
                Color color = colorName == null ? null : FileColorManager.getInstance((Project)project).getColor(colorName);
                return color;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        @NonNls
        @Nullable
        public final String getColorId(@Nullable DbElement element, @Nullable Ref<Boolean> sharedRef) {
            Object object = ourLock;
            synchronized (object) {
                String colorId;
                boolean bl = false;
                if (element == null) {
                    return null;
                }
                DbDataSource dbDataSource = element.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
                if (Companion.isGlobal((DasDataSource)dbDataSource) && (colorId = Companion.getColorIdForGlobalDataSource(element)) != null) {
                    return colorId;
                }
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                LocalColors local = (LocalColors)Companion.getLocalColorManager(project2).getState();
                Object shared = Companion.getSharedColorManager(project2).getState();
                if (((SharedColors)shared).colors.isEmpty() && local.colors.isEmpty()) {
                    return null;
                }
                boolean isShared = false;
                DbElement e = element;
                while (e != null) {
                    String elementId = Companion.getElementId(e);
                    String s = (String)local.colors.get(elementId);
                    boolean bl2 = isShared = s == null;
                    if (s == null) {
                        s = ((SharedColors)shared).colors.get(elementId);
                        boolean bl3 = isShared = s != null;
                    }
                    if (s != null) {
                        Ref<Boolean> ref = sharedRef;
                        if (ref == null) return s;
                        ref.set((Object)isShared);
                        return s;
                    }
                    e = e.getParent();
                }
                return null;
            }
        }

        private final void changeScopeToGlobal(DbElement e) {
            String string = e.getDataSource().getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
            String globalDsId = string;
            Project project = e.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.changeScopeToGlobal(project, arg_0 -> Companion.changeScopeToGlobal$lambda$0(globalDsId, arg_0));
        }

        private final void changeScopeToGlobal(Project p, Predicate<String> pred) {
            Map local = this.getLocalColorManager((Project)p).getMyState().colors;
            Map<String, String> shared = this.getSharedColorManager((Project)p).getMyState().colors;
            Map<String, String> global = this.getGlobalColorManager().getMyState().colors;
            this.moveColorEntry(shared, global, pred);
            this.moveColorEntry(local, global, pred);
        }

        private final void moveColorEntry(Map<String, String> from, Map<String, String> to, Predicate<String> pred) {
            Iterator<Map.Entry<String, String>> i = from.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, String> e = i.next();
                if (!pred.test(e.getKey())) continue;
                if (!to.containsKey(e.getKey())) {
                    to.put(e.getKey(), e.getValue());
                } else {
                    String string = "Lost color for %s: %s";
                    Object[] objectArray = new Object[]{e.getKey(), e.getValue()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    LOG.warn(string2);
                }
                i.remove();
            }
        }

        private final boolean belongsToDs(String elementId, String dsId) {
            String string;
            int kindSepIdx = StringsKt.indexOf$default((CharSequence)elementId, (char)':', (int)0, (boolean)false, (int)6, null);
            if (kindSepIdx != -1) {
                String string2 = elementId.substring(0, kindSepIdx);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = elementId;
            }
            String trimmedId = string;
            return StringsKt.endsWith$default((String)trimmedId, (String)dsId, (boolean)false, (int)2, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void changeDsScopeToGlobal(@NotNull Project p, @NotNull LocalDataSource ds) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
            Object object = ourLock;
            synchronized (object) {
                boolean bl = false;
                String string = ds.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
                String dsId = string;
                Companion.changeScopeToGlobal(p, arg_0 -> Companion.changeDsScopeToGlobal$lambda$0$0(dsId, arg_0));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void changeDsScopeToProject(@NotNull Project p, @NotNull LocalDataSource ds) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
            Object object = ourLock;
            synchronized (object) {
                boolean bl = false;
                Map local = DatabaseColorManager.Companion.getLocalColorManager((Project)p).getMyState().colors;
                Map<String, String> global = DatabaseColorManager.Companion.getGlobalColorManager().getMyState().colors;
                String string = ds.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
                String dsId = string;
                Companion.moveColorEntry(global, local, arg_0 -> Companion.changeDsScopeToProject$lambda$0$0(dsId, arg_0));
                Unit unit = Unit.INSTANCE;
            }
        }

        @JvmStatic
        private final boolean isGlobal(DasDataSource ds) {
            RawDataSource rawDataSource = DbImplUtilCore.unwrapDS((DasDataSource)ds);
            if (rawDataSource == null) {
                return false;
            }
            RawDataSource delegate = rawDataSource;
            return delegate.getStorageScope() == DataSourceStorageScope.DSSS_APPLICATION;
        }

        private final String getColorIdForGlobalDataSource(DbElement element) {
            Object state = this.getGlobalColorManager().getState();
            if (((SharedColors)state).colors.isEmpty()) {
                return null;
            }
            return (String)JBIterable.generate((Object)element, arg_0 -> Companion.getColorIdForGlobalDataSource$lambda$1(Companion::getColorIdForGlobalDataSource$lambda$0, arg_0)).filterMap(arg_0 -> Companion.getColorIdForGlobalDataSource$lambda$3(arg_0 -> Companion.getColorIdForGlobalDataSource$lambda$2((SharedColors)state, arg_0), arg_0)).first();
        }

        private final String getElementId(DbElement element) {
            StringBuilder b = new StringBuilder();
            for (DbElement cur = element; cur != null; cur = cur.getParent()) {
                if (((CharSequence)b).length() > 0) {
                    b.append("/");
                }
                String str = cur instanceof DbDataSource ? ((DbDataSource)cur).getUniqueId() : DatabaseElementVirtualFileUtils.escape((String)cur.getName());
                b.append(str);
            }
            if (!(element instanceof DbDataSource)) {
                b.append(":").append(element.getKind().name());
            }
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void cleanupColors(Project project) {
            Global global;
            Shared shared;
            List list = DbPsiFacade.getInstance((Project)project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            List dataSources = list;
            Set set = JBIterable.from((Iterable)dataSources).map(arg_0 -> Companion.cleanupColors$lambda$1(Companion::cleanupColors$lambda$0, arg_0)).toSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
            Set existingRoots = set;
            Local local = (Local)project.getServiceIfCreated(Local.class);
            if (local != null) {
                this.cleanupColors(local, (Set<String>)existingRoots);
            }
            if ((shared = (Shared)project.getServiceIfCreated(Shared.class)) != null) {
                this.cleanupColors(shared, (Set<String>)existingRoots);
            }
            if ((global = (Global)ApplicationManager.getApplication().getServiceIfCreated(Global.class)) != null) {
                this.cleanupColors(global, (Set<String>)existingRoots);
            }
        }

        private final void cleanupColors(DatabaseColorManager<?> manager, Set<String> existingRoots) {
            Map<String, String> colors = ((SharedColors)manager.getState()).colors;
            if (!colors.isEmpty()) {
                this.cleanupColors(colors, existingRoots);
            }
        }

        private final void cleanupColors(Map<String, String> colors, Set<String> roots) {
            String[] stringArray = ArrayUtilRt.toStringArray((Collection)colors.keySet());
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
            for (String s : stringArray) {
                boolean foundRoot = false;
                for (String root : roots) {
                    Intrinsics.checkNotNull((Object)s);
                    if (!StringsKt.contains$default((CharSequence)s, (CharSequence)root, (boolean)false, (int)2, null)) continue;
                    foundRoot = true;
                    break;
                }
                if (foundRoot) continue;
                colors.remove(s);
            }
        }

        @JvmStatic
        @NotNull
        public final ColorSettings getSettings(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DatabaseColorManager<LocalColors> lcm = this.getLocalColorManager(project);
            LocalColors state = (LocalColors)lcm.getState();
            return new ColorSettings(state.useColors, state.inDatabaseView, state.useInEditor, state.inEditorTabs, state.useInToolbars);
        }

        @JvmStatic
        public final void setSettings(@NotNull Project project, @NotNull ColorSettings settings) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            DatabaseColorManager<LocalColors> lcm = this.getLocalColorManager(project);
            LocalColors state = (LocalColors)lcm.getState();
            state.useColors = settings.useColors;
            state.inDatabaseView = settings.inExplorer;
            state.useInEditor = settings.inEditor;
            state.inEditorTabs = settings.inEditorTabs;
            state.useInToolbars = settings.inToolbars;
        }

        private static final DbElement getColor$lambda$0(boolean $isConsoleFile, Project $project, VirtualFile $file) {
            return $isConsoleFile ? (DbElement)DbVFSUtils.getDataSource((Project)$project, (VirtualFile)$file) : QueryFileUtilsKt.getDbElementForVirtualFile($project, $file);
        }

        private static final boolean clearChildren$lambda$0(String $trimmedId, String item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return Companion.isChild(item, $trimmedId);
        }

        private static final boolean clearChildren$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean changeScopeToGlobal$lambda$0(String $globalDsId, String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return Companion.belongsToDs(id, $globalDsId);
        }

        private static final boolean changeDsScopeToGlobal$lambda$0$0(String $dsId, String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return Companion.belongsToDs(id, $dsId);
        }

        private static final boolean changeDsScopeToProject$lambda$0$0(String $dsId, String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return Companion.belongsToDs(id, $dsId);
        }

        private static final DbElement getColorIdForGlobalDataSource$lambda$0(DbElement e) {
            return e.getParent();
        }

        private static final DbElement getColorIdForGlobalDataSource$lambda$1(Function1 $tmp0, Object p0) {
            return (DbElement)$tmp0.invoke(p0);
        }

        private static final String getColorIdForGlobalDataSource$lambda$2(SharedColors $state, DbElement e) {
            Map<String, String> map2 = $state.colors;
            Intrinsics.checkNotNull((Object)e);
            return map2.get(Companion.getElementId(e));
        }

        private static final String getColorIdForGlobalDataSource$lambda$3(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final String cleanupColors$lambda$0(DbDataSource o) {
            return o.getUniqueId();
        }

        private static final String cleanupColors$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.APP})
    @State(name="DatabaseGlobalColorSettings", storages={@Storage(value="dataSourceColors.xml", roamingType=RoamingType.DISABLED)})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/view/DatabaseColorManager$Global;", "Lcom/intellij/database/view/DatabaseColorManager;", "Lcom/intellij/database/view/DatabaseColorManager$SharedColors;", "<init>", "()V", "intellij.database.impl"})
    private static final class Global
    extends DatabaseColorManager<SharedColors> {
        public Global() {
            this.setMyState(new SharedColors());
        }
    }

    @Service(value={Service.Level.PROJECT})
    @State(name="DatabaseLocalColorSettings", storages={@Storage(value="$WORKSPACE_FILE$", roamingType=RoamingType.DISABLED)})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/view/DatabaseColorManager$Local;", "Lcom/intellij/database/view/DatabaseColorManager;", "Lcom/intellij/database/view/DatabaseColorManager$LocalColors;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "intellij.database.impl"})
    private static final class Local
    extends DatabaseColorManager<LocalColors> {
        public Local(final @NotNull Project project, @NotNull CoroutineScope scope2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            this.setMyState((SharedColors)new LocalColors());
            SimpleMessageBusConnection simpleMessageBusConnection = project.getMessageBus().connect(scope2);
            Topic topic = ProjectManager.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            simpleMessageBusConnection.subscribe(topic, (Object)new ProjectManagerListener(){

                public void projectClosingBeforeSave(Project eventProject) {
                    Intrinsics.checkNotNullParameter((Object)eventProject, (String)"eventProject");
                    if (Intrinsics.areEqual((Object)project, (Object)eventProject)) {
                        Companion.cleanupColors(project);
                    }
                }
            });
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/view/DatabaseColorManager$LocalColors;", "Lcom/intellij/database/view/DatabaseColorManager$SharedColors;", "<init>", "()V", "useColors", "", "inEditorTabs", "inDatabaseView", "useInToolbars", "useInEditor", "intellij.database.impl"})
    public static final class LocalColors
    extends SharedColors {
        @OptionTag(value="use-colors")
        @JvmField
        public boolean useColors = true;
        @OptionTag(value="in-editor-tabs")
        @JvmField
        public boolean inEditorTabs = true;
        @OptionTag(value="in-database-view")
        @JvmField
        public boolean inDatabaseView = true;
        @OptionTag(value="in-toolbars")
        @JvmField
        public boolean useInToolbars = true;
        @OptionTag(value="in-editor")
        @JvmField
        public boolean useInEditor;
    }

    @Service(value={Service.Level.PROJECT})
    @State(name="DatabaseColorSettings", storages={@Storage(value="databaseColors.xml", roamingType=RoamingType.DISABLED)})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/view/DatabaseColorManager$Shared;", "Lcom/intellij/database/view/DatabaseColorManager;", "Lcom/intellij/database/view/DatabaseColorManager$SharedColors;", "<init>", "()V", "intellij.database.impl"})
    private static final class Shared
    extends DatabaseColorManager<SharedColors> {
        public Shared() {
            this.setMyState(new SharedColors());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/view/DatabaseColorManager$SharedColors;", "", "<init>", "()V", "colors", "", "", "intellij.database.impl"})
    public static class SharedColors {
        @Tag(value="colors")
        @MapAnnotation(surroundWithTag=false)
        @JvmField
        @NotNull
        public Map<String, String> colors = new HashMap();
    }
}

