/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.connectivity.dataSource.BasicDataSourceManager;
import com.intellij.database.explorer.structure.DvTreeStructure;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.Searchable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.tree.TreePath;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DatabaseStructure
extends BaseTreeModel<BasicNode>
implements InvokerSupplier,
Searchable,
AsyncTreeModel.AsyncChildrenProvider<BasicNode> {
    @NotNull
    private final DvTreeStructure myStructure;
    @NotNull
    private final Invoker myInvoker;
    private static final Logger ourLog = Logger.getInstance(DatabaseStructure.class);

    public DatabaseStructure(@NotNull DvTreeStructure structure) {
        if (structure == null) {
            DatabaseStructure.$$$reportNull$$$0(0);
        }
        this.myInvoker = Invoker.forBackgroundThreadWithoutReadAction((Disposable)this);
        this.myStructure = structure;
    }

    public void refreshAll() {
        this.treeStructureChanged(null, null, null);
    }

    public BasicNode getRoot() {
        return this.myStructure.getRootNode();
    }

    public boolean isLeaf(Object node) {
        return node instanceof BasicNode ? this.myStructure.isAlwaysLeaf((BasicNode)node) : true;
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            DatabaseStructure.$$$reportNull$$$0(1);
        }
        return invoker;
    }

    @NotNull
    public Promise<TreePath> getTreePath(@Nullable Object object) {
        if (object == null) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                DatabaseStructure.$$$reportNull$$$0(2);
            }
            return promise;
        }
        Object[] path = object instanceof BasicNode ? this.myStructure.getPath((BasicNode)object) : ArrayUtil.EMPTY_OBJECT_ARRAY;
        TreePath treePath = path.length > 0 ? new TreePath(path) : new TreePath(object);
        Promise promise = Promises.resolvedPromise((Object)treePath);
        if (promise == null) {
            DatabaseStructure.$$$reportNull$$$0(3);
        }
        return promise;
    }

    @NotNull
    public List<? extends BasicNode> getChildren(Object parent2) {
        if (parent2 instanceof BasicNode) {
            List<BasicNode> collectedChildren;
            BasicNode p = (BasicNode)parent2;
            JBIterable<? extends BasicNode> children = this.getChildrenImpl(p);
            List<BasicNode> list = collectedChildren = DatabaseStructure.collectNodesToListSafely(children);
            if (list == null) {
                DatabaseStructure.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            DatabaseStructure.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    protected JBIterable<? extends BasicNode> getChildrenImpl(BasicNode p) {
        JBIterable jBIterable = SequenceFun.jbi((Sequence)this.myStructure.childrenOf(p));
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    public Promise<? extends List<? extends BasicNode>> getChildrenAsync(Object parent2) {
        if (parent2 instanceof DataSourceNode) {
            DataSourceNode dsn = (DataSourceNode)parent2;
            Project project = this.myStructure.getContext().project;
            BasicDataSourceManager dsManager = (BasicDataSourceManager)ObjectUtils.tryCast((Object)DataSourceManager.byDataSource((Project)project, (RawDataSource)dsn.dataSource), BasicDataSourceManager.class);
            if (dsManager != null && dsManager.isLoading(dsn.dataSource)) {
                Promise loadingPromise = dsManager.getLoadingPromise(dsn.dataSource);
                Promise promise = loadingPromise.then(x -> {
                    this.myStructure.dataSourceChanged(dsn.dataSource);
                    return this.getChildren(parent2);
                });
                if (promise == null) {
                    DatabaseStructure.$$$reportNull$$$0(7);
                }
                return promise;
            }
        }
        Promise promise = Promises.resolvedPromise(this.getChildren(parent2));
        if (promise == null) {
            DatabaseStructure.$$$reportNull$$$0(8);
        }
        return promise;
    }

    @NotNull
    private static List<BasicNode> collectNodesToListSafely(@NotNull JBIterable<? extends BasicNode> nodes) {
        if (nodes == null) {
            DatabaseStructure.$$$reportNull$$$0(9);
        }
        if (nodes.isEmpty()) {
            List<BasicNode> list = Collections.emptyList();
            if (list == null) {
                DatabaseStructure.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<BasicNode> container = new ArrayList<BasicNode>();
        Object exception = null;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            ArrayList<BasicNode> arrayList;
            try {
                int j = 0;
                for (BasicNode node : nodes) {
                    container.add(node);
                    if (++j % 10 != 0) continue;
                    ProgressManager.checkCanceled();
                }
                arrayList = container;
            }
            catch (ConcurrentModificationException cme) {
                if (exception == null) {
                    exception = cme;
                }
                container.clear();
                continue;
            }
            if (arrayList == null) {
                DatabaseStructure.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        String exceptionName = exception.getClass().getSimpleName();
        String exceptionMessage = ((Throwable)exception).getMessage();
        ourLog.warn("Unable to collect nodes from 3 attempts; the first exception: " + exceptionName + ": " + exceptionMessage);
        List<BasicNode> list = Collections.emptyList();
        if (list == null) {
            DatabaseStructure.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreePath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenAsync";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNodesToListSafely";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectNodesToListSafely";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

