/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.internals;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.actions.diagnostic.DatabaseTreeTweakAction;
import com.intellij.database.explorer.forest.DvArm;
import com.intellij.database.explorer.forest.DvBushRef;
import com.intellij.database.explorer.forest.DvFolder;
import com.intellij.database.explorer.forest.DvForest;
import com.intellij.database.explorer.forest.DvForestGartner;
import com.intellij.database.explorer.forest.DvForestService;
import com.intellij.database.explorer.structure.DvTreeLayerDef;
import com.intellij.database.explorer.structure.DvTreeStoreyLayer;
import com.intellij.database.explorer.structure.DvTreeStructureService;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewService;
import com.intellij.database.view.internals.DatabaseTreeTweakDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001:\u0004JKLMB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u00104\u001a\u000205*\u00020\u00172\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020509J\u0006\u0010:\u001a\u000205J\b\u0010;\u001a\u000205H\u0002J\b\u0010<\u001a\u000205H\u0002J\b\u0010=\u001a\u000205H\u0002J\b\u0010>\u001a\u000205H\u0002J\b\u0010?\u001a\u000205H\u0002J\b\u0010@\u001a\u000205H\u0002J\b\u0010A\u001a\u000205H\u0002J\b\u0010B\u001a\u000205H\u0002J\b\u0010C\u001a\u000205H\u0002J\u0010\u0010D\u001a\u0002052\u0006\u0010E\u001a\u000201H\u0002J\b\u0010F\u001a\u000205H\u0002J\b\u0010G\u001a\u000205H\u0002J\b\u0010H\u001a\u000205H\u0002J\b\u0010I\u001a\u000205H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020!0#X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020(X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020&X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "forestService", "Lcom/intellij/database/explorer/forest/DvForestService;", "forest", "Lcom/intellij/database/explorer/forest/DvForest;", "Lcom/intellij/database/view/DataSourceNode;", "allDefs", "Lkotlin/enums/EnumEntries;", "Lcom/intellij/database/explorer/structure/DvTreeLayerDef;", "service", "Lcom/intellij/database/explorer/structure/DvTreeStructureService;", "storeyLayers", "Ljava/util/SortedMap;", "Lcom/intellij/database/explorer/structure/DvTreeStoreyLayer;", "layerRows", "", "Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog$LayerRow;", "mainPane", "Ljavax/swing/JTabbedPane;", "topPanelOfForest", "Lcom/intellij/openapi/ui/DialogPanel;", "topPanelOfLayers", "topPanelOfSerialization", "topPanelOfProblems", "foldersListModel", "Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog$SimpleListModel;", "Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog$FolderItem;", "folderContentListModel", "Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog$ArmItem;", "folderList", "Lcom/intellij/ui/components/JBList;", "folderContentList", "applyButton", "Ljavax/swing/JButton;", "forestTextArea", "Lcom/intellij/ui/components/JBTextArea;", "statsTextField", "Lcom/intellij/ui/components/JBTextField;", "forestData", "", "problems", "", "Lcom/intellij/database/explorer/forest/DvForestService$Problem;", "problemsGroupBy", "", "problemsTextArea", "problemsFixButton", "onceWhenTabActivated", "", "tabIndex", "", "listener", "Lkotlin/Function0;", "doIt", "setup", "setupForest", "showSelectedFolderContent", "setupLayers", "apply", "setupSerialization", "showSerialization", "showStats", "collectProblems", "switchProblemGrouping", "by", "showProblems", "recoverProblems", "reimportAllDS", "dispose", "LayerRow", "FolderItem", "ArmItem", "SimpleListModel", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseTreeTweakDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseTreeTweakDialog.kt\ncom/intellij/database/view/internals/DatabaseTreeTweakDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,477:1\n30#2,2:478\n30#2,2:480\n30#2,2:482\n30#2,2:512\n30#2,2:514\n30#2,2:516\n1512#3:484\n1538#3,3:485\n1541#3,3:495\n1512#3:498\n1538#3,3:499\n1541#3,3:509\n383#4,7:488\n383#4,7:502\n1#5:518\n*S KotlinDebug\n*F\n+ 1 DatabaseTreeTweakDialog.kt\ncom/intellij/database/view/internals/DatabaseTreeTweakDialog\n*L\n68#1:478,2\n101#1:480,2\n353#1:482,2\n393#1:512,2\n395#1:514,2\n400#1:516,2\n375#1:484\n375#1:485,3\n375#1:495,3\n382#1:498\n382#1:499,3\n382#1:509,3\n375#1:488,7\n382#1:502,7\n*E\n"})
public final class DatabaseTreeTweakDialog
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final DvForestService forestService;
    @NotNull
    private final DvForest<DataSourceNode> forest;
    @NotNull
    private final EnumEntries<DvTreeLayerDef> allDefs;
    @NotNull
    private final DvTreeStructureService service;
    @NotNull
    private final SortedMap<DvTreeLayerDef, DvTreeStoreyLayer> storeyLayers;
    @NotNull
    private final Map<DvTreeLayerDef, LayerRow> layerRows;
    @NotNull
    private final JTabbedPane mainPane;
    @NotNull
    private final DialogPanel topPanelOfForest;
    @NotNull
    private final DialogPanel topPanelOfLayers;
    @NotNull
    private final DialogPanel topPanelOfSerialization;
    @NotNull
    private final DialogPanel topPanelOfProblems;
    @NotNull
    private final SimpleListModel<FolderItem> foldersListModel;
    @NotNull
    private final SimpleListModel<ArmItem> folderContentListModel;
    private JBList<FolderItem> folderList;
    private JBList<ArmItem> folderContentList;
    @NotNull
    private final JButton applyButton;
    private JBTextArea forestTextArea;
    private JBTextField statsTextField;
    @Nullable
    private String forestData;
    @NotNull
    private List<DvForestService.Problem> problems;
    private byte problemsGroupBy;
    private JBTextArea problemsTextArea;
    private JButton problemsFixButton;

    /*
     * WARNING - void declaration
     */
    public DatabaseTreeTweakDialog(@NotNull Project project) {
        void $this$_init__u24lambda_u247;
        void $this$_init__u24lambda_u241;
        JBList $this$_init__u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.allDefs = DvTreeLayerDef.getEntries();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        JBList serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.service = (DvTreeStructureService)object;
        this.storeyLayers = this.service.getAllStoreyLayers();
        this.foldersListModel = new SimpleListModel();
        this.folderContentListModel = new SimpleListModel();
        this.problems = CollectionsKt.emptyList();
        $this$service$iv = (ComponentManager)this.project;
        $i$f$service = false;
        serviceClass$iv = DvForestService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.forestService = (DvForestService)object2;
        this.forest = this.forestService.getForest();
        EnumMap layerRows = new EnumMap(DvTreeLayerDef.class);
        Ref.ObjectRef applyButton = new Ref.ObjectRef();
        serviceClass$iv = new JBList((ListModel)this.foldersListModel);
        Object object3 = serviceClass$iv;
        DatabaseTreeTweakDialog databaseTreeTweakDialog = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setEmptyText("No folders");
        $this$_init__u24lambda_u240.addListSelectionListener(arg_0 -> DatabaseTreeTweakDialog.lambda$0$0(this, arg_0));
        databaseTreeTweakDialog.folderList = serviceClass$iv;
        $this$_init__u24lambda_u240 = serviceClass$iv = new JBList((ListModel)this.folderContentListModel);
        databaseTreeTweakDialog = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setEmptyText("");
        databaseTreeTweakDialog.folderContentList = serviceClass$iv;
        JBList<FolderItem> jBList = this.folderList;
        if (jBList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folderList");
            jBList = null;
        }
        Component component = new JScrollPane((Component)jBList);
        JBList<ArmItem> jBList2 = this.folderContentList;
        if (jBList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folderContentList");
            jBList2 = null;
        }
        Object $this$_init__u24lambda_u242 = object3 = new JSplitPane(1, component, new JScrollPane((Component)jBList2));
        boolean bl3 = false;
        ((JSplitPane)$this$_init__u24lambda_u242).setResizeWeight(0.5);
        Object forestSplitPane = object3;
        this.topPanelOfForest = BuilderKt.panel(arg_0 -> DatabaseTreeTweakDialog._init_$lambda$3((JSplitPane)forestSplitPane, arg_0));
        this.topPanelOfLayers = BuilderKt.panel(arg_0 -> DatabaseTreeTweakDialog._init_$lambda$4(this, layerRows, applyButton, arg_0));
        this.topPanelOfSerialization = BuilderKt.panel(arg_0 -> DatabaseTreeTweakDialog._init_$lambda$5(this, arg_0));
        this.topPanelOfProblems = BuilderKt.panel(arg_0 -> DatabaseTreeTweakDialog._init_$lambda$6(this, arg_0));
        $this$_init__u24lambda_u242 = object3 = new JBTabbedPane();
        databaseTreeTweakDialog = this;
        boolean bl4 = false;
        $this$_init__u24lambda_u247.setFont($this$_init__u24lambda_u247.getFont().deriveFont(1));
        $this$_init__u24lambda_u247.addTab("Forest", (Component)this.topPanelOfForest);
        $this$_init__u24lambda_u247.setMnemonicAt(0, 70);
        $this$_init__u24lambda_u247.addTab("Layers", (Component)this.topPanelOfLayers);
        $this$_init__u24lambda_u247.setMnemonicAt(1, 76);
        $this$_init__u24lambda_u247.addTab("Serialization", (Component)this.topPanelOfSerialization);
        $this$_init__u24lambda_u247.setMnemonicAt(2, 83);
        $this$_init__u24lambda_u247.addTab("Problems", (Component)this.topPanelOfProblems);
        $this$_init__u24lambda_u247.setMnemonicAt(3, 80);
        this.onceWhenTabActivated((JTabbedPane)$this$_init__u24lambda_u247, 2, (Function0<Unit>)((Function0)() -> DatabaseTreeTweakDialog.lambda$7$0(this)));
        this.onceWhenTabActivated((JTabbedPane)$this$_init__u24lambda_u247, 3, (Function0<Unit>)((Function0)() -> DatabaseTreeTweakDialog.lambda$7$1(this)));
        databaseTreeTweakDialog.mainPane = (JTabbedPane)object3;
        this.layerRows = layerRows;
        Object object4 = applyButton.element;
        Intrinsics.checkNotNull((Object)object4);
        this.applyButton = (JButton)object4;
    }

    public final void onceWhenTabActivated(@NotNull JTabbedPane $this$onceWhenTabActivated, int tabIndex, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$onceWhenTabActivated, (String)"<this>");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        $this$onceWhenTabActivated.addChangeListener(new ChangeListener($this$onceWhenTabActivated, tabIndex, listener2){
            final /* synthetic */ JTabbedPane $this_onceWhenTabActivated;
            final /* synthetic */ int $tabIndex;
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$this_onceWhenTabActivated = $receiver;
                this.$tabIndex = $tabIndex;
                this.$listener = $listener;
            }

            public void stateChanged(ChangeEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.$this_onceWhenTabActivated.getSelectedIndex() == this.$tabIndex) {
                    this.$this_onceWhenTabActivated.removeChangeListener(this);
                    this.$listener.invoke();
                }
            }
        });
    }

    public final void doIt() {
        DialogBuilder dialogBuilder;
        DialogBuilder $this$doIt_u24lambda_u240 = dialogBuilder = new DialogBuilder(this.project);
        boolean bl = false;
        $this$doIt_u24lambda_u240.setTitle("Database Explorer Debug");
        $this$doIt_u24lambda_u240.setCenterPanel((JComponent)this.mainPane);
        $this$doIt_u24lambda_u240.setPreferredFocusComponent((JComponent)this.mainPane);
        $this$doIt_u24lambda_u240.addDisposable((Disposable)this);
        $this$doIt_u24lambda_u240.setDimensionServiceKey(DatabaseTreeTweakAction.class.getSimpleName());
        $this$doIt_u24lambda_u240.removeAllActions();
        DialogBuilder dia = dialogBuilder;
        this.setup();
        dia.showNotModal();
    }

    private final void setup() {
        this.setupForest();
        this.setupLayers();
    }

    private final void setupForest() {
        List allFolderItems = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)this.forest.getFoldersTree().traverseDepthFirst()), DatabaseTreeTweakDialog::setupForest$lambda$0));
        this.foldersListModel.replaceAll(allFolderItems);
        if (!((Collection)allFolderItems).isEmpty()) {
            JBList<FolderItem> jBList = this.folderList;
            if (jBList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folderList");
                jBList = null;
            }
            jBList.setSelectedIndex(0);
        }
        this.showSelectedFolderContent();
    }

    private final void showSelectedFolderContent() {
        int selectedFolderIndex;
        JBList<FolderItem> jBList = this.folderList;
        if (jBList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folderList");
            jBList = null;
        }
        if ((selectedFolderIndex = jBList.getSelectedIndex()) < 0) {
            this.folderContentListModel.clear();
            return;
        }
        DvFolder selectedFolder = this.foldersListModel.getElementAt(selectedFolderIndex).getFolder();
        List armItems2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)selectedFolder.getInnerChildren(), (Function1)showSelectedFolderContent.armItems.1.INSTANCE));
        this.folderContentListModel.replaceAll(armItems2);
    }

    private final void setupLayers() {
        Set selectedDefs = this.service.getSelectedLayerDefs();
        for (LayerRow row : this.layerRows.values()) {
            ButtonKt.selected(row.getCheckBox(), (boolean)selectedDefs.contains(row.getDef()));
        }
    }

    private final void apply() {
        EnumSet<DvTreeLayerDef> newSelectedDefs = EnumSet.noneOf(DvTreeLayerDef.class);
        for (LayerRow lr : this.layerRows.values()) {
            if (!((JBCheckBox)lr.getCheckBox().getComponent()).isSelected()) continue;
            newSelectedDefs.add(lr.getDef());
        }
        this.applyButton.setEnabled(false);
        Intrinsics.checkNotNull(newSelectedDefs);
        this.service.setupLayers((Set)newSelectedDefs);
        DatabaseView.refreshViewNicely(this.project);
        this.setup();
    }

    private final void setupSerialization() {
        this.showSerialization();
        this.showStats();
    }

    private final void showSerialization() {
        DvForestGartner gartner = new DvForestGartner(this.forest);
        this.forestData = gartner.exportState();
        JBTextArea jBTextArea = this.forestTextArea;
        if (jBTextArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"forestTextArea");
            jBTextArea = null;
        }
        String string = this.forestData;
        Intrinsics.checkNotNull((Object)string);
        jBTextArea.setText(string);
        JBTextArea jBTextArea2 = this.forestTextArea;
        if (jBTextArea2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"forestTextArea");
            jBTextArea2 = null;
        }
        jBTextArea2.setCaretPosition(0);
    }

    private final void showStats() {
        Ref.IntRef cntOfFolders = new Ref.IntRef();
        Ref.IntRef cntOfBrokenBushes = new Ref.IntRef();
        HashSet dataSourcesInFolders = new HashSet();
        this.forest.readTree(() -> DatabaseTreeTweakDialog.showStats$lambda$0(this, dataSourcesInFolders, cntOfBrokenBushes, cntOfFolders));
        BasicModelRegistry mr = BasicModelRegistry.Companion.instance();
        List allDataSources = SequencesKt.toList((Sequence)mr.listDataSourceNodesForProject(this.project));
        int cntOfAllDataSources = allDataSources.size();
        int cntOfDataSourcesInFolders = dataSourcesInFolders.size();
        int cntOfForgottenDataSources = CollectionsKt.minus((Iterable)allDataSources, (Iterable)dataSourcesInFolders).size();
        String str = "Folders " + cntOfFolders.element + ", Data Sources " + cntOfAllDataSources + ", In folders " + cntOfDataSourcesInFolders + ", Broken Bushes " + cntOfBrokenBushes.element + ", Forgotten " + cntOfForgottenDataSources;
        JBTextField jBTextField = this.statsTextField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statsTextField");
            jBTextField = null;
        }
        jBTextField.setText(str);
        JBTextField jBTextField2 = this.statsTextField;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statsTextField");
            jBTextField2 = null;
        }
        jBTextField2.setCaretPosition(0);
    }

    private final void collectProblems() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvForestService> serviceClass$iv = DvForestService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvForestService forestService = (DvForestService)object;
        this.problems = forestService.selfInspect();
        this.showProblems();
        JButton jButton = this.problemsFixButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"problemsFixButton");
            jButton = null;
        }
        jButton.setEnabled(!((Collection)this.problems).isEmpty());
    }

    private final void switchProblemGrouping(byte by) {
        if (this.problemsGroupBy == by) {
            return;
        }
        this.problemsGroupBy = by;
        this.showProblems();
    }

    /*
     * WARNING - void declaration
     */
    private final void showProblems() {
        JBTextArea jBTextArea;
        StringBuilder b = new StringBuilder();
        byte by = this.problemsGroupBy;
        if (by == 0) {
            int cnt = 0;
            for (DvForestService.Problem problem : this.problems) {
                b.append(++cnt).append(". ").append(problem.text).append("\n");
            }
        } else if (by == 1) {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = this.problems;
            boolean bl = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                void $this$getOrPut$iv$iv$iv;
                DvForestService.Problem it = (DvForestService.Problem)element$iv$iv;
                boolean bl2 = false;
                DvForestService.ProblemType key$iv$iv = it.type;
                Map map2 = destination$iv$iv;
                DvForestService.ProblemType key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl22 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map groups = destination$iv$iv;
            for (Map.Entry entry : groups.entrySet()) {
                DvForestService.ProblemType type = (DvForestService.ProblemType)entry.getKey();
                List ps = (List)entry.getValue();
                b.append(type.getDisplayName()).append(" (").append(ps.size()).append("):\n");
                for (DvForestService.Problem p : ps) {
                    b.append("  - ").append(p.text).append("\n");
                }
            }
        } else if (by == 2) {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = this.problems;
            boolean bl = false;
            Iterable type = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                DvForestService.Problem it = (DvForestService.Problem)element$iv$iv;
                boolean bl3 = false;
                BasicNode key$iv$iv = it.node;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                BasicNode key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl32 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map groups = destination$iv$iv;
            for (Map.Entry entry : groups.entrySet()) {
                BasicNode node = (BasicNode)entry.getKey();
                List ps = (List)entry.getValue();
                b.append(node.getDisplayName()).append(":\n");
                for (DvForestService.Problem p : ps) {
                    b.append("  - ").append(p.text).append("\n");
                }
            }
        }
        if ((jBTextArea = this.problemsTextArea) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"problemsTextArea");
            jBTextArea = null;
        }
        jBTextArea.setText(b.toString());
    }

    private final void recoverProblems() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvForestService> serviceClass$iv = DvForestService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvForestService forestService = (DvForestService)object;
        forestService.recoverProblems();
        $this$service$iv = (ComponentManager)this.project;
        $i$f$service = false;
        serviceClass$iv = DatabaseViewService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((DatabaseViewService)object2).refreshTree(false, null);
        this.collectProblems();
    }

    private final void reimportAllDS() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvForestService> serviceClass$iv = DvForestService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvForestService forestService = (DvForestService)object;
        DvForestService.importRestDataSources$default((DvForestService)forestService, (boolean)false, (int)1, null);
        this.setupSerialization();
    }

    public void dispose() {
        this.mainPane.setVisible(false);
        this.mainPane.removeAll();
    }

    private static final void lambda$0$0(DatabaseTreeTweakDialog this$0, ListSelectionEvent it) {
        this$0.showSelectedFolderContent();
    }

    private static final Unit lambda$3$0(JSplitPane $forestSplitPane, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$forestSplitPane).align(Align.FILL);
        $this$row.resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$2$1(Ref.ObjectRef $applyButton, JBCheckBox it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            JButton jButton = (JButton)$applyButton.element;
            if (jButton == null) break block0;
            jButton.setEnabled(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$3$0(DatabaseTreeTweakDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.apply();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.layout(RowLayout.PARENT_GRID);
        $this$row.label("Layer");
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.layout(RowLayout.PARENT_GRID);
        $this$row.label("Root").customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)new IntelliJSpacingConfiguration().getHorizontalIndent(), (int)0, (int)0, (int)13, null));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$2(DvTreeLayerDef $def, EnumMap $layerRows, DatabaseTreeTweakDialog this$0, Ref.ObjectRef $applyButton, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.layout(RowLayout.PARENT_GRID);
        Cell $this$lambda_u244_u242_u240 = cell = $this$row.checkBox($def.getDisplayName());
        boolean bl = false;
        $this$lambda_u244_u242_u240.enabled(this$0.storeyLayers.keySet().contains($def));
        Cell cb = cell;
        cb.onChanged(arg_0 -> DatabaseTreeTweakDialog.lambda$4$2$1($applyButton, arg_0));
        ((Map)$layerRows).put($def, new LayerRow($def, (Cell<? extends JBCheckBox>)cb));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$3(Ref.ObjectRef $applyButton, DatabaseTreeTweakDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell b = $this$row.button("Apply Layers", arg_0 -> DatabaseTreeTweakDialog.lambda$4$3$0(this$0, arg_0));
        $applyButton.element = b.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$0$0$0(DatabaseTreeTweakDialog this$0, FocusEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setupSerialization();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$0$0(DatabaseTreeTweakDialog this$0, JBTextArea $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.forestTextArea = $this$applyToComponent;
        $this$applyToComponent.setEditable(false);
        $this$applyToComponent.setLineWrap(false);
        $this$applyToComponent.setRows(15);
        $this$applyToComponent.setColumns(60);
        $this$applyToComponent.setFont(new Font("Monospaced", 0, $this$applyToComponent.getFont().getSize()));
        ListenerUiUtil.onceWhenFocusGained$default((Component)((Component)$this$applyToComponent), null, arg_0 -> DatabaseTreeTweakDialog.lambda$5$0$0$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$1$0(DatabaseTreeTweakDialog this$0, JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.statsTextField = $this$applyToComponent;
        $this$applyToComponent.setEditable(false);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$2$0(DatabaseTreeTweakDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reimportAllDS();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$0(DatabaseTreeTweakDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.textArea().align(Align.FILL).applyToComponent(arg_0 -> DatabaseTreeTweakDialog.lambda$5$0$0(this$0, arg_0));
        $this$row.resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$1(DatabaseTreeTweakDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.textField().align((Align)AlignX.FILL.INSTANCE).applyToComponent(arg_0 -> DatabaseTreeTweakDialog.lambda$5$1$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$2(DatabaseTreeTweakDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button("Reimport All DS", arg_0 -> DatabaseTreeTweakDialog.lambda$5$2$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$0$0$0$0$0(DatabaseTreeTweakDialog this$0, JBRadioButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isSelected()) {
            this$0.switchProblemGrouping((byte)0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$0$0$0$0$1(DatabaseTreeTweakDialog this$0, JBRadioButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isSelected()) {
            this$0.switchProblemGrouping((byte)1);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$0$0$0$0$2(DatabaseTreeTweakDialog this$0, JBRadioButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isSelected()) {
            this$0.switchProblemGrouping((byte)2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$0$0$0$0(DatabaseTreeTweakDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label("Group:");
        ButtonKt.selected((Cell)Row.radioButton$default((Row)$this$row, (String)"no", null, (int)2, null), (boolean)true).onChanged(arg_0 -> DatabaseTreeTweakDialog.lambda$6$0$0$0$0$0(this$0, arg_0));
        Row.radioButton$default((Row)$this$row, (String)"by type", null, (int)2, null).onChanged(arg_0 -> DatabaseTreeTweakDialog.lambda$6$0$0$0$0$1(this$0, arg_0));
        Row.radioButton$default((Row)$this$row, (String)"by node", null, (int)2, null).onChanged(arg_0 -> DatabaseTreeTweakDialog.lambda$6$0$0$0$0$2(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$0$0$0(DatabaseTreeTweakDialog this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> DatabaseTreeTweakDialog.lambda$6$0$0$0$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$0$0(DatabaseTreeTweakDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> DatabaseTreeTweakDialog.lambda$6$0$0$0(this$0, arg_0), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$0$1(DatabaseTreeTweakDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.collectProblems();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$1$0(JBTextArea $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setEditable(false);
        $this$applyToComponent.setLineWrap(false);
        $this$applyToComponent.setFont(new Font("Monospaced", 0, $this$applyToComponent.getFont().getSize()));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$2$0(DatabaseTreeTweakDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.recoverProblems();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$0(DatabaseTreeTweakDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> DatabaseTreeTweakDialog.lambda$6$0$0(this$0, arg_0));
        $this$row.button("Refresh", arg_0 -> DatabaseTreeTweakDialog.lambda$6$0$1(this$0, arg_0)).align((Align)AlignX.RIGHT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$1(DatabaseTreeTweakDialog this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell it = cell = $this$row.textArea().align(Align.FILL).applyToComponent(DatabaseTreeTweakDialog::lambda$6$1$0);
        boolean bl = false;
        this$0.problemsTextArea = (JBTextArea)it.getComponent();
        $this$row.resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$2(DatabaseTreeTweakDialog this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell it = cell = $this$row.button("Recover", arg_0 -> DatabaseTreeTweakDialog.lambda$6$2$0(this$0, arg_0)).enabled(false).align((Align)AlignX.RIGHT.INSTANCE);
        boolean bl = false;
        this$0.problemsFixButton = (JButton)it.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$0(DatabaseTreeTweakDialog this$0) {
        this$0.setupSerialization();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$1(DatabaseTreeTweakDialog this$0) {
        this$0.collectProblems();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(JSplitPane $forestSplitPane, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$3$0($forestSplitPane, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(DatabaseTreeTweakDialog this$0, EnumMap $layerRows, Ref.ObjectRef $applyButton, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row("#", DatabaseTreeTweakDialog::lambda$4$0);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        $this$panel.row("0", DatabaseTreeTweakDialog::lambda$4$1);
        for (DvTreeLayerDef def : this$0.allDefs) {
            $this$panel.row(String.valueOf(def.getLevel()), arg_0 -> DatabaseTreeTweakDialog.lambda$4$2(def, $layerRows, this$0, $applyButton, arg_0));
        }
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$4$3($applyButton, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(DatabaseTreeTweakDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$5$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$5$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$5$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(DatabaseTreeTweakDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$6$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$6$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseTreeTweakDialog.lambda$6$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final FolderItem setupForest$lambda$0(DvFolder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new FolderItem(it);
    }

    private static final Unit showStats$lambda$0(DatabaseTreeTweakDialog this$0, HashSet $dataSourcesInFolders, Ref.IntRef $cntOfBrokenBushes, Ref.IntRef $cntOfFolders) {
        Sequence allFolders = this$0.forest.getRoot().traversFolders();
        for (DvFolder f : allFolders) {
            Iterator iterator;
            Intrinsics.checkNotNullExpressionValue(f.getInnerBushRefList().iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                DataSourceNode dsn;
                DvBushRef r = (DvBushRef)iterator.next();
                if (r.isValid()) {
                    BasicUniqueBush basicUniqueBush = r.getBush();
                    Intrinsics.checkNotNull((Object)basicUniqueBush, (String)"null cannot be cast to non-null type com.intellij.database.view.DataSourceNode");
                    v1 = (DataSourceNode)basicUniqueBush;
                } else {
                    v1 = dsn = null;
                }
                if (dsn != null) {
                    ((Collection)$dataSourcesInFolders).add(dsn);
                    continue;
                }
                int n = $cntOfBrokenBushes.element;
                $cntOfBrokenBushes.element = n + 1;
            }
            int n = $cntOfFolders.element;
            $cntOfFolders.element = n + 1;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u00020\tH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog$ArmItem;", "", "arm", "Lcom/intellij/database/explorer/forest/DvArm;", "<init>", "(Lcom/intellij/database/explorer/forest/DvArm;)V", "getArm", "()Lcom/intellij/database/explorer/forest/DvArm;", "toString", "", "intellij.database.impl"})
    private static final class ArmItem {
        @NotNull
        private final DvArm arm;

        public ArmItem(@NotNull DvArm arm) {
            Intrinsics.checkNotNullParameter((Object)arm, (String)"arm");
            this.arm = arm;
        }

        @NotNull
        public final DvArm getArm() {
            return this.arm;
        }

        @NotNull
        public String toString() {
            Object object;
            char litera = '\u0000';
            Object text = null;
            DvArm dvArm = this.arm;
            if (dvArm instanceof DvFolder) {
                litera = 'F';
                String string = ((DvFolder)this.arm).getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
                text = string;
            } else if (dvArm instanceof DvBushRef) {
                litera = 'B';
                BasicUniqueBush basicUniqueBush = ((DvBushRef)this.arm).getBush();
                Intrinsics.checkNotNull((Object)basicUniqueBush, (String)"null cannot be cast to non-null type com.intellij.database.view.DataSourceNode");
                DataSourceNode dsn = (DataSourceNode)basicUniqueBush;
                text = ((DvBushRef)this.arm).getDisplayName() + " (" + dsn.getUniqueId() + ")";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if ((object = this.arm.getParent()) == null || (object = String.valueOf(object.getOrderId())) == null) {
                object = "*";
            }
            Object parentId = object;
            String prefix = litera + "." + this.arm.getPosition() + " [" + this.arm.getOrderId() + ":" + (String)parentId + "] ";
            return prefix + (String)text;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u00020\tH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog$FolderItem;", "", "folder", "Lcom/intellij/database/explorer/forest/DvFolder;", "<init>", "(Lcom/intellij/database/explorer/forest/DvFolder;)V", "getFolder", "()Lcom/intellij/database/explorer/forest/DvFolder;", "toString", "", "intellij.database.impl"})
    private static final class FolderItem {
        @NotNull
        private final DvFolder folder;

        public FolderItem(@NotNull DvFolder folder) {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            this.folder = folder;
        }

        @NotNull
        public final DvFolder getFolder() {
            return this.folder;
        }

        @NotNull
        public String toString() {
            return StringsKt.repeat((CharSequence)"    ", (int)this.folder.getLevel()) + this.folder.getDisplayName() + "  (" + this.folder.getInnerFolders().size() + " + " + this.folder.getInnerBushRefList().size() + ")";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog$LayerRow;", "", "def", "Lcom/intellij/database/explorer/structure/DvTreeLayerDef;", "checkBox", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBCheckBox;", "<init>", "(Lcom/intellij/database/explorer/structure/DvTreeLayerDef;Lcom/intellij/ui/dsl/builder/Cell;)V", "getDef", "()Lcom/intellij/database/explorer/structure/DvTreeLayerDef;", "getCheckBox", "()Lcom/intellij/ui/dsl/builder/Cell;", "intellij.database.impl"})
    private static final class LayerRow {
        @NotNull
        private final DvTreeLayerDef def;
        @NotNull
        private final Cell<JBCheckBox> checkBox;

        public LayerRow(@NotNull DvTreeLayerDef def, @NotNull Cell<? extends JBCheckBox> checkBox) {
            Intrinsics.checkNotNullParameter((Object)def, (String)"def");
            Intrinsics.checkNotNullParameter(checkBox, (String)"checkBox");
            this.def = def;
            this.checkBox = checkBox;
        }

        @NotNull
        public final DvTreeLayerDef getDef() {
            return this.def;
        }

        @NotNull
        public final Cell<JBCheckBox> getCheckBox() {
            return this.checkBox;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004J\u0006\u0010\u000e\u001a\u00020\rJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0013R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/view/internals/DatabaseTreeTweakDialog$SimpleListModel;", "E", "Ljavax/swing/AbstractListModel;", "items", "", "<init>", "(Ljava/util/Collection;)V", "()V", "list", "", "getList", "()Ljava/util/List;", "replaceAll", "", "clear", "getSize", "", "getElementAt", "index", "(I)Ljava/lang/Object;", "intellij.database.impl"})
    private static final class SimpleListModel<E>
    extends AbstractListModel<E> {
        @NotNull
        private final List<E> list;

        @NotNull
        public final List<E> getList() {
            return this.list;
        }

        public SimpleListModel(@NotNull Collection<? extends E> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.list = new ArrayList<E>(items);
        }

        public SimpleListModel() {
            this.list = new ArrayList();
        }

        public final void replaceAll(@NotNull Collection<? extends E> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            int oldSize = this.list.size();
            this.list.clear();
            this.list.addAll(items);
            int newSize = this.list.size();
            int minSize = Math.min(oldSize, newSize);
            if (oldSize > minSize) {
                this.fireIntervalRemoved(this, minSize, oldSize - 1);
            }
            this.fireContentsChanged(this, 0, minSize - 1);
            if (newSize > minSize) {
                this.fireIntervalAdded(this, minSize, newSize - 1);
            }
        }

        public final void clear() {
            int size = this.list.size();
            if (size > 0) {
                this.list.clear();
                this.fireIntervalRemoved(this, 0, size - 1);
            }
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public E getElementAt(int index) {
            return this.list.get(index);
        }
    }
}

