/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.properties.datasource.detector;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.model.SpringDataSourceInfoProvider;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/boot/properties/datasource/detector/SpringBootConfigDataSourceInfoProvider;", "Lcom/intellij/spring/model/SpringDataSourceInfoProvider;", "<init>", "()V", "getModuleDataSourceUrls", "", "", "module", "Lcom/intellij/openapi/module/Module;", "getUrlFromFile", "propertiesFile", "Lcom/intellij/lang/properties/psi/PropertiesFile;", "intellij.spring.boot.properties.datasource"})
@SourceDebugExtension(value={"SMAP\nSpringBootConfigDataSourceInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootConfigDataSourceInfoProvider.kt\ncom/intellij/spring/boot/properties/datasource/detector/SpringBootConfigDataSourceInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n1#2:30\n*E\n"})
public final class SpringBootConfigDataSourceInfoProvider
implements SpringDataSourceInfoProvider {
    @NotNull
    public List<String> getModuleDataSourceUrls(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List result = new ArrayList();
        for (VirtualFile file : SpringBootConfigurationFileService.getInstance().findConfigFiles(module, false)) {
            String it;
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
            PropertiesFile propertiesFile = psiFile instanceof PropertiesFile ? (PropertiesFile)psiFile : null;
            if (propertiesFile == null) continue;
            PropertiesFile propertiesFile2 = propertiesFile;
            if (this.getUrlFromFile(propertiesFile2) == null) continue;
            boolean bl = false;
            result.add(it);
        }
        return result;
    }

    private final String getUrlFromFile(PropertiesFile propertiesFile) {
        return (String)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)propertiesFile.getContainingFile()), () -> SpringBootConfigDataSourceInfoProvider.getUrlFromFile$lambda$0(propertiesFile));
    }

    private static final CachedValueProvider.Result getUrlFromFile$lambda$0(PropertiesFile $propertiesFile) {
        IProperty iProperty = $propertiesFile.findPropertyByKey("spring.datasource.url");
        String value = iProperty != null ? iProperty.getValue() : null;
        Object[] objectArray = (Object[])value;
        String url = objectArray == null || StringsKt.isBlank((CharSequence)objectArray) ? null : value;
        objectArray = new Object[]{$propertiesFile};
        return CachedValueProvider.Result.create((Object)url, (Object[])objectArray);
    }
}

