/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.core.FileState;
import com.intellij.settingsSync.core.FileStateKt;
import com.intellij.settingsSync.core.GitSettingsLogKt;
import com.intellij.settingsSync.core.SettingsLog;
import com.intellij.settingsSync.core.SettingsProvider;
import com.intellij.settingsSync.core.SettingsSnapshot;
import com.intellij.settingsSync.core.SettingsSnapshotKt;
import com.intellij.settingsSync.core.SettingsSnapshotZipSerializer;
import com.intellij.settingsSync.core.SettingsSyncLocalSettings;
import com.intellij.settingsSync.core.communicator.SettingsSyncUserData;
import com.intellij.settingsSync.core.notification.NotificationService;
import com.intellij.settingsSync.core.plugins.SettingsSyncPluginsState;
import com.intellij.settingsSync.core.plugins.SettingsSyncPluginsStateMerger;
import com.intellij.settingsSync.core.statistics.SettingsSyncEventsStatistics;
import com.intellij.util.io.PathKt;
import com.intellij.util.system.OS;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.EmptyCommitException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0010\b\u0007\u0018\u0000 \u0088\u00012\u00020\u00012\u00020\u0002:\u0006\u0087\u0001\u0088\u0001\u0089\u0001BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0004H\u0002J\b\u0010'\u001a\u00020$H\u0002J\b\u0010(\u001a\u00020!H\u0002J\b\u0010)\u001a\u00020!H\u0016J\u0018\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020$H\u0002J\b\u0010.\u001a\u00020!H\u0002J\u0010\u0010/\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020,H\u0016J\u0018\u00103\u001a\u00020!2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020,H\u0016J\u0018\u00104\u001a\u0002052\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020,H\u0016J*\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020,2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020,2\b\b\u0002\u00108\u001a\u00020$H\u0002J \u00109\u001a\u00020!2\u0006\u00107\u001a\u00020,2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020,H\u0002J\u001c\u0010:\u001a\u00020,2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010,H\u0002J\u0018\u0010>\u001a\u00020!2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0004H\u0002J$\u0010B\u001a\u00020!2\u0006\u00102\u001a\u00020,2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020$H\u0002J\u0018\u0010F\u001a\u00020!2\u0006\u0010B\u001a\u00020G2\u0006\u0010C\u001a\u00020DH\u0002J\b\u0010H\u001a\u00020!H\u0016J\b\u0010I\u001a\u00020\fH\u0016J\n\u0010J\u001a\u0004\u0018\u00010KH\u0002J\b\u0010L\u001a\u000205H\u0016J\b\u0010M\u001a\u000205H\u0016J\b\u0010N\u001a\u000205H\u0016J\u0010\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\u0016H\u0002J\u0010\u0010R\u001a\u00020!2\u0006\u0010S\u001a\u000205H\u0016J\u0010\u0010T\u001a\u00020!2\u0006\u0010S\u001a\u000205H\u0016J\u0010\u0010U\u001a\u00020!2\u0006\u0010S\u001a\u000205H\u0016J\u0018\u0010V\u001a\u00020\u00162\u0006\u00107\u001a\u00020,2\u0006\u0010W\u001a\u000205H\u0002J\b\u0010X\u001a\u000205H\u0016J\u0010\u0010Y\u001a\u00020!2\u0006\u0010Z\u001a\u00020,H\u0016J\u0018\u0010[\u001a\u00020!2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020]H\u0002J\u0018\u0010_\u001a\u00020`2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010a\u001a\u00020]H\u0002J8\u0010b\u001a\u00020,\"\b\b\u0000\u0010c*\u00020d2\f\u0010e\u001a\b\u0012\u0004\u0012\u0002Hc0f2\u0006\u0010g\u001a\u00020,2\u0006\u0010h\u001a\u00020G2\u0006\u0010i\u001a\u00020GH\u0002J \u0010j\u001a\u00020,2\u0006\u0010k\u001a\u00020,2\u0006\u0010h\u001a\u00020G2\u0006\u0010i\u001a\u00020GH\u0002Jp\u0010l\u001a\u00020,\"\u0004\b\u0000\u0010c2\u0006\u0010g\u001a\u00020,2\u0006\u0010h\u001a\u00020G2\u0006\u0010i\u001a\u00020G2\u0012\u0010m\u001a\u000e\u0012\u0004\u0012\u0002Hc\u0012\u0004\u0012\u00020,0\u000b2\u0012\u0010n\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u0002Hc0\u000b2 \u0010o\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u0001Hc\u0012\u0004\u0012\u0002Hc\u0012\u0004\u0012\u0002Hc\u0012\u0004\u0012\u0002Hc0pH\u0002J\"\u0010q\u001a\u0004\u0018\u00010,2\u0006\u0010k\u001a\u00020,2\u0006\u0010r\u001a\u00020G2\u0006\u0010s\u001a\u00020GH\u0002J\u001a\u0010t\u001a\u0004\u0018\u00010G2\u0006\u0010r\u001a\u00020G2\u0006\u0010s\u001a\u00020GH\u0002J\u0018\u0010u\u001a\u00020,2\u0006\u0010v\u001a\u00020,2\u0006\u0010w\u001a\u00020GH\u0002J&\u0010x\u001a\u00020!2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020,0z2\u0006\u0010{\u001a\u00020G2\u0006\u0010|\u001a\u00020GH\u0002J\u001a\u0010}\u001a\u0004\u0018\u00010G2\u0006\u0010~\u001a\u00020,2\u0006\u0010\u007f\u001a\u00020\u0016H\u0002J\u0011\u0010\u0080\u0001\u001a\u00020G2\u0006\u0010Q\u001a\u00020\u0016H\u0002J\u0011\u0010\u0081\u0001\u001a\u00020D2\u0006\u0010B\u001a\u00020GH\u0002J\t\u0010\u0082\u0001\u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0083\u0001\u001a\u00020,*\u00020\u00168BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001R\u001b\u0010\u0083\u0001\u001a\u00020,*\u00020]8BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u0084\u0001\u0010\u0086\u0001\u00a8\u0006\u008a\u0001"}, d2={"Lcom/intellij/settingsSync/core/GitSettingsLog;", "Lcom/intellij/settingsSync/core/SettingsLog;", "Lcom/intellij/openapi/Disposable;", "settingsSyncStorage", "Ljava/nio/file/Path;", "rootConfigPath", "parentDisposable", "userDataProvider", "Lkotlin/Function0;", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncUserData;", "initialSnapshotProvider", "Lkotlin/Function1;", "Lcom/intellij/settingsSync/core/SettingsSnapshot;", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "FIVE_SECONDS", "", "repository", "Lorg/eclipse/jgit/lib/Repository;", "git", "Lorg/eclipse/jgit/api/Git;", "master", "Lorg/eclipse/jgit/lib/Ref;", "getMaster", "()Lorg/eclipse/jgit/lib/Ref;", "ide", "getIde", "cloud", "getCloud", "pluginsFile", "json", "Lkotlinx/serialization/json/Json;", "initialize", "", "initAndCheckRepository", "canRetry", "", "checkLocks", "dotGit", "isRepositoryConsistent", "configureJGit", "logExistingSettings", "createBranchIfNeeded", "name", "", "newRepository", "copyExistingSettings", "addInitialCommit", "applyIdeState", "snapshot", "message", "applyCloudState", "forceWriteToMaster", "Lcom/intellij/settingsSync/core/SettingsLog$Position;", "applyState", "refName", "warnAboutEmptySnapshot", "applySnapshotAndCommit", "buildCommitMessage", "info", "Lcom/intellij/settingsSync/core/SettingsSnapshot$AppInfo;", "restoresRevision", "writeFileStateContent", "fileState", "Lcom/intellij/settingsSync/core/FileState;", "fileToWrite", "commit", "dateCreated", "Ljava/time/Instant;", "allowEmpty", "recordCreationDate", "Lorg/eclipse/jgit/revwalk/RevCommit;", "dispose", "collectCurrentSnapshot", "readPluginsState", "Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginsState;", "getIdePosition", "getCloudPosition", "getMasterPosition", "getPosition", "Lcom/intellij/settingsSync/core/GitSettingsLog$BranchPosition;", "ref", "setIdePosition", "position", "setCloudPosition", "setMasterPosition", "updateBranchPosition", "targetPosition", "advanceMaster", "restoreStateAt", "commitHash", "removeNewlyAddedFiles", "revisionBefore", "Lorg/eclipse/jgit/lib/ObjectId;", "revisionAfter", "prepareTreeParser", "Lorg/eclipse/jgit/treewalk/AbstractTreeIterator;", "objectId", "mergeSettingsProviderFile", "T", "", "settingsProvider", "Lcom/intellij/settingsSync/core/SettingsProvider;", "relativePath", "ideBranchTip", "cloudBranchTip", "mergePluginJson", "pluginJson", "smartMergeFile", "serializer", "deserializer", "merger", "Lkotlin/Function3;", "findMergeBaseContent", "commit1", "commit2", "findMergeBase", "getFileContentInBranch", "file", "branchTip", "mergeFilesOneByOne", "conflictingFiles", "", "ideTip", "cloudTip", "getLatestCommitForFile", "filePath", "branch", "getBranchTip", "getDate", "abortMerge", "short", "getShort", "(Lorg/eclipse/jgit/lib/Ref;)Ljava/lang/String;", "(Lorg/eclipse/jgit/lib/ObjectId;)Ljava/lang/String;", "BranchPosition", "Companion", "MockGpgSigner", "intellij.settingsSync.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGitSettingsLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSettingsLog.kt\ncom/intellij/settingsSync/core/GitSettingsLog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,706:1\n1915#2,2:707\n1807#2,3:718\n1807#2,3:721\n205#3:709\n222#3:717\n205#3:724\n222#3:725\n1#4:710\n1184#5,3:711\n1184#5,3:714\n13#6:726\n*S KotlinDebug\n*F\n+ 1 GitSettingsLog.kt\ncom/intellij/settingsSync/core/GitSettingsLog\n*L\n131#1:707,2\n431#1:718,3\n433#1:721,3\n233#1:709\n352#1:717\n534#1:724\n533#1:725\n334#1:711,3\n342#1:714,3\n675#1:726\n*E\n"})
public final class GitSettingsLog
implements SettingsLog,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path settingsSyncStorage;
    @NotNull
    private final Path rootConfigPath;
    @NotNull
    private final Function0<SettingsSyncUserData> userDataProvider;
    @NotNull
    private final Function1<SettingsSnapshot, SettingsSnapshot> initialSnapshotProvider;
    private final int FIVE_SECONDS;
    private Repository repository;
    private Git git;
    @NotNull
    private final Path pluginsFile;
    @NotNull
    private final Json json;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String MASTER_REF_NAME = "master";
    @NotNull
    public static final String IDE_REF_NAME = "ide";
    @NotNull
    public static final String CLOUD_REF_NAME = "cloud";
    @NotNull
    public static final String PLUGINS_FILE = "plugins.json";
    @NotNull
    public static final String METAINFO_FOLDER = ".metainfo";
    @NotNull
    public static final String DATE_PREFIX = "date: ";
    private static final Pattern DATE_PATTERN;

    public GitSettingsLog(@NotNull Path settingsSyncStorage, @NotNull Path rootConfigPath, @NotNull Disposable parentDisposable, @NotNull Function0<SettingsSyncUserData> userDataProvider, @NotNull Function1<? super SettingsSnapshot, SettingsSnapshot> initialSnapshotProvider) {
        Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
        Intrinsics.checkNotNullParameter((Object)rootConfigPath, (String)"rootConfigPath");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(userDataProvider, (String)"userDataProvider");
        Intrinsics.checkNotNullParameter(initialSnapshotProvider, (String)"initialSnapshotProvider");
        this.settingsSyncStorage = settingsSyncStorage;
        this.rootConfigPath = rootConfigPath;
        this.userDataProvider = userDataProvider;
        this.initialSnapshotProvider = initialSnapshotProvider;
        this.FIVE_SECONDS = 5000;
        Path path = this.settingsSyncStorage.resolve(METAINFO_FOLDER);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path.resolve(PLUGINS_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        this.pluginsFile = path2;
        this.json = JsonKt.Json$default(null, GitSettingsLog::json$lambda$0, (int)1, null);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    private final Ref getMaster() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        Ref ref = repository.findRef(MASTER_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    private final Ref getIde() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        Ref ref = repository.findRef(IDE_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    private final Ref getCloud() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        Ref ref = repository.findRef(CLOUD_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    @Override
    public void initialize() {
        this.configureJGit();
        this.initAndCheckRepository(true);
    }

    private final void initAndCheckRepository(boolean canRetry) {
        Repository repository;
        boolean newRepository;
        Path path = this.settingsSyncStorage.resolve(".git");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path dotGit = path;
        Repository repository2 = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(dotGit.toFile())).setAutonomous(true)).readEnvironment()).build();
        Intrinsics.checkNotNullExpressionValue((Object)repository2, (String)"build(...)");
        this.repository = repository2;
        Repository repository3 = this.repository;
        if (repository3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository3 = null;
        }
        this.git = new Git(repository3);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = newRepository = !Files.exists(dotGit, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        if (newRepository) {
            LOG.info("Initializing new Git repository for Settings Sync at " + this.settingsSyncStorage);
            Repository repository4 = this.repository;
            if (repository4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository4 = null;
            }
            repository4.create();
            Repository repository5 = this.repository;
            if (repository5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository5 = null;
            }
            this.addInitialCommit(repository5);
        } else {
            this.checkLocks(dotGit);
            if (!this.isRepositoryConsistent()) {
                if (!canRetry) {
                    throw new RuntimeException("Settings Sync local repository is corrupted after retry. Will not enable settings sync");
                }
                LOG.warn("Settings Sync repository is corrupted, removing it");
                if (FileUtil.delete((File)this.settingsSyncStorage.toFile())) {
                    this.initAndCheckRepository(false);
                } else {
                    throw new RuntimeException("Settings Sync local repository is corrupted and cannot be deleted. Will not enable settings sync");
                }
            }
        }
        if ((repository = this.repository) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        if (!GitSettingsLogKt.headCommitExists(repository)) {
            Repository repository6 = this.repository;
            if (repository6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository6 = null;
            }
            this.addInitialCommit(repository6);
        }
        this.createBranchIfNeeded(MASTER_REF_NAME, newRepository);
        this.createBranchIfNeeded(CLOUD_REF_NAME, newRepository);
        this.createBranchIfNeeded(IDE_REF_NAME, newRepository);
    }

    private final void checkLocks(Path dotGit) {
        List rootLockEntries = PathsKt.listDirectoryEntries((Path)dotGit, (String)"*.lock");
        Path path = dotGit.resolve("refs");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path.resolve("heads");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path refsHeads = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(refsHeads, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.warn("refs/heads is absent under " + dotGit + ". Will reinitialize the repo from scratch");
            return;
        }
        List headsLockEntries = PathsKt.listDirectoryEntries((Path)refsHeads, (String)"*.lock");
        for (Path lock : CollectionsKt.plus((Collection)rootLockEntries, (Iterable)headsLockEntries)) {
            long l = System.currentTimeMillis();
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            FileTime fileTime = Files.getLastModifiedTime(lock, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
            if (l - fileTime.toMillis() > (long)this.FIVE_SECONDS) {
                FileUtil.delete((Path)lock);
                continue;
            }
            Path path3 = lock.getFileName();
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            FileTime fileTime2 = Files.getLastModifiedTime(lock, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length));
            Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"getLastModifiedTime(...)");
            LOG.warn("Found new lock (" + path3 + ") modified " + fileTime2.toInstant() + ". Repo initialization might fail");
        }
    }

    private final boolean isRepositoryConsistent() {
        try {
            LOG.info("Checking consistency of the repository...");
            Git git = this.git;
            if (git == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                git = null;
            }
            Object object = git.log().call();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"call(...)");
            List commits = CollectionsKt.toList((Iterable)object);
            Iterable $this$forEach$iv = commits;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RevCommit it = (RevCommit)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                LOG.debug("Found local commit " + this.getShort(it));
            }
            Git git2 = this.git;
            if (git2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                git2 = null;
            }
            Status status = git2.status().call();
            LOG.info("Local repository has " + commits.size() + ". Status: " + (status.isClean() ? "Clean" : "Dirty"));
            return true;
        }
        catch (Exception ex) {
            LOG.warn("An exception occurred while checking repository consistency. Will delete the repository", (Throwable)ex);
            return false;
        }
    }

    private final void configureJGit() {
        GpgSigner.setDefault(new MockGpgSigner());
    }

    @Override
    public void logExistingSettings() {
        this.copyExistingSettings();
    }

    private final void createBranchIfNeeded(String name, boolean newRepository) {
        Ref ref;
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        if ((ref = repository.findRef(name)) == null) {
            Git git;
            Repository repository2 = this.repository;
            if (repository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository2 = null;
            }
            RevCommit head = GitSettingsLogKt.headCommit(repository2);
            if (!newRepository) {
                ObjectId objectId = head.toObjectId();
                Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"toObjectId(...)");
                LOG.warn("Ref with name " + name + " not found in existing repository. Recreating at position of HEAD@" + this.getShort(objectId));
            }
            if ((git = this.git) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                git = null;
            }
            git.branchCreate().setName(name).setStartPoint(head).call();
        }
    }

    private final void copyExistingSettings() {
        LOG.info("Copying existing settings from " + this.rootConfigPath + " to " + this.settingsSyncStorage);
        SettingsSnapshot snapshot = (SettingsSnapshot)this.initialSnapshotProvider.invoke((Object)this.collectCurrentSnapshot());
        this.applyState(IDE_REF_NAME, snapshot, "Copy current configs", false);
    }

    private final void addInitialCommit(Repository repository) {
        Path gitignore = this.settingsSyncStorage.resolve(".gitignore");
        Intrinsics.checkNotNull((Object)gitignore);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(gitignore, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(PathKt.createParentDirectories((Path)gitignore), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        }
        PathKt.write$default((Path)gitignore, (CharSequence)"event-log-metadata\njdbc-drivers\nssl\nport\nport.lock\nupdatedBrokenPlugins.db\n", null, (boolean)false, (int)6, null);
        Git git = new Git(repository);
        git.add().addFilepattern(".gitignore").call();
        GitSettingsLog.commit$default(this, "Initial", null, false, 2, null);
    }

    @Override
    public void applyIdeState(@NotNull SettingsSnapshot snapshot, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GitSettingsLog.applyState$default(this, IDE_REF_NAME, snapshot, message, false, 8, null);
    }

    @Override
    public void applyCloudState(@NotNull SettingsSnapshot snapshot, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GitSettingsLog.applyState$default(this, CLOUD_REF_NAME, snapshot, message, false, 8, null);
    }

    @Override
    @NotNull
    public SettingsLog.Position forceWriteToMaster(@NotNull SettingsSnapshot snapshot, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GitSettingsLog.applyState$default(this, MASTER_REF_NAME, snapshot, message, false, 8, null);
        return this.getMasterPosition();
    }

    private final void applyState(String refName, SettingsSnapshot snapshot, String message, boolean warnAboutEmptySnapshot) {
        if (snapshot.isEmpty()) {
            if (warnAboutEmptySnapshot) {
                LOG.error("Empty snapshot, requested to apply on branch '" + refName + "' with message '" + message + "'");
            }
            return;
        }
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.checkout().setName(refName).call();
        this.applySnapshotAndCommit(refName, snapshot, message);
    }

    static /* synthetic */ void applyState$default(GitSettingsLog gitSettingsLog, String string, SettingsSnapshot settingsSnapshot, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        gitSettingsLog.applyState(string, settingsSnapshot, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void applySnapshotAndCommit(String refName, SettingsSnapshot snapshot, String message) {
        Path file;
        LOG.info("Applying settings changes to branch " + refName + ": " + CollectionsKt.joinToString$default((Iterable)snapshot.getFileStates(), null, null, null, (int)5, null, GitSettingsLog::applySnapshotAndCommit$lambda$0, (int)23, null));
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        AddCommand addCommand = git.add();
        for (FileState fileState : snapshot.getFileStates()) {
            file = this.settingsSyncStorage.resolve(fileState.getFile());
            Intrinsics.checkNotNull((Object)file);
            this.writeFileStateContent(fileState, file);
            addCommand.addFilepattern(fileState.getFile());
        }
        for (FileState fileState : snapshot.getAdditionalFiles()) {
            file = this.settingsSyncStorage.resolve(METAINFO_FOLDER).resolve(fileState.getFile());
            Intrinsics.checkNotNull((Object)file);
            this.writeFileStateContent(fileState, file);
            addCommand.addFilepattern(".metainfo/" + fileState.getFile());
        }
        if (snapshot.getPlugins() != null) {
            void this_$iv;
            SettingsSyncPluginsState sortedState = new SettingsSyncPluginsState(MapsKt.toSortedMap(snapshot.getPlugins().getPlugins()));
            file = this.json;
            Object value$iv = sortedState;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String string = this_$iv.encodeToString((SerializationStrategy)SettingsSyncPluginsState.Companion.serializer(), value$iv);
            PathKt.write$default((Path)this.pluginsFile, (CharSequence)string, null, (boolean)false, (int)6, null);
            addCommand.addFilepattern(".metainfo/plugins.json");
        }
        for (Map.Entry entry : SettingsSnapshotZipSerializer.INSTANCE.serializeSettingsProviders$intellij_settingsSync_core(snapshot.getSettingsFromProviders()).entrySet()) {
            String relativePath = (String)entry.getKey();
            String content = (String)entry.getValue();
            Path path = this.settingsSyncStorage.resolve(METAINFO_FOLDER).resolve(relativePath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            PathKt.write$default((Path)path, (CharSequence)content, null, (boolean)false, (int)6, null);
            addCommand.addFilepattern(".metainfo/" + relativePath);
        }
        addCommand.call();
        SettingsSnapshot.AppInfo info = snapshot.getMetaInfo().getAppInfo();
        String string = this.buildCommitMessage(info, null);
        this.commit(message + string, snapshot.getMetaInfo().getDateCreated(), false);
    }

    private final String buildCommitMessage(SettingsSnapshot.AppInfo info, String restoresRevision) {
        Object object;
        block8: {
            block7: {
                block4: {
                    Object object2;
                    String baseMessage;
                    block6: {
                        block5: {
                            if (info == null) break block4;
                            SettingsSnapshot.AppInfo it = info;
                            boolean bl = false;
                            String thisOrThat = Intrinsics.areEqual((Object)it.getApplicationId(), (Object)SettingsSyncLocalSettings.Companion.getInstance().getApplicationId()) ? "[this]" : "[other]";
                            baseMessage = "\n\n" + StringsKt.trimIndent((String)("\n            id:       " + thisOrThat + " " + it.getApplicationId() + "\n            build:    " + it.getBuildNumber() + "\n            appName:  " + it.getFullApplicationName() + "\n            user:     " + it.getUserName() + "\n            host:     " + it.getHostName() + "\n            config:   " + it.getConfigFolder() + "\n            os:       " + OS.CURRENT + "\n        "));
                            object2 = restoresRevision;
                            if (object2 == null) break block5;
                            String hash = object2;
                            boolean bl2 = false;
                            String string = "\nrestores: " + hash;
                            object2 = string;
                            if (string != null) break block6;
                        }
                        object2 = "";
                    }
                    String restoresMessage = object2;
                    return baseMessage + restoresMessage;
                }
                object = restoresRevision;
                if (object == null) break block7;
                String it = object;
                boolean bl = false;
                String string = "restores: " + it;
                object = string;
                if (string != null) break block8;
            }
            object = "";
        }
        return object;
    }

    private final void writeFileStateContent(FileState fileState, Path fileToWrite) {
        FileState fileState2 = fileState;
        if (fileState2 instanceof FileState.Modified) {
            v0 = PathKt.write((Path)fileToWrite, (byte[])((FileState.Modified)fileState).getContent());
        } else if (fileState2 instanceof FileState.Deleted) {
            v0 = PathKt.write$default((Path)fileToWrite, (CharSequence)"DELETED", null, (boolean)false, (int)6, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void commit(String message, Instant dateCreated, boolean allowEmpty) {
        try {
            Git git = this.git;
            if (git == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                git = null;
            }
            CommitCommand commitData = git.commit().setMessage(message).setAllowEmpty(allowEmpty).setNoVerify(true).setSign(false);
            SettingsSyncUserData settingsSyncUserData = (SettingsSyncUserData)this.userDataProvider.invoke();
            if (settingsSyncUserData != null) {
                String string;
                SettingsSyncUserData it = settingsSyncUserData;
                boolean bl = false;
                String string2 = it.getName();
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = it.getEmail()) == null) {
                    string = "<>";
                }
                PersonIdent personIdent = new PersonIdent(string2, string);
                commitData.setAuthor(personIdent);
                commitData.setCommitter(personIdent);
            }
            RevCommit commit = commitData.call();
            if (dateCreated != null) {
                Intrinsics.checkNotNull((Object)commit);
                this.recordCreationDate(commit, dateCreated);
            }
        }
        catch (EmptyCommitException e) {
            LOG.info("No actual changes in the settings");
        }
    }

    static /* synthetic */ void commit$default(GitSettingsLog gitSettingsLog, String string, Instant instant, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            instant = null;
        }
        gitSettingsLog.commit(string, instant, bl);
    }

    private final void recordCreationDate(RevCommit commit, Instant dateCreated) {
        Git git;
        Instant date;
        if (dateCreated.compareTo(Instant.now()) <= 0) {
            v0 = dateCreated;
        } else {
            LOG.error("Date of the snapshot happens in future: " + dateCreated);
            v0 = date = Instant.now();
        }
        if ((git = this.git) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.notesAdd().setMessage(DATE_PREFIX + date.toEpochMilli()).setObjectId(commit).call();
    }

    public void dispose() {
        if (this.repository != null) {
            Repository repository = this.repository;
            if (repository == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository = null;
            }
            repository.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SettingsSnapshot collectCurrentSnapshot() {
        void $this$mapTo$iv;
        Sequence it;
        Collection collection;
        void $this$mapTo$iv2;
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.checkout().setName(MASTER_REF_NAME).setForced(true).call();
        Git git2 = this.git;
        if (git2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git2 = null;
        }
        git2.reset().setMode(ResetCommand.ResetType.HARD).call();
        Git git3 = this.git;
        if (git3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git3 = null;
        }
        git3.clean().setForce(true).setCleanDirectories(true).call();
        Instant lastModifiedDate = this.getDate(this.getBranchTip(this.getMaster()));
        File file = this.settingsSyncStorage.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file).onEnter(GitSettingsLog::collectCurrentSnapshot$lambda$0)), GitSettingsLog::collectCurrentSnapshot$lambda$1);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv2) {
            File file2 = (File)item$iv;
            collection = destination$iv;
            boolean bl = false;
            Path path = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            collection.add(FileStateKt.getFileStateFromFileWithDeletedMarker(path, this.settingsSyncStorage));
        }
        HashSet settingFiles = (HashSet)destination$iv;
        Path metaInfoFolder = this.settingsSyncStorage.resolve(METAINFO_FOLDER);
        Intrinsics.checkNotNull((Object)metaInfoFolder);
        Pair<Map<String, Object>, Set<Path>> pair = SettingsSnapshotZipSerializer.INSTANCE.deserializeSettingsProviders$intellij_settingsSync_core(metaInfoFolder);
        Map settingsFromProviders = (Map)pair.component1();
        Set filesFromProviders = (Set)pair.component2();
        File file3 = metaInfoFolder.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
        it = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file3)), arg_0 -> GitSettingsLog.collectCurrentSnapshot$lambda$3(filesFromProviders, arg_0));
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            File file4 = (File)item$iv;
            collection = destination$iv2;
            boolean bl = false;
            Path path = it2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            collection.add(FileStateKt.getFileStateFromFileWithDeletedMarker(path, metaInfoFolder));
        }
        HashSet additionalFiles = (HashSet)destination$iv2;
        SettingsSyncPluginsState pluginsState = this.readPluginsState();
        return new SettingsSnapshot(new SettingsSnapshot.MetaInfo(lastModifiedDate, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), settingFiles, pluginsState, settingsFromProviders, additionalFiles);
    }

    /*
     * WARNING - void declaration
     */
    private final SettingsSyncPluginsState readPluginsState() {
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(this.pluginsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                void this_$iv;
                Json json = this.json;
                String string$iv = PathsKt.readText$default((Path)this.pluginsFile, null, (int)1, null);
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                return (SettingsSyncPluginsState)this_$iv.decodeFromString((DeserializationStrategy)SettingsSyncPluginsState.Companion.serializer(), string$iv);
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't parse " + this.pluginsFile, (Throwable)e);
        }
        return null;
    }

    @Override
    @NotNull
    public SettingsLog.Position getIdePosition() {
        return this.getPosition(this.getIde());
    }

    @Override
    @NotNull
    public SettingsLog.Position getCloudPosition() {
        return this.getPosition(this.getCloud());
    }

    @Override
    @NotNull
    public SettingsLog.Position getMasterPosition() {
        return this.getPosition(this.getMaster());
    }

    private final BranchPosition getPosition(Ref ref) {
        String string = ref.getObjectId().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return new BranchPosition(string);
    }

    @Override
    public void setIdePosition(@NotNull SettingsLog.Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.updateBranchPosition(IDE_REF_NAME, position);
    }

    @Override
    public void setCloudPosition(@NotNull SettingsLog.Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.updateBranchPosition(CLOUD_REF_NAME, position);
    }

    @Override
    public void setMasterPosition(@NotNull SettingsLog.Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.updateBranchPosition(MASTER_REF_NAME, position);
    }

    private final Ref updateBranchPosition(String refName, SettingsLog.Position targetPosition) {
        RefUpdate refUpdate;
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        Ref ref = repository.findRef(refName);
        Intrinsics.checkNotNull((Object)ref);
        Ref ref2 = ref;
        ObjectId previousObjectId = ref2.getObjectId();
        Repository repository2 = this.repository;
        if (repository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository2 = null;
        }
        RefUpdate $this$updateBranchPosition_u24lambda_u240 = refUpdate = repository2.updateRef(ref2.getName());
        boolean bl = false;
        $this$updateBranchPosition_u24lambda_u240.setNewObjectId(ObjectId.fromString(targetPosition.getId()));
        $this$updateBranchPosition_u24lambda_u240.setForceUpdate(true);
        RefUpdate.Result result2 = refUpdate.update();
        String string = this.getShort(ref2);
        Intrinsics.checkNotNull((Object)previousObjectId);
        LOG.info("Updated position of " + string + " from " + this.getShort(previousObjectId) + " to " + targetPosition + ": " + result2);
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.reset().setMode(ResetCommand.ResetType.HARD).call();
        Repository repository3 = this.repository;
        if (repository3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository3 = null;
        }
        Ref ref3 = repository3.findRef(ref2.getName());
        Intrinsics.checkNotNull((Object)ref3);
        return ref3;
    }

    @Override
    @NotNull
    public SettingsLog.Position advanceMaster() {
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.checkout().setName(MASTER_REF_NAME).call();
        ObjectId objectId = this.getMaster().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"getObjectId(...)");
        String string = this.getShort(objectId);
        ObjectId objectId2 = this.getIde().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId2, (String)"getObjectId(...)");
        String string2 = this.getShort(objectId2);
        ObjectId objectId3 = this.getCloud().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId3, (String)"getObjectId(...)");
        LOG.info("Advancing master@" + string + ". Need merge of ide@" + string2 + " and cloud@" + this.getShort(objectId3));
        Git git2 = this.git;
        if (git2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git2 = null;
        }
        git2.reset().setRef(IDE_REF_NAME).setMode(ResetCommand.ResetType.HARD).call();
        Git git3 = this.git;
        if (git3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git3 = null;
        }
        MergeResult mergeResult = git3.merge().include(this.getCloud()).call();
        ObjectId objectId4 = this.getMaster().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId4, (String)"getObjectId(...)");
        String string3 = this.getShort(objectId4);
        ObjectId objectId5 = this.getCloud().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId5, (String)"getObjectId(...)");
        LOG.info("Merge of master&ide@" + string3 + " with cloud@" + this.getShort(objectId5) + ": " + mergeResult);
        if (mergeResult.getMergeStatus() == MergeResult.MergeStatus.CONFLICTING) {
            Object v12;
            String it;
            AddCommand addCommand;
            RevCommit cloudBranchTip;
            RevCommit ideBranchTip;
            List conflictingFiles;
            block17: {
                conflictingFiles = CollectionsKt.toMutableList((Collection)mergeResult.getConflicts().keySet());
                LOG.info("Merge of master&ide with cloud failed with conflicts in files: " + conflictingFiles);
                ideBranchTip = this.getBranchTip(this.getIde());
                cloudBranchTip = this.getBranchTip(this.getCloud());
                Git git4 = this.git;
                if (git4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                    git4 = null;
                }
                addCommand = git4.add();
                Iterable iterable = conflictingFiles;
                for (Object t : iterable) {
                    it = (String)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)".metainfo/plugins.json")) continue;
                    v12 = t;
                    break block17;
                }
                v12 = null;
            }
            String pluginJsonPath = v12;
            if (pluginJsonPath != null) {
                SettingsSyncEventsStatistics.INSTANCE.getMERGE_CONFLICT_OCCURRED().log((Object)SettingsSyncEventsStatistics.MergeConflictType.PLUGINS_JSON);
                String mergedContent = this.mergePluginJson(pluginJsonPath, ideBranchTip, cloudBranchTip);
                PathKt.write$default((Path)this.pluginsFile, (CharSequence)mergedContent, null, (boolean)false, (int)6, null);
                addCommand.addFilepattern(pluginJsonPath);
                ((Collection)conflictingFiles).remove(pluginJsonPath);
            }
            if (!((Collection)conflictingFiles).isEmpty()) {
                boolean bl;
                block19: {
                    boolean bl2;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    block18: {
                        $this$any$iv = conflictingFiles;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl3 = false;
                                Intrinsics.checkNotNull((Object)it);
                                if (!(!StringsKt.startsWith$default((String)it, (String)"options", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it, (String)METAINFO_FOLDER, (boolean)false, (int)2, null))) continue;
                                bl2 = true;
                                break block18;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        SettingsSyncEventsStatistics.INSTANCE.getMERGE_CONFLICT_OCCURRED().log((Object)SettingsSyncEventsStatistics.MergeConflictType.SCHEMES);
                    }
                    $this$any$iv = conflictingFiles;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl4 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!StringsKt.startsWith$default((String)it, (String)"options", (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block19;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    SettingsSyncEventsStatistics.INSTANCE.getMERGE_CONFLICT_OCCURRED().log((Object)SettingsSyncEventsStatistics.MergeConflictType.OPTIONS);
                }
            }
            SettingsProvider.Companion.getSETTINGS_PROVIDER_EP().forEachExtensionSafe(arg_0 -> GitSettingsLog.advanceMaster$lambda$3(this, conflictingFiles, ideBranchTip, cloudBranchTip, addCommand, arg_0));
            this.mergeFilesOneByOne(conflictingFiles, ideBranchTip, cloudBranchTip);
            for (String file : conflictingFiles) {
                addCommand.addFilepattern(file);
            }
            addCommand.call();
            GitSettingsLog.commit$default(this, "Merge with conflicts", null, true, 2, null);
        }
        return this.getPosition(this.getMaster());
    }

    @Override
    public void restoreStateAt(@NotNull String commitHash) {
        Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
        try {
            Repository repository = this.repository;
            if (repository == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository = null;
            }
            ObjectId commitId = repository.resolve(commitHash);
            Repository repository2 = this.repository;
            if (repository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository2 = null;
            }
            ObjectId ideBranchId = repository2.resolve(IDE_REF_NAME);
            if (commitId == null || ideBranchId == null) {
                NotificationService.Companion.getInstance().notifySateRestoreFailed();
                LOG.error("Failed to resolve git reference. commitId = " + commitId + " for reference = " + commitHash);
                return;
            }
            Git git = this.git;
            if (git == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                git = null;
            }
            git.checkout().setStartPoint(commitId.getName()).setAllPaths(true).call();
            this.removeNewlyAddedFiles(commitId, ideBranchId);
            Git git2 = this.git;
            if (git2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                git2 = null;
            }
            git2.add().addFilepattern(".").call();
            this.commit(this.buildCommitMessage(SettingsSnapshotKt.getLocalApplicationInfo(), commitHash), null, false);
        }
        catch (GitAPIException e) {
            NotificationService.Companion.getInstance().notifySateRestoreFailed();
            LOG.error("Failed to restore state to hash = " + commitHash, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeNewlyAddedFiles(ObjectId revisionBefore, ObjectId revisionAfter) {
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        Repository repository = git.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"getRepository(...)");
        AbstractTreeIterator treeBefore = this.prepareTreeParser(repository, revisionBefore);
        Git git2 = this.git;
        if (git2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git2 = null;
        }
        Repository repository2 = git2.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository2, (String)"getRepository(...)");
        AbstractTreeIterator treeAfter = this.prepareTreeParser(repository2, revisionAfter);
        Git git3 = this.git;
        if (git3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git3 = null;
        }
        AutoCloseable autoCloseable = new TreeWalk(git3.getRepository());
        Throwable throwable = null;
        try {
            TreeWalk tw = (TreeWalk)autoCloseable;
            boolean bl = false;
            tw.setRecursive(true);
            tw.addTree(treeBefore);
            tw.addTree(treeAfter);
            while (tw.next()) {
                if (!Intrinsics.areEqual((Object)tw.getFileMode(0), (Object)FileMode.MISSING) || Intrinsics.areEqual((Object)tw.getFileMode(1), (Object)FileMode.MISSING)) continue;
                Git git4 = this.git;
                if (git4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                    git4 = null;
                }
                git4.rm().addFilepattern(tw.getPathString()).call();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final AbstractTreeIterator prepareTreeParser(Repository repository, ObjectId objectId) {
        RevWalk walk = new RevWalk(repository);
        RevCommit commit = walk.parseCommit(objectId);
        RevTree tree = walk.parseTree(commit.getTree().getId());
        CanonicalTreeParser treeIterator = new CanonicalTreeParser();
        ObjectReader reader = repository.newObjectReader();
        treeIterator.reset(reader, tree.getId());
        walk.dispose();
        return treeIterator;
    }

    private final <T> String mergeSettingsProviderFile(SettingsProvider<T> settingsProvider, String relativePath, RevCommit ideBranchTip, RevCommit cloudBranchTip) {
        return this.smartMergeFile(relativePath, ideBranchTip, cloudBranchTip, arg_0 -> GitSettingsLog.mergeSettingsProviderFile$lambda$0(settingsProvider, arg_0), arg_0 -> GitSettingsLog.mergeSettingsProviderFile$lambda$1(settingsProvider, arg_0), (arg_0, arg_1, arg_2) -> GitSettingsLog.mergeSettingsProviderFile$lambda$2(settingsProvider, arg_0, arg_1, arg_2));
    }

    private final String mergePluginJson(String pluginJson, RevCommit ideBranchTip, RevCommit cloudBranchTip) {
        return this.smartMergeFile(pluginJson, ideBranchTip, cloudBranchTip, arg_0 -> GitSettingsLog.mergePluginJson$lambda$0(this, arg_0), arg_0 -> GitSettingsLog.mergePluginJson$lambda$1(this, arg_0), GitSettingsLog::mergePluginJson$lambda$2);
    }

    private final <T> String smartMergeFile(String relativePath, RevCommit ideBranchTip, RevCommit cloudBranchTip, Function1<? super T, String> serializer2, Function1<? super String, ? extends T> deserializer, Function3<? super T, ? super T, ? super T, ? extends T> merger) {
        String ideContent = this.getFileContentInBranch(relativePath, ideBranchTip);
        Object ideState = deserializer.invoke((Object)ideContent);
        String cloudContent = this.getFileContentInBranch(relativePath, cloudBranchTip);
        Object cloudState = deserializer.invoke((Object)cloudContent);
        String mergeBaseContent = this.findMergeBaseContent(relativePath, ideBranchTip, cloudBranchTip);
        Object baseState = mergeBaseContent != null ? deserializer.invoke((Object)mergeBaseContent) : null;
        Object mergedState = merger.invoke(baseState, cloudState, ideState);
        return (String)serializer2.invoke(mergedState);
    }

    private final String findMergeBaseContent(String pluginJson, RevCommit commit1, RevCommit commit2) {
        RevCommit revCommit;
        try {
            revCommit = this.findMergeBase(commit1, commit2);
        }
        catch (Exception e) {
            LOG.warn("Couldn't find the merge base for " + pluginJson + " between " + commit1 + " and " + commit2, (Throwable)e);
            revCommit = null;
        }
        RevCommit mergeBase = revCommit;
        if (mergeBase == null) {
            return null;
        }
        return this.getFileContentInBranch(pluginJson, mergeBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RevCommit findMergeBase(RevCommit commit1, RevCommit commit2) {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        AutoCloseable autoCloseable = new RevWalk(repository);
        Throwable throwable = null;
        try {
            RevWalk walk = (RevWalk)autoCloseable;
            boolean bl = false;
            walk.setRevFilter(RevFilter.MERGE_BASE);
            Repository repository2 = this.repository;
            if (repository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository2 = null;
            }
            walk.markStart(repository2.parseCommit(commit1.toObjectId()));
            Repository repository3 = this.repository;
            if (repository3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository3 = null;
            }
            walk.markStart(repository3.parseCommit(commit2.toObjectId()));
            RevCommit revCommit = walk.next();
            return revCommit;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFileContentInBranch(String file, RevCommit branchTip) {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        AutoCloseable autoCloseable = TreeWalk.forPath(repository, file, branchTip.getTree());
        Throwable throwable = null;
        try {
            String string;
            TreeWalk treeWalk = (TreeWalk)autoCloseable;
            boolean bl = false;
            ObjectId blobId = treeWalk.getObjectId(0);
            Repository repository2 = this.repository;
            if (repository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository2 = null;
            }
            AutoCloseable autoCloseable2 = repository2.newObjectReader();
            Throwable throwable2 = null;
            try {
                ObjectReader objectReader = (ObjectReader)autoCloseable2;
                boolean bl2 = false;
                ObjectLoader objectLoader = objectReader.open(blobId);
                byte[] byArray = objectLoader.getBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] byArray2 = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                string = new String(byArray2, charset2);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            String string2 = string;
            return string2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void mergeFilesOneByOne(Collection<String> conflictingFiles, RevCommit ideTip, RevCommit cloudTip) {
        if (conflictingFiles.isEmpty()) {
            return;
        }
        Instant ideTipDate = this.getDate(ideTip);
        Instant cloudTipDate = this.getDate(cloudTip);
        for (String file : conflictingFiles) {
            String string;
            Instant cloudDateForFile;
            RevCommit cloudTipForFile;
            RevCommit ideTipForFile;
            RevCommit revCommit = ideTipForFile = this.getLatestCommitForFile(file, this.getIde());
            Instant ideDateForFile = revCommit != null ? this.getDate(revCommit) : ideTipDate;
            RevCommit revCommit2 = cloudTipForFile = this.getLatestCommitForFile(file, this.getCloud());
            Instant instant = cloudDateForFile = revCommit2 != null ? this.getDate(revCommit2) : cloudTipDate;
            if (ideDateForFile.compareTo(cloudDateForFile) >= 0) {
                Object object = ideTipForFile;
                if (object == null || (object = this.getShort((ObjectId)object)) == null) {
                    object = this.getShort(ideTip);
                }
                LOG.info("File " + file + " was modified later in 'ide' in " + (String)object);
                string = this.getFileContentInBranch(file, ideTip);
            } else {
                Object object = cloudTipForFile;
                if (object == null || (object = this.getShort((ObjectId)object)) == null) {
                    object = this.getShort(cloudTip);
                }
                LOG.info("File " + file + " was modified later in 'cloud' in " + (String)object);
                string = this.getFileContentInBranch(file, cloudTip);
            }
            String content = string;
            Path path = this.settingsSyncStorage.resolve(file);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            PathKt.write$default((Path)path, (CharSequence)content, null, (boolean)false, (int)6, null);
        }
    }

    private final RevCommit getLatestCommitForFile(String filePath, Ref branch) {
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        Object object = git.log().add(branch.getObjectId()).setMaxCount(1).addPath(filePath).call();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"call(...)");
        RevCommit commit = (RevCommit)CollectionsKt.firstOrNull((Iterable)object);
        if (commit == null) {
            LOG.warn("Could not find latest commit for file " + filePath + " in branch " + branch);
        }
        return commit;
    }

    private final RevCommit getBranchTip(Ref ref) {
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        Object object = git.log().add(ref.getObjectId()).setMaxCount(1).call();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"call(...)");
        Object object2 = CollectionsKt.first((Iterable)object);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first(...)");
        return (RevCommit)object2;
    }

    private final Instant getDate(RevCommit commit) {
        try {
            Note noteObject;
            Git git = this.git;
            if (git == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                git = null;
            }
            if ((noteObject = git.notesShow().setObjectId(commit).call()) != null) {
                Repository repository = this.repository;
                if (repository == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                    repository = null;
                }
                byte[] byArray = repository.open(noteObject.getData()).getBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] byArray2 = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                String noteContent = new String(byArray2, charset2);
                Matcher matcher = DATE_PATTERN.matcher(noteContent);
                if (matcher.matches()) {
                    String date = matcher.group(1);
                    Intrinsics.checkNotNull((Object)date);
                    Instant instant = Instant.ofEpochMilli(Long.parseLong(date));
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
                    return instant;
                }
                LOG.warn("Note for commit " + commit + " doesn't match format: [" + noteContent + "]");
            } else if (commit.getParentCount() == 1) {
                LOG.warn("No note assigned to commit " + commit);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error reading a note assigned to commit " + commit, e);
        }
        Instant instant = Instant.ofEpochSecond(commit.getCommitTime());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
        return instant;
    }

    private final void abortMerge() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        repository.writeMergeCommitMsg(null);
        Repository repository2 = this.repository;
        if (repository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository2 = null;
        }
        repository2.writeMergeHeads(null);
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.reset().setMode(ResetCommand.ResetType.HARD).call();
    }

    private final String getShort(Ref $this$short) {
        String string = $this$short.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.removePrefix((String)string, (CharSequence)"refs/heads/");
    }

    private final String getShort(ObjectId $this$short) {
        String string = $this$short.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        int n = 0;
        int n2 = 8;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string3;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final CharSequence applySnapshotAndCommit$lambda$0(FileState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFile();
    }

    private static final boolean collectCurrentSnapshot$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getName(), (Object)".git") && !Intrinsics.areEqual((Object)it.getName(), (Object)METAINFO_FOLDER);
    }

    private static final boolean collectCurrentSnapshot$lambda$1(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile() && !Intrinsics.areEqual((Object)it.getName(), (Object)".gitignore");
    }

    private static final boolean collectCurrentSnapshot$lambda$3(Set $filesFromProviders, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile() && !Intrinsics.areEqual((Object)it.getName(), (Object)PLUGINS_FILE) && !$filesFromProviders.contains(it.toPath());
    }

    private static final void advanceMaster$lambda$3(GitSettingsLog this$0, List $conflictingFiles, RevCommit $ideBranchTip, RevCommit $cloudBranchTip, AddCommand $addCommand, SettingsProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String relativePath = ".metainfo/" + it.getId() + "/" + it.getFileName();
        Path file = this$0.settingsSyncStorage.resolve(relativePath);
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && $conflictingFiles.contains(relativePath)) {
            String mergedContent = this$0.mergeSettingsProviderFile(it, relativePath, $ideBranchTip, $cloudBranchTip);
            PathKt.write$default((Path)file, (CharSequence)mergedContent, null, (boolean)false, (int)6, null);
            $addCommand.addFilepattern(relativePath);
            ((Collection)$conflictingFiles).remove(relativePath);
        }
    }

    private static final String mergeSettingsProviderFile$lambda$0(SettingsProvider $settingsProvider, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $settingsProvider.serialize(it);
    }

    private static final Object mergeSettingsProviderFile$lambda$1(SettingsProvider $settingsProvider, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $settingsProvider.deserialize(it);
    }

    private static final Object mergeSettingsProviderFile$lambda$2(SettingsProvider $settingsProvider, Object base, Object cloud, Object ide) {
        Intrinsics.checkNotNullParameter((Object)cloud, (String)CLOUD_REF_NAME);
        Intrinsics.checkNotNullParameter((Object)ide, (String)IDE_REF_NAME);
        return $settingsProvider.mergeStates(base, cloud, ide);
    }

    /*
     * WARNING - void declaration
     */
    private static final String mergePluginJson$lambda$0(GitSettingsLog this$0, SettingsSyncPluginsState it) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Json json = this$0.json;
        SettingsSyncPluginsState value$iv = it;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        return this_$iv.encodeToString((SerializationStrategy)SettingsSyncPluginsState.Companion.serializer(), (Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final SettingsSyncPluginsState mergePluginJson$lambda$1(GitSettingsLog this$0, String it) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Json json = this$0.json;
        String string$iv = it;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (SettingsSyncPluginsState)this_$iv.decodeFromString((DeserializationStrategy)SettingsSyncPluginsState.Companion.serializer(), string$iv);
    }

    private static final SettingsSyncPluginsState mergePluginJson$lambda$2(SettingsSyncPluginsState base, SettingsSyncPluginsState cloud, SettingsSyncPluginsState ide) {
        Intrinsics.checkNotNullParameter((Object)cloud, (String)CLOUD_REF_NAME);
        Intrinsics.checkNotNullParameter((Object)ide, (String)IDE_REF_NAME);
        SettingsSyncPluginsState settingsSyncPluginsState = base;
        if (settingsSyncPluginsState == null) {
            settingsSyncPluginsState = new SettingsSyncPluginsState(MapsKt.emptyMap());
        }
        return SettingsSyncPluginsStateMerger.INSTANCE.mergePluginStates$intellij_settingsSync_core(settingsSyncPluginsState, cloud, ide);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitSettingsLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DATE_PATTERN = Pattern.compile("date: (\\d+)");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u00020\u0003H\u0096\u0080\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/settingsSync/core/GitSettingsLog$BranchPosition;", "Lcom/intellij/settingsSync/core/SettingsLog$Position;", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "intellij.settingsSync.core"})
    private static final class BranchPosition
    implements SettingsLog.Position {
        @NotNull
        private final String id;

        public BranchPosition(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public String toString() {
            String string = this.getId().substring(0, 8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final BranchPosition copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new BranchPosition(id);
        }

        public static /* synthetic */ BranchPosition copy$default(BranchPosition branchPosition, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = branchPosition.id;
            }
            return branchPosition.copy(string);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BranchPosition)) {
                return false;
            }
            BranchPosition branchPosition = (BranchPosition)other;
            return Intrinsics.areEqual((Object)this.id, (Object)branchPosition.id);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/settingsSync/core/GitSettingsLog$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "MASTER_REF_NAME", "", "IDE_REF_NAME", "CLOUD_REF_NAME", "PLUGINS_FILE", "METAINFO_FOLDER", "DATE_PREFIX", "DATE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getDATE_PATTERN", "()Ljava/util/regex/Pattern;", "intellij.settingsSync.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public final Pattern getDATE_PATTERN() {
            return DATE_PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J&\u0010\u000e\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/settingsSync/core/GitSettingsLog$MockGpgSigner;", "Lorg/eclipse/jgit/lib/GpgSigner;", "<init>", "()V", "sign", "", "commit", "Lorg/eclipse/jgit/lib/CommitBuilder;", "gpgSigningKey", "", "committer", "Lorg/eclipse/jgit/lib/PersonIdent;", "credentialsProvider", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "canLocateSigningKey", "", "intellij.settingsSync.core"})
    public static final class MockGpgSigner
    extends GpgSigner {
        @Override
        public void sign(@Nullable CommitBuilder commit, @Nullable String gpgSigningKey, @Nullable PersonIdent committer, @Nullable CredentialsProvider credentialsProvider) {
        }

        @Override
        public boolean canLocateSigningKey(@Nullable String gpgSigningKey, @Nullable PersonIdent committer, @Nullable CredentialsProvider credentialsProvider) {
            return false;
        }
    }
}

