/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.view;

import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.jvm.cache.SourceTestLibSearcher;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ws.rest.model.jam.RSHttpMappingInfo;
import com.intellij.ws.rest.model.jam.RSJamModel;
import com.intellij.ws.rest.model.jam.RsUrlPathSpecification;
import com.intellij.ws.rest.model.jam.RsUrlPathSpecificationKt;
import com.intellij.ws.rest.providers.RSUrlTargetInfo;
import com.intellij.ws.rest.utils.RSUtils;
import com.intellij.ws.rest.view.RSEndpointsProvider;
import com.intellij.ws.rest.view.RSPsiClassPath;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ws/rest/view/RSServerFramework;", "Lcom/intellij/ws/rest/view/RSEndpointsProvider;", "<init>", "()V", "serversSearcher", "Lcom/intellij/microservices/jvm/cache/SourceTestLibSearcher;", "Lcom/intellij/ws/rest/view/RSPsiClassPath;", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "rsHttpMethod", "Lcom/intellij/ws/rest/model/jam/RSHttpMappingInfo;", "createUrlTargetInfo", "intellij.javaee.jax.rs"})
@ApiStatus.Internal
public final class RSServerFramework
extends RSEndpointsProvider {
    @NotNull
    private final SourceTestLibSearcher<RSPsiClassPath> serversSearcher = new SourceTestLibSearcher("RS_SERVERS", (Function2)new Function2<Module, GlobalSearchScope, Collection<? extends RSPsiClassPath>>((Object)RSJamModel.INSTANCE){

        public final Collection<RSPsiClassPath> invoke(Module p0, GlobalSearchScope p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            return RSJamModel.findServerPaths(p0, p1);
        }
    });
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("JEE-RESTful-WS-Server", "JEE RESTful WS Server", JavaUltimateIcons.Web.RequestMapping);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_SERVER_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public Iterable<RSPsiClassPath> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        Module module = ((ModuleEndpointsFilter)filter).getModule();
        if (!RSUtils.hasRestLibrary(module)) {
            return CollectionsKt.emptyList();
        }
        return this.serversSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @Override
    @NotNull
    protected Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull RSHttpMappingInfo rsHttpMethod) {
        Intrinsics.checkNotNullParameter((Object)rsHttpMethod, (String)"rsHttpMethod");
        return CollectionsKt.listOf((Object)this.createUrlTargetInfo(rsHttpMethod));
    }

    @Override
    @NotNull
    protected UrlTargetInfo createUrlTargetInfo(@NotNull RSHttpMappingInfo rsHttpMethod) {
        Intrinsics.checkNotNullParameter((Object)rsHttpMethod, (String)"rsHttpMethod");
        UrlPath urlPath = RsUrlPathSpecification.INSTANCE.parsePath(RSUtils.getResourcePath(rsHttpMethod));
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rsHttpMethod.getMapping().getPsiElement());
        return new RSUrlTargetInfo(UrlConstants.HTTP_SCHEMES, urlPath, rsHttpMethod, RsUrlPathSpecificationKt.getAuthoritiesByModule(module));
    }
}

