/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRewordService;
import git4idea.rebase.GitSingleCommitEditingAction;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.rebase.log.GitLogCommitDetailsLoaderKt;
import git4idea.rebase.log.GitNewCommitMessageActionDialog;
import git4idea.repo.GitRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\tH\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lgit4idea/rebase/GitRewordAction;", "Lgit4idea/rebase/GitSingleCommitEditingAction;", "<init>", "()V", "prohibitRebaseDuringRebasePolicy", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "getProhibitRebaseDuringRebasePolicy", "()Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "checkNotMergeCommit", "", "commitEditingData", "Lgit4idea/rebase/GitSingleCommitEditingAction$SingleCommitEditingData;", "actionPerformedAfterChecks", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getFailureTitle", "getProhibitedStateMessage", "operation", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRewordAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRewordAction.kt\ngit4idea/rebase/GitRewordAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,56:1\n30#2,2:57\n*S KotlinDebug\n*F\n+ 1 GitRewordAction.kt\ngit4idea/rebase/GitRewordAction\n*L\n43#1:57,2\n*E\n"})
public final class GitRewordAction
extends GitSingleCommitEditingAction {
    @NotNull
    private final GitCommitEditingActionBase.ProhibitRebaseDuringRebasePolicy.Prohibit prohibitRebaseDuringRebasePolicy;

    public GitRewordAction() {
        String string = GitBundle.message((String)"rebase.log.action.operation.reword.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.prohibitRebaseDuringRebasePolicy = new GitCommitEditingActionBase.ProhibitRebaseDuringRebasePolicy.Prohibit(string);
    }

    @Override
    @NotNull
    protected GitCommitEditingActionBase.ProhibitRebaseDuringRebasePolicy.Prohibit getProhibitRebaseDuringRebasePolicy() {
        return this.prohibitRebaseDuringRebasePolicy;
    }

    @Override
    @Nullable
    protected String checkNotMergeCommit(@NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        VcsCommitMetadata commit = commitEditingData.getSelectedCommit();
        GitRepository repository2 = commitEditingData.getRepository();
        if (Intrinsics.areEqual((Object)((Hash)commit.getId()).asString(), (Object)repository2.getCurrentRevision())) {
            return null;
        }
        return super.checkNotMergeCommit((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData);
    }

    @Override
    protected void actionPerformedAfterChecks(@NotNull CoroutineScope scope, @NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        List<VcsCommitMetadata> details = GitLogCommitDetailsLoaderKt.getOrLoadDetails(commitEditingData.getProject(), commitEditingData.getLogData(), commitEditingData.getSelection());
        VcsCommitMetadata commit = (VcsCommitMetadata)CollectionsKt.first(details);
        GitCommitEditingActionBase.MultipleCommitEditingData multipleCommitEditingData = commitEditingData;
        String string = commit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
        String string2 = GitBundle.message((String)"rebase.log.reword.dialog.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Object[] objectArray = new Object[]{1, ((Hash)commit.getId()).toShortString(), VcsUserUtil.getShortPresentation((VcsUser)commit.getAuthor())};
        String string3 = GitBundle.message((String)"rebase.log.reword.dialog.description.label", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        GitNewCommitMessageActionDialog dialog2 = new GitNewCommitMessageActionDialog(multipleCommitEditingData, string, string2, string3);
        dialog2.show((Function1<? super String, Unit>)((Function1)arg_0 -> GitRewordAction.actionPerformedAfterChecks$lambda$0(commitEditingData, commit, arg_0)));
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        String string = GitBundle.message((String)"rebase.log.reword.action.failure.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @Nullable
    protected String getProhibitedStateMessage(@NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData, @NotNull String operation) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        if (commitEditingData.getRepository().getState() == Repository.State.REBASING && commitEditingData.isHeadCommit()) {
            return null;
        }
        return super.getProhibitedStateMessage((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData, operation);
    }

    private static final Unit actionPerformedAfterChecks$lambda$0(GitSingleCommitEditingAction.SingleCommitEditingData $commitEditingData, VcsCommitMetadata $commit, String newMessage) {
        Intrinsics.checkNotNullParameter((Object)newMessage, (String)"newMessage");
        Project project = $commitEditingData.getRepository().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitRewordService> serviceClass$iv = GitRewordService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((GitRewordService)object).launchReword($commitEditingData.getRepository(), $commit, newMessage);
        return Unit.INSTANCE;
    }
}

