/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.inspections.DockerFileInspectorBase;
import com.intellij.docker.dockerFile.lexer.DockerTokenTypes;
import com.intellij.docker.dockerFile.parser.psi.DockerFileAddOrCopyCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerFileHeredoc;
import com.intellij.docker.dockerFile.parser.psi.DockerFileHeredocStart;
import com.intellij.docker.dockerFile.parser.psi.DockerFileRunCommand;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerFileHeredocDelimitersInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "HeredocDelimitersInspector", "AppendMissingMarkersQuickFix", "intellij.clouds.docker.file.backend"})
public final class DockerFileHeredocDelimitersInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder.getFile() instanceof DockerPsiFile) {
            psiElementVisitor = (PsiElementVisitor)new HeredocDelimitersInspector(holder, isOnTheFly);
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        }
        return psiElementVisitor;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerFileHeredocDelimitersInspection$AppendMissingMarkersQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.clouds.docker.file.backend"})
    private static final class AppendMissingMarkersQuickFix
    implements LocalQuickFix {
        @NotNull
        private final String text;

        public AppendMissingMarkersQuickFix(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public String getFamilyName() {
            String string = DockerBundle.message((String)"DockerFileHeredocDelimitersInspection.quickfix", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement elem = descriptor.getPsiElement();
            if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)elem), (Object)DockerTokenTypes.HEREDOC_START)) {
                elem = elem.getParent();
            }
            Document document = elem.getContainingFile().getFileDocument();
            PsiElement psiElement = elem;
            Intrinsics.checkNotNull((Object)psiElement);
            document.insertString(PsiTreeUtilKt.getEndOffset((PsiElement)psiElement), (CharSequence)this.text);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerFileHeredocDelimitersInspection$HeredocDelimitersInspector;", "Lcom/intellij/docker/dockerFile/inspections/DockerFileInspectorBase;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "onTheFly", "", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Z)V", "visitAddOrCopyCommand", "", "o", "Lcom/intellij/docker/dockerFile/parser/psi/DockerFileAddOrCopyCommand;", "visitRunCommand", "Lcom/intellij/docker/dockerFile/parser/psi/DockerFileRunCommand;", "checkArgumentMismatch", "heredocStartList", "", "Lcom/intellij/docker/dockerFile/parser/psi/DockerFileHeredocStart;", "heredocList", "Lcom/intellij/docker/dockerFile/parser/psi/DockerFileHeredoc;", "intellij.clouds.docker.file.backend"})
    @SourceDebugExtension(value={"SMAP\nDockerFileHeredocDelimitersInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerFileHeredocDelimitersInspection.kt\ncom/intellij/docker/dockerFile/inspections/DockerFileHeredocDelimitersInspection$HeredocDelimitersInspector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1586#2:88\n1661#2,3:89\n*S KotlinDebug\n*F\n+ 1 DockerFileHeredocDelimitersInspection.kt\ncom/intellij/docker/dockerFile/inspections/DockerFileHeredocDelimitersInspection$HeredocDelimitersInspector\n*L\n59#1:88\n59#1:89,3\n*E\n"})
    private static final class HeredocDelimitersInspector
    extends DockerFileInspectorBase {
        public HeredocDelimitersInspector(@NotNull ProblemsHolder holder, boolean onTheFly) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            super(holder, onTheFly);
        }

        public void visitAddOrCopyCommand(@NotNull DockerFileAddOrCopyCommand o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            if (PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)o))) {
                return;
            }
            List list = o.getHeredocStartList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHeredocStartList(...)");
            List list2 = o.getHeredocList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getHeredocList(...)");
            this.checkArgumentMismatch(list, list2);
        }

        public void visitRunCommand(@NotNull DockerFileRunCommand o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            if (PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)o))) {
                return;
            }
            List list = o.getHeredocStartList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHeredocStartList(...)");
            List list2 = o.getHeredocList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getHeredocList(...)");
            this.checkArgumentMismatch(list, list2);
        }

        /*
         * WARNING - void declaration
         */
        private final void checkArgumentMismatch(List<? extends DockerFileHeredocStart> heredocStartList, List<? extends DockerFileHeredoc> heredocList) {
            int diff = 0;
            diff = heredocStartList.size() - heredocList.size();
            DockerFileHeredoc dockerFileHeredoc = (DockerFileHeredoc)CollectionsKt.lastOrNull(heredocList);
            if (dockerFileHeredoc != null) {
                DockerFileHeredoc dockerFileHeredoc2;
                DockerFileHeredoc last = dockerFileHeredoc2 = dockerFileHeredoc;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)last.getLastChild()), (Object)DockerTokenTypes.HEREDOC_MARKER_END)) {
                    ++diff;
                }
            }
            if (diff > 0) {
                void $this$mapTo$iv$iv;
                List unclosedMarkers = CollectionsKt.takeLast(heredocStartList, (int)diff);
                Object[] $this$map$iv = (Object[])unclosedMarkers;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DockerFileHeredocStart dockerFileHeredocStart = (DockerFileHeredocStart)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getLastChild().getText());
                }
                List unclosedMarkersText = (List)destination$iv$iv;
                String text = CollectionsKt.joinToString$default((Iterable)unclosedMarkersText, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                String textNl = CollectionsKt.joinToString$default((Iterable)unclosedMarkersText, (CharSequence)"\n", (CharSequence)"\n", null, (int)0, null, null, (int)60, null);
                objectArray = new Object[]{text};
                String string = DockerBundle.message((String)"DockerFileHeredocDelimitersInspection.problem", (Object[])objectArray);
                objectArray = new LocalQuickFix[]{new AppendMissingMarkersQuickFix(textNl)};
                this.registerProblem(unclosedMarkers, string, ProblemHighlightType.GENERIC_ERROR, (LocalQuickFix[])objectArray);
            }
        }
    }
}

