/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.irLowerings;

import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrReplSnippet;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.scripting.compiler.plugin.irLowerings.ReplSnippetAccessCallsGenerator;
import org.jetbrains.kotlin.scripting.compiler.plugin.irLowerings.ReplSnippetLoweringKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.irLowerings.ScriptLikeToClassTransformer;
import org.jetbrains.kotlin.scripting.compiler.plugin.irLowerings.ScriptLikeToClassTransformerContext;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001c\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/irLowerings/ReplSnippetToClassTransformer;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/irLowerings/ScriptLikeToClassTransformer;", "context", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "irSnippet", "Lorg/jetbrains/kotlin/ir/declarations/IrReplSnippet;", "irSnippetClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "snippetClassReceiver", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "typeRemapper", "Lorg/jetbrains/kotlin/ir/util/TypeRemapper;", "accessCallsGenerator", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/irLowerings/ReplSnippetAccessCallsGenerator;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;Lorg/jetbrains/kotlin/ir/declarations/IrReplSnippet;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;Lorg/jetbrains/kotlin/ir/util/TypeRemapper;Lorg/jetbrains/kotlin/scripting/compiler/plugin/irLowerings/ReplSnippetAccessCallsGenerator;)V", "getIrSnippet", "()Lorg/jetbrains/kotlin/ir/declarations/IrReplSnippet;", "getAccessCallsGenerator", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/irLowerings/ReplSnippetAccessCallsGenerator;", "visitMemberAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "data", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/irLowerings/ScriptLikeToClassTransformerContext;", "visitClass", "declaration", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "kotlin-scripting-compiler"})
final class ReplSnippetToClassTransformer
extends ScriptLikeToClassTransformer {
    @NotNull
    private final IrReplSnippet irSnippet;
    @NotNull
    private final ReplSnippetAccessCallsGenerator accessCallsGenerator;

    public ReplSnippetToClassTransformer(@NotNull IrPluginContext context, @NotNull IrReplSnippet irSnippet, @NotNull IrClass irSnippetClass, @NotNull IrValueParameter snippetClassReceiver, @NotNull TypeRemapper typeRemapper, @NotNull ReplSnippetAccessCallsGenerator accessCallsGenerator) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)irSnippet, (String)"irSnippet");
        Intrinsics.checkNotNullParameter((Object)irSnippetClass, (String)"irSnippetClass");
        Intrinsics.checkNotNullParameter((Object)snippetClassReceiver, (String)"snippetClassReceiver");
        Intrinsics.checkNotNullParameter((Object)typeRemapper, (String)"typeRemapper");
        Intrinsics.checkNotNullParameter((Object)accessCallsGenerator, (String)"accessCallsGenerator");
        super(context, (IrDeclaration)irSnippet, irSnippetClass, snippetClassReceiver, typeRemapper, accessCallsGenerator, SetsKt.emptySet(), true);
        this.irSnippet = irSnippet;
        this.accessCallsGenerator = accessCallsGenerator;
    }

    @NotNull
    public final IrReplSnippet getIrSnippet() {
        return this.irSnippet;
    }

    @Override
    @NotNull
    public ReplSnippetAccessCallsGenerator getAccessCallsGenerator() {
        return this.accessCallsGenerator;
    }

    @Override
    @NotNull
    public IrExpression visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression, @NotNull ScriptLikeToClassTransformerContext data) {
        IrDeclaration declaration;
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrSymbolOwner irSymbolOwner = expression.getSymbol().getOwner();
        IrDeclaration irDeclaration = declaration = irSymbolOwner instanceof IrDeclaration ? (IrDeclaration)irSymbolOwner : null;
        if (declaration != null && this.irSnippet.getDeclarationsFromOtherSnippets().contains(declaration)) {
            ReplSnippetAccessCallsGenerator replSnippetAccessCallsGenerator = this.getAccessCallsGenerator();
            IrDeclarationParent irDeclarationParent = declaration.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            expression.setDispatchReceiver(replSnippetAccessCallsGenerator.createAccessToSnippet(((IrClass)irDeclarationParent).getSymbol(), expression.getStartOffset(), expression.getEndOffset()));
            expression.transformChildren((IrTransformer)this, (Object)data);
            return (IrExpression)expression;
        }
        return super.visitMemberAccess(expression, data);
    }

    @Override
    @NotNull
    public IrClass visitClass(@NotNull IrClass declaration, @NotNull ScriptLikeToClassTransformerContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ReplSnippetLoweringKt.access$updateVisibilityToPublicIfNeeded((IrDeclarationWithVisibility)declaration);
        return super.visitClass(declaration, data);
    }

    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull ScriptLikeToClassTransformerContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ReplSnippetLoweringKt.access$updateVisibilityToPublicIfNeeded((IrDeclarationWithVisibility)declaration);
        return super.visitFunction(declaration, (Object)data);
    }

    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull ScriptLikeToClassTransformerContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ReplSnippetLoweringKt.access$updateVisibilityToPublicIfNeeded((IrDeclarationWithVisibility)declaration);
        return super.visitProperty(declaration, (Object)data);
    }
}

