/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.align;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.layout.LayoutTool;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphUndoService;
import com.intellij.openapi.graph.view.Graph2D;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class GraphAbstractAlignNodesAction
extends AbstractGraphAction {
    @Override
    protected void actionPerformed(@NotNull AnActionEvent e2, @NotNull Graph2D graph) {
        GraphBuilder<?, ?> graphBuilder;
        if (e2 == null) {
            GraphAbstractAlignNodesAction.k(0);
        }
        if (graph == null) {
            GraphAbstractAlignNodesAction.k(1);
        }
        if ((graphBuilder = this.getBuilder(e2)) == null) {
            return;
        }
        NodeList nodeList = GraphManager.getGraphManager().createNodeList(graph.selectedNodes());
        GraphUndoService.getInstance().performPositionsOnlyChangingAction(graphBuilder, this.getActionName(), () -> {
            LayoutTool.Statics.alignNodeLayouts(graph, nodeList, null, this.doAlignVertically(), this.getAlignmentMode());
            Layouter layouter = graphBuilder.getGraphPresentationModel().getSettings().getCurrentLayouter();
            Layouter layouter2 = GraphLayoutService.getInstance().getEdgeRouterForLayouter(layouter);
            if (layouter2 != null) {
                GraphLayoutService.getInstance().queryLayout(graphBuilder).withLayouter(layouter2).withFitContent(GraphLayoutService.GraphLayoutQueryParams.FitContentOption.NEVER).run();
            }
        });
        graph.updateViews();
    }

    @Nls
    protected abstract String getActionName();

    protected abstract boolean doAlignVertically();

    protected abstract byte getAlignmentMode();

    @Override
    protected void update(@NotNull AnActionEvent e2, @NotNull Graph2D graph) {
        if (e2 == null) {
            GraphAbstractAlignNodesAction.k(2);
        }
        if (graph == null) {
            GraphAbstractAlignNodesAction.k(3);
        }
        int n2 = this.getAlignmentMode() == LayoutTool.ALIGN_NODES_DISTRIBUTED ? 3 : 2;
        e2.getPresentation().setEnabledAndVisible(graph.selectedNodes().size() >= n2);
    }

    private static /* synthetic */ void k(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/actions/align/GraphAbstractAlignNodesAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

