/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.orientation;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.GraphLayoutOrientation;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphToggleAction;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphUndoService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import org.jetbrains.annotations.NotNull;

public abstract class SelectLayoutOrientationAction
extends AbstractGraphToggleAction {
    @NotNull
    protected abstract GraphLayoutOrientation getLayoutOrientation();

    @Override
    protected boolean isSelected(@NotNull Graph2D graph, @NotNull Project project, @NotNull AnActionEvent event) {
        GraphBuilder<?, ?> graphBuilder;
        if (graph == null) {
            SelectLayoutOrientationAction.k(0);
        }
        if (project == null) {
            SelectLayoutOrientationAction.k(1);
        }
        if (event == null) {
            SelectLayoutOrientationAction.k(2);
        }
        return (graphBuilder = this.getBuilder(event)) != null && graphBuilder.getGraphPresentationModel().getSettings().getCurrentLayoutOrientation() == this.getLayoutOrientation();
    }

    @Override
    protected boolean isEnabled(@NotNull Graph2D graph, @NotNull Project project, @NotNull AnActionEvent event) {
        GraphBuilder<?, ?> graphBuilder;
        if (graph == null) {
            SelectLayoutOrientationAction.k(3);
        }
        if (project == null) {
            SelectLayoutOrientationAction.k(4);
        }
        if (event == null) {
            SelectLayoutOrientationAction.k(5);
        }
        if ((graphBuilder = this.getBuilder(event)) == null) {
            return false;
        }
        Layouter layouter = graphBuilder.getGraphPresentationModel().getSettings().getCurrentLayouter();
        return GraphLayoutService.getInstance().doesSupportLayoutOrientation(layouter);
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SelectLayoutOrientationAction.k(6);
        }
        return actionUpdateThread;
    }

    @Override
    protected void setSelected(@NotNull Graph2D graph, boolean state, @NotNull Project project, @NotNull AnActionEvent e2) {
        GraphBuilder<?, ?> graphBuilder;
        if (graph == null) {
            SelectLayoutOrientationAction.k(7);
        }
        if (project == null) {
            SelectLayoutOrientationAction.k(8);
        }
        if (e2 == null) {
            SelectLayoutOrientationAction.k(9);
        }
        if ((graphBuilder = this.getBuilder(e2)) == null) {
            return;
        }
        GraphLayoutOrientation graphLayoutOrientation = graphBuilder.getGraphPresentationModel().getSettings().getCurrentLayoutOrientation();
        GraphUndoService.getInstance().performPositionsOnlyChangingAction(graphBuilder, this.getActionName(), () -> {
            graphBuilder.getGraphPresentationModel().getSettings().setCurrentLayoutOrientation(this.getLayoutOrientation());
            GraphLayoutService.getInstance().queryLayout(graphBuilder).animated().run();
        }, runnable -> {
            graphBuilder.getGraphPresentationModel().getSettings().setCurrentLayoutOrientation(graphLayoutOrientation);
            runnable.run();
        }, runnable -> {
            graphBuilder.getGraphPresentationModel().getSettings().setCurrentLayoutOrientation(this.getLayoutOrientation());
            runnable.run();
        });
    }

    @NlsActions.ActionText
    protected abstract String getActionName();

    private static /* synthetic */ void k(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/actions/orientation/SelectLayoutOrientationAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/actions/orientation/SelectLayoutOrientationAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

