/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.EdgeRealizerProvider;
import com.intellij.openapi.graph.GraphLayoutOrientation;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphEdgeRealizerService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class GraphSettings {
    @NotNull
    public static final String USE_SNAPPING_REGKEY = "diagrams.use.snapping";
    @NotNull
    private volatile Layouter myCurrentLayouter;
    @NotNull
    private volatile GraphLayoutOrientation myCurrentLayoutOrientation;
    @NotNull
    private volatile EdgeRealizerProvider myCurrentEdgeRealizerProvider;
    private volatile boolean myDoFitContentAfterLayout;
    private volatile boolean myDoShowGrid;
    private volatile boolean myDoShowEdgeLabels;
    private volatile boolean myDoShowBridges;
    private volatile boolean myDoShowStructureViewForSelectedNode;
    private volatile boolean myDoMergeEdgeBySources;
    private volatile boolean myDoMergeEdgeByTargets;
    private volatile boolean myDoCollapseEdgesOnGrouping;
    @NotNull
    private final EventDispatcher<ChangeListener> myDispatcher;

    public GraphSettings() {
        this.myCurrentLayouter = GraphLayoutService.getInstance().getHierarchicLayouter();
        this.myCurrentLayoutOrientation = GraphLayoutOrientation.BOTTOM_TO_TOP;
        this.myCurrentEdgeRealizerProvider = GraphEdgeRealizerService.getInstance().getSmoothedPolylineEdgeRealizerProvider();
        this.myDoFitContentAfterLayout = true;
        this.myDoShowGrid = true;
        this.myDoShowEdgeLabels = true;
        this.myDoShowBridges = true;
        this.myDoShowStructureViewForSelectedNode = false;
        this.myDoMergeEdgeBySources = true;
        this.myDoMergeEdgeByTargets = true;
        this.myDoCollapseEdgesOnGrouping = false;
        this.myDispatcher = EventDispatcher.create(ChangeListener.class);
    }

    private GraphSettings(@NotNull Layouter currentLayouter, boolean doFitContentAfterLayout, boolean doShowEdgeLabels, boolean doShowBridges, boolean doMergeEdgeBySources, boolean doMergeEdgeByTargets, boolean doCollapseEdgesOnGrouping) {
        if (currentLayouter == null) {
            GraphSettings.X(0);
        }
        this.myCurrentLayouter = GraphLayoutService.getInstance().getHierarchicLayouter();
        this.myCurrentLayoutOrientation = GraphLayoutOrientation.BOTTOM_TO_TOP;
        this.myCurrentEdgeRealizerProvider = GraphEdgeRealizerService.getInstance().getSmoothedPolylineEdgeRealizerProvider();
        this.myDoFitContentAfterLayout = true;
        this.myDoShowGrid = true;
        this.myDoShowEdgeLabels = true;
        this.myDoShowBridges = true;
        this.myDoShowStructureViewForSelectedNode = false;
        this.myDoMergeEdgeBySources = true;
        this.myDoMergeEdgeByTargets = true;
        this.myDoCollapseEdgesOnGrouping = false;
        this.myDispatcher = EventDispatcher.create(ChangeListener.class);
        this.X(currentLayouter, doFitContentAfterLayout, doShowEdgeLabels, doShowBridges, doMergeEdgeBySources, doMergeEdgeByTargets, doCollapseEdgesOnGrouping);
    }

    private GraphSettings(@NotNull GraphSettings that) {
        if (that == null) {
            GraphSettings.X(1);
        }
        this.myCurrentLayouter = GraphLayoutService.getInstance().getHierarchicLayouter();
        this.myCurrentLayoutOrientation = GraphLayoutOrientation.BOTTOM_TO_TOP;
        this.myCurrentEdgeRealizerProvider = GraphEdgeRealizerService.getInstance().getSmoothedPolylineEdgeRealizerProvider();
        this.myDoFitContentAfterLayout = true;
        this.myDoShowGrid = true;
        this.myDoShowEdgeLabels = true;
        this.myDoShowBridges = true;
        this.myDoShowStructureViewForSelectedNode = false;
        this.myDoMergeEdgeBySources = true;
        this.myDoMergeEdgeByTargets = true;
        this.myDoCollapseEdgesOnGrouping = false;
        this.myDispatcher = EventDispatcher.create(ChangeListener.class);
        this.setFrom(that);
    }

    private void X(@NotNull Layouter layouter, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (layouter == null) {
            GraphSettings.X(2);
        }
        this.myCurrentLayouter = layouter;
        this.myDoFitContentAfterLayout = bl;
        this.myDoShowEdgeLabels = bl2;
        this.myDoShowBridges = bl3;
        this.myDoMergeEdgeBySources = bl4;
        this.myDoMergeEdgeByTargets = bl5;
        this.myDoCollapseEdgesOnGrouping = bl6;
    }

    public void setFrom(@NotNull GraphSettings that) {
        if (that == null) {
            GraphSettings.X(3);
        }
        this.X(that.myCurrentLayouter, that.myDoFitContentAfterLayout, that.myDoShowEdgeLabels, that.myDoShowBridges, that.myDoMergeEdgeBySources, that.myDoMergeEdgeByTargets, that.myDoCollapseEdgesOnGrouping);
    }

    @NotNull
    public GraphSettings copy() {
        return new GraphSettings(this);
    }

    public void addListener(@NotNull Disposable parent, @NotNull ChangeListener listener) {
        if (parent == null) {
            GraphSettings.X(4);
        }
        if (listener == null) {
            GraphSettings.X(5);
        }
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    private void X(@NotNull GraphSettings graphSettings) {
        if (graphSettings == null) {
            GraphSettings.X(6);
        }
        ((ChangeListener)this.myDispatcher.getMulticaster()).settingsChanged(graphSettings, this.copy());
    }

    @NotNull
    public Layouter getCurrentLayouter() {
        Layouter layouter = this.myCurrentLayouter;
        if (layouter == null) {
            GraphSettings.X(7);
        }
        return layouter;
    }

    public void setCurrentLayouter(@NotNull Layouter currentLayouter) {
        if (currentLayouter == null) {
            GraphSettings.X(8);
        }
        GraphSettings graphSettings = this.copy();
        this.myCurrentLayouter = currentLayouter;
        this.X(graphSettings);
    }

    @NotNull
    public GraphLayoutOrientation getCurrentLayoutOrientation() {
        GraphLayoutOrientation graphLayoutOrientation = this.myCurrentLayoutOrientation;
        if (graphLayoutOrientation == null) {
            GraphSettings.X(9);
        }
        return graphLayoutOrientation;
    }

    public void setCurrentLayoutOrientation(@NotNull GraphLayoutOrientation currentLayoutOrientation) {
        if (currentLayoutOrientation == null) {
            GraphSettings.X(10);
        }
        GraphSettings graphSettings = this.copy();
        this.myCurrentLayoutOrientation = currentLayoutOrientation;
        this.X(graphSettings);
    }

    @NotNull
    public EdgeRealizerProvider getCurrentEdgeRealizerProvider() {
        EdgeRealizerProvider edgeRealizerProvider = this.myCurrentEdgeRealizerProvider;
        if (edgeRealizerProvider == null) {
            GraphSettings.X(11);
        }
        return edgeRealizerProvider;
    }

    public void setCurrentEdgeRealizerProvider(@NotNull EdgeRealizerProvider currentEdgeRealizerProvider) {
        if (currentEdgeRealizerProvider == null) {
            GraphSettings.X(12);
        }
        GraphSettings graphSettings = this.copy();
        this.myCurrentEdgeRealizerProvider = currentEdgeRealizerProvider;
        this.X(graphSettings);
    }

    public boolean isFitContentAfterLayout() {
        return this.myDoFitContentAfterLayout;
    }

    public void setFitContentAfterLayout(boolean fitContentAfterLayout) {
        GraphSettings graphSettings = this.copy();
        this.myDoFitContentAfterLayout = fitContentAfterLayout;
        this.X(graphSettings);
    }

    public boolean isShowGrid() {
        return this.myDoShowGrid;
    }

    public void setShowGrid(boolean doShowGrid) {
        GraphSettings graphSettings = this.copy();
        this.myDoShowGrid = doShowGrid;
        this.X(graphSettings);
    }

    public boolean isShowEdgeLabels() {
        return this.myDoShowEdgeLabels;
    }

    public void setShowEdgeLabels(boolean showEdgeLabels) {
        GraphSettings graphSettings = this.copy();
        this.myDoShowEdgeLabels = showEdgeLabels;
        this.X(graphSettings);
    }

    public boolean isShowBridges() {
        return this.myDoShowBridges;
    }

    public void setShowBridges(boolean doShowBridges) {
        GraphSettings graphSettings = this.copy();
        this.myDoShowBridges = doShowBridges;
        this.X(graphSettings);
    }

    public boolean isShowStructureViewForSelectedNode() {
        return this.myDoShowStructureViewForSelectedNode;
    }

    public void setShowStructureViewForSelectedNode(boolean doShowStructureViewForSelectedNode) {
        GraphSettings graphSettings = this.copy();
        this.myDoShowStructureViewForSelectedNode = doShowStructureViewForSelectedNode;
        this.X(graphSettings);
    }

    public boolean isMergeEdgeBySources() {
        return this.myDoMergeEdgeBySources;
    }

    public void setMergeEdgeBySources(boolean doMergeEdgeBySources) {
        GraphSettings graphSettings = this.copy();
        this.myDoMergeEdgeBySources = doMergeEdgeBySources;
        this.X(graphSettings);
    }

    public boolean isMergeEdgeByTargets() {
        return this.myDoMergeEdgeByTargets;
    }

    public void setMergeEdgeByTargets(boolean doMergeEdgeByTargets) {
        GraphSettings graphSettings = this.copy();
        this.myDoMergeEdgeByTargets = doMergeEdgeByTargets;
        this.X(graphSettings);
    }

    public boolean isCollapseEdgesOnGrouping() {
        return this.myDoCollapseEdgesOnGrouping;
    }

    public void setCollapseEdgesOnGrouping(boolean doCollapseEdgesOnGrouping) {
        GraphSettings graphSettings = this.copy();
        this.myDoCollapseEdgesOnGrouping = doCollapseEdgesOnGrouping;
        this.X(graphSettings);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        GraphSettings graphSettings = (GraphSettings)o2;
        return this.myDoFitContentAfterLayout == graphSettings.myDoFitContentAfterLayout && this.myDoShowEdgeLabels == graphSettings.myDoShowEdgeLabels && this.myDoShowBridges == graphSettings.myDoShowBridges && this.myDoMergeEdgeBySources == graphSettings.myDoMergeEdgeBySources && this.myDoMergeEdgeByTargets == graphSettings.myDoMergeEdgeByTargets;
    }

    public int hashCode() {
        return Objects.hash(this.myCurrentLayouter, this.myDoFitContentAfterLayout, this.myDoShowEdgeLabels, this.myDoShowBridges, this.myDoMergeEdgeBySources, this.myDoMergeEdgeByTargets);
    }

    public String toString() {
        return "GraphSettings{myCurrentLayouter=" + String.valueOf(this.myCurrentLayouter) + ", myDoFitContentAfterLayout=" + this.myDoFitContentAfterLayout + ", myDoShowEdgeLabels=" + this.myDoShowEdgeLabels + ", myDoShowBridges=" + this.myDoShowBridges + ", myDoMergeEdgeBySources=" + this.myDoMergeEdgeBySources + ", myDoMergeEdgeByTargets=" + this.myDoMergeEdgeByTargets + "}";
    }

    private static /* synthetic */ void X(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 7, 9, 11 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLayouter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/settings/GraphSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLayoutOrientation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentEdgeRealizerProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/settings/GraphSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLayouter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLayoutOrientation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEdgeRealizerProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFrom";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fireSettingsChanged";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentLayouter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentLayoutOrientation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentEdgeRealizerProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 11 -> new IllegalStateException(string);
        };
    }

    public static interface ChangeListener
    extends EventListener {
        public void settingsChanged(@NotNull GraphSettings var1, @NotNull GraphSettings var2);
    }
}

