/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.api.customization;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.customization.LspCommandsCustomizer;
import com.intellij.platform.lsp.api.customization.LspCommandsSupport;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionDisabled;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u000fJ\b\u0010\u0016\u001a\u00020\u0012H\u0016J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u0017\u001a\u00020\u000fJ\b\u0010\u001e\u001a\u00020\u001fH\u0003J!\u0010 \u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0002J\u0010\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"J$\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J$\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0015J\u0012\u0010+\u001a\u0004\u0018\u00010\u00132\u0006\u0010+\u001a\u00020,H\u0002J\u001e\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\u0006\u0010.\u001a\u00020*H\u0002J\u001c\u0010/\u001a\u0004\u0018\u00010\u00132\u0006\u00100\u001a\u00020\u00122\b\b\u0002\u00101\u001a\u000202H\u0002J \u00103\u001a\u0002042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001dH\u0016J\u0018\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0013H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/platform/lsp/api/customization/LspIntentionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "initialCodeAction", "Lorg/eclipse/lsp4j/CodeAction;", "LspIntentionAction", "(Lcom/intellij/platform/lsp/api/LspServer;Lorg/eclipse/lsp4j/CodeAction;)V", "getLspServer", "()Lcom/intellij/platform/lsp/api/LspServer;", "resolvedCodeAction", "codeAction", "X", "()Lorg/eclipse/lsp4j/CodeAction;", "uriToDocumentMapInitialized", "", "uriToDocumentMap", "", "", "Lcom/intellij/openapi/editor/Document;", "getFamilyName", "startInWriteAction", "getText", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "X", "", "invoke", "contextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "X", "commandsSupport", "Lcom/intellij/platform/lsp/api/customization/LspCommandsCustomizer;", "command", "Lorg/eclipse/lsp4j/Command;", "applyWorkspaceEdit", "workspaceEdit", "Lorg/eclipse/lsp4j/WorkspaceEdit;", "X", "Lorg/eclipse/lsp4j/CreateFile;", "X", "edit", "X", "documentUri", "version", "", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "nonPhysicalPsiFile", "X", "nonPhysicalDocument", "physicalDocument", "intellij.platform.lsp"})
@SourceDebugExtension(value={"SMAP\nLspIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspIntentionAction.kt\ncom/intellij/platform/lsp/api/customization/LspIntentionAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,270:1\n1#2:271\n129#3:272\n158#3,3:273\n1915#4,2:276\n1807#4,3:278\n1915#4:281\n1916#4:283\n1915#4,2:287\n1915#4,2:289\n1915#4,2:295\n1915#4,2:297\n23#5:282\n23#5:284\n23#5:285\n23#5:286\n23#5:291\n23#5:292\n23#5:293\n23#5:294\n*S KotlinDebug\n*F\n+ 1 LspIntentionAction.kt\ncom/intellij/platform/lsp/api/customization/LspIntentionAction\n*L\n91#1:272\n91#1:273,3\n113#1:276,2\n122#1:278,3\n127#1:281\n127#1:283\n185#1:287,2\n194#1:289,2\n254#1:295,2\n261#1:297,2\n131#1:282\n158#1:284\n172#1:285\n178#1:286\n214#1:291\n219#1:292\n225#1:293\n231#1:294\n*E\n"})
public class LspIntentionAction
implements IntentionAction {
    @NotNull
    private final LspServer lspServer;
    @NotNull
    private final CodeAction initialCodeAction;
    @Nullable
    private CodeAction resolvedCodeAction;
    private boolean uriToDocumentMapInitialized;
    @Nullable
    private Map<String, ? extends Document> uriToDocumentMap;

    public LspIntentionAction(@NotNull LspServer lspServer, @NotNull CodeAction initialCodeAction) {
        InitializeResult initializeResult;
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)initialCodeAction, (String)"initialCodeAction");
        this.lspServer = lspServer;
        this.initialCodeAction = initialCodeAction;
        this.resolvedCodeAction = this.initialCodeAction.getEdit() != null || !((initializeResult = this.lspServer.getInitializeResult()) != null && (initializeResult = initializeResult.getCapabilities()) != null && (initializeResult = initializeResult.getCodeActionProvider()) != null && (initializeResult = (CodeActionOptions)initializeResult.getRight()) != null ? Intrinsics.areEqual((Object)initializeResult.getResolveProvider(), (Object)true) : false) ? this.initialCodeAction : null;
    }

    @NotNull
    protected final LspServer getLspServer() {
        return this.lspServer;
    }

    private final CodeAction X() {
        CodeAction codeAction = this.resolvedCodeAction;
        if (codeAction == null) {
            codeAction = this.initialCodeAction;
        }
        return codeAction;
    }

    @NotNull
    public final String getFamilyName() {
        return "";
    }

    public final boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        String string = this.X().getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.isAvailable();
    }

    public final boolean isAvailable() {
        CodeActionDisabled codeActionDisabled = this.X().getDisabled();
        if (codeActionDisabled != null) {
            CodeActionDisabled codeActionDisabled2 = codeActionDisabled;
            boolean bl = false;
            return false;
        }
        this.X();
        if (!this.uriToDocumentMapInitialized) {
            Map<String, Document> map;
            if (this.X().getEdit() != null) {
                WorkspaceEdit workspaceEdit = this.X().getEdit();
                Intrinsics.checkNotNullExpressionValue((Object)workspaceEdit, (String)"getEdit(...)");
                map = this.X(workspaceEdit);
            } else {
                map = MapsKt.emptyMap();
            }
            this.uriToDocumentMap = map;
            this.uriToDocumentMapInitialized = true;
        }
        return this.uriToDocumentMap != null && (this.X().getEdit() != null || this.X().getCommand() != null);
    }

    @RequiresBackgroundThread
    private final void X() {
        if (this.resolvedCodeAction != null) {
            return;
        }
        CodeAction codeAction = (CodeAction)LspServer.sendRequestSync$default(this.lspServer, 0, arg_0 -> LspIntentionAction.X(this, arg_0), 1, null);
        CodeAction codeAction2 = codeAction;
        if (codeAction2 == null) {
            codeAction2 = this.initialCodeAction;
        }
        this.resolvedCodeAction = codeAction2;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.invoke(psiFile.getVirtualFile());
    }

    public final void invoke(@Nullable VirtualFile contextFile) {
        block7: {
            Map<String, ? extends Document> map;
            block6: {
                Map<String, ? extends Document> map2 = this.uriToDocumentMap;
                if (map2 == null) {
                    return;
                }
                Map<String, ? extends Document> map3 = map = map2;
                boolean bl = false;
                Map<String, ? extends Document> map4 = map3;
                Collection collection = new ArrayList(map3.size());
                boolean bl2 = false;
                Iterator<Map.Entry<String, ? extends Document>> iterator = map4.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ? extends Document> entry;
                    Map.Entry<String, ? extends Document> entry2 = entry = iterator.next();
                    Collection collection2 = collection;
                    boolean bl3 = false;
                    collection2.add(FileDocumentManager.getInstance().getFile(entry2.getValue()));
                }
                List list = (List)collection;
                if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(this.lspServer.getProject(), (Collection)list)) {
                    return;
                }
                Object object = this.X().getEdit();
                if (object != null && (object = object.getChanges()) != null ? !object.isEmpty() : false) break block6;
                Object object2 = this.X().getEdit();
                boolean bl4 = object2 != null && (object2 = object2.getDocumentChanges()) != null ? !((Collection)object2).isEmpty() : false;
                if (!bl4) break block7;
            }
            WriteAction.run(() -> LspIntentionAction.X(this, map));
        }
        this.X(this.lspServer.getDescriptor().getLspCustomization().getCommandsCustomizer(), this.X().getCommand(), contextFile);
    }

    private final void X(LspCommandsCustomizer lspCommandsCustomizer, Command command, VirtualFile virtualFile) {
        if (lspCommandsCustomizer instanceof LspCommandsSupport && command != null && virtualFile != null) {
            ((LspCommandsSupport)lspCommandsCustomizer).executeCommand(this.lspServer, virtualFile, command);
        }
    }

    @RequiresWriteLock
    protected void applyWorkspaceEdit(@NotNull WorkspaceEdit workspaceEdit, @NotNull Map<String, ? extends Document> uriToDocumentMap) {
        block14: {
            boolean bl;
            boolean bl2;
            Iterable iterable;
            List list;
            Map map;
            block13: {
                Intrinsics.checkNotNullParameter((Object)workspaceEdit, (String)"workspaceEdit");
                Intrinsics.checkNotNullParameter(uriToDocumentMap, (String)"uriToDocumentMap");
                Map map2 = workspaceEdit.getChanges();
                if (map2 != null) {
                    Map map3 = map2;
                    boolean bl3 = false;
                    Iterable iterable2 = map3.entrySet();
                    boolean bl4 = false;
                    for (Object object : iterable2) {
                        Document document;
                        Map.Entry entry = (Map.Entry)object;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)uriToDocumentMap.get(entry.getKey()));
                        Object v2 = entry.getValue();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-value>(...)");
                        if (Lsp4jUtilKt.applyTextEdits(document, (List)v2)) continue;
                        return;
                    }
                }
                map = new LinkedHashMap();
                List list2 = workspaceEdit.getDocumentChanges();
                if (list2 == null) break block14;
                list = list2;
                boolean bl6 = false;
                iterable = list;
                bl2 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = false;
                } else {
                    for (Map.Entry entry : iterable) {
                        Either either = (Either)entry;
                        boolean bl7 = false;
                        if (!(either.isRight() && !(either.getRight() instanceof CreateFile))) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
            iterable = list;
            bl2 = false;
            for (Map.Entry entry : iterable) {
                boolean bl8;
                LspIntentionAction lspIntentionAction;
                Document document;
                TextDocumentEdit textDocumentEdit;
                boolean bl9;
                Either either = (Either)entry;
                boolean bl10 = false;
                if ((TextDocumentEdit)either.getLeft() != null) {
                    bl9 = false;
                    Document document2 = uriToDocumentMap.get(textDocumentEdit.getTextDocument().getUri());
                    if (document2 == null) {
                        document2 = (Document)map.get(textDocumentEdit.getTextDocument().getUri());
                    }
                    if ((document = document2) == null) {
                        lspIntentionAction = this;
                        bl8 = false;
                        Logger logger = Logger.getInstance(LspIntentionAction.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("No Document for " + textDocumentEdit.getTextDocument().getUri());
                        return;
                    }
                    List list3 = textDocumentEdit.getEdits();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getEdits(...)");
                    if (!Lsp4jUtilKt.applyTextEdits(document, list3)) {
                        return;
                    }
                }
                if ((ResourceOperation)either.getRight() == null) continue;
                bl9 = false;
                document = textDocumentEdit;
                if (document instanceof CreateFile) {
                    if (this.X((CreateFile)textDocumentEdit) != null) {
                        bl8 = false;
                        map.put(((CreateFile)textDocumentEdit).getUri(), lspIntentionAction);
                    }
                    continue;
                }
                if (!(document instanceof DeleteFile) && !(document instanceof RenameFile)) continue;
            }
        }
    }

    private final Document X(CreateFile createFile) {
        Document document;
        VirtualFile virtualFile;
        String string = createFile.getUri();
        String string2 = PathUtil.getParentPath((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getParentPath(...)");
        String string3 = string2;
        VirtualFile virtualFile2 = this.lspServer.getDescriptor().findFileByUri(string3);
        while (virtualFile2 == null && !(((CharSequence)string3).length() == 0)) {
            Intrinsics.checkNotNullExpressionValue((Object)PathUtil.getParentPath((String)string3), (String)"getParentPath(...)");
            virtualFile2 = this.lspServer.getDescriptor().findFileByUri(string3);
        }
        if (virtualFile2 == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Ignoring CreateFile(" + string + "): base directory not found");
            return null;
        }
        Intrinsics.checkNotNull((Object)string);
        String string4 = string.substring(string3.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String string5 = string4;
        String string6 = PathUtil.getFileName((String)string5);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getFileName(...)");
        String string7 = string6;
        String string8 = PathUtil.getParentPath((String)string5);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getParentPath(...)");
        String string9 = string8;
        VirtualFile virtualFile3 = virtualFile = ((CharSequence)string9).length() == 0 ? virtualFile2 : VfsUtil.createDirectoryIfMissing((String)(virtualFile2.getPath() + "/" + string9));
        if (virtualFile == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to create parent directory for CreateFile(" + string + ")");
            return null;
        }
        VirtualFile virtualFile4 = virtualFile.createChildData((Object)this, string7);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"createChildData(...)");
        VirtualFile virtualFile5 = virtualFile4;
        Document document2 = document = FileDocumentManager.getInstance().getDocument(virtualFile5);
        boolean bl = false;
        if (document2 == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl2 = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("No Document for created file " + virtualFile5.getPath());
        }
        return document;
    }

    private final Map<String, Document> X(WorkspaceEdit workspaceEdit) {
        Map map;
        block7: {
            map = new LinkedHashMap();
            Map map2 = workspaceEdit.getChanges();
            if (map2 != null) {
                Map map3 = map2;
                boolean bl = false;
                Iterable iterable = map3.keySet();
                boolean bl2 = false;
                for (Object object : iterable) {
                    Document document;
                    String string = (String)object;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)string);
                    if (LspIntentionAction.getDocument$default(this, string, 0, 2, null) == null) {
                        return null;
                    }
                    map.put(string, document);
                }
            }
            Set set = new LinkedHashSet();
            List list = workspaceEdit.getDocumentChanges();
            if (list == null) break block7;
            List list2 = list;
            boolean bl = false;
            Iterable iterable = list2;
            boolean bl4 = false;
            for (String string : iterable) {
                Either either = (Either)string;
                boolean bl5 = false;
                if ((TextDocumentEdit)either.getLeft() != null) {
                    TextDocumentEdit textDocumentEdit;
                    boolean bl6 = false;
                    String string2 = textDocumentEdit.getTextDocument().getUri();
                    if (!set.contains(string2)) {
                        Document document;
                        Integer n2 = textDocumentEdit.getTextDocument().getVersion();
                        Intrinsics.checkNotNull((Object)string2);
                        Integer n3 = n2;
                        if (this.X(string2, n3 != null ? n3 : -1) == null) {
                            return null;
                        }
                        map.put(string2, document);
                    }
                }
                Object object = either.getRight();
                Object object2 = object instanceof CreateFile ? (CreateFile)object : null;
                if (object2 == null || (object2 = object2.getUri()) == null) continue;
                Object object3 = object2;
                boolean bl7 = false;
                set.add(object3);
            }
        }
        return map;
    }

    private final Document X(String string, int n2) {
        VirtualFile virtualFile = this.lspServer.getDescriptor().findFileByUri(string);
        if (virtualFile == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("File not found: " + string);
            return null;
        }
        if (!ProjectFileIndex.getInstance((Project)this.lspServer.getProject()).isInContent(virtualFile)) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("File is not within the project content: " + string);
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Document not found for file: " + virtualFile);
            return null;
        }
        int n3 = this.lspServer.getDocumentVersion(document);
        if (n2 != -1 && n3 != n2) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Ignoring CodeAction for document version " + n2 + " (" + virtualFile.getName() + "); current document version: " + n3);
            return null;
        }
        return document;
    }

    static /* synthetic */ Document getDocument$default(LspIntentionAction lspIntentionAction, String string, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDocument");
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return lspIntentionAction.X(string, n2);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile nonPhysicalPsiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)nonPhysicalPsiFile, (String)"nonPhysicalPsiFile");
        Map<String, ? extends Document> map = this.uriToDocumentMap;
        if (map == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        Map<String, ? extends Document> map2 = map;
        PsiFile psiFile = nonPhysicalPsiFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile psiFile2 = psiFile;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
        if (document == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        Document document2 = document;
        if (!map2.containsValue(document2)) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        Document document3 = nonPhysicalPsiFile.getViewProvider().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
        this.X(document3, document2);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    private final void X(Document document, Document document2) {
        block5: {
            boolean bl;
            Map.Entry entry;
            boolean bl2;
            Iterable iterable;
            boolean bl3;
            Object object;
            Map<String, ? extends Document> map = this.uriToDocumentMap;
            if (map == null) {
                return;
            }
            Map<String, ? extends Document> map2 = map;
            WorkspaceEdit workspaceEdit = this.X().getEdit();
            if (workspaceEdit == null) {
                return;
            }
            WorkspaceEdit workspaceEdit2 = workspaceEdit;
            Map map3 = workspaceEdit2.getChanges();
            if (map3 != null) {
                object = map3;
                bl3 = false;
                iterable = object.entrySet();
                bl2 = false;
                for (Object t2 : iterable) {
                    entry = (Map.Entry)t2;
                    bl = false;
                    if (!Intrinsics.areEqual((Object)document2, (Object)map2.get(entry.getKey()))) continue;
                    Object v2 = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-value>(...)");
                    if (Lsp4jUtilKt.applyTextEdits(document, (List)v2)) continue;
                    return;
                }
            }
            List list = workspaceEdit2.getDocumentChanges();
            if (list == null) break block5;
            object = list;
            bl3 = false;
            iterable = (Iterable)object;
            bl2 = false;
            for (Object t2 : iterable) {
                TextDocumentEdit textDocumentEdit;
                entry = (Either)t2;
                bl = false;
                if ((TextDocumentEdit)entry.getLeft() == null) continue;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)document2, (Object)map2.get(textDocumentEdit.getTextDocument().getUri()))) continue;
                List list2 = textDocumentEdit.getEdits();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEdits(...)");
                if (Lsp4jUtilKt.applyTextEdits(document, list2)) continue;
                return;
            }
        }
    }

    private static final CompletableFuture X(LspIntentionAction lspIntentionAction, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().resolveCodeAction(lspIntentionAction.X());
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"resolveCodeAction(...)");
        return completableFuture;
    }

    private static final void X(LspIntentionAction lspIntentionAction, Map map) {
        WorkspaceEdit workspaceEdit = lspIntentionAction.X().getEdit();
        Intrinsics.checkNotNullExpressionValue((Object)workspaceEdit, (String)"getEdit(...)");
        lspIntentionAction.applyWorkspaceEdit(workspaceEdit, map);
    }
}

