/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.hierarchy.Lsp4jHierarchyItem;
import com.intellij.platform.lsp.impl.navigation.LspNavigationUtilKt;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/lsp/impl/hierarchy/LspHierarchyNodeDescriptor;", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "Lcom/intellij/pom/Navigatable;", "server", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "item", "Lcom/intellij/platform/lsp/impl/hierarchy/Lsp4jHierarchyItem;", "element", "Lcom/intellij/psi/PsiElement;", "parent", "isBase", "", "LspHierarchyNodeDescriptor", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;Lcom/intellij/platform/lsp/impl/hierarchy/Lsp4jHierarchyItem;Lcom/intellij/psi/PsiElement;Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;Z)V", "getServer$intellij_platform_lsp_impl", "()Lcom/intellij/platform/lsp/impl/LspServerImpl;", "getItem$intellij_platform_lsp_impl", "()Lcom/intellij/platform/lsp/impl/hierarchy/Lsp4jHierarchyItem;", "isBase$intellij_platform_lsp_impl", "()Z", "update", "canNavigate", "navigate", "", "requestFocus", "getIcon", "Ljavax/swing/Icon;", "intellij.platform.lsp.impl"})
public final class LspHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    @NotNull
    private final LspServerImpl server;
    @Nullable
    private final Lsp4jHierarchyItem item;
    private final boolean isBase;

    public LspHierarchyNodeDescriptor(@NotNull LspServerImpl server2, @Nullable Lsp4jHierarchyItem item, @NotNull PsiElement element, @Nullable HierarchyNodeDescriptor parent, boolean isBase) {
        Intrinsics.checkNotNullParameter((Object)server2, (String)"server");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(server2.getProject(), (NodeDescriptor)parent, element, isBase);
        this.server = server2;
        this.item = item;
        this.isBase = isBase;
    }

    @NotNull
    public final LspServerImpl getServer$intellij_platform_lsp_impl() {
        return this.server;
    }

    @Nullable
    public final Lsp4jHierarchyItem getItem$intellij_platform_lsp_impl() {
        return this.item;
    }

    public final boolean isBase$intellij_platform_lsp_impl() {
        return this.isBase;
    }

    public boolean update() {
        super.update();
        if (this.item == null) {
            return false;
        }
        CompositeAppearance compositeAppearance = this.myHighlightedText;
        Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance, (String)"myHighlightedText");
        CompositeAppearance compositeAppearance2 = compositeAppearance;
        this.myHighlightedText = new CompositeAppearance();
        this.myHighlightedText.getEnding().addText(this.item.getName());
        String string = this.item.getDetail();
        CharSequence charSequence = string;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.myHighlightedText.getEnding().addText(" : " + string, HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        return !Intrinsics.areEqual((Object)this.myHighlightedText, (Object)compositeAppearance2);
    }

    public boolean canNavigate() {
        if (this.item == null) {
            return false;
        }
        return ((CharSequence)this.item.getUri()).length() > 0;
    }

    public void navigate(boolean requestFocus) {
        if (this.item == null) {
            return;
        }
        VirtualFile virtualFile = this.server.getDescriptor().findFileByUri(this.item.getUri());
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Position position = this.item.getSelectionRange().getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        LspNavigationUtilKt.navigateToLspPosition(virtualFile2, project, position, requestFocus);
    }

    @Nullable
    protected Icon getIcon(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.item == null) {
            return null;
        }
        SymbolKind symbolKind = this.item.getKind();
        return this.server.getDescriptor().getLspCustomization().getSymbolKindCustomizer().getIcon(symbolKind);
    }
}

