/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.presentation;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

class AggregateReport {
    private final SortedMap<Fragment, Duplicate> myMap;
    @NotNull
    private final PathMacroManager myMacroManager;

    AggregateReport(@NotNull Project project) {
        if (project == null) {
            AggregateReport.X(0);
        }
        this.myMap = new TreeMap<Fragment, Duplicate>();
        this.myMacroManager = PathMacroManager.getInstance((ComponentManager)project);
    }

    void add(@NotNull TextClone textClone) {
        if (textClone == null) {
            AggregateReport.X(1);
        }
        TreeSet<Fragment> treeSet = new TreeSet<Fragment>();
        treeSet.add(new Fragment(textClone.getMain(), this.myMacroManager));
        for (TextFragment object2 : textClone.getDuplicates()) {
            treeSet.add(new Fragment(object2, this.myMacroManager));
        }
        ArrayList arrayList = new ArrayList();
        for (Fragment fragment : treeSet) {
            Duplicate duplicate = (Duplicate)this.myMap.get(fragment);
            if (duplicate == null) continue;
            arrayList.addAll(duplicate.myFragments);
        }
        treeSet.addAll(arrayList);
        Duplicate duplicate = new Duplicate(treeSet);
        for (Fragment fragment : duplicate.myFragments) {
            this.myMap.put(fragment, duplicate);
        }
    }

    void addContentTo(Consumer<? super Element> resultConsumer) {
        TreeSet<Duplicate> treeSet = new TreeSet<Duplicate>(this.myMap.values());
        for (Duplicate duplicate : treeSet) {
            resultConsumer.accept((Element)duplicate.createContent());
        }
    }

    private static /* synthetic */ void X(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textClone";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/clones/presentation/AggregateReport";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Fragment
    implements Comparable<Fragment> {
        @NotNull
        final String myCollapsedUrl;
        final int myLine;
        final int myStart;
        final int myEnd;

        Fragment(@NotNull TextFragment fragment, @NotNull PathMacroManager macroManager) {
            if (fragment == null) {
                Fragment.X(0);
            }
            if (macroManager == null) {
                Fragment.X(1);
            }
            this.myCollapsedUrl = macroManager.collapsePath(fragment.getFile().getUrl());
            this.myLine = Fragment.X(fragment);
            this.myStart = fragment.getRange().getStartOffset();
            this.myEnd = fragment.getRange().getEndOffset();
        }

        private static int X(@NotNull TextFragment textFragment) {
            if (textFragment == null) {
                Fragment.X(2);
            }
            try {
                return textFragment.getLines().getStart();
            }
            catch (Exception exception) {
                return 0;
            }
        }

        @NotNull
        Element createContent() {
            Element element = new Element("fragment");
            element.setAttribute("file", this.myCollapsedUrl);
            element.setAttribute("line", String.valueOf(this.myLine));
            element.setAttribute("start", String.valueOf(this.myStart));
            element.setAttribute("end", String.valueOf(this.myEnd));
            Element element2 = element;
            if (element2 == null) {
                Fragment.X(3);
            }
            return element2;
        }

        @Override
        public int compareTo(@NotNull Fragment f2) {
            int n2;
            if (f2 == null) {
                Fragment.X(4);
            }
            if ((n2 = this.myCollapsedUrl.compareTo(f2.myCollapsedUrl)) != 0) {
                return n2;
            }
            n2 = Integer.compare(this.myStart, f2.myStart);
            if (n2 != 0) {
                return n2;
            }
            return Integer.compare(this.myEnd, f2.myEnd);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof Fragment)) {
                return false;
            }
            Fragment fragment = (Fragment)o2;
            return this.myCollapsedUrl.equalsIgnoreCase(fragment.myCollapsedUrl) && this.myStart == fragment.myStart && this.myEnd == fragment.myEnd;
        }

        public int hashCode() {
            int n2 = this.myCollapsedUrl.hashCode();
            n2 = 31 * n2 + this.myStart;
            n2 = 31 * n2 + this.myEnd;
            return n2;
        }

        public String toString() {
            return this.myCollapsedUrl + ":" + this.myLine + " (" + this.myStart + "," + this.myEnd + ")";
        }

        private static /* synthetic */ void X(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "macroManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/clones/presentation/AggregateReport$Fragment";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "f";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/clones/presentation/AggregateReport$Fragment";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContent";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class Duplicate
    implements Comparable<Duplicate> {
        final List<Fragment> myFragments;
        @NotNull
        private final Fragment myFirstFragment;

        Duplicate(@NotNull SortedSet<Fragment> fragments) {
            if (fragments == null) {
                Duplicate.X(0);
            }
            if (fragments.isEmpty()) {
                throw new IllegalArgumentException("empty set of duplicates");
            }
            this.myFragments = new ArrayList<Fragment>(fragments);
            this.myFirstFragment = this.myFragments.get(0);
        }

        @NotNull
        Element createContent() {
            Element element = new Element("duplicate");
            element.setAttribute("cost", "1");
            element.setAttribute("hash", "0");
            for (Fragment fragment : this.myFragments) {
                element.addContent(fragment.createContent());
            }
            Element element2 = element;
            if (element2 == null) {
                Duplicate.X(1);
            }
            return element2;
        }

        @Override
        public int compareTo(@NotNull Duplicate d10) {
            if (d10 == null) {
                Duplicate.X(2);
            }
            return this.myFirstFragment.compareTo(d10.myFirstFragment);
        }

        public boolean equals(Object o2) {
            return this == o2 || o2 instanceof Duplicate && this.myFragments.equals(((Duplicate)o2).myFragments);
        }

        public int hashCode() {
            return this.myFragments.hashCode();
        }

        public String toString() {
            return this.myFragments.toString();
        }

        private static /* synthetic */ void X(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/clones/presentation/AggregateReport$Duplicate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "d";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/clones/presentation/AggregateReport$Duplicate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContent";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

