/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.xpath.XPath2ElementTypes;
import org.intellij.lang.xpath.XPath2TokenTypes;
import org.intellij.lang.xpath.XPathElementTypes;
import org.intellij.lang.xpath.XPathParser;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.Nullable;

public class XPath2Parser
extends XPathParser {
    @Override
    protected boolean parseExpr(PsiBuilder builder) {
        PsiBuilder.Marker seq = builder.mark();
        boolean b = this.parseExprSingle(builder);
        if (b && builder.getTokenType() == XPathTokenTypes.COMMA) {
            do {
                builder.advanceLexer();
                if (this.parseExprSingle(builder)) continue;
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            } while (builder.getTokenType() == XPathTokenTypes.COMMA);
            seq.done(XPath2ElementTypes.SEQUENCE);
        } else {
            seq.drop();
        }
        return b;
    }

    @Override
    protected boolean parseParenExpr(PsiBuilder builder) {
        if (builder.getTokenType() == XPathTokenTypes.RPAREN) {
            builder.mark().done(XPath2ElementTypes.SEQUENCE);
            return true;
        }
        return super.parseParenExpr(builder);
    }

    @Override
    protected boolean parsePrimaryExpr(PsiBuilder builder) {
        if (builder.getTokenType() == XPathTokenTypes.DOT) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done(XPath2ElementTypes.CONTEXT_ITEM);
            return true;
        }
        return super.parsePrimaryExpr(builder);
    }

    private boolean parseExprSingle(PsiBuilder builder) {
        if (builder.getTokenType() == XPath2TokenTypes.FOR) {
            return this.parseForExpr(builder);
        }
        if (XPath2TokenTypes.QUANTIFIERS.contains(builder.getTokenType())) {
            return this.parseQuantifiedExpr(builder);
        }
        if (builder.getTokenType() == XPath2TokenTypes.IF) {
            return this.parseIfExpr(builder);
        }
        return this.parseOrExpr(builder);
    }

    @Override
    protected boolean parseArgument(PsiBuilder builder) {
        return this.parseExprSingle(builder);
    }

    private boolean parseIfExpr(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        XPath2Parser.checkMatches(builder, XPath2TokenTypes.IF, XPathBundle.message("parsing.error.if.expected", new Object[0]));
        XPath2Parser.checkMatches(builder, XPathTokenTypes.LPAREN, XPathBundle.message("parsing.error.opening.parenthesis.expected", new Object[0]));
        if (!this.parseExpr(builder)) {
            builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        XPath2Parser.checkMatches(builder, XPathTokenTypes.RPAREN, XPathBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
        XPath2Parser.checkMatches(builder, XPath2TokenTypes.THEN, XPathBundle.message("parsing.error.then.expected", new Object[0]));
        if (!this.parseExprSingle(builder)) {
            builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        XPath2Parser.checkMatches(builder, XPath2TokenTypes.ELSE, XPathBundle.message("parsing.error.else.expected", new Object[0]));
        if (!this.parseExprSingle(builder)) {
            builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        mark.done(XPath2ElementTypes.IF);
        return true;
    }

    private boolean parseQuantifiedExpr(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        XPath2Parser.checkMatches(builder, XPath2TokenTypes.QUANTIFIERS, XPathBundle.message("parsing.error.every.or.some.expected", new Object[0]));
        this.parseBindingSequence(builder);
        XPath2Parser.checkMatches(builder, XPath2TokenTypes.SATISFIES, XPathBundle.message("parsing.error.satisfies.expected", new Object[0]));
        PsiBuilder.Marker ret = builder.mark();
        if (!this.parseExprSingle(builder)) {
            builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        ret.done(XPath2ElementTypes.BODY);
        mark.done(XPath2ElementTypes.QUANTIFIED);
        return true;
    }

    protected boolean parseForExpr(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        XPath2Parser.checkMatches(builder, XPath2TokenTypes.FOR, XPathBundle.message("parsing.error.for.expected", new Object[0]));
        this.parseBindingSequence(builder);
        PsiBuilder.Marker ret = builder.mark();
        XPath2Parser.checkMatches(builder, XPath2TokenTypes.RETURN, XPathBundle.message("parsing.error.return.expected", new Object[0]));
        if (!this.parseExprSingle(builder)) {
            builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        ret.done(XPath2ElementTypes.BODY);
        mark.done(XPath2ElementTypes.FOR);
        return true;
    }

    private void parseBindingSequence(PsiBuilder builder) {
        do {
            if (builder.getTokenType() == XPathTokenTypes.COMMA) {
                builder.advanceLexer();
            }
            PsiBuilder.Marker bindingSeq = builder.mark();
            XPath2Parser.parseVariableDecl(builder);
            XPath2Parser.checkMatches(builder, XPath2TokenTypes.IN, XPathBundle.message("parsing.error.in.expected", new Object[0]));
            if (!this.parseExprSingle(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            bindingSeq.done(XPath2ElementTypes.BINDING_SEQ);
        } while (builder.getTokenType() == XPathTokenTypes.COMMA);
    }

    @Override
    protected boolean parseEqualityExpression(PsiBuilder builder) {
        return this.parseComparisonExpr(builder);
    }

    private boolean parseComparisonExpr(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseRangeExpression(builder)) {
            expr.drop();
            return false;
        }
        while (XPath2TokenTypes.COMP_OPS.contains(builder.getTokenType())) {
            XPath2Parser.makeToken(builder);
            if (!this.parseRangeExpression(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected boolean parseRangeExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseAdditiveExpression(builder)) {
            expr.drop();
            return false;
        }
        while (builder.getTokenType() == XPath2TokenTypes.TO) {
            XPath2Parser.makeToken(builder);
            if (!this.parseAdditiveExpression(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPath2ElementTypes.RANGE_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    @Override
    protected boolean parseMultiplicativeExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseUnionExpression(builder)) {
            expr.drop();
            return false;
        }
        while (XPath2TokenTypes.MULT_OPS.contains(builder.getTokenType())) {
            XPath2Parser.makeToken(builder);
            if (!this.parseUnionExpression(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    @Override
    protected boolean parseUnionExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseIntersectExceptExpr(builder)) {
            expr.drop();
            return false;
        }
        while (XPath2TokenTypes.UNION_OPS.contains(builder.getTokenType())) {
            XPath2Parser.makeToken(builder);
            if (!this.parseIntersectExceptExpr(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected boolean parseIntersectExceptExpr(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseInstanceofExpr(builder)) {
            expr.drop();
            return false;
        }
        while (XPath2TokenTypes.INTERSECT_EXCEPT.contains(builder.getTokenType())) {
            XPath2Parser.makeToken(builder);
            if (!this.parseInstanceofExpr(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected boolean parseInstanceofExpr(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseTreatExpr(builder)) {
            expr.drop();
            return false;
        }
        if (builder.getTokenType() == XPath2TokenTypes.INSTANCE) {
            builder.advanceLexer();
            XPath2Parser.checkMatches(builder, XPath2TokenTypes.OF, XPathBundle.message("parsing.error.of.expected", new Object[0]));
            if (!this.parseSequenceType(builder)) {
                builder.error(XPathBundle.message("parsing.error.sequence.type.expected", new Object[0]));
            }
            expr.done(XPath2ElementTypes.INSTANCE_OF);
        } else {
            expr.drop();
        }
        return true;
    }

    protected boolean parseTreatExpr(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseCastableExpr(builder)) {
            expr.drop();
            return false;
        }
        if (builder.getTokenType() == XPath2TokenTypes.TREAT) {
            builder.advanceLexer();
            XPath2Parser.checkMatches(builder, XPath2TokenTypes.AS, XPathBundle.message("parsing.error.as.expected", new Object[0]));
            if (!this.parseSequenceType(builder)) {
                builder.error(XPathBundle.message("parsing.error.sequence.type.expected", new Object[0]));
            }
            expr.done(XPath2ElementTypes.TREAT_AS);
        } else {
            expr.drop();
        }
        return true;
    }

    protected boolean parseCastableExpr(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseCastExpr(builder)) {
            expr.drop();
            return false;
        }
        if (builder.getTokenType() == XPath2TokenTypes.CASTABLE) {
            builder.advanceLexer();
            XPath2Parser.checkMatches(builder, XPath2TokenTypes.AS, XPathBundle.message("parsing.error.as.expected", new Object[0]));
            XPath2Parser.parseSingleType(builder);
            expr.done(XPath2ElementTypes.CASTABLE_AS);
        } else {
            expr.drop();
        }
        return true;
    }

    protected boolean parseCastExpr(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseUnaryExpression(builder)) {
            expr.drop();
            return false;
        }
        if (builder.getTokenType() == XPath2TokenTypes.CAST) {
            builder.advanceLexer();
            XPath2Parser.checkMatches(builder, XPath2TokenTypes.AS, XPathBundle.message("parsing.error.as.expected", new Object[0]));
            XPath2Parser.parseSingleType(builder);
            expr.done(XPath2ElementTypes.CAST_AS);
        } else {
            expr.drop();
        }
        return true;
    }

    private static void parseSingleType(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        if (!XPath2Parser.parseQName(builder)) {
            builder.error(XPathBundle.message("parsing.error.qname.expected", new Object[0]));
        }
        if (builder.getTokenType() == XPath2TokenTypes.QUEST) {
            builder.advanceLexer();
        }
        mark.done(XPath2ElementTypes.SINGLE_TYPE);
        if (builder.getTokenType() == XPathTokenTypes.STAR) {
            builder.remapCurrentToken(XPathTokenTypes.MULT);
        }
    }

    private boolean parseSequenceType(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        IElementType type = this.parseItemOrEmptySequenceType(builder);
        if (type != null) {
            if (type == XPath2TokenTypes.ITEM && XPath2TokenTypes.OCCURRENCE_OPS.contains(builder.getTokenType())) {
                XPath2Parser.makeToken(builder);
            }
            mark.done(XPath2ElementTypes.SEQUENCE_TYPE);
            return true;
        }
        if (this.parseNodeType(builder) || XPath2Parser.parseQName(builder)) {
            if (builder.getTokenType() == XPathTokenTypes.MULT) {
                builder.remapCurrentToken(XPathTokenTypes.STAR);
            }
            if (XPath2TokenTypes.OCCURRENCE_OPS.contains(builder.getTokenType())) {
                XPath2Parser.makeToken(builder);
            }
            mark.done(XPath2ElementTypes.SEQUENCE_TYPE);
            return true;
        }
        mark.drop();
        return false;
    }

    @Nullable
    private IElementType parseItemOrEmptySequenceType(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == XPath2TokenTypes.ITEM || tokenType == XPath2TokenTypes.EMPTY_SEQUENCE) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            this.parseArgumentList(builder);
            mark.done(XPath2ElementTypes.ITEM_OR_EMPTY_SEQUENCE);
            return tokenType;
        }
        return null;
    }

    private static boolean parseQName(PsiBuilder builder) {
        if (builder.getTokenType() == XPathTokenTypes.NCNAME) {
            builder.advanceLexer();
            if (builder.getTokenType() == XPathTokenTypes.COL) {
                builder.advanceLexer();
                XPath2Parser.checkMatches(builder, XPathTokenTypes.NCNAME, XPathBundle.message("parsing.error.ncname.expected", new Object[0]));
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean parseUnaryExpression(PsiBuilder builder) {
        if (XPathTokenTypes.ADD_OPS.contains(builder.getTokenType())) {
            PsiBuilder.Marker expr = builder.mark();
            do {
                builder.advanceLexer();
                if (!this.parseUnaryExpression(builder)) {
                    builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
                }
                expr.done(XPathElementTypes.PREFIX_EXPRESSION);
                expr = expr.precede();
            } while (XPathTokenTypes.ADD_OPS.contains(builder.getTokenType()));
            expr.drop();
            return true;
        }
        return this.parseValueExpression(builder);
    }

    private boolean parseValueExpression(PsiBuilder builder) {
        return this.parsePathExpression(builder);
    }

    private static void parseVariableDecl(PsiBuilder builder) {
        XPath2Parser.parseVariable(builder, XPath2ElementTypes.VARIABLE_DECL);
    }

    @Override
    protected boolean parsePathExpression(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.getTokenType() == XPathTokenTypes.PATH) {
            builder.advanceLexer();
            this.parseRelativePathExpr(builder, false);
            marker.done(XPathElementTypes.LOCATION_PATH);
            return true;
        }
        if (builder.getTokenType() == XPathTokenTypes.ANY_PATH) {
            builder.advanceLexer();
            if (!this.parseRelativePathExpr(builder, false)) {
                builder.error(XPathBundle.message("parsing.error.relative.path.expected", new Object[0]));
            }
            marker.done(XPathElementTypes.LOCATION_PATH);
            return true;
        }
        marker.drop();
        return this.parseRelativePathExpr(builder, true);
    }

    private boolean parseRelativePathExpr(PsiBuilder builder, boolean pathRequired) {
        PsiBuilder.Marker path = builder.mark();
        boolean nameLocationPath = false;
        PsiBuilder.Marker expr = builder.mark();
        if (this.parseAxisStep(builder)) {
            expr.done(XPathElementTypes.STEP);
            expr = expr.precede();
            if (pathRequired) {
                nameLocationPath = true;
            }
        } else if (!this.parseFilterExpr(builder)) {
            expr.drop();
            path.drop();
            return false;
        }
        while (XPathTokenTypes.PATH_OPS.contains(builder.getTokenType())) {
            if (pathRequired) {
                nameLocationPath = true;
            }
            XPath2Parser.makeToken(builder);
            if (!this.parseStepExpr(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.STEP);
            expr = expr.precede();
        }
        expr.drop();
        if (nameLocationPath) {
            path.done(XPathElementTypes.LOCATION_PATH);
        } else {
            path.drop();
        }
        return true;
    }

    private boolean parseStepExpr(PsiBuilder builder) {
        return this.parseFilterExpr(builder) || this.parseAxisStep(builder);
    }

    private boolean parseAxisStep(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        PsiBuilder.Marker mark = builder.mark();
        if (XPathTokenTypes.AXIS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            mark.done(XPathElementTypes.AXIS_SPECIFIER);
            XPath2Parser.checkMatches(builder, XPathTokenTypes.COLCOL, XPathBundle.message("parsing.error.double.colon.expected", new Object[0]));
            if (!this.parseNodeTest(builder)) {
                builder.error(XPathBundle.message("parsing.error.node.test.expected", new Object[0]));
            }
        } else if (builder.getTokenType() == XPathTokenTypes.AT) {
            builder.advanceLexer();
            mark.done(XPathElementTypes.AXIS_SPECIFIER);
            if (!this.parseNodeTest(builder)) {
                builder.error(XPathBundle.message("parsing.error.node.test.expected", new Object[0]));
            }
        } else if (builder.getTokenType() == XPathTokenTypes.DOTDOT) {
            mark.drop();
            builder.advanceLexer();
        } else {
            mark.done(XPathElementTypes.AXIS_SPECIFIER);
            if (!this.parseNodeTest(builder)) {
                mark.rollbackTo();
                expr.drop();
                return false;
            }
        }
        while (XPathTokenTypes.LBRACKET == builder.getTokenType()) {
            this.parsePredicate(builder);
            expr.done(XPathElementTypes.FILTER_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseFilterExpr(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parsePrimaryExpr(builder)) {
            expr.drop();
            return false;
        }
        while (XPathTokenTypes.LBRACKET == builder.getTokenType()) {
            this.parsePredicate(builder);
            expr.done(XPathElementTypes.FILTER_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    @Override
    protected boolean parseWildcard(PsiBuilder builder) {
        builder.advanceLexer();
        if (builder.getTokenType() == XPathTokenTypes.COL) {
            builder.advanceLexer();
            if (builder.getTokenType() != XPathTokenTypes.NCNAME) {
                builder.error(XPathBundle.message("parsing.error.ncname.expected", new Object[0]));
            }
            builder.advanceLexer();
        }
        return true;
    }

    @Override
    protected TokenSet unionOps() {
        return XPath2TokenTypes.UNION_OPS;
    }
}

