/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.dbdrivers;

import com.intellij.jpa.jpb.model.backend.ds.DbDriversManagerExtension;
import com.intellij.jpa.jpb.model.backend.events.ExceptionEvent;
import com.intellij.jpa.jpb.model.config.DatabaseDriversConfigState;
import com.intellij.jpa.jpb.model.config.DbDriver;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.notifydialog.HNotificationManager;
import com.intellij.jpa.jpb.model.dbdrivers.DatabaseArtifactsManager;
import com.intellij.jpa.jpb.model.dbdrivers.DbDriversManager$registerDriverWrapper$;
import com.intellij.jpa.jpb.model.dbdrivers.DbDriversManager$removeIllegalDriver$;
import com.intellij.jpa.jpb.model.dbdrivers.DriverWrapper;
import com.intellij.jpa.jpb.model.util.DbUtils;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PathUtil;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0007\u0018\u0000 -2\u00020\u0001:\u0002-.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u0019\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0012\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016J#\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010#\u001a\u00020\bJ\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0016\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010#\u001a\u00020\bH\u0002J\u0014\u0010'\u001a\u00020\u000b2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\"H\u0002J\u000e\u0010)\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\bJ\u0018\u0010*\u001a\u00020\u000b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010+\u001a\u00020,R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/jpa/jpb/model/dbdrivers/DbDriversManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "driverClassToClassLoaderMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/jpa/jpb/model/dbdrivers/DbDriversManager$MyURLClassLoader;", "dispose", "", "showNotification", "message", "type", "Lcom/intellij/notification/NotificationType;", "getCompleteClassLoader", "Ljava/net/URLClassLoader;", "driverClassName", "getActualDriverURLs", "", "Ljava/net/URL;", "(Ljava/lang/String;)[Ljava/net/URL;", "isNeedRecreateClassLoader", "", "currClassLoader", "actualURLs", "(Lcom/intellij/jpa/jpb/model/dbdrivers/DbDriversManager$MyURLClassLoader;[Ljava/net/URL;)Z", "hasDriver", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "findDriver", "Ljava/sql/Driver;", "loadDriver", "Ljava/lang/Class;", "className", "removeIllegalDriver", "classLoader", "findCachedDriverClass", "registerDriverWrapper", "driverClass", "isDriverNeedToWrap", "handleException", "throwable", "", "Companion", "MyURLClassLoader", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nDbDriversManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbDriversManager.kt\ncom/intellij/jpa/jpb/model/dbdrivers/DbDriversManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1915#2,2:236\n14060#3,2:238\n13225#3,2:241\n13#4:240\n479#5:243\n1342#5,2:244\n479#5:246\n1#6:247\n*S KotlinDebug\n*F\n+ 1 DbDriversManager.kt\ncom/intellij/jpa/jpb/model/dbdrivers/DbDriversManager\n*L\n69#1:236,2\n89#1:238,2\n101#1:241,2\n96#1:240\n149#1:243\n151#1:244,2\n171#1:246\n*E\n"})
public final class DbDriversManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, MyURLClassLoader> driverClassToClassLoaderMap;
    public static final int NATIVE_LIB_MAX_DEPTH = 6;

    public DbDriversManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.driverClassToClassLoaderMap = new ConcurrentHashMap();
    }

    public void dispose() {
        Collection<MyURLClassLoader> collection = this.driverClassToClassLoaderMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MyURLClassLoader it = (MyURLClassLoader)element$iv;
            boolean bl = false;
            it.close();
        }
    }

    public final void showNotification(@NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        HNotificationManager.showNotification_(message, type);
    }

    @NotNull
    public final URLClassLoader getCompleteClassLoader(@NotNull String driverClassName) {
        Intrinsics.checkNotNullParameter((Object)driverClassName, (String)"driverClassName");
        MyURLClassLoader foundClassLoader = this.driverClassToClassLoaderMap.get(driverClassName);
        URL[] actualDriverURLs = this.getActualDriverURLs(driverClassName);
        if (foundClassLoader == null) {
            ((Map)this.driverClassToClassLoaderMap).put(driverClassName, new MyURLClassLoader(actualDriverURLs));
        } else if (this.isNeedRecreateClassLoader(foundClassLoader, actualDriverURLs)) {
            foundClassLoader.close();
            MyURLClassLoader newClassLoader = new MyURLClassLoader(actualDriverURLs);
            ((Map)this.driverClassToClassLoaderMap).put(driverClassName, newClassLoader);
            this.removeIllegalDriver(newClassLoader, driverClassName);
        } else {
            URL[] $this$forEach$iv = actualDriverURLs;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                URL element$iv;
                URL it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                foundClassLoader.addURL(it);
            }
        }
        MyURLClassLoader myURLClassLoader = this.driverClassToClassLoaderMap.get(driverClassName);
        Intrinsics.checkNotNull((Object)myURLClassLoader);
        return myURLClassLoader;
    }

    @NotNull
    public final URL[] getActualDriverURLs(@NotNull String driverClassName) {
        Intrinsics.checkNotNullParameter((Object)driverClassName, (String)"driverClassName");
        Object[] actualDriverURLs = DbDriversManagerExtension.Companion.getInstance().getActualDriverURLs(driverClassName, this.project);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DbDriversManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Actual Driver URLs for " + driverClassName + ": " + ArraysKt.joinToString$default((Object[])actualDriverURLs, (CharSequence)", ", null, null, (int)0, null, DbDriversManager::getActualDriverURLs$lambda$0, (int)30, null));
        return actualDriverURLs;
    }

    private final boolean isNeedRecreateClassLoader(MyURLClassLoader currClassLoader, URL[] actualURLs) {
        boolean bl;
        block1: {
            URL[] uRLArray = currClassLoader.getURLs();
            Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"getURLs(...)");
            Object[] $this$any$iv = uRLArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                URL it = (URL)element$iv;
                boolean bl2 = false;
                if (!(!ArraysKt.contains((Object[])actualURLs, (Object)it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean hasDriver(@NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        try {
            String string = dbType.getDriverClass();
            if (string == null) {
                return true;
            }
            String driverClass = string;
            this.loadDriver(driverClass);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Nullable
    public final Driver findDriver(@NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        String string = dbType.getDriverClass();
        if (string == null) {
            return null;
        }
        String driverClassName = string;
        MyURLClassLoader classLoader = this.driverClassToClassLoaderMap.get(driverClassName);
        if (classLoader != null) {
            Set set = ArraysKt.toSet((Object[])this.getActualDriverURLs(driverClassName));
            URL[] uRLArray = classLoader.getURLs();
            Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"getURLs(...)");
            if (Intrinsics.areEqual((Object)set, (Object)ArraysKt.toSet((Object[])uRLArray))) {
                Object v4;
                block4: {
                    Enumeration<Driver> enumeration = DriverManager.getDrivers();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getDrivers(...)");
                    Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                    for (Object e : sequence) {
                        Driver driver = (Driver)e;
                        boolean bl = false;
                        Driver actualDriver = driver instanceof DriverWrapper ? ((DriverWrapper)driver).getDriver() : driver;
                        if (!Intrinsics.areEqual((Object)actualDriver.getClass().getName(), (Object)driverClassName)) continue;
                        v4 = e;
                        break block4;
                    }
                    v4 = null;
                }
                return v4;
            }
        }
        return null;
    }

    @Nullable
    public final Class<?> loadDriver(@NotNull String className) throws ClassNotFoundException {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        MyURLClassLoader classLoader = this.driverClassToClassLoaderMap.get(className);
        if (classLoader != null) {
            Class<?> foundDriverClass;
            Set set = ArraysKt.toSet((Object[])this.getActualDriverURLs(className));
            URL[] uRLArray = classLoader.getURLs();
            Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"getURLs(...)");
            if (Intrinsics.areEqual((Object)set, (Object)ArraysKt.toSet((Object[])uRLArray)) && (foundDriverClass = this.findCachedDriverClass(className)) != null) {
                return foundDriverClass;
            }
        }
        Class<?> driverClass = Class.forName(className, true, this.getCompleteClassLoader(className));
        if (this.isDriverNeedToWrap(className)) {
            Intrinsics.checkNotNull(driverClass);
            this.registerDriverWrapper(driverClass);
        }
        return driverClass;
    }

    private final void removeIllegalDriver(MyURLClassLoader classLoader, String driverClassName) {
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getDrivers(...)");
        Sequence $this$filterIsInstance$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)removeIllegalDriver$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)sequence, arg_0 -> DbDriversManager.removeIllegalDriver$lambda$0(driverClassName, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DriverWrapper it = (DriverWrapper)element$iv;
            boolean bl = false;
            try {
                Class.forName(driverClassName, false, classLoader);
            }
            catch (ClassNotFoundException e) {
                DriverManager.deregisterDriver(it);
            }
        }
    }

    private final Class<?> findCachedDriverClass(String className) {
        Object v1;
        block2: {
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getDrivers(...)");
            Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            for (Object e : sequence) {
                Driver driver = (Driver)e;
                boolean bl = false;
                Driver actualDriver = driver instanceof DriverWrapper ? ((DriverWrapper)driver).getDriver() : driver;
                if (!Intrinsics.areEqual((Object)actualDriver.getClass().getName(), (Object)className)) continue;
                v1 = e;
                break block2;
            }
            v1 = null;
        }
        Driver driver = v1;
        if (driver == null) {
            return null;
        }
        Driver foundDriver = driver;
        return foundDriver instanceof DriverWrapper ? ((DriverWrapper)foundDriver).getDriver().getClass() : foundDriver.getClass();
    }

    private final void registerDriverWrapper(Class<?> driverClass) {
        Object v2;
        block2: {
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getDrivers(...)");
            Sequence $this$filterIsInstance$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)registerDriverWrapper$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence sequence2 = sequence;
            for (Object e : sequence2) {
                DriverWrapper it = (DriverWrapper)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDriver().getClass().getName(), (Object)driverClass.getName())) continue;
                v2 = e;
                break block2;
            }
            v2 = null;
        }
        DriverWrapper oldDriverWrapper = v2;
        if (oldDriverWrapper != null) {
            DriverManager.deregisterDriver(oldDriverWrapper);
        }
        Object obj = driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.sql.Driver");
        DriverManager.registerDriver(new DriverWrapper((Driver)obj));
    }

    public final boolean isDriverNeedToWrap(@NotNull String driverClassName) {
        Intrinsics.checkNotNullParameter((Object)driverClassName, (String)"driverClassName");
        return true;
    }

    public final void handleException(@Nullable Project project, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (project == null) {
            String string = throwable.getMessage();
            if (string == null) {
                string = throwable.getClass().getName();
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            this.showNotification(string2, NotificationType.ERROR);
        } else {
            new ExceptionEvent(this, throwable, true, false).post(project);
        }
    }

    private static final CharSequence getActualDriverURLs$lambda$0(URL it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private static final boolean removeIllegalDriver$lambda$0(String $driverClassName, DriverWrapper it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getDriver().getClass().getName(), (Object)$driverClassName);
    }

    @JvmStatic
    @NotNull
    public static final DbDriversManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @Nullable
    public static final DatabaseArtifactsManager.ArtifactVersion findCurrentMssqlArtifactVersion() {
        return Companion.findCurrentMssqlArtifactVersion();
    }

    @JvmStatic
    @NotNull
    public static final String getMssqlAuthLibUrl() {
        return Companion.getMssqlAuthLibUrl();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jpa/jpb/model/dbdrivers/DbDriversManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/dbdrivers/DbDriversManager;", "project", "Lcom/intellij/openapi/project/Project;", "NATIVE_LIB_MAX_DEPTH", "", "findCurrentMssqlArtifactVersion", "Lcom/intellij/jpa/jpb/model/dbdrivers/DatabaseArtifactsManager$ArtifactVersion;", "getMssqlAuthLibUrl", "", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nDbDriversManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbDriversManager.kt\ncom/intellij/jpa/jpb/model/dbdrivers/DbDriversManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1#2:236\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DbDriversManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(DbDriversManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DbDriversManager)object;
        }

        @JvmStatic
        @Nullable
        public final DatabaseArtifactsManager.ArtifactVersion findCurrentMssqlArtifactVersion() {
            Object artifactVersion;
            block7: {
                Object v4;
                Object object;
                block6: {
                    Object v2;
                    Object it;
                    Object object2;
                    DatabaseArtifactsManager.Artifact artifact;
                    block5: {
                        DatabaseArtifactsManager databaseArtifactsManager = DatabaseArtifactsManager.Companion.getInstance();
                        String string = DbType.MSSQL.getDriverClass();
                        if (string == null) {
                            return null;
                        }
                        String mssqlDriverClass = string;
                        DatabaseArtifactsManager.Artifact artifact2 = databaseArtifactsManager.findArtifactByDriverClass(mssqlDriverClass);
                        if (artifact2 == null) {
                            return null;
                        }
                        artifact = artifact2;
                        object = DatabaseDriversConfigState.Companion.getInstance().getDrivers();
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            object2 = iterator.next();
                            it = (DbDriver)object2;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)((DbDriver)it).getId(), (Object)mssqlDriverClass)) continue;
                            v2 = object2;
                            break block5;
                        }
                        v2 = null;
                    }
                    DbDriver dbDriver = v2;
                    artifactVersion = null;
                    artifactVersion = CollectionsKt.last((Iterable)artifact.getVersions());
                    if (dbDriver == null) break block7;
                    SequencedCollection sequencedCollection = artifact.getVersions().reversed();
                    Intrinsics.checkNotNullExpressionValue((Object)sequencedCollection, (String)"reversed(...)");
                    object2 = sequencedCollection;
                    it = object2.iterator();
                    while (it.hasNext()) {
                        Object e = it.next();
                        DatabaseArtifactsManager.ArtifactVersion it2 = (DatabaseArtifactsManager.ArtifactVersion)e;
                        boolean bl = false;
                        if (!(dbDriver.getVersion() != null && Intrinsics.areEqual((Object)it2.getVersion(), (Object)dbDriver.getVersion()))) continue;
                        v4 = e;
                        break block6;
                    }
                    v4 = null;
                }
                object = v4;
                if (object != null) {
                    Object it = object;
                    boolean bl = false;
                    artifactVersion = it;
                }
            }
            return (DatabaseArtifactsManager.ArtifactVersion)artifactVersion;
        }

        @JvmStatic
        @NotNull
        public final String getMssqlAuthLibUrl() {
            String string;
            Object v1;
            block2: {
                DatabaseArtifactsManager.ArtifactVersion artifactVersion = this.findCurrentMssqlArtifactVersion();
                if (artifactVersion == null) {
                    return "";
                }
                DatabaseArtifactsManager.ArtifactVersion artifactVersion2 = artifactVersion;
                Iterable iterable = artifactVersion2.getItems();
                for (Object t : iterable) {
                    DatabaseArtifactsManager.Item item = (DatabaseArtifactsManager.Item)t;
                    boolean bl = false;
                    if (!(item.getType() == DatabaseArtifactsManager.Item.Type.NATIVE && StringsKt.contains((CharSequence)item.getName(), (CharSequence)"-win-auth", (boolean)true))) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            DatabaseArtifactsManager.Item item = v1;
            return item != null && (string = item.getUrl()) != null ? string : "";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/jpa/jpb/model/dbdrivers/DbDriversManager$MyURLClassLoader;", "Ljava/net/URLClassLoader;", "urls", "", "Ljava/net/URL;", "<init>", "([Ljava/net/URL;)V", "addURL", "", "url", "findLibrary", "", "libname", "intellij.javaee.jpa.jpb.model"})
    private static final class MyURLClassLoader
    extends URLClassLoader {
        public MyURLClassLoader(@NotNull URL[] urls) {
            Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
            super(urls, DbDriversManagerExtension.Companion.getInstance().getClass().getClassLoader());
        }

        public /* synthetic */ MyURLClassLoader(URL[] uRLArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                uRLArray = new URL[]{};
            }
            this(uRLArray);
        }

        @Override
        public void addURL(@Nullable URL url) {
            super.addURL(url);
        }

        @Override
        @Nullable
        protected String findLibrary(@Nullable String libname) {
            Path path;
            if (!SystemInfo.isWindows) {
                return super.findLibrary(libname);
            }
            File nativeLibsRoot = DbUtils.NATIVE_LIBS_ROOT;
            if (!nativeLibsRoot.exists()) {
                return super.findLibrary(libname);
            }
            Path path2 = Files.find(nativeLibsRoot.toPath(), 6, (arg_0, arg_1) -> MyURLClassLoader.findLibrary$lambda$0(libname, arg_0, arg_1), new FileVisitOption[0]).findFirst().orElse(null);
            String foundLib = path2 != null && (path = path2.toAbsolutePath()) != null ? ((Object)path).toString() : null;
            String string = foundLib;
            if (string == null) {
                string = super.findLibrary(libname);
            }
            return string;
        }

        private static final boolean findLibrary$lambda$0(String $libname, Path path, BasicFileAttributes fileAttributes) {
            return !fileAttributes.isDirectory() && StringsKt.equals((String)PathUtil.getFileName((String)((Object)path.getFileName()).toString()), (String)$libname, (boolean)true);
        }

        public MyURLClassLoader() {
            this(null, 1, null);
        }
    }
}

