/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.dateTime.SqlDtToken;
import com.intellij.sql.dialects.dateTime.psi.ParseContext;
import com.intellij.sql.dialects.dateTime.psi.ParseUtilsKt;
import com.intellij.sql.dialects.dateTime.psi.SqlDtCompositeElementType;
import com.intellij.sql.dialects.dateTime.psi.values.SqlTemporalValue;
import com.intellij.sql.dialects.dateTime.psi.values.SqlTemporalValueKt;
import com.intellij.sql.dialects.mysql._MysqlDtLexer;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlTimeAndDateLiteralExpressionImpl;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u000e\u0018\u00010\u001e\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u001f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/sql/dialects/mysql/MysqlDateTimeLanguageHelper;", "Lcom/intellij/sql/dialects/dateTime/SqlDateTimeLanguageHelper;", "<init>", "()V", "DATE_TIME_DELIMITERS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "DELIMITERS_NON_STRICT", "DATE_DELIMITERS_STRICT", "TIME_DELIMITERS_STRICT", "ODBC_TIME_DELIMITERS", "MAX_DURATION_HOURS", "", "getRootElementType", "Lcom/intellij/sql/dialects/dateTime/psi/SqlDtCompositeElementType;", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "createLexer", "Lcom/intellij/lexer/FlexLexer;", "createParser", "Lcom/intellij/lang/PsiParser;", "inspectTemporalValue", "Lcom/intellij/codeInspection/ProblemDescriptor;", "temporal", "Lcom/intellij/sql/dialects/dateTime/psi/values/SqlTemporalValue;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "validateTemporalValue", "", "Lorg/jetbrains/annotations/Nls;", "intellij.database.dialects.mysqlbase"})
public final class MysqlDateTimeLanguageHelper
extends SqlDateTimeLanguageHelper {
    @NotNull
    public static final MysqlDateTimeLanguageHelper INSTANCE = new MysqlDateTimeLanguageHelper();
    @NotNull
    private static final TokenSet DATE_TIME_DELIMITERS;
    @NotNull
    private static final TokenSet DELIMITERS_NON_STRICT;
    @NotNull
    private static final TokenSet DATE_DELIMITERS_STRICT;
    @NotNull
    private static final TokenSet TIME_DELIMITERS_STRICT;
    @NotNull
    private static final TokenSet ODBC_TIME_DELIMITERS;
    private static final int MAX_DURATION_HOURS = 838;

    private MysqlDateTimeLanguageHelper() {
    }

    @Nullable
    public SqlDtCompositeElementType getRootElementType(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiElement psiElement = host.getParent();
        SqlTimeAndDateLiteralExpressionImpl sqlTimeAndDateLiteralExpressionImpl = psiElement instanceof SqlTimeAndDateLiteralExpressionImpl ? (SqlTimeAndDateLiteralExpressionImpl)psiElement : null;
        return Intrinsics.areEqual((Object)(sqlTimeAndDateLiteralExpressionImpl != null ? sqlTimeAndDateLiteralExpressionImpl.getElementType() : null), (Object)SqlCompositeElementTypes.SQL_TIME_LITERAL) ? SqlDtCompositeElementType.Companion.getDURATION() : super.getRootElementType(host);
    }

    @NotNull
    public FlexLexer createLexer(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiElement psiElement = host.getParent();
        IElementType hostType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
        return new _MysqlDtLexer(Intrinsics.areEqual((Object)hostType, (Object)SqlCompositeElementTypes.ODBC_DATE) || Intrinsics.areEqual((Object)hostType, (Object)SqlCompositeElementTypes.ODBC_TIME) ? SqlDtToken.WHITE_SPACE : (IElementType)SqlDtToken.SIGNIFICANT_WHITE_SPACE);
    }

    @NotNull
    public PsiParser createParser(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return ParseUtilsKt.parser((arg_0, arg_1) -> MysqlDateTimeLanguageHelper.createParser$lambda$0(host, arg_0, arg_1));
    }

    @Nullable
    public ProblemDescriptor inspectTemporalValue(@NotNull SqlTemporalValue<?> temporal, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptor problemDescriptor;
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (temporal instanceof SqlTemporalValue.TimeDuration) {
            SqlTemporalValue.Hour hour = ((SqlTemporalValue.TimeDuration)temporal).getHour();
            if (hour == null) {
                return null;
            }
            SqlTemporalValue.Hour hour2 = hour;
            Object object = ((SqlTemporalValue.TimeDuration)temporal).getDayOfTime();
            int dayOfTime = Math.abs(object != null && (object = object.getValue()) != null ? (Integer)object : 0);
            int maxHours = 838 - dayOfTime * 24;
            if (maxHours < 0) {
                return null;
            }
            int minHours = ((SqlTemporalValue.TimeDuration)temporal).getDayOfTime() != null ? 0 : -maxHours;
            String string = this.validateInterval((SqlTemporalValue)hour2, minHours, maxHours);
            if (string == null) {
                return null;
            }
            String message = string;
            problemDescriptor = manager.createProblemDescriptor((PsiElement)hour2.getPsi(), SqlTemporalValueKt.getRangeInElement((SqlTemporalValue)((SqlTemporalValue)hour2)), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]);
        } else {
            problemDescriptor = super.inspectTemporalValue(temporal, manager, isOnTheFly);
        }
        return problemDescriptor;
    }

    @Nullable
    public String validateTemporalValue(@NotNull SqlTemporalValue<?> temporal) {
        String string;
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        SqlTemporalValue<?> sqlTemporalValue = temporal;
        if (sqlTemporalValue instanceof SqlTemporalValue.Date) {
            int textLength = ((SqlTemporalValue.Date)temporal).getPsi().getTextLength();
            string = SqlTemporalValueKt.isConcatenated(temporal) && textLength != 6 && textLength != 8 ? SqlBundle.message((String)"inspection.message.concatenated.date.must.take.form.either.yymmdd.or.yyyymmdd", (Object[])new Object[0]) : null;
        } else if (sqlTemporalValue instanceof SqlTemporalValue.Year) {
            string = this.validateInterval(temporal, -9999, 9999);
        } else if (sqlTemporalValue instanceof SqlTemporalValue.DayOfTime) {
            string = this.validateInterval(temporal, 0, 34);
        } else if (sqlTemporalValue instanceof SqlTemporalValue.Hour) {
            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)((SqlTemporalValue.Hour)temporal).getPsi().getParent());
            string = Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getTIMESTAMP()) ? this.validateInterval(temporal, 0, 23) : (Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getTIME()) ? this.validateInterval(temporal, -838, 838) : null);
        } else if (sqlTemporalValue instanceof SqlTemporalValue.SecondFraction) {
            IntRange intRange = new IntRange(0, 999999);
            Integer n = ((SqlTemporalValue.SecondFraction)temporal).getValue();
            string = !(n != null && intRange.contains(n.intValue())) ? SqlBundle.message((String)"inspection.message.fractions.longer.than.digits.are.rounded.off", (Object[])new Object[0]) : null;
        } else {
            string = super.validateTemporalValue(temporal);
        }
        return string;
    }

    private static final boolean createParser$lambda$0$parseDate$0(IElementType $hostType, ParseContext $this$elem) {
        Intrinsics.checkNotNullParameter((Object)$this$elem, (String)"$this$elem");
        return (!Intrinsics.areEqual((Object)$hostType, (Object)SqlCompositeElementTypes.ODBC_DATE) || $this$elem.maybe((IElementType)SqlDtToken.MINUS)) && ParseContext.tok$default((ParseContext)$this$elem, (IElementType)((IElementType)SqlDtToken.NUMBER), null, (int)2, null);
    }

    private static final boolean createParser$lambda$0$parseDate$1(ParseContext $this$elem) {
        Intrinsics.checkNotNullParameter((Object)$this$elem, (String)"$this$elem");
        return ParseContext.tok$default((ParseContext)$this$elem, (IElementType)((IElementType)SqlDtToken.NUMBER), null, (int)2, null);
    }

    private static final boolean createParser$lambda$0$parseDate$2(ParseContext $this$elem) {
        Intrinsics.checkNotNullParameter((Object)$this$elem, (String)"$this$elem");
        return ParseContext.tok$default((ParseContext)$this$elem, (IElementType)((IElementType)SqlDtToken.NUMBER), null, (int)2, null);
    }

    private static final boolean createParser$lambda$0$parseFractionalPart$3$1$0(ParseContext $this$elem) {
        Intrinsics.checkNotNullParameter((Object)$this$elem, (String)"$this$elem");
        return ParseContext.tok$default((ParseContext)$this$elem, (IElementType)((IElementType)SqlDtToken.NUMBER), null, (int)2, null);
    }

    private static final String createParser$lambda$0$parseFractionalPart$3$0(ParseContext $this$tok, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$tok, (String)"$this$tok");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)".") ? "'.' expected" : null;
    }

    private static final boolean createParser$lambda$0$parseFractionalPart$3$1(ParseContext $this$maybe) {
        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
        return ParseContext.elem$default((ParseContext)$this$maybe, (IElementType)((IElementType)SqlDtCompositeElementType.Companion.getSECOND_FRACTION()), null, MysqlDateTimeLanguageHelper::createParser$lambda$0$parseFractionalPart$3$1$0, (int)2, null);
    }

    private static final boolean createParser$lambda$0$parseFractionalPart$3(IElementType $hostType, ParseContext $this$maybe) {
        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
        return (ParseContext.tok$default((ParseContext)$this$maybe, (IElementType)((IElementType)SqlDtToken.DOT), null, (int)2, null) || $this$maybe.tok((IElementType)SqlDtToken.GENERIC_DELIMITER, MysqlDateTimeLanguageHelper::createParser$lambda$0$parseFractionalPart$3$0)) && $this$maybe.maybe(!Intrinsics.areEqual((Object)$hostType, (Object)SqlCompositeElementTypes.ODBC_TIMESTAMP), MysqlDateTimeLanguageHelper::createParser$lambda$0$parseFractionalPart$3$1);
    }

    private static final boolean createParser$lambda$0$parseTimeBase$4$0(ParseContext $this$elem) {
        Intrinsics.checkNotNullParameter((Object)$this$elem, (String)"$this$elem");
        return ParseContext.tok$default((ParseContext)$this$elem, (IElementType)((IElementType)SqlDtToken.NUMBER), null, (int)2, null);
    }

    private static final boolean createParser$lambda$0$parseTimeBase$5$0$1$0$0(ParseContext $this$elem) {
        Intrinsics.checkNotNullParameter((Object)$this$elem, (String)"$this$elem");
        return ParseContext.tok$default((ParseContext)$this$elem, (IElementType)((IElementType)SqlDtToken.NUMBER), null, (int)2, null);
    }

    private static final boolean createParser$lambda$0$parseTimeBase$5$0$1$0(ParseContext $this_parser, IElementType $hostType, ParseContext $this$maybe) {
        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
        return (ParseContext.elem$default((ParseContext)$this$maybe, (IElementType)((IElementType)SqlDtCompositeElementType.Companion.getSECOND()), null, MysqlDateTimeLanguageHelper::createParser$lambda$0$parseTimeBase$5$0$1$0$0, (int)2, null) || $this$maybe.recoverUpTo((IElementType)SqlDtToken.NUMBER, "positive number")) && MysqlDateTimeLanguageHelper.createParser$lambda$0$parseFractionalPart($this_parser, $hostType);
    }

    private static final boolean createParser$lambda$0$parseTimeBase$5$0$0(ParseContext $this$elem) {
        Intrinsics.checkNotNullParameter((Object)$this$elem, (String)"$this$elem");
        return ParseContext.tok$default((ParseContext)$this$elem, (IElementType)((IElementType)SqlDtToken.NUMBER), null, (int)2, null);
    }

    private static final boolean createParser$lambda$0$parseTimeBase$5$0$1(TokenSet $timeDelimiters, boolean $isOdbc, String $delimiterMessage, IElementType $root, ParseContext $this_parser, IElementType $hostType, ParseContext $this$maybe) {
        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
        return ($this$maybe.some($timeDelimiters) || $isOdbc && Intrinsics.areEqual((Object)$this$maybe.getBuilder().getTokenType(), (Object)SqlDtToken.NUMBER) || $this$maybe.recoverUpTo((IElementType)SqlDtToken.NUMBER, $delimiterMessage)) && $this$maybe.maybe(!$isOdbc && Intrinsics.areEqual((Object)$root, (Object)SqlDtCompositeElementType.Companion.getTIMESTAMP()), arg_0 -> MysqlDateTimeLanguageHelper.createParser$lambda$0$parseTimeBase$5$0$1$0($this_parser, $hostType, arg_0));
    }

    private static final boolean createParser$lambda$0$parseTimeBase$5$0(boolean $isOdbc, TokenSet $timeDelimiters, String $delimiterMessage, IElementType $root, ParseContext $this_parser, IElementType $hostType, ParseContext $this$maybe) {
        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
        return (ParseContext.elem$default((ParseContext)$this$maybe, (IElementType)((IElementType)SqlDtCompositeElementType.Companion.getMINUTE()), null, MysqlDateTimeLanguageHelper::createParser$lambda$0$parseTimeBase$5$0$0, (int)2, null) || $this$maybe.recoverUpTo((IElementType)SqlDtToken.NUMBER, "positive number")) && $this$maybe.maybe(!$isOdbc, arg_0 -> MysqlDateTimeLanguageHelper.createParser$lambda$0$parseTimeBase$5$0$1($timeDelimiters, $isOdbc, $delimiterMessage, $root, $this_parser, $hostType, arg_0));
    }

    private static final boolean createParser$lambda$0$parseTimeBase$4(TokenSet $timeDelimiters, ParseContext $this$maybe) {
        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
        return $this$maybe.elem((IElementType)SqlDtCompositeElementType.Companion.getHOUR(), $timeDelimiters.contains($this$maybe.getBuilder().getTokenType()) ? null : "positive number", MysqlDateTimeLanguageHelper::createParser$lambda$0$parseTimeBase$4$0);
    }

    private static final boolean createParser$lambda$0$parseTimeBase$5(TokenSet $timeDelimiters, boolean $isOdbc, String $delimiterMessage, IElementType $root, ParseContext $this_parser, IElementType $hostType, ParseContext $this$maybe) {
        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
        return ($this$maybe.some($timeDelimiters) || $isOdbc && Intrinsics.areEqual((Object)$this$maybe.getBuilder().getTokenType(), (Object)SqlDtToken.NUMBER) || $this$maybe.recoverUpTo((IElementType)SqlDtToken.NUMBER, $delimiterMessage)) && $this$maybe.maybe(!$isOdbc && Intrinsics.areEqual((Object)$root, (Object)SqlDtCompositeElementType.Companion.getTIMESTAMP()), arg_0 -> MysqlDateTimeLanguageHelper.createParser$lambda$0$parseTimeBase$5$0($isOdbc, $timeDelimiters, $delimiterMessage, $root, $this_parser, $hostType, arg_0));
    }

    private static final boolean createParser$lambda$0$parseTime$6$0(ParseContext $this$elem) {
        Intrinsics.checkNotNullParameter((Object)$this$elem, (String)"$this$elem");
        return ParseContext.tok$default((ParseContext)$this$elem, (IElementType)((IElementType)SqlDtToken.NUMBER), null, (int)2, null) && Intrinsics.areEqual((Object)$this$elem.getBuilder().getTokenType(), (Object)SqlDtToken.SIGNIFICANT_WHITE_SPACE);
    }

    private static final boolean createParser$lambda$0$parseTime$6(IElementType $root, ParseContext $this$maybe) {
        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
        return Intrinsics.areEqual((Object)$root, (Object)SqlDtCompositeElementType.Companion.getDURATION()) && $this$maybe.maybe((IElementType)SqlDtToken.MINUS) && ParseContext.elem$default((ParseContext)$this$maybe, (IElementType)((IElementType)SqlDtCompositeElementType.Companion.getDAY_OF_TIME()), null, MysqlDateTimeLanguageHelper::createParser$lambda$0$parseTime$6$0, (int)2, null) && $this$maybe.consumeSpaces();
    }

    private static final boolean createParser$lambda$0$parseConcatenatedValue(ParseContext $this_parser, Function2<? super ParseContext, ? super String, SqlDtCompositeElementType> calcType) {
        if (!Intrinsics.areEqual((Object)$this_parser.getBuilder().getTokenType(), (Object)SqlDtToken.NUMBER)) {
            return false;
        }
        if ($this_parser.getBuilder().rawLookup(1) == null || Intrinsics.areEqual((Object)$this_parser.getBuilder().rawLookup(1), (Object)SqlDtToken.DOT) || Intrinsics.areEqual((Object)$this_parser.getBuilder().rawLookup(1), (Object)SqlDtToken.SIGNIFICANT_WHITE_SPACE) && $this_parser.getBuilder().rawLookup(2) == null) {
            String string = $this_parser.getBuilder().getTokenText();
            Intrinsics.checkNotNull((Object)string);
            SqlDtCompositeElementType elementType = (SqlDtCompositeElementType)calcType.invoke((Object)$this_parser, (Object)string);
            PsiBuilder.Marker marker = $this_parser.getBuilder().mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker2 = marker;
            $this_parser.getBuilder().advanceLexer();
            marker2.done((IElementType)elementType);
            return true;
        }
        return false;
    }

    private static final boolean createParser$lambda$0$parseDate(boolean isOdbc, ParseContext $this_parser, IElementType hostType) {
        TokenSet dateDelimiters = isOdbc ? DATE_DELIMITERS_STRICT : DELIMITERS_NON_STRICT;
        String delimiterMessage = isOdbc ? "'-'" : "punctuation character";
        return $this_parser.elem((IElementType)SqlDtCompositeElementType.Companion.getYEAR(), "positive number", arg_0 -> MysqlDateTimeLanguageHelper.createParser$lambda$0$parseDate$0(hostType, arg_0)) && ($this_parser.some(dateDelimiters) || isOdbc && Intrinsics.areEqual((Object)$this_parser.getBuilder().getTokenType(), (Object)SqlDtToken.NUMBER) || $this_parser.recoverUpTo((IElementType)SqlDtToken.NUMBER, delimiterMessage)) && $this_parser.elem((IElementType)SqlDtCompositeElementType.Companion.getMONTH(), "positive number", MysqlDateTimeLanguageHelper::createParser$lambda$0$parseDate$1) && ($this_parser.some(dateDelimiters) || isOdbc && Intrinsics.areEqual((Object)$this_parser.getBuilder().getTokenType(), (Object)SqlDtToken.NUMBER) || $this_parser.recoverUpTo((IElementType)SqlDtToken.NUMBER, delimiterMessage)) && $this_parser.elem((IElementType)SqlDtCompositeElementType.Companion.getDAY_OF_MONTH(), "positive number", MysqlDateTimeLanguageHelper::createParser$lambda$0$parseDate$2);
    }

    private static final boolean createParser$lambda$0$parseFractionalPart(ParseContext $this_parser, IElementType hostType) {
        return ParseContext.maybe$default((ParseContext)$this_parser, (boolean)false, arg_0 -> MysqlDateTimeLanguageHelper.createParser$lambda$0$parseFractionalPart$3(hostType, arg_0), (int)1, null);
    }

    private static final boolean createParser$lambda$0$parseTimeBase(IElementType hostType, ParseContext $this_parser, boolean isOdbc, IElementType $root, boolean isOptionalHour) {
        IElementType iElementType = hostType;
        Pair pair = Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.ODBC_TIMESTAMP) ? TuplesKt.to((Object)TIME_DELIMITERS_STRICT, (Object)"':'") : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.ODBC_TIME) ? TuplesKt.to((Object)ODBC_TIME_DELIMITERS, (Object)"':' or '.'") : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_TIME_LITERAL) ? TuplesKt.to((Object)TIME_DELIMITERS_STRICT, (Object)"':'") : TuplesKt.to((Object)DELIMITERS_NON_STRICT, (Object)"punctuation character")));
        TokenSet timeDelimiters = (TokenSet)pair.component1();
        String delimiterMessage = (String)pair.component2();
        LighterASTNode lighterASTNode = $this_parser.getBuilder().getLatestDoneMarker();
        return (Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)SqlDtCompositeElementType.Companion.getDAY_OF_TIME()) || $this_parser.maybe((IElementType)SqlDtToken.MINUS)) && $this_parser.maybe(isOptionalHour, arg_0 -> MysqlDateTimeLanguageHelper.createParser$lambda$0$parseTimeBase$4(timeDelimiters, arg_0)) && $this_parser.maybe(!isOdbc, arg_0 -> MysqlDateTimeLanguageHelper.createParser$lambda$0$parseTimeBase$5(timeDelimiters, isOdbc, delimiterMessage, $root, $this_parser, hostType, arg_0));
    }

    private static final boolean createParser$lambda$0$parseTime(ParseContext $this_parser, IElementType $root, IElementType hostType, boolean isOdbc) {
        return ParseContext.maybe$default((ParseContext)$this_parser, (boolean)false, arg_0 -> MysqlDateTimeLanguageHelper.createParser$lambda$0$parseTime$6($root, arg_0), (int)1, null) && MysqlDateTimeLanguageHelper.createParser$lambda$0$parseTimeBase(hostType, $this_parser, isOdbc, $root, true);
    }

    private static final boolean createParser$lambda$0$parseDateTimeDelimiter(IElementType hostType, ParseContext $this_parser) {
        if (Intrinsics.areEqual((Object)hostType, (Object)SqlCompositeElementTypes.ODBC_TIMESTAMP)) {
            return $this_parser.singleSpace();
        }
        int tokenCount = 0;
        boolean isError = false;
        PsiBuilder.Marker marker = $this_parser.getBuilder().mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        while (DATE_TIME_DELIMITERS.contains($this_parser.getBuilder().getTokenType())) {
            if (Intrinsics.areEqual((Object)$this_parser.getBuilder().getTokenType(), (Object)SqlDtToken.IDENTIFIER)) {
                isError = !Intrinsics.areEqual((Object)$this_parser.getBuilder().getTokenText(), (Object)"T");
            }
            ++tokenCount;
            $this_parser.getBuilder().advanceLexer();
        }
        boolean bl = isError = isError || tokenCount != 1;
        if (isError) {
            marker2.error(SqlBundle.message((String)"parsing.error.t.or.space.expected", (Object[])new Object[0]));
        } else {
            marker2.drop();
        }
        return true;
    }

    private static final boolean createParser$lambda$0$parseTimestamp(boolean isOdbc, ParseContext $this_parser, IElementType hostType, IElementType $root) {
        return MysqlDateTimeLanguageHelper.createParser$lambda$0$parseDate(isOdbc, $this_parser, hostType) && MysqlDateTimeLanguageHelper.createParser$lambda$0$parseDateTimeDelimiter(hostType, $this_parser) && MysqlDateTimeLanguageHelper.createParser$lambda$0$parseTimeBase(hostType, $this_parser, isOdbc, $root, false);
    }

    private static final SqlDtCompositeElementType createParser$lambda$0$7(ParseContext $this$parseConcatenatedValue, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$parseConcatenatedValue, (String)"$this$parseConcatenatedValue");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SqlDtCompositeElementType.Companion.getCONCATENATED_VALUE();
    }

    private static final SqlDtCompositeElementType createParser$lambda$0$8(ParseContext $this$parseConcatenatedValue, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$parseConcatenatedValue, (String)"$this$parseConcatenatedValue");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.length() <= 2 ? SqlDtCompositeElementType.Companion.getSECOND() : SqlDtCompositeElementType.Companion.getCONCATENATED_VALUE();
    }

    private static final SqlDtCompositeElementType createParser$lambda$0$9(ParseContext $this$parseConcatenatedValue, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$parseConcatenatedValue, (String)"$this$parseConcatenatedValue");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SqlDtCompositeElementType.Companion.getCONCATENATED_VALUE();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createParser$lambda$0(PsiLanguageInjectionHost $host, ParseContext $this$parser, IElementType root) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$parser, (String)"$this$parser");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        PsiElement psiElement = $host.getParent();
        IElementType hostType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
        boolean isOdbc = SqlCompositeElementTypes.ODBC_DATE_TIME_TYPES.contains(hostType);
        if (!$this$parser.consumeSpaces()) return false;
        IElementType iElementType = root;
        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getDATE())) {
            if (isOdbc || !MysqlDateTimeLanguageHelper.createParser$lambda$0$parseConcatenatedValue($this$parser, (Function2<? super ParseContext, ? super String, SqlDtCompositeElementType>)((Function2)MysqlDateTimeLanguageHelper::createParser$lambda$0$7))) {
                if (!MysqlDateTimeLanguageHelper.createParser$lambda$0$parseDate(isOdbc, $this$parser, hostType)) return false;
            }
            bl = true;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getTIME()) || Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getDURATION())) {
            if (isOdbc || !$this$parser.maybe((IElementType)SqlDtToken.MINUS) || !MysqlDateTimeLanguageHelper.createParser$lambda$0$parseConcatenatedValue($this$parser, (Function2<? super ParseContext, ? super String, SqlDtCompositeElementType>)((Function2)MysqlDateTimeLanguageHelper::createParser$lambda$0$8)) || !MysqlDateTimeLanguageHelper.createParser$lambda$0$parseFractionalPart($this$parser, hostType)) {
                if (!MysqlDateTimeLanguageHelper.createParser$lambda$0$parseTime($this$parser, root, hostType, isOdbc)) return false;
            }
            bl = true;
        } else {
            if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getTIMESTAMP())) return false;
            if (isOdbc || !MysqlDateTimeLanguageHelper.createParser$lambda$0$parseConcatenatedValue($this$parser, (Function2<? super ParseContext, ? super String, SqlDtCompositeElementType>)((Function2)MysqlDateTimeLanguageHelper::createParser$lambda$0$9)) || !MysqlDateTimeLanguageHelper.createParser$lambda$0$parseFractionalPart($this$parser, hostType)) {
                if (!MysqlDateTimeLanguageHelper.createParser$lambda$0$parseTimestamp(isOdbc, $this$parser, hostType, root)) return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (!$this$parser.consumeSpaces()) return false;
        return true;
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{SqlDtToken.SIGNIFICANT_WHITE_SPACE, SqlDtToken.IDENTIFIER};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        DATE_TIME_DELIMITERS = tokenSet;
        iElementTypeArray = new IElementType[]{SqlDtToken.PLUS, SqlDtToken.MINUS, SqlDtToken.COLON, SqlDtToken.DOT, SqlDtToken.GENERIC_DELIMITER};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        DELIMITERS_NON_STRICT = tokenSet2;
        iElementTypeArray = new IElementType[]{SqlDtToken.MINUS};
        TokenSet tokenSet3 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"create(...)");
        DATE_DELIMITERS_STRICT = tokenSet3;
        iElementTypeArray = new IElementType[]{SqlDtToken.COLON};
        TokenSet tokenSet4 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"create(...)");
        TIME_DELIMITERS_STRICT = tokenSet4;
        iElementTypeArray = new IElementType[]{SqlDtToken.COLON, SqlDtToken.DOT};
        TokenSet tokenSet5 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet5, (String)"create(...)");
        ODBC_TIME_DELIMITERS = tokenSet5;
    }
}

