/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigKeyParts {
    public static final char CONFIG_KEY_SEPARATOR = '.';
    private static final CharFilter KEY_INDEX_CHAR_FILTER = ch -> Character.isLetterOrDigit(ch) || ch == '-';
    private final String myConfigKey;
    private final String myKeyIndex;
    private final String myKeyProperty;

    private ConfigKeyParts(@NotNull String configKey, @Nullable String keyIndex, @Nullable String keyProperty) {
        if (configKey == null) {
            ConfigKeyParts.$$$reportNull$$$0(0);
        }
        this.myConfigKey = configKey;
        this.myKeyIndex = keyIndex;
        this.myKeyProperty = keyProperty;
    }

    @NotNull
    public String getConfigKey() {
        String string = this.myConfigKey;
        if (string == null) {
            ConfigKeyParts.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getKeyIndex() {
        return this.myKeyIndex;
    }

    @Nullable
    public String getKeyProperty() {
        return this.myKeyProperty;
    }

    public boolean matchesKeyName(@NotNull String keyName, @NotNull BiPredicate<String, String> matcher) {
        if (keyName == null) {
            ConfigKeyParts.$$$reportNull$$$0(2);
        }
        if (matcher == null) {
            ConfigKeyParts.$$$reportNull$$$0(3);
        }
        return matcher.test(keyName, this.myConfigKey);
    }

    @Nullable
    public String getKeyIndexIfMatches(@NotNull String keyName, @Nullable String keyProperty, @NotNull BiPredicate<String, String> matcher) {
        if (keyName == null) {
            ConfigKeyParts.$$$reportNull$$$0(4);
        }
        if (matcher == null) {
            ConfigKeyParts.$$$reportNull$$$0(5);
        }
        if (this.myKeyIndex != null && this.matchesKeyName(keyName, matcher) && (keyProperty == null || this.myKeyProperty != null && matcher.test(keyProperty, this.myKeyProperty))) {
            return this.myKeyIndex;
        }
        return null;
    }

    @Nullable
    public static ConfigKeyParts splitToParts(@NotNull MetaConfigKey key, @NotNull String configKeyText, boolean filterKeyIndex) {
        if (key == null) {
            ConfigKeyParts.$$$reportNull$$$0(6);
        }
        if (configKeyText == null) {
            ConfigKeyParts.$$$reportNull$$$0(7);
        }
        return ConfigKeyParts.splitToParts(key.getName(), configKeyText, filterKeyIndex);
    }

    @Nullable
    public static ConfigKeyParts splitToParts(@NotNull String keyName, @NotNull String configKeyText, boolean filterKeyIndex) {
        String keyIndex;
        int propertySeparatorIndex;
        if (keyName == null) {
            ConfigKeyParts.$$$reportNull$$$0(8);
        }
        if (configKeyText == null) {
            ConfigKeyParts.$$$reportNull$$$0(9);
        }
        if (configKeyText.isEmpty() || configKeyText.equals(".")) {
            return null;
        }
        int keyNameSeparatorsCount = StringUtil.countChars((CharSequence)keyName, (char)'.');
        int separatorIndex = -1;
        for (int i = 0; i < keyNameSeparatorsCount; ++i) {
            if ((separatorIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)'.', (int)(separatorIndex + 1))) >= 0) continue;
            return null;
        }
        int keySeparatorIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)'.', (int)(separatorIndex + 1));
        int bracketIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)'[', (int)(separatorIndex + 1));
        if (keySeparatorIndex < 0 || bracketIndex >= 0 && bracketIndex < keySeparatorIndex) {
            keySeparatorIndex = bracketIndex;
        }
        if (keySeparatorIndex < 0) {
            return new ConfigKeyParts(configKeyText, null, null);
        }
        String keyNamePrefix = configKeyText.substring(0, keySeparatorIndex);
        Character indexEndingSeparator = null;
        if (configKeyText.charAt(keySeparatorIndex) == '.' && keySeparatorIndex != configKeyText.length() - 1) {
            char indexSeparatorChar = configKeyText.charAt(keySeparatorIndex + 1);
            if (indexSeparatorChar == '[') {
                indexEndingSeparator = Character.valueOf(']');
                ++keySeparatorIndex;
            } else if (indexSeparatorChar == '\"') {
                indexEndingSeparator = Character.valueOf('\"');
                ++keySeparatorIndex;
            }
        }
        if (keySeparatorIndex == configKeyText.length() - 1) {
            return new ConfigKeyParts(keyNamePrefix, null, null);
        }
        if (indexEndingSeparator == null && configKeyText.charAt(keySeparatorIndex) == '[') {
            indexEndingSeparator = Character.valueOf(']');
        }
        if (indexEndingSeparator != null) {
            propertySeparatorIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)indexEndingSeparator.charValue(), (int)(keySeparatorIndex + 1));
            String string = keyIndex = propertySeparatorIndex >= 0 ? configKeyText.substring(keySeparatorIndex + 1, propertySeparatorIndex) : configKeyText.substring(keySeparatorIndex + 1);
            if (propertySeparatorIndex >= 0 && propertySeparatorIndex != configKeyText.length() - 1 && configKeyText.charAt(propertySeparatorIndex + 1) == '.') {
                ++propertySeparatorIndex;
            }
        } else {
            propertySeparatorIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)'.', (int)(keySeparatorIndex + 1));
            String string = keyIndex = propertySeparatorIndex >= 0 ? configKeyText.substring(keySeparatorIndex + 1, propertySeparatorIndex) : configKeyText.substring(keySeparatorIndex + 1);
            if (filterKeyIndex && !StringUtil.isLatinAlphanumeric((CharSequence)keyIndex)) {
                keyIndex = StringUtil.strip((String)keyIndex, (CharFilter)KEY_INDEX_CHAR_FILTER);
            }
        }
        String keyProperty = propertySeparatorIndex < 0 || propertySeparatorIndex == configKeyText.length() - 1 ? null : configKeyText.substring(propertySeparatorIndex + 1);
        return new ConfigKeyParts(keyNamePrefix, keyIndex, keyProperty);
    }

    @NotNull
    public static List<String> joinArbitraryKeyParts(@NotNull List<String> keyParts) {
        if (keyParts == null) {
            ConfigKeyParts.$$$reportNull$$$0(10);
        }
        if (keyParts.isEmpty() || keyParts.size() == 1) {
            List<String> list = keyParts;
            if (list == null) {
                ConfigKeyParts.$$$reportNull$$$0(11);
            }
            return list;
        }
        LinkedList<String> result = new LinkedList<String>();
        int i = 0;
        while (i < keyParts.size()) {
            String current = keyParts.get(i);
            String next = null;
            if (i + 1 < keyParts.size()) {
                next = keyParts.get(i + 1);
            }
            if (next != null && next.startsWith("[")) {
                result.add(String.format("%s.%s", current, next));
                i += 2;
                continue;
            }
            result.add(current);
            ++i;
        }
        LinkedList<String> linkedList = result;
        if (linkedList == null) {
            ConfigKeyParts.$$$reportNull$$$0(12);
        }
        return linkedList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 1: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/ConfigKeyParts";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKeyText";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/ConfigKeyParts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigKey";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "joinArbitraryKeyParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matchesKeyName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKeyIndexIfMatches";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "splitToParts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "joinArbitraryKeyParts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 11, 12 -> new IllegalStateException(string);
        };
    }
}

