/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.cron;

import com.intellij.cron.CronDefinitionExpressionProvider;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.Property;
import com.intellij.microservices.jvm.cron.PropertyReferenceCronUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/microservices/jvm/cron/PropertyReferenceCronExpressionProvider;", "Lcom/intellij/cron/CronDefinitionExpressionProvider;", "<init>", "()V", "languages", "", "Lcom/intellij/lang/Language;", "getLanguages", "()Ljava/util/Collection;", "supportId", "", "getSupportId", "()Ljava/lang/String;", "isSuitableElement", "", "element", "Lcom/intellij/psi/PsiElement;", "hasPropertyReference", "value", "getCronExpression", "intellij.microservices.jvm.cron"})
@SourceDebugExtension(value={"SMAP\nPropertyReferenceCronExpressionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyReferenceCronExpressionProvider.kt\ncom/intellij/microservices/jvm/cron/PropertyReferenceCronExpressionProvider\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n18#2:40\n18#2:41\n1#3:42\n*S KotlinDebug\n*F\n+ 1 PropertyReferenceCronExpressionProvider.kt\ncom/intellij/microservices/jvm/cron/PropertyReferenceCronExpressionProvider\n*L\n20#1:40\n34#1:41\n*E\n"})
public abstract class PropertyReferenceCronExpressionProvider
implements CronDefinitionExpressionProvider {
    @NotNull
    public Collection<Language> getLanguages() {
        return CollectionsKt.listOf((Object)PropertiesLanguage.INSTANCE);
    }

    @NotNull
    public String getSupportId() {
        return "Properties";
    }

    public boolean isSuitableElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$asSafely$iv = element;
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof Property)) {
            psiElement = null;
        }
        Property property = (Property)psiElement;
        if (property == null) {
            return false;
        }
        Property property2 = property;
        String string = property2.getKey();
        if (string == null) {
            return false;
        }
        String key = string;
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        if (this.hasPropertyReference(property2.getValue())) {
            return false;
        }
        return PropertyReferenceCronUtilsKt.isCronReferenceValue(module2, key);
    }

    private final boolean hasPropertyReference(String value) {
        if (value == null) {
            return false;
        }
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)value, (String)"${", (String)"}");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPlaceholderRanges(...)");
        Set propertyPlaceholderRange = set;
        return !((Collection)propertyPlaceholderRange).isEmpty();
    }

    @Nullable
    public String getCronExpression(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$asSafely$iv = element;
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof Property)) {
            psiElement = null;
        }
        Property property = (Property)psiElement;
        if (property == null) {
            return null;
        }
        Property property2 = property;
        String string2 = property2.getValue();
        if (string2 == null) {
            return null;
        }
        String value = string2;
        if (this.hasPropertyReference(value)) {
            return null;
        }
        String it = string = ((Object)StringsKt.trim((CharSequence)value)).toString();
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)it) ? string : null;
    }
}

