/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.gutter;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0015"}, d2={"findModuleForElement", "Lcom/intellij/openapi/module/Module;", "psiElement", "Lcom/intellij/psi/PsiElement;", "isDumb", "", "findModuleForElementWhenDumb", "findModuleForFileWhenDumb", "psiFile", "Lcom/intellij/psi/PsiFile;", "isAnnotatedInDumbMode", "uDeclaration", "Lorg/jetbrains/uast/UDeclaration;", "annotations", "", "", "getAnnotationNameDumb", "uAnnotation", "Lorg/jetbrains/uast/UAnnotation;", "getUParentForIdentifierDumbAware", "Lorg/jetbrains/uast/UElement;", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nDumbAwareLineMarkerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumbAwareLineMarkerUtils.kt\ncom/intellij/microservices/jvm/gutter/DumbAwareLineMarkerUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1807#2,3:74\n*S KotlinDebug\n*F\n+ 1 DumbAwareLineMarkerUtils.kt\ncom/intellij/microservices/jvm/gutter/DumbAwareLineMarkerUtilsKt\n*L\n41#1:74,3\n*E\n"})
public final class DumbAwareLineMarkerUtilsKt {
    @Nullable
    public static final Module findModuleForElement(@Nullable PsiElement psiElement, boolean isDumb) {
        if (psiElement == null) {
            return null;
        }
        if (isDumb) {
            return DumbAwareLineMarkerUtilsKt.findModuleForElementWhenDumb(psiElement);
        }
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
    }

    @Nullable
    public static final Module findModuleForElementWhenDumb(@Nullable PsiElement psiElement) {
        Module module;
        if (psiElement == null) {
            return null;
        }
        try {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            module = null;
        }
        return module;
    }

    @Nullable
    public static final Module findModuleForFileWhenDumb(@NotNull PsiFile psiFile) {
        Module module;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        try {
            module = ModuleUtilCore.findModuleForFile((PsiFile)psiFile);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            module = null;
        }
        return module;
    }

    public static final boolean isAnnotatedInDumbMode(@NotNull UDeclaration uDeclaration, @NotNull Collection<String> annotations) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uDeclaration, (String)"uDeclaration");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        try {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = uDeclaration.getUAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UAnnotation uAnnotation = (UAnnotation)element$iv;
                        boolean bl3 = false;
                        String name = DumbAwareLineMarkerUtilsKt.getAnnotationNameDumb(uAnnotation);
                        if (!CollectionsKt.contains((Iterable)annotations, (Object)name)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (IndexNotReadyException indexNotReadyException) {
            bl = false;
        }
        return bl;
    }

    private static final String getAnnotationNameDumb(UAnnotation uAnnotation) {
        String string;
        try {
            UIdentifier uIdentifier = uAnnotation.getUastAnchor();
            string = uIdentifier != null ? uIdentifier.getName() : null;
        }
        catch (IndexNotReadyException indexNotReadyException) {
            Object object = uAnnotation.getSourcePsi();
            string = object != null && (object = object.getText()) != null && (object = StringsKt.removePrefix((String)object, (CharSequence)"@")) != null ? StringsKt.substringAfterLast$default((String)object, (char)'.', null, (int)2, null) : null;
        }
        return string;
    }

    @Nullable
    public static final UElement getUParentForIdentifierDumbAware(@NotNull PsiElement psiElement, boolean isDumb) {
        UElement uElement;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        try {
            uElement = UastUtils.getUParentForIdentifier((PsiElement)psiElement);
        }
        catch (IndexNotReadyException e) {
            if (!isDumb) {
                throw e;
            }
            uElement = null;
        }
        return uElement;
    }
}

