/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.inject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.microservices.jvm.inject.InjectionGeneratorContext;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\u000bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c2\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c2\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/microservices/jvm/inject/GeneratorAction;", "", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "target", "Lcom/intellij/psi/PsiElement;", "additionalActions", "", "<init>", "(Lcom/intellij/codeInsight/intention/IntentionAction;Lcom/intellij/psi/PsiElement;Ljava/util/Collection;)V", "isValid", "", "context", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorContext;", "invoke", "", "startInWriteAction", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nInjectionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectionUtils.kt\ncom/intellij/microservices/jvm/inject/GeneratorAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,419:1\n1915#2,2:420\n*S KotlinDebug\n*F\n+ 1 InjectionUtils.kt\ncom/intellij/microservices/jvm/inject/GeneratorAction\n*L\n162#1:420,2\n*E\n"})
public final class GeneratorAction {
    @NotNull
    private final IntentionAction action;
    @NotNull
    private final PsiElement target;
    @NotNull
    private final Collection<IntentionAction> additionalActions;

    public GeneratorAction(@NotNull IntentionAction action2, @NotNull PsiElement target, @NotNull Collection<? extends IntentionAction> additionalActions) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(additionalActions, (String)"additionalActions");
        this.action = action2;
        this.target = target;
        this.additionalActions = additionalActions;
    }

    public /* synthetic */ GeneratorAction(IntentionAction intentionAction, PsiElement psiElement, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            collection = CollectionsKt.emptyList();
        }
        this(intentionAction, psiElement, collection);
    }

    public final boolean isValid(@NotNull InjectionGeneratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.target.isValid() && this.action.isAvailable(context.getProject(), context.getEditor(), context.getContainingFile());
    }

    public final void invoke(@NotNull InjectionGeneratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.action.invoke(context.getProject(), context.getEditor(), context.getContainingFile());
        Iterable $this$forEach$iv = this.additionalActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntentionAction it = (IntentionAction)element$iv;
            boolean bl = false;
            it.invoke(context.getProject(), context.getEditor(), context.getContainingFile());
        }
    }

    public final boolean startInWriteAction() {
        return this.action.startInWriteAction();
    }

    private final IntentionAction component1() {
        return this.action;
    }

    private final PsiElement component2() {
        return this.target;
    }

    private final Collection<IntentionAction> component3() {
        return this.additionalActions;
    }

    @NotNull
    public final GeneratorAction copy(@NotNull IntentionAction action2, @NotNull PsiElement target, @NotNull Collection<? extends IntentionAction> additionalActions) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(additionalActions, (String)"additionalActions");
        return new GeneratorAction(action2, target, additionalActions);
    }

    public static /* synthetic */ GeneratorAction copy$default(GeneratorAction generatorAction, IntentionAction intentionAction, PsiElement psiElement, Collection collection, int n, Object object) {
        if ((n & 1) != 0) {
            intentionAction = generatorAction.action;
        }
        if ((n & 2) != 0) {
            psiElement = generatorAction.target;
        }
        if ((n & 4) != 0) {
            collection = generatorAction.additionalActions;
        }
        return generatorAction.copy(intentionAction, psiElement, collection);
    }

    @NotNull
    public String toString() {
        return "GeneratorAction(action=" + this.action + ", target=" + this.target + ", additionalActions=" + this.additionalActions + ")";
    }

    public int hashCode() {
        int result = this.action.hashCode();
        result = result * 31 + this.target.hashCode();
        result = result * 31 + ((Object)this.additionalActions).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeneratorAction)) {
            return false;
        }
        GeneratorAction generatorAction = (GeneratorAction)other;
        if (!Intrinsics.areEqual((Object)this.action, (Object)generatorAction.action)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.target, (Object)generatorAction.target)) {
            return false;
        }
        return Intrinsics.areEqual(this.additionalActions, generatorAction.additionalActions);
    }
}

