/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.InferredAnnotationProvider;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProtobufInferredAnnotationProvider
implements InferredAnnotationProvider {
    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            ProtobufInferredAnnotationProvider.$$$reportNull$$$0(0);
        }
        if (annotationFQN == null) {
            ProtobufInferredAnnotationProvider.$$$reportNull$$$0(1);
        }
        if (!ProtobufInferredAnnotationProvider.isProtobufGetter(listOwner)) {
            return null;
        }
        Project project = listOwner.getProject();
        if (project.isDefault()) {
            return null;
        }
        NullableNotNullManager nullableNotNullManager = NullableNotNullManager.getInstance((Project)project);
        if (!nullableNotNullManager.getDefaultNotNull().equals(annotationFQN)) {
            return null;
        }
        return ProjectBytecodeAnalysis.getInstance(project).getNotNullAnnotation();
    }

    private static boolean isProtobufGetter(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            ProtobufInferredAnnotationProvider.$$$reportNull$$$0(2);
        }
        if (!(listOwner instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)listOwner;
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (method.getReturnType() instanceof PsiPrimitiveType) {
            return false;
        }
        PsiReferenceList extendsList = aClass.getExtendsList();
        if (extendsList == null) {
            return false;
        }
        Object[] types = extendsList.getReferencedTypes();
        return ContainerUtil.exists((Object[])types, t -> TypeUtils.typeEquals("com.google.protobuf.GeneratedMessage", (PsiType)t) || TypeUtils.typeEquals("com.google.protobuf.GeneratedMessageV3", (PsiType)t) || TypeUtils.typeEquals("com.google.protobuf.GeneratedMessageLite", (PsiType)t));
    }

    @NotNull
    public List<PsiAnnotation> findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            ProtobufInferredAnnotationProvider.$$$reportNull$$$0(3);
        }
        if (!ProtobufInferredAnnotationProvider.isProtobufGetter(listOwner)) {
            List<PsiAnnotation> list = Collections.emptyList();
            if (list == null) {
                ProtobufInferredAnnotationProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        Project project = listOwner.getProject();
        if (project.isDefault()) {
            List<PsiAnnotation> list = Collections.emptyList();
            if (list == null) {
                ProtobufInferredAnnotationProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<PsiAnnotation> list = Collections.singletonList(ProjectBytecodeAnalysis.getInstance(project).getNotNullAnnotation());
        if (list == null) {
            ProtobufInferredAnnotationProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ProtobufInferredAnnotationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ProtobufInferredAnnotationProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findInferredAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isProtobufGetter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotations";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

