/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentModCommandFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressFix
extends AbstractBatchSuppressByNoInspectionCommentModCommandFix {
    private String myAlternativeID;

    public SuppressFix(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            SuppressFix.$$$reportNull$$$0(0);
        }
        this(key.getID());
        this.myAlternativeID = HighlightDisplayKey.getAlternativeID((HighlightDisplayKey)key);
    }

    public SuppressFix(@NotNull String ID) {
        if (ID == null) {
            SuppressFix.$$$reportNull$$$0(1);
        }
        super(ID, false);
    }

    @NotNull
    public String getText() {
        String myText = super.getText();
        String string = StringUtil.isEmpty((String)myText) ? JavaAnalysisBundle.message((String)"suppress.inspection.member", (Object[])new Object[0]) : myText;
        if (string == null) {
            SuppressFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public PsiJavaDocumentedElement getContainer(PsiElement context) {
        if (context == null || !BaseIntentionAction.canModify((PsiElement)context)) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (!containingFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) || context instanceof PsiFile) {
            return null;
        }
        PsiElement container = context;
        while (container instanceof PsiAnonymousClass || !(container instanceof PsiJavaDocumentedElement) || container instanceof PsiTypeParameter) {
            if ((container = PsiTreeUtil.getParentOfType((PsiElement)container, PsiJavaDocumentedElement.class)) != null) continue;
            return null;
        }
        return container instanceof SyntheticElement || container instanceof PsiImplicitClass ? null : (PsiJavaDocumentedElement)container;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
        PsiJavaDocumentedElement container;
        boolean isValid;
        if (project == null) {
            SuppressFix.$$$reportNull$$$0(3);
        }
        if (context == null) {
            SuppressFix.$$$reportNull$$$0(4);
        }
        boolean bl = isValid = (container = this.getContainer(context)) != null && (!(container instanceof PsiMethod) || !(container instanceof SyntheticElement));
        if (!isValid) {
            return false;
        }
        if (container instanceof PsiJavaModule) {
            this.setText(JavaAnalysisBundle.message((String)"suppress.inspection.module", (Object[])new Object[0]));
        } else if (container instanceof PsiClass) {
            this.setText(JavaAnalysisBundle.message((String)"suppress.inspection.class", (Object[])new Object[0]));
        } else if (container instanceof PsiMethod) {
            this.setText(JavaAnalysisBundle.message((String)"suppress.inspection.method", (Object[])new Object[0]));
        } else {
            this.setText(JavaAnalysisBundle.message((String)"suppress.inspection.field", (Object[])new Object[0]));
        }
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaDocumentedElement container;
        if (project == null) {
            SuppressFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            SuppressFix.$$$reportNull$$$0(6);
        }
        if ((container = this.getContainer(element)) == null) {
            return;
        }
        this.doSuppress(project, container);
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"suppress.inspection.member", (Object[])new Object[0]);
        if (string == null) {
            SuppressFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doSuppress(@NotNull Project project, @NotNull PsiJavaDocumentedElement container) {
        if (project == null) {
            SuppressFix.$$$reportNull$$$0(8);
        }
        if (container == null) {
            SuppressFix.$$$reportNull$$$0(9);
        }
        if (container instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierOwner = (PsiModifierListOwner)container;
            if (this.use15Suppressions(container)) {
                PsiModifierList modifierList = modifierOwner.getModifierList();
                if (modifierList == null) return;
                JavaSuppressionUtil.addSuppressAnnotation(project, (PsiElement)container, modifierOwner, this.getID((PsiElement)container));
                return;
            }
        }
        this.suppressByDocComment(project, container);
    }

    private void suppressByDocComment(@NotNull Project project, PsiJavaDocumentedElement container) {
        PsiDocComment docComment;
        if (project == null) {
            SuppressFix.$$$reportNull$$$0(10);
        }
        if ((docComment = container.getDocComment()) == null) {
            String commentText = "/** @noinspection " + this.getID((PsiElement)container) + "*/";
            docComment = JavaPsiFacade.getElementFactory((Project)project).createDocCommentFromText(commentText);
            PsiElement firstChild = container.getFirstChild();
            container.addBefore((PsiElement)docComment, firstChild);
        } else {
            PsiDocTag noInspectionTag = docComment.findTagByName("noinspection");
            if (noInspectionTag != null) {
                String tagText = noInspectionTag.getText() + ", " + this.getID((PsiElement)container);
                noInspectionTag.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createDocTagFromText(tagText));
            } else {
                String tagText = "@noinspection " + this.getID((PsiElement)container);
                docComment.add((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createDocTagFromText(tagText));
            }
        }
    }

    protected boolean use15Suppressions(@NotNull PsiJavaDocumentedElement container) {
        if (container == null) {
            SuppressFix.$$$reportNull$$$0(11);
        }
        return JavaSuppressionUtil.canHave15Suppressions((PsiElement)container) && !JavaSuppressionUtil.alreadyHas14Suppressions(container) && !SuppressFix.isInjectedToStringLiteral(container);
    }

    private static boolean isInjectedToStringLiteral(@NotNull PsiJavaDocumentedElement container) {
        if (container == null) {
            SuppressFix.$$$reportNull$$$0(12);
        }
        return JavaResolveUtil.findParentContextOfClass((PsiElement)container, PsiLiteralExpression.class, (boolean)true) != null;
    }

    private String getID(@NotNull PsiElement place) {
        String id;
        if (place == null) {
            SuppressFix.$$$reportNull$$$0(13);
        }
        return (id = SuppressFix.getID(place, this.myAlternativeID)) != null ? id : this.myID;
    }

    @Nullable
    static String getID(@NotNull PsiElement place, String alternativeID) {
        Module module;
        if (place == null) {
            SuppressFix.$$$reportNull$$$0(14);
        }
        if (alternativeID != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)place)) != null && ClassPathStorageUtil.isClasspathStorage((Module)module)) {
            return alternativeID;
        }
        return null;
    }

    public int getPriority() {
        return 40;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/SuppressFix";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/SuppressFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doSuppress";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suppressByDocComment";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "use15Suppressions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInjectedToStringLiteral";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getID";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }
}

