/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.AdaptExpressionTypeFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RemoveNewKeywordFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsConditionalFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeNewOperatorTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeStringLiteralToCharInMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ConstructorParametersFixer;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnFixFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveParenthesisFix;
import com.intellij.codeInsight.daemon.impl.quickfix.PermuteArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifySuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyThisArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveRedundantArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveRepeatingCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceAssignmentFromVoidWithStatementIntentionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceGetClassWithClassLiteralFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceInaccessibleFieldWithGetterSetterFix;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapWithAdapterMethodCallFix;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.PriorityIntentionActionWrapper;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.java.codeserver.core.JavaPatternExhaustivenessUtil;
import com.intellij.java.codeserver.core.JavaPsiModifierUtil;
import com.intellij.java.codeserver.core.JavaPsiSealedUtil;
import com.intellij.java.codeserver.core.JavaPsiSwitchUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.lang.jvm.util.JvmUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiJvmModifiersOwner;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FieldAccessFixer;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.SwitchUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightFixUtil {
    private static final Logger LOG = Logger.getInstance(HighlightFixUtil.class);
    private static final CallMatcher COLLECTION_TO_ARRAY = CallMatcher.instanceCall("java.util.Collection", "toArray").parameterCount(0);

    static void registerCollectionToArrayFixAction(@NotNull Consumer<? super CommonIntentionAction> info, @Nullable PsiType fromType, @Nullable PsiType toType, @NotNull PsiExpression expression) {
        PsiType arrayComponentType;
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            HighlightFixUtil.$$$reportNull$$$0(1);
        }
        if (toType instanceof PsiArrayType && !((arrayComponentType = ((PsiArrayType)toType).getComponentType()) instanceof PsiPrimitiveType) && !(PsiUtil.resolveClassInType((PsiType)arrayComponentType) instanceof PsiTypeParameter)) {
            PsiType collectionItemType;
            PsiMethodCallExpression call;
            PsiExpression collection = expression;
            if (expression instanceof PsiMethodCallExpression && COLLECTION_TO_ARRAY.test(call = (PsiMethodCallExpression)expression)) {
                collection = call.getMethodExpression().getQualifierExpression();
                if (collection == null) {
                    return;
                }
                fromType = collection.getType();
            }
            if (fromType instanceof PsiClassType && ("java.lang.Object".equals(arrayComponentType.getCanonicalText()) || !((PsiClassType)fromType).isRaw()) && InheritanceUtil.isInheritor((PsiType)fromType, (String)"java.util.Collection") && (collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)fromType, (GlobalSearchScope)expression.getResolveScope())) != null && arrayComponentType.isConvertibleFrom(collectionItemType)) {
                info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createCollectionToArrayFix(collection, expression, (PsiArrayType)toType));
            }
        }
    }

    static void registerAccessQuickFixAction(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiJvmMember refElement, @NotNull PsiJavaCodeReferenceElement place, @Nullable PsiElement fileResolveScope) {
        PsiReferenceExpression ref;
        FieldAccessFixer fixer;
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(2);
        }
        if (refElement == null) {
            HighlightFixUtil.$$$reportNull$$$0(3);
        }
        if (place == null) {
            HighlightFixUtil.$$$reportNull$$$0(4);
        }
        PsiClass accessObjectClass = null;
        PsiElement qualifier = place.getQualifier();
        if (qualifier instanceof PsiExpression) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)((PsiExpression)qualifier)).getElement();
        }
        if (place instanceof PsiReferenceExpression && (fixer = FieldAccessFixer.create(ref = (PsiReferenceExpression)place, (PsiElement)refElement, (PsiElement)place)) != null) {
            info.accept((CommonIntentionAction)new ReplaceInaccessibleFieldWithGetterSetterFix(ref, fixer));
        }
        if (refElement instanceof PsiCompiledElement) {
            return;
        }
        PsiModifierList modifierList = refElement.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiClass packageLocalClassInTheMiddle = JavaPsiModifierUtil.getPackageLocalClassInTheMiddle((PsiElement)place);
        if (packageLocalClassInTheMiddle != null) {
            List fixes = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)packageLocalClassInTheMiddle, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.PUBLIC, (boolean)true));
            fixes.forEach(info);
            return;
        }
        try {
            PsiClass containingClass;
            Project project = refElement.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiModifierList modifierListCopy = facade.getElementFactory().createFieldFromText("int a;", null).getModifierList();
            assert (modifierListCopy != null);
            modifierListCopy.setModifierProperty("static", modifierList.hasModifierProperty("static"));
            int minAccessLevel = 2;
            if (refElement.hasModifierProperty("packageLocal")) {
                minAccessLevel = 3;
            }
            if (refElement.hasModifierProperty("protected")) {
                minAccessLevel = 4;
            }
            if ((containingClass = refElement.getContainingClass()) != null && containingClass.isInterface()) {
                minAccessLevel = 4;
            }
            int[] accessLevels = new int[]{2, 3, 4};
            for (int i = ArrayUtil.indexOf((int[])accessLevels, (int)minAccessLevel); i < accessLevels.length; ++i) {
                int level = accessLevels[i];
                modifierListCopy.setModifierProperty(PsiUtil.getAccessModifier((int)level), true);
                if (!facade.getResolveHelper().isAccessible((PsiMember)refElement, modifierListCopy, (PsiElement)place, accessObjectClass, fileResolveScope)) continue;
                List fixes = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)refElement, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmUtil.getAccessModifier((int)level), (boolean)true));
                fixes.forEach(info);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    static void registerChangeVariableTypeFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiExpression expression, @NotNull PsiType type) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            HighlightFixUtil.$$$reportNull$$$0(6);
        }
        if (type == null) {
            HighlightFixUtil.$$$reportNull$$$0(7);
        }
        if (!(expression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)expression;
        PsiElement psiElement = ref.resolve();
        if (!(psiElement instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable = (PsiVariable)psiElement;
        HighlightFixUtil.registerChangeVariableTypeFixes(info, variable, type);
    }

    static void registerUnhandledExceptionFixes(@NotNull PsiElement element, @NotNull Consumer<? super CommonIntentionAction> info) {
        if (element == null) {
            HighlightFixUtil.$$$reportNull$$$0(8);
        }
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(9);
        }
        QuickFixFactory quickFixFactory = QuickFixFactory.getInstance();
        info.accept((CommonIntentionAction)quickFixFactory.createAddExceptionFromFieldInitializerToConstructorThrowsFix(element));
        info.accept((CommonIntentionAction)quickFixFactory.createAddExceptionToCatchFix());
        info.accept((CommonIntentionAction)quickFixFactory.createAddExceptionToExistingCatch(element));
        info.accept((CommonIntentionAction)quickFixFactory.createAddExceptionToThrowsFix(element));
        info.accept((CommonIntentionAction)quickFixFactory.createSurroundWithTryCatchFix(element));
    }

    static void registerStaticProblemQuickFixAction(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiElement refElement, @NotNull PsiJavaCodeReferenceElement place) {
        PsiModifierListOwner staticParent;
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(10);
        }
        if (refElement == null) {
            HighlightFixUtil.$$$reportNull$$$0(11);
        }
        if (place == null) {
            HighlightFixUtil.$$$reportNull$$$0(12);
        }
        if (place instanceof PsiReferenceExpression && place.getParent() instanceof PsiMethodCallExpression) {
            ReplaceGetClassWithClassLiteralFix.registerFix((PsiMethodCallExpression)place.getParent(), info);
        }
        if (refElement instanceof PsiJvmModifiersOwner && !(refElement instanceof PsiParameter)) {
            List fixes = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((PsiJvmModifiersOwner)refElement), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)true));
            fixes.forEach(info);
        }
        if ((staticParent = PsiUtil.getEnclosingStaticElement((PsiElement)place, null)) != null && HighlightFixUtil.isInstanceReference(place)) {
            info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createModifierListFix(staticParent, "static", false, false));
        }
        if (place instanceof PsiReferenceExpression && refElement instanceof PsiField) {
            info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createCreateFieldFromUsageFix((PsiReferenceExpression)place));
        }
    }

    private static boolean isInstanceReference(@NotNull PsiJavaCodeReferenceElement place) {
        PsiElement qualifier;
        if (place == null) {
            HighlightFixUtil.$$$reportNull$$$0(13);
        }
        if ((qualifier = place.getQualifier()) == null) {
            return true;
        }
        if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiElement q = ((PsiReference)qualifier).resolve();
        if (q instanceof PsiClass) {
            return false;
        }
        if (q != null) {
            return true;
        }
        String qname = ((PsiJavaCodeReferenceElement)qualifier).getQualifiedName();
        return qname == null || !Character.isLowerCase(qname.charAt(0));
    }

    static void registerChangeVariableTypeFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiVariable parameter, @Nullable PsiType itemType) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(14);
        }
        if (parameter == null) {
            HighlightFixUtil.$$$reportNull$$$0(15);
        }
        for (IntentionAction action : HighlightFixUtil.getChangeVariableTypeFixes(parameter, itemType)) {
            info.accept((CommonIntentionAction)action);
        }
    }

    @Nullable
    static IntentionAction createChangeReturnTypeFix(@Nullable PsiExpression expr, @NotNull PsiType toType) {
        PsiMethodCallExpression call;
        PsiMethod method;
        if (toType == null) {
            HighlightFixUtil.$$$reportNull$$$0(16);
        }
        if (expr instanceof PsiMethodCallExpression && (method = (call = (PsiMethodCallExpression)expr).resolveMethod()) != null) {
            return PriorityIntentionActionWrapper.lowPriority((IntentionAction)QuickFixFactory.getInstance().createMethodReturnFix(method, toType, true));
        }
        return null;
    }

    @NotNull
    public static List<IntentionAction> getChangeVariableTypeFixes(@NotNull PsiVariable variable, @Nullable PsiType itemType) {
        PsiClassType boxedType;
        PsiType componentType;
        PsiType type;
        if (variable == null) {
            HighlightFixUtil.$$$reportNull$$$0(17);
        }
        if (itemType instanceof PsiMethodReferenceType) {
            List<IntentionAction> list = Collections.emptyList();
            if (list == null) {
                HighlightFixUtil.$$$reportNull$$$0(18);
            }
            return list;
        }
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        if (itemType != null && PsiTypesUtil.allTypeParametersResolved((PsiElement)variable, (PsiType)itemType)) {
            for (ChangeVariableTypeQuickFixProvider fixProvider : ChangeVariableTypeQuickFixProvider.EP_NAME.getExtensionList()) {
                Collections.addAll(result, fixProvider.getFixes(variable, itemType));
            }
            IntentionAction changeFix = HighlightFixUtil.getChangeParameterClassFix(variable.getType(), itemType);
            if (changeFix != null) {
                result.add(changeFix);
            }
        } else if (itemType instanceof PsiArrayType && (type = variable.getType()) instanceof PsiArrayType && type.getArrayDimensions() == itemType.getArrayDimensions() && (componentType = type.getDeepComponentType()) instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)componentType).getBoxedType((PsiElement)variable)) != null) {
            return HighlightFixUtil.getChangeVariableTypeFixes(variable, PsiTypesUtil.createArrayType((PsiType)boxedType, (int)type.getArrayDimensions()));
        }
        ArrayList<IntentionAction> arrayList = result;
        if (arrayList == null) {
            HighlightFixUtil.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Nullable
    private static IntentionAction getChangeParameterClassFix(@NotNull PsiType lType, @NotNull PsiType rType) {
        if (lType == null) {
            HighlightFixUtil.$$$reportNull$$$0(20);
        }
        if (rType == null) {
            HighlightFixUtil.$$$reportNull$$$0(21);
        }
        PsiClass lClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)lType);
        PsiClass rClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)rType);
        if (rClass == null || lClass == null) {
            return null;
        }
        if (rClass instanceof PsiAnonymousClass) {
            return null;
        }
        if (rClass.isInheritor(lClass, true)) {
            return null;
        }
        if (lClass.isInheritor(rClass, true)) {
            return null;
        }
        if (lClass == rClass) {
            return null;
        }
        return QuickFixFactory.getInstance().createChangeParameterClassFix(rClass, (PsiClassType)lType);
    }

    static void registerLambdaReturnTypeFixes(@NotNull Consumer<? super CommonIntentionAction> info, PsiLambdaExpression lambda, PsiExpression expression) {
        PsiType type;
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(22);
        }
        if ((type = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda)) != null) {
            AdaptExpressionTypeFixUtil.registerExpectedTypeFixes(info, expression, type);
        }
    }

    static void registerChangeParameterClassFix(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiType lType, @Nullable PsiType rType) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(23);
        }
        if (lType == null) {
            HighlightFixUtil.$$$reportNull$$$0(24);
        }
        if (rType == null) {
            return;
        }
        IntentionAction action = HighlightFixUtil.getChangeParameterClassFix(lType, rType);
        if (action != null) {
            info.accept((CommonIntentionAction)action);
        }
    }

    @Nullable
    private static PsiSwitchStatement findInitializingSwitch(@NotNull PsiVariable variable, @NotNull PsiElement topBlock, @NotNull PsiElement readPoint) {
        ControlFlow controlFlow;
        if (variable == null) {
            HighlightFixUtil.$$$reportNull$$$0(25);
        }
        if (topBlock == null) {
            HighlightFixUtil.$$$reportNull$$$0(26);
        }
        if (readPoint == null) {
            HighlightFixUtil.$$$reportNull$$$0(27);
        }
        PsiSwitchStatement switchForAll = null;
        for (PsiReferenceExpression reference : VariableAccessUtils.getVariableReferences(variable, topBlock)) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)reference)) continue;
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiSwitchStatement.class);
            if (switchStatement == null || !PsiTreeUtil.isAncestor((PsiElement)topBlock, (PsiElement)switchStatement, (boolean)true)) {
                return null;
            }
            if (switchForAll != null) {
                if (switchForAll == switchStatement) continue;
                return null;
            }
            switchForAll = switchStatement;
        }
        if (switchForAll == null) {
            return null;
        }
        if (SwitchUtils.calculateBranchCount(switchForAll) < 0) {
            return null;
        }
        List labels = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)switchForAll.getBody(), PsiSwitchLabelStatementBase.class);
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        try {
            controlFlow = ControlFlowFactory.getInstance((Project)topBlock.getProject()).getControlFlow(topBlock, (ControlFlowPolicy)policy);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        int switchOffset = controlFlow.getStartOffset((PsiElement)switchForAll);
        int readOffset = controlFlow.getStartOffset(readPoint);
        if (switchOffset == -1 || readOffset == -1 || !ControlFlowUtil.isDominator((ControlFlow)controlFlow, (int)switchOffset, (int)readOffset)) {
            return null;
        }
        boolean[] offsets = ControlFlowUtil.getVariablePossiblyUnassignedOffsets((PsiVariable)variable, (ControlFlow)controlFlow);
        for (PsiSwitchLabelStatementBase label : labels) {
            int offset = controlFlow.getStartOffset((PsiElement)label);
            if (offset != -1 && !offsets[offset]) continue;
            return null;
        }
        return switchForAll;
    }

    @Nullable
    static IntentionAction createInsertSwitchDefaultFix(@NotNull PsiVariable variable, @NotNull PsiElement topBlock, @NotNull PsiElement readPoint) {
        PsiSwitchStatement switchStatement;
        if (variable == null) {
            HighlightFixUtil.$$$reportNull$$$0(28);
        }
        if (topBlock == null) {
            HighlightFixUtil.$$$reportNull$$$0(29);
        }
        if (readPoint == null) {
            HighlightFixUtil.$$$reportNull$$$0(30);
        }
        if ((switchStatement = HighlightFixUtil.findInitializingSwitch(variable, topBlock, readPoint)) != null) {
            String message = QuickFixBundle.message("add.default.branch.to.variable.initializing.switch.fix.name", variable.getName());
            return QuickFixFactory.getInstance().createAddSwitchDefaultFix((PsiSwitchBlock)switchStatement, message);
        }
        return null;
    }

    public static void registerFixesForExpressionStatement(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiElement statement) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(31);
        }
        if (statement == null) {
            HighlightFixUtil.$$$reportNull$$$0(32);
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return;
        }
        PsiElement psiElement = statement.getParent();
        if (!(psiElement instanceof PsiCodeBlock)) {
            return;
        }
        PsiCodeBlock block = (PsiCodeBlock)psiElement;
        PsiExpression expression = ((PsiExpressionStatement)statement).getExpression();
        if (expression instanceof PsiAssignmentExpression) {
            return;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return;
        }
        if (!type.equals(PsiTypes.voidType())) {
            PsiMethod method;
            PsiType returnType;
            PsiElement psiElement2;
            info.accept((CommonIntentionAction)PriorityIntentionActionWrapper.highPriority((IntentionAction)QuickFixFactory.getInstance().createIterateFix(expression)));
            if (PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement) == block.getRBrace() && (psiElement2 = block.getParent()) instanceof PsiMethod && (returnType = (method = (PsiMethod)psiElement2).getReturnType()) != null && HighlightFixUtil.isPossibleReturnValue(expression, type, returnType)) {
                info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createInsertReturnFix(expression));
            }
            info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createIntroduceVariableAction(expression));
        }
    }

    private static boolean isPossibleReturnValue(PsiExpression expression, PsiType type, PsiType returnType) {
        if (returnType.isAssignableFrom(type)) {
            return true;
        }
        if (!(type instanceof PsiClassType) || !(returnType instanceof PsiClassType)) {
            return false;
        }
        if (!returnType.isAssignableFrom(TypeConversionUtil.erasure((PsiType)type))) {
            return false;
        }
        PsiExpression copy = (PsiExpression)LambdaUtil.copyWithExpectedType((PsiElement)expression, (PsiType)returnType);
        PsiType copyType = copy.getType();
        return copyType != null && returnType.isAssignableFrom(copyType);
    }

    static void registerSpecifyVarTypeFix(@NotNull PsiLocalVariable variable, @NotNull Consumer<? super CommonIntentionAction> info) {
        PsiElement block;
        if (variable == null) {
            HighlightFixUtil.$$$reportNull$$$0(33);
        }
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(34);
        }
        if ((block = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null)) == null) {
            return;
        }
        PsiTreeUtil.processElements((PsiElement)block, PsiReferenceExpression.class, ref -> {
            PsiExpression rExpression;
            PsiAssignmentExpression assignment;
            PsiElement patt0$temp;
            if (ref.isReferenceTo((PsiElement)variable) && (patt0$temp = ref.getParent()) instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)patt0$temp).getLExpression() == ref && assignment.getOperationTokenType() == JavaTokenType.EQ && (rExpression = assignment.getRExpression()) != null) {
                PsiType type = rExpression.getType();
                if (type instanceof PsiPrimitiveType) {
                    PsiPrimitiveType primitiveType = (PsiPrimitiveType)type;
                    if (!PsiTypes.voidType().equals((Object)type) && variable.getInitializer() != null) {
                        type = primitiveType.getBoxedType((PsiElement)variable);
                    }
                }
                if (type != null) {
                    if (PsiTypesUtil.isDenotableType((PsiType)(type = GenericsUtil.getVariableTypeByExpressionType((PsiType)type)), (PsiElement)variable) && !PsiTypes.voidType().equals((Object)type)) {
                        info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createSetVariableTypeFix((PsiVariable)variable, type));
                    }
                    return false;
                }
            }
            return true;
        });
    }

    static void registerQualifyMethodCallFix(@NotNull Consumer<? super CommonIntentionAction> info, CandidateInfo @NotNull [] methodCandidates, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList exprList) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(35);
        }
        if (methodCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(36);
        }
        if (exprList == null) {
            HighlightFixUtil.$$$reportNull$$$0(37);
        }
        if (methodCandidates == null) {
            HighlightFixUtil.$$$reportNull$$$0(38);
        }
        if (methodCall.getMethodExpression().getQualifierExpression() != null) {
            return;
        }
        for (CandidateInfo methodCandidate : methodCandidates) {
            PsiExpression qualifier;
            PsiMethod method = (PsiMethod)methodCandidate.getElement();
            if (!methodCandidate.isAccessible() || !PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)methodCandidate.getSubstitutor(), (PsiExpressionList)exprList) || (qualifier = ExpressionUtils.getEffectiveQualifier(methodCall.getMethodExpression(), (PsiMember)method)) == null) continue;
            info.accept((CommonIntentionAction)new QualifyMethodCallFix(methodCall, qualifier.getText()));
        }
    }

    private static void registerStaticMethodQualifierFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiMethodCallExpression methodCall) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(39);
        }
        if (methodCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(40);
        }
        info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createStaticImportMethodFix(methodCall));
        info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createQualifyStaticMethodCallFix(methodCall));
        info.accept((CommonIntentionAction)QuickFixFactory.getInstance().addMethodQualifierFix(methodCall));
    }

    private static void registerUsageFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiMethodCallExpression methodCall) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(41);
        }
        if (methodCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(42);
        }
        QuickFixFactory.getInstance().createCreateMethodFromUsageFixes(methodCall).forEach(info);
    }

    private static void registerThisSuperFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiMethodCallExpression methodCall) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(43);
        }
        if (methodCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(44);
        }
        QuickFixFactory.getInstance().createCreateConstructorFromCallExpressionFixes(methodCall).forEach(info);
    }

    static void registerMethodCallIntentions(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList list) {
        PsiSuperExpression superExpression;
        PsiExpression qualifierExpression;
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(45);
        }
        if (methodCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(46);
        }
        if (list == null) {
            HighlightFixUtil.$$$reportNull$$$0(47);
        }
        if ((qualifierExpression = methodCall.getMethodExpression().getQualifierExpression()) instanceof PsiReferenceExpression) {
            PsiClass psiClass;
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            PsiElement resolve = referenceExpression.resolve();
            if (resolve instanceof PsiClass && (psiClass = (PsiClass)resolve).getContainingClass() != null && !psiClass.hasModifierProperty("static")) {
                List actions = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)psiClass, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)true));
                actions.forEach(info);
            }
        } else if (qualifierExpression instanceof PsiSuperExpression && (superExpression = (PsiSuperExpression)qualifierExpression).getQualifier() == null) {
            QualifySuperArgumentFix.registerQuickFixAction(superExpression, info);
        }
        PsiResolveHelper resolveHelper = PsiResolveHelper.getInstance((Project)methodCall.getProject());
        CandidateInfo[] methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true);
        IntentionAction action2 = QuickFixFactory.getInstance().createSurroundWithArrayFix((PsiCall)methodCall, null);
        info.accept((CommonIntentionAction)action2);
        CastMethodArgumentFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, info);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, info);
        CandidateInfo[] candidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true);
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(candidates, methodCall, info);
        WrapWithAdapterMethodCallFix.registerCastActions(methodCandidates, (PsiCall)methodCall, info);
        IntentionAction action1 = QuickFixFactory.getInstance().createReplaceAddAllArrayToCollectionFix(methodCall);
        info.accept((CommonIntentionAction)action1);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions(methodCandidates, (PsiCall)methodCall, info);
        MethodReturnFixFactory.INSTANCE.registerCastActions(methodCandidates, (PsiCall)methodCall, info);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])methodCandidates, list.getExpressions(), info);
        QualifyThisArgumentFix.registerQuickFixAction(methodCandidates, (PsiCall)methodCall, info);
        HighlightFixUtil.registerMethodAccessLevelIntentions(info, methodCandidates, methodCall, list);
        if (!PermuteArgumentsFix.registerFix(info, (PsiCall)methodCall, methodCandidates) && !MoveParenthesisFix.registerFix(info, (PsiCallExpression)methodCall, methodCandidates)) {
            HighlightFixUtil.registerChangeMethodSignatureFromUsageIntentions(info, (JavaResolveResult[])methodCandidates, list);
        }
        QuickFixFactory.getInstance().getVariableTypeFromCallFixes(methodCall, list).forEach(info);
        if (methodCandidates.length == 0) {
            HighlightFixUtil.registerStaticMethodQualifierFixes(info, methodCall);
        }
        HighlightFixUtil.registerThisSuperFixes(info, methodCall);
        HighlightFixUtil.registerUsageFixes(info, methodCall);
        RemoveRedundantArgumentsFix.registerIntentions((JavaResolveResult[])methodCandidates, list, info);
        info.accept((CommonIntentionAction)RemoveRepeatingCallFix.createFix(methodCall));
        HighlightFixUtil.registerChangeParameterClassFix(info, (PsiCall)methodCall, list);
    }

    private static void registerMethodAccessLevelIntentions(@NotNull Consumer<? super CommonIntentionAction> info, CandidateInfo @NotNull [] methodCandidates, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList exprList) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(48);
        }
        if (methodCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(49);
        }
        if (exprList == null) {
            HighlightFixUtil.$$$reportNull$$$0(50);
        }
        if (methodCandidates == null) {
            HighlightFixUtil.$$$reportNull$$$0(51);
        }
        for (CandidateInfo methodCandidate : methodCandidates) {
            PsiMethod method = (PsiMethod)methodCandidate.getElement();
            if (methodCandidate.isAccessible() || !PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)methodCandidate.getSubstitutor(), (PsiExpressionList)exprList)) continue;
            HighlightFixUtil.registerAccessQuickFixAction(info, (PsiJvmMember)method, (PsiJavaCodeReferenceElement)methodCall.getMethodExpression(), methodCandidate.getCurrentFileResolveScope());
        }
    }

    static void registerChangeParameterClassFix(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiCall methodCall, @NotNull PsiExpressionList list) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(52);
        }
        if (methodCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(53);
        }
        if (list == null) {
            HighlightFixUtil.$$$reportNull$$$0(54);
        }
        JavaResolveResult result = methodCall.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpression[] expressions = list.getExpressions();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != expressions.length) {
            return;
        }
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression = expressions[i];
            PsiParameter parameter = parameters[i];
            PsiType expressionType = expression.getType();
            PsiType parameterType = substitutor.substitute(parameter.getType());
            if (expressionType == null || expressionType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)expressionType) || expressionType instanceof PsiArrayType || parameterType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)parameterType) || parameterType instanceof PsiArrayType || parameterType.isAssignableFrom(expressionType)) continue;
            PsiClass parameterClass = PsiUtil.resolveClassInType((PsiType)parameterType);
            PsiClass expressionClass = PsiUtil.resolveClassInType((PsiType)expressionType);
            if (parameterClass == null || expressionClass == null || expressionClass instanceof PsiAnonymousClass || expressionClass.equals((Object)parameterClass) || expressionClass.isInheritor(parameterClass, true)) continue;
            IntentionAction action = QuickFixFactory.getInstance().createChangeParameterClassFix(expressionClass, (PsiClassType)parameterType);
            info.accept((CommonIntentionAction)action);
        }
    }

    static void registerChangeMethodSignatureFromUsageIntentions(@NotNull Consumer<? super CommonIntentionAction> info, JavaResolveResult @NotNull [] candidates, @NotNull PsiExpressionList list) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(55);
        }
        if (list == null) {
            HighlightFixUtil.$$$reportNull$$$0(56);
        }
        if (candidates == null) {
            HighlightFixUtil.$$$reportNull$$$0(57);
        }
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            HighlightFixUtil.registerChangeMethodSignatureFromUsageIntention(info, expressions, candidate, (PsiElement)list);
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntention(@NotNull Consumer<? super CommonIntentionAction> info, PsiExpression @NotNull [] expressions, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(58);
        }
        if (candidate == null) {
            HighlightFixUtil.$$$reportNull$$$0(59);
        }
        if (context == null) {
            HighlightFixUtil.$$$reportNull$$$0(60);
        }
        if (expressions == null) {
            HighlightFixUtil.$$$reportNull$$$0(61);
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (method != null && context.getManager().isInProject((PsiElement)method)) {
            IntentionAction fix = QuickFixFactory.getInstance().createChangeMethodSignatureFromUsageFix(method, expressions, substitutor, context, false, 2);
            info.accept((CommonIntentionAction)fix);
            IntentionAction f2 = QuickFixFactory.getInstance().createChangeMethodSignatureFromUsageReverseOrderFix(method, expressions, substitutor, context, false, 2);
            info.accept((CommonIntentionAction)f2);
        }
    }

    static void registerMethodReturnFixAction(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull MethodCandidateInfo candidate, @NotNull PsiCall methodCall) {
        PsiMethod containerMethod;
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(62);
        }
        if (candidate == null) {
            HighlightFixUtil.$$$reportNull$$$0(63);
        }
        if (methodCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(64);
        }
        if (candidate.getInferenceErrorMessage() != null && methodCall.getParent() instanceof PsiReturnStatement && (containerMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class})) != null) {
            PsiMethod method = candidate.getElement();
            PsiExpression methodCallCopy = JavaPsiFacade.getElementFactory((Project)method.getProject()).createExpressionFromText(methodCall.getText(), (PsiElement)methodCall);
            PsiType methodCallTypeByArgs = methodCallCopy.getType();
            methodCallTypeByArgs = JavaPsiFacade.getElementFactory((Project)method.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)method).substitute(methodCallTypeByArgs);
            if (methodCallTypeByArgs != null) {
                info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createMethodReturnFix(containerMethod, methodCallTypeByArgs, true));
            }
        }
    }

    static MethodCandidateInfo @NotNull [] toMethodCandidates(JavaResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            HighlightFixUtil.$$$reportNull$$$0(65);
        }
        MethodCandidateInfo[] methodCandidateInfoArray = (MethodCandidateInfo[])Arrays.stream(resolveResults).filter(result -> result instanceof MethodCandidateInfo).map(result -> (MethodCandidateInfo)result).filter(CandidateInfo::isAccessible).toArray(MethodCandidateInfo[]::new);
        if (methodCandidateInfoArray == null) {
            HighlightFixUtil.$$$reportNull$$$0(66);
        }
        return methodCandidateInfoArray;
    }

    static void registerFixesOnInvalidConstructorCall(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiConstructorCall constructorCall, @NotNull PsiClass aClass, JavaResolveResult @NotNull [] results) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(67);
        }
        if (constructorCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(68);
        }
        if (aClass == null) {
            HighlightFixUtil.$$$reportNull$$$0(69);
        }
        if (results == null) {
            HighlightFixUtil.$$$reportNull$$$0(70);
        }
        ConstructorParametersFixer.registerFixActions(constructorCall, info);
        ChangeTypeArgumentsFix.registerIntentions(results, constructorCall, info, aClass);
        PsiMethod[] constructors = aClass.getConstructors();
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(constructors, constructorCall, info);
        IntentionAction action = QuickFixFactory.getInstance().createSurroundWithArrayFix((PsiCall)constructorCall, null);
        info.accept((CommonIntentionAction)action);
        PsiExpressionList list = constructorCall.getArgumentList();
        if (list == null) {
            return;
        }
        if (!PermuteArgumentsFix.registerFix(info, (PsiCall)constructorCall, (CandidateInfo[])HighlightFixUtil.toMethodCandidates(results))) {
            HighlightFixUtil.registerChangeMethodSignatureFromUsageIntentions(info, results, list);
        }
        QuickFixFactory.getInstance().createCreateConstructorFromUsageFixes(constructorCall).forEach(info);
        HighlightFixUtil.registerChangeParameterClassFix(info, (PsiCall)constructorCall, list);
        RemoveRedundantArgumentsFix.registerIntentions(results, list, info);
    }

    static void registerTargetTypeFixesBasedOnApplicabilityInference(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiMethodCallExpression methodCall, @NotNull MethodCandidateInfo resolveResult, @NotNull PsiMethod resolved) {
        PsiType expectedTypeByApplicabilityConstraints;
        PsiType rType;
        PsiReferenceExpression referenceExpression;
        PsiElement resolve;
        PsiAssignmentExpression assignmentExpression;
        PsiExpression lExpression;
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(71);
        }
        if (methodCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(72);
        }
        if (resolveResult == null) {
            HighlightFixUtil.$$$reportNull$$$0(73);
        }
        if (resolved == null) {
            HighlightFixUtil.$$$reportNull$$$0(74);
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
        PsiVariable variable = null;
        if (parent instanceof PsiVariable) {
            variable = (PsiVariable)parent;
        } else if (parent instanceof PsiAssignmentExpression && (lExpression = (assignmentExpression = (PsiAssignmentExpression)parent).getLExpression()) instanceof PsiReferenceExpression && (resolve = (referenceExpression = (PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable) {
            variable = (PsiVariable)resolve;
        }
        if (variable != null && (rType = methodCall.getType()) != null && !variable.getType().isAssignableFrom(rType) && (expectedTypeByApplicabilityConstraints = resolveResult.getSubstitutor(false).substitute(resolved.getReturnType())) != null && !variable.getType().isAssignableFrom(expectedTypeByApplicabilityConstraints) && PsiTypesUtil.allTypeParametersResolved((PsiElement)variable, (PsiType)expectedTypeByApplicabilityConstraints)) {
            HighlightFixUtil.registerChangeVariableTypeFixes(info, variable, expectedTypeByApplicabilityConstraints);
        }
    }

    static void registerCallInferenceFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiMethodCallExpression callExpression) {
        JavaResolveResult result;
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(75);
        }
        if (callExpression == null) {
            HighlightFixUtil.$$$reportNull$$$0(76);
        }
        if (!((result = callExpression.getMethodExpression().advancedResolve(true)) instanceof MethodCandidateInfo)) {
            return;
        }
        MethodCandidateInfo resolveResult = (MethodCandidateInfo)result;
        PsiMethod method = resolveResult.getElement();
        HighlightFixUtil.registerMethodCallIntentions(info, callExpression, callExpression.getArgumentList());
        PsiType actualType = ((PsiExpression)callExpression.copy()).getType();
        if (!PsiTypesUtil.mentionsTypeParameters((PsiType)actualType, Set.of(method.getTypeParameters()))) {
            HighlightFixUtil.registerMethodReturnFixAction(info, resolveResult, (PsiCall)callExpression);
        }
        HighlightFixUtil.registerTargetTypeFixesBasedOnApplicabilityInference(info, callExpression, resolveResult, method);
    }

    static void registerImplementsExtendsFix(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethod resolvedMethod) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(77);
        }
        if (methodCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(78);
        }
        if (resolvedMethod == null) {
            HighlightFixUtil.$$$reportNull$$$0(79);
        }
        if (!JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)methodCall)) {
            return;
        }
        if (!resolvedMethod.isConstructor() || !resolvedMethod.getParameterList().isEmpty()) {
            return;
        }
        PsiClass psiClass = resolvedMethod.getContainingClass();
        if (psiClass == null || !"java.lang.Object".equals(psiClass.getQualifiedName())) {
            return;
        }
        PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)methodCall);
        if (containingClass == null) {
            return;
        }
        PsiReferenceList extendsList = containingClass.getExtendsList();
        if (extendsList != null && extendsList.getReferenceElements().length > 0) {
            return;
        }
        PsiReferenceList implementsList = containingClass.getImplementsList();
        if (implementsList == null) {
            return;
        }
        for (PsiClassType type : implementsList.getReferencedTypes()) {
            PsiClass superInterface = type.resolve();
            if (superInterface == null || superInterface.isInterface()) continue;
            for (PsiMethod constructor : superInterface.getConstructors()) {
                if (constructor.getParameterList().isEmpty()) continue;
                info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createChangeExtendsToImplementsFix(containingClass, type));
            }
        }
    }

    static void registerVariableParameterizedTypeFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiVariable variable, @NotNull PsiReferenceParameterList parameterList) {
        PsiType type;
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(80);
        }
        if (variable == null) {
            HighlightFixUtil.$$$reportNull$$$0(81);
        }
        if (parameterList == null) {
            HighlightFixUtil.$$$reportNull$$$0(82);
        }
        if (!((type = variable.getType()) instanceof PsiClassType)) {
            return;
        }
        PsiClassType classType = (PsiClassType)type;
        if (DumbService.getInstance((Project)variable.getProject()).isDumb()) {
            return;
        }
        String shortName = classType.getClassName();
        PsiFile psiFile = parameterList.getContainingFile();
        Project project = psiFile.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiShortNamesCache shortNamesCache = PsiShortNamesCache.getInstance((Project)project);
        PsiClass[] classes = shortNamesCache.getClassesByName(shortName, GlobalSearchScope.allScope((Project)project));
        PsiElementFactory factory = facade.getElementFactory();
        for (PsiClass aClass : classes) {
            if (aClass == null || !HighlightFixUtil.isPotentiallyCompatible(aClass, parameterList)) continue;
            PsiType[] actualTypeParameters = parameterList.getTypeArguments();
            PsiTypeParameter[] classTypeParameters = aClass.getTypeParameters();
            HashMap<PsiTypeParameter, PsiType> map = new HashMap<PsiTypeParameter, PsiType>();
            for (int j = 0; j < Math.min(classTypeParameters.length, actualTypeParameters.length); ++j) {
                PsiTypeParameter classTypeParameter = classTypeParameters[j];
                PsiType actualTypeParameter = actualTypeParameters[j];
                map.put(classTypeParameter, actualTypeParameter);
            }
            PsiSubstitutor substitutor = factory.createSubstitutor(map);
            PsiClassType suggestedType = factory.createType(aClass, substitutor);
            HighlightFixUtil.registerChangeVariableTypeFixes(info, variable, (PsiType)suggestedType);
        }
    }

    @Nullable
    static PsiType determineReturnType(@NotNull PsiMethod method) {
        if (method == null) {
            HighlightFixUtil.$$$reportNull$$$0(83);
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            PsiManager manager = method.getManager();
            PsiReturnStatement[] returnStatements = PsiUtil.findReturnStatements((PsiMethod)method);
            if (returnStatements.length == 0) {
                return CachedValueProvider.Result.create((Object)PsiTypes.voidType(), (Object[])new Object[]{method});
            }
            PsiType expectedType = null;
            for (PsiReturnStatement returnStatement : returnStatements) {
                ReturnModel returnModel = ReturnModel.create(returnStatement);
                if (returnModel == null) {
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{method});
                }
                expectedType = HighlightFixUtil.lub(expectedType, returnModel.myLeastType, returnModel.myType, method, manager);
            }
            return CachedValueProvider.Result.create(expectedType, (Object[])new Object[]{method});
        });
    }

    @NotNull
    private static PsiType lub(@Nullable PsiType currentType, @NotNull PsiType leastValueType, @NotNull PsiType valueType, @NotNull PsiMethod method, @NotNull PsiManager manager) {
        if (leastValueType == null) {
            HighlightFixUtil.$$$reportNull$$$0(84);
        }
        if (valueType == null) {
            HighlightFixUtil.$$$reportNull$$$0(85);
        }
        if (method == null) {
            HighlightFixUtil.$$$reportNull$$$0(86);
        }
        if (manager == null) {
            HighlightFixUtil.$$$reportNull$$$0(87);
        }
        if (currentType == null || PsiTypes.voidType().equals((Object)currentType)) {
            PsiType psiType = valueType;
            if (psiType == null) {
                HighlightFixUtil.$$$reportNull$$$0(88);
            }
            return psiType;
        }
        if (currentType == valueType) {
            PsiType psiType = currentType;
            if (psiType == null) {
                HighlightFixUtil.$$$reportNull$$$0(89);
            }
            return psiType;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)valueType)) {
            if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)currentType)) {
                int r2;
                int r1 = TypeConversionUtil.getTypeRank((PsiType)currentType);
                PsiType psiType = r1 >= (r2 = TypeConversionUtil.getTypeRank((PsiType)leastValueType)) ? currentType : valueType;
                if (psiType == null) {
                    HighlightFixUtil.$$$reportNull$$$0(90);
                }
                return psiType;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)currentType);
            if (valueType.equals(unboxedType)) {
                PsiType psiType = currentType;
                if (psiType == null) {
                    HighlightFixUtil.$$$reportNull$$$0(91);
                }
                return psiType;
            }
            PsiClassType boxedType = ((PsiPrimitiveType)valueType).getBoxedType((PsiElement)method);
            if (boxedType == null) {
                PsiType psiType = valueType;
                if (psiType == null) {
                    HighlightFixUtil.$$$reportNull$$$0(92);
                }
                return psiType;
            }
            valueType = boxedType;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)currentType)) {
            currentType = ((PsiPrimitiveType)currentType).getBoxedType((PsiElement)method);
        }
        PsiType psiType = Objects.requireNonNullElse(GenericsUtil.getLeastUpperBound((PsiType)currentType, (PsiType)valueType, (PsiManager)manager), Objects.requireNonNullElse(currentType, valueType));
        if (psiType == null) {
            HighlightFixUtil.$$$reportNull$$$0(93);
        }
        return psiType;
    }

    static void registerAmbiguousCallFixes(@NotNull Consumer<? super @Nullable CommonIntentionAction> sink, @NotNull PsiMethodCallExpression methodCall, @NotNull @NotNull JavaResolveResult @NotNull [] resolveResults) {
        if (sink == null) {
            HighlightFixUtil.$$$reportNull$$$0(94);
        }
        if (methodCall == null) {
            HighlightFixUtil.$$$reportNull$$$0(95);
        }
        if (resolveResults == null) {
            HighlightFixUtil.$$$reportNull$$$0(96);
        }
        PsiExpressionList list = methodCall.getArgumentList();
        MethodCandidateInfo[] candidates = HighlightFixUtil.toMethodCandidates(resolveResults);
        WrapWithAdapterMethodCallFix.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, sink);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, sink);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])candidates, list.getExpressions(), sink);
        PermuteArgumentsFix.registerFix(sink, (PsiCall)methodCall, (CandidateInfo[])candidates);
        HighlightFixUtil.registerChangeParameterClassFix(sink, (PsiCall)methodCall, list);
        HighlightFixUtil.registerMethodCallIntentions(sink, methodCall, list);
    }

    static void registerIncompatibleTypeFixes(@NotNull Consumer<? super @Nullable CommonIntentionAction> sink, @NotNull PsiElement anchor, @NotNull PsiType lType, @Nullable PsiType rType) {
        PsiTypeElement typeElement;
        PsiVariable variable;
        PsiElement classReference;
        PsiClass usedClass;
        PsiMethod method;
        PsiElement psiElement;
        if (sink == null) {
            HighlightFixUtil.$$$reportNull$$$0(97);
        }
        if (anchor == null) {
            HighlightFixUtil.$$$reportNull$$$0(98);
        }
        if (lType == null) {
            HighlightFixUtil.$$$reportNull$$$0(99);
        }
        QuickFixFactory factory = QuickFixFactory.getInstance();
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)anchor.getParent());
        if (anchor instanceof PsiJavaCodeReferenceElement && parent instanceof PsiReferenceList && (psiElement = parent.getParent()) instanceof PsiMethod && (method = (PsiMethod)psiElement).getThrowsList() == parent && (usedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)rType)) != null && lType instanceof PsiClassType) {
            PsiClassType throwableType = (PsiClassType)lType;
            sink.accept((CommonIntentionAction)factory.createExtendsListFix(usedClass, throwableType, true));
        }
        if (anchor instanceof PsiExpression) {
            PsiAssignmentExpression assignment;
            PsiVariable var;
            PsiAssignmentExpression assignment2;
            PsiExpression expression = (PsiExpression)anchor;
            AddTypeArgumentsConditionalFix.register(sink, expression, lType);
            AdaptExpressionTypeFixUtil.registerExpectedTypeFixes(sink, expression, lType, rType);
            sink.accept((CommonIntentionAction)ChangeNewOperatorTypeFix.createFix(expression, lType));
            if (PsiTypes.booleanType().equals((Object)lType) && expression instanceof PsiAssignmentExpression && (assignment2 = (PsiAssignmentExpression)expression).getOperationTokenType() == JavaTokenType.EQ) {
                sink.accept((CommonIntentionAction)factory.createAssignmentToComparisonFix(assignment2));
            } else if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression;
                HighlightFixUtil.registerCallInferenceFixes(sink, callExpression);
            }
            if (parent instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression initializerList = (PsiArrayInitializerExpression)parent;
                PsiType sameType = JavaHighlightUtil.sameType(initializerList.getInitializers());
                sink.accept((CommonIntentionAction)(sameType == null ? null : VariableArrayTypeFix.createFix(initializerList, sameType)));
            } else if (parent instanceof PsiConditionalExpression) {
                PsiExpression otherSide;
                PsiConditionalExpression ternary = (PsiConditionalExpression)parent;
                PsiExpression thenExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)ternary.getThenExpression());
                PsiExpression elseExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)ternary.getElseExpression());
                PsiExpression psiExpression = otherSide = elseExpression == expression ? thenExpression : elseExpression;
                if (otherSide != null && !TypeConversionUtil.isVoidType((PsiType)rType)) {
                    if (TypeConversionUtil.isVoidType((PsiType)otherSide.getType())) {
                        HighlightFixUtil.registerIncompatibleTypeFixes(sink, (PsiElement)ternary, lType, rType);
                    } else {
                        PsiExpression expressionCopy = PsiElementFactory.getInstance((Project)expression.getProject()).createExpressionFromText(ternary.getText(), (PsiElement)ternary);
                        PsiType expectedType = expression.getType();
                        PsiType actualType = expressionCopy.getType();
                        if (expectedType != null && actualType != null && !expectedType.isAssignableFrom(actualType)) {
                            HighlightFixUtil.registerIncompatibleTypeFixes(sink, (PsiElement)ternary, expectedType, actualType);
                        }
                    }
                }
            } else if (parent instanceof PsiReturnStatement && rType != null && !PsiTypes.voidType().equals((Object)rType)) {
                PsiElement elseExpression = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                if (elseExpression instanceof PsiMethod) {
                    PsiMethod method2 = (PsiMethod)elseExpression;
                    sink.accept((CommonIntentionAction)factory.createMethodReturnFix(method2, rType, true, true));
                    PsiType expectedType = HighlightFixUtil.determineReturnType(method2);
                    if (expectedType != null && !PsiTypes.voidType().equals((Object)expectedType) && !expectedType.equals(rType)) {
                        sink.accept((CommonIntentionAction)factory.createMethodReturnFix(method2, expectedType, true, true));
                    }
                }
            } else if (parent instanceof PsiVariable && PsiUtil.skipParenthesizedExprDown((PsiExpression)(var = (PsiVariable)parent).getInitializer()) == expression && rType != null) {
                HighlightFixUtil.registerChangeVariableTypeFixes(sink, var, rType);
            } else if (parent instanceof PsiAssignmentExpression && PsiUtil.skipParenthesizedExprDown((PsiExpression)(assignment = (PsiAssignmentExpression)parent).getRExpression()) == expression) {
                PsiExpression lExpr = assignment.getLExpression();
                sink.accept((CommonIntentionAction)factory.createChangeToAppendFix(assignment.getOperationTokenType(), lType, assignment));
                if (rType != null) {
                    HighlightFixUtil.registerChangeVariableTypeFixes(sink, lExpr, rType);
                    if (expression instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
                        if (assignment.getParent() instanceof PsiStatement && PsiTypes.voidType().equals((Object)rType)) {
                            sink.accept((CommonIntentionAction)new ReplaceAssignmentFromVoidWithStatementIntentionAction(assignment, (PsiExpression)call));
                        }
                    }
                }
            }
        }
        if (anchor instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)anchor;
            if (parent instanceof PsiForeachStatement) {
                PsiType type;
                PsiForeachStatement forEach = (PsiForeachStatement)parent;
                HighlightFixUtil.registerChangeVariableTypeFixes(sink, (PsiVariable)parameter, lType);
                PsiExpression iteratedValue = forEach.getIteratedValue();
                if (iteratedValue != null && rType != null && (type = iteratedValue.getType()) instanceof PsiArrayType) {
                    AdaptExpressionTypeFixUtil.registerExpectedTypeFixes(sink, iteratedValue, (PsiType)rType.createArrayType(), type);
                }
            }
        }
        if (anchor instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)anchor;
            classReference = newExpression.getClassOrAnonymousClassReference();
            factory.createReplaceTypeWithWrongImportFixes((PsiJavaCodeReferenceElement)classReference).forEach(sink);
        }
        if ((classReference = anchor.getParent()) instanceof PsiVariable && (variable = (PsiVariable)classReference).getTypeElement() != null && !variable.getTypeElement().isInferredType() && (typeElement = variable.getTypeElement()) != null) {
            factory.createReplaceTypeWithWrongImportFixes(typeElement.getInnermostComponentReferenceElement()).forEach(sink);
        }
        HighlightFixUtil.registerChangeParameterClassFix(sink, lType, rType);
    }

    @NotNull
    private static LanguageLevel getApplicableLevel(@NotNull PsiFile psiFile, @NotNull JavaFeature feature) {
        JavaSdkVersion sdkVersion;
        if (psiFile == null) {
            HighlightFixUtil.$$$reportNull$$$0(100);
        }
        if (feature == null) {
            HighlightFixUtil.$$$reportNull$$$0(101);
        }
        LanguageLevel standardLevel = feature.getStandardLevel();
        LanguageLevel featureLevel = feature.getMinimumLevel();
        if (featureLevel.isPreview() && (sdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((PsiElement)psiFile)) != null) {
            if (standardLevel != null && sdkVersion.isAtLeast(JavaSdkVersion.fromLanguageLevel((LanguageLevel)standardLevel))) {
                LanguageLevel languageLevel = standardLevel;
                if (languageLevel == null) {
                    HighlightFixUtil.$$$reportNull$$$0(102);
                }
                return languageLevel;
            }
            LanguageLevel previewLevel = sdkVersion.getMaxLanguageLevel().getPreviewLevel();
            if (previewLevel != null && previewLevel.isAtLeast(featureLevel)) {
                LanguageLevel languageLevel = previewLevel;
                if (languageLevel == null) {
                    HighlightFixUtil.$$$reportNull$$$0(103);
                }
                return languageLevel;
            }
        }
        LanguageLevel languageLevel = featureLevel;
        if (languageLevel == null) {
            HighlightFixUtil.$$$reportNull$$$0(104);
        }
        return languageLevel;
    }

    @NotNull
    public static List<CommonIntentionAction> getIncreaseLanguageLevelFixes(@NotNull PsiElement element, @NotNull JavaFeature feature) {
        if (element == null) {
            HighlightFixUtil.$$$reportNull$$$0(105);
        }
        if (feature == null) {
            HighlightFixUtil.$$$reportNull$$$0(106);
        }
        if (PsiUtil.isAvailable((JavaFeature)feature, (PsiElement)element)) {
            List<CommonIntentionAction> list = List.of();
            if (list == null) {
                HighlightFixUtil.$$$reportNull$$$0(107);
            }
            return list;
        }
        if (feature.isLimited()) {
            List<CommonIntentionAction> list = List.of();
            if (list == null) {
                HighlightFixUtil.$$$reportNull$$$0(108);
            }
            return list;
        }
        LanguageLevel applicableLevel = HighlightFixUtil.getApplicableLevel(element.getContainingFile(), feature);
        if (applicableLevel == LanguageLevel.JDK_X) {
            List<CommonIntentionAction> list = List.of();
            if (list == null) {
                HighlightFixUtil.$$$reportNull$$$0(109);
            }
            return list;
        }
        QuickFixFactory factory = QuickFixFactory.getInstance();
        List<IntentionAction> list = List.of(factory.createIncreaseLanguageLevelFix(applicableLevel), factory.createUpgradeSdkFor(applicableLevel), factory.createShowModulePropertiesFix(element));
        if (list == null) {
            HighlightFixUtil.$$$reportNull$$$0(110);
        }
        return list;
    }

    static void registerFixesOnInvalidSelector(@NotNull Consumer<? super @Nullable CommonIntentionAction> sink, @NotNull PsiExpression selector) {
        if (sink == null) {
            HighlightFixUtil.$$$reportNull$$$0(111);
        }
        if (selector == null) {
            HighlightFixUtil.$$$reportNull$$$0(112);
        }
        QuickFixFactory factory = QuickFixFactory.getInstance();
        PsiElement psiElement = selector.getParent();
        if (psiElement instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)psiElement;
            sink.accept((CommonIntentionAction)factory.createConvertSwitchToIfIntention(switchStatement));
        }
        PsiType selectorType = selector.getType();
        if (PsiTypes.longType().equals((Object)selectorType) || PsiTypes.floatType().equals((Object)selectorType) || PsiTypes.doubleType().equals((Object)selectorType)) {
            sink.accept((CommonIntentionAction)factory.createAddTypeCastFix((PsiType)PsiTypes.intType(), selector));
            sink.accept((CommonIntentionAction)factory.createWrapWithAdapterFix((PsiType)PsiTypes.intType(), selector));
        }
    }

    @Nullable
    static IntentionAction createPrimitiveToBoxedPatternFix(@NotNull PsiElement anchor) {
        PsiExpression selector;
        PsiPattern pattern;
        PsiSwitchBlock block;
        if (anchor == null) {
            HighlightFixUtil.$$$reportNull$$$0(113);
        }
        PsiTypeElement element = null;
        PsiType operandType = null;
        if (anchor instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)anchor;
            element = InstanceOfUtils.findCheckTypeElement(instanceOfExpression);
            operandType = instanceOfExpression.getOperand().getType();
        } else if (anchor instanceof PsiPattern && (block = (PsiSwitchBlock)PsiTreeUtil.getParentOfType((PsiElement)(element = JavaPsiPatternUtil.getPatternTypeElement((PsiCaseLabelElement)(pattern = (PsiPattern)anchor))), PsiSwitchBlock.class)) != null && (selector = block.getExpression()) != null) {
            operandType = selector.getType();
        }
        if (element != null && operandType != null && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)element.getType())) {
            return QuickFixFactory.getInstance().createReplacePrimitiveWithBoxedTypeAction(operandType, Objects.requireNonNull(element));
        }
        return null;
    }

    @Contract(value="null -> false", pure=true)
    private static boolean isCallToStaticMember(@Nullable PsiElement element) {
        PsiMethod[] methods;
        PsiJavaCodeReferenceElement referenceElement;
        PsiElement memberName;
        PsiNewExpression newExpression;
        block10: {
            block9: {
                if (!(element instanceof PsiNewExpression)) {
                    return false;
                }
                newExpression = (PsiNewExpression)element;
                PsiJavaCodeReferenceElement reference = newExpression.getClassOrAnonymousClassReference();
                if (reference == null) {
                    return false;
                }
                PsiElement qualifier = reference.getQualifier();
                memberName = reference.getReferenceNameElement();
                if (!(qualifier instanceof PsiJavaCodeReferenceElement)) break block9;
                referenceElement = (PsiJavaCodeReferenceElement)qualifier;
                if (memberName != null) break block10;
            }
            return false;
        }
        PsiClass clazz = (PsiClass)ObjectUtils.tryCast((Object)referenceElement.resolve(), PsiClass.class);
        if (clazz == null) {
            return false;
        }
        if (newExpression.getArgumentList() == null) {
            PsiField field = clazz.findFieldByName(memberName.getText(), true);
            return field != null && field.hasModifierProperty("static");
        }
        for (PsiMethod method : methods = clazz.findMethodsByName(memberName.getText(), true)) {
            if (!method.hasModifierProperty("static")) continue;
            PsiClass containingClass = method.getContainingClass();
            assert (containingClass != null);
            if (containingClass.isInterface() && containingClass != clazz) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static CommonIntentionAction createUnresolvedReferenceFix(PsiJavaCodeReferenceElement psi) {
        PsiNewExpression newExpression;
        PsiElement psiElement = PsiTreeUtil.skipParentsOfType((PsiElement)psi, (Class[])new Class[]{PsiJavaCodeReferenceElement.class});
        return psiElement instanceof PsiNewExpression && HighlightFixUtil.isCallToStaticMember((PsiElement)(newExpression = (PsiNewExpression)psiElement)) ? new RemoveNewKeywordFix(newExpression) : null;
    }

    public static boolean isPotentiallyCompatible(@NotNull PsiClass psiClass, @NotNull PsiReferenceParameterList referenceParameterList) {
        int refParametersNum;
        if (psiClass == null) {
            HighlightFixUtil.$$$reportNull$$$0(114);
        }
        if (referenceParameterList == null) {
            HighlightFixUtil.$$$reportNull$$$0(115);
        }
        PsiTypeElement[] referenceElements = referenceParameterList.getTypeParameterElements();
        PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
        int targetParametersNum = typeParameters.length;
        if (targetParametersNum != (refParametersNum = referenceParameterList.getTypeArguments().length)) {
            return false;
        }
        for (int i = 0; i < targetParametersNum; ++i) {
            PsiType type = referenceElements[i].getType();
            if (!ContainerUtil.exists((Object[])typeParameters[i].getSuperTypes(), bound -> !bound.equalsToText("java.lang.Object") && GenericsUtil.checkNotInBounds((PsiType)type, (PsiType)bound, (PsiReferenceParameterList)referenceParameterList))) continue;
            return false;
        }
        return true;
    }

    static void addCompletenessFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiSwitchBlock block) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(116);
        }
        if (block == null) {
            HighlightFixUtil.$$$reportNull$$$0(117);
        }
        List elements = JavaPsiSwitchUtil.getCaseLabelElements((PsiSwitchBlock)block);
        PsiExpression selector = block.getExpression();
        if (selector == null) {
            return;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            return;
        }
        PsiClass selectorClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)TypeConversionUtil.erasure((PsiType)selectorType));
        JavaPsiSwitchUtil.SelectorKind kind = JavaPsiSwitchUtil.getSwitchSelectorKind((PsiType)selectorType);
        if (selectorClass != null && kind == JavaPsiSwitchUtil.SelectorKind.ENUM) {
            Set enumElements = StreamEx.of((Collection)elements).select(PsiReferenceExpression.class).map(PsiReference::resolve).select(PsiEnumConstant.class).toSet();
            HighlightFixUtil.addEnumCompletenessFixes(info, block, selectorClass, enumElements);
            return;
        }
        List<PsiType> sealedTypes = HighlightFixUtil.getAbstractSealedTypes(JavaPsiPatternUtil.deconstructSelectorType((PsiType)selectorType));
        if (!sealedTypes.isEmpty()) {
            HighlightFixUtil.addSealedClassCompletenessFixes(info, block, selectorType, elements);
            return;
        }
        if (selectorClass != null && selectorClass.isRecord()) {
            if (HighlightFixUtil.checkRecordCaseSetNotEmpty(elements)) {
                HighlightFixUtil.addRecordExhaustivenessFixes(info, block, elements, selectorType, selectorClass);
            }
        } else if (kind == JavaPsiSwitchUtil.SelectorKind.BOOLEAN) {
            QuickFixFactory factory = QuickFixFactory.getInstance();
            info.accept((CommonIntentionAction)factory.createAddMissingBooleanPrimitiveBranchesFix(block));
            info.accept((CommonIntentionAction)factory.createAddMissingBooleanPrimitiveBranchesFixWithNull(block));
        }
    }

    private static void addEnumCompletenessFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiSwitchBlock block, @NotNull PsiClass selectorClass, @NotNull Set<PsiEnumConstant> enumElements) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(118);
        }
        if (block == null) {
            HighlightFixUtil.$$$reportNull$$$0(119);
        }
        if (selectorClass == null) {
            HighlightFixUtil.$$$reportNull$$$0(120);
        }
        if (enumElements == null) {
            HighlightFixUtil.$$$reportNull$$$0(121);
        }
        LinkedHashSet missingConstants = (LinkedHashSet)((StreamEx)StreamEx.of((Object[])selectorClass.getFields()).select(PsiEnumConstant.class).remove(enumElements::contains)).map(PsiField::getName).toCollection(LinkedHashSet::new);
        if (!missingConstants.isEmpty()) {
            IntentionAction enumBranchesFix = QuickFixFactory.getInstance().createAddMissingEnumBranchesFix(block, (Set)missingConstants);
            info.accept((CommonIntentionAction)PriorityIntentionActionWrapper.highPriority((IntentionAction)enumBranchesFix));
        }
    }

    @NotNull
    private static List<PsiType> getAbstractSealedTypes(@NotNull List<PsiType> selectorTypes) {
        if (selectorTypes == null) {
            HighlightFixUtil.$$$reportNull$$$0(122);
        }
        List<PsiType> list = selectorTypes.stream().filter(type -> {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)TypeConversionUtil.erasure((PsiType)type));
            return psiClass != null && JavaPsiSealedUtil.isAbstractSealed((PsiClass)psiClass);
        }).toList();
        if (list == null) {
            HighlightFixUtil.$$$reportNull$$$0(123);
        }
        return list;
    }

    private static void addRecordExhaustivenessFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiSwitchBlock block, @NotNull List<? extends PsiCaseLabelElement> elements, @NotNull PsiType selectorClassType, @NotNull PsiClass selectorClass) {
        JavaPatternExhaustivenessUtil.RecordExhaustivenessResult exhaustivenessResult;
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(124);
        }
        if (block == null) {
            HighlightFixUtil.$$$reportNull$$$0(125);
        }
        if (elements == null) {
            HighlightFixUtil.$$$reportNull$$$0(126);
        }
        if (selectorClassType == null) {
            HighlightFixUtil.$$$reportNull$$$0(127);
        }
        if (selectorClass == null) {
            HighlightFixUtil.$$$reportNull$$$0(128);
        }
        if (!(exhaustivenessResult = JavaPatternExhaustivenessUtil.checkRecordExhaustiveness(elements, (PsiType)selectorClassType, (PsiElement)block)).isExhaustive() && exhaustivenessResult.canBeAdded()) {
            IntentionAction fix = QuickFixFactory.getInstance().createAddMissingRecordClassBranchesFix(block, selectorClass, exhaustivenessResult.getMissedBranchesByType(), elements);
            info.accept((CommonIntentionAction)fix);
        }
    }

    private static boolean checkRecordCaseSetNotEmpty(@NotNull List<? extends PsiCaseLabelElement> elements) {
        if (elements == null) {
            HighlightFixUtil.$$$reportNull$$$0(129);
        }
        return ContainerUtil.exists(elements, element -> {
            PsiPattern pattern;
            return element instanceof PsiPattern && !JavaPsiPatternUtil.isGuarded((PsiCaseLabelElement)(pattern = (PsiPattern)element));
        });
    }

    @NotNull
    private static Set<PsiClass> getMissedClassesInSealedHierarchy(@NotNull PsiType selectorType, @NotNull List<? extends PsiCaseLabelElement> elements, @NotNull PsiSwitchBlock block) {
        if (selectorType == null) {
            HighlightFixUtil.$$$reportNull$$$0(130);
        }
        if (elements == null) {
            HighlightFixUtil.$$$reportNull$$$0(131);
        }
        if (block == null) {
            HighlightFixUtil.$$$reportNull$$$0(132);
        }
        Set classes = JavaPatternExhaustivenessUtil.findMissedClasses((PsiSwitchBlock)block, (PsiType)selectorType, elements);
        List missedSealedClasses = ((StreamEx)StreamEx.of((Collection)classes).sortedBy(t -> t.getQualifiedName())).toList();
        LinkedHashSet<PsiClass> missedClasses = new LinkedHashSet<PsiClass>();
        PsiExpression selector = Objects.requireNonNull(block.getExpression());
        for (PsiClass missedClass : missedSealedClasses) {
            PsiClassType missedClassType = TypeUtils.getType(missedClass);
            if (JavaPsiPatternUtil.covers((PsiElement)selector, (PsiType)missedClassType, (PsiType)selectorType)) {
                missedClasses.clear();
                missedClasses.add(missedClass);
                break;
            }
            missedClasses.add(missedClass);
        }
        LinkedHashSet<PsiClass> linkedHashSet = missedClasses;
        if (linkedHashSet == null) {
            HighlightFixUtil.$$$reportNull$$$0(133);
        }
        return linkedHashSet;
    }

    private static void addSealedClassCompletenessFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiSwitchBlock block, @NotNull PsiType selectorType, @NotNull List<? extends PsiCaseLabelElement> elements) {
        if (info == null) {
            HighlightFixUtil.$$$reportNull$$$0(134);
        }
        if (block == null) {
            HighlightFixUtil.$$$reportNull$$$0(135);
        }
        if (selectorType == null) {
            HighlightFixUtil.$$$reportNull$$$0(136);
        }
        if (elements == null) {
            HighlightFixUtil.$$$reportNull$$$0(137);
        }
        Set<PsiClass> missedClasses = HighlightFixUtil.getMissedClassesInSealedHierarchy(selectorType, elements, block);
        List<String> allNames = HighlightFixUtil.collectLabelElementNames(elements, missedClasses);
        Set missingCases = ContainerUtil.map2LinkedSet(missedClasses, PsiClass::getQualifiedName);
        QuickFixFactory factory = QuickFixFactory.getInstance();
        info.accept((CommonIntentionAction)factory.createAddMissingSealedClassBranchesFix(block, missingCases, allNames));
        info.accept((CommonIntentionAction)factory.createAddMissingSealedClassBranchesFixWithNull(block, missingCases, allNames));
    }

    @NotNull
    private static List<String> collectLabelElementNames(@NotNull List<? extends PsiCaseLabelElement> elements, @NotNull Set<? extends PsiClass> missingClasses) {
        if (elements == null) {
            HighlightFixUtil.$$$reportNull$$$0(138);
        }
        if (missingClasses == null) {
            HighlightFixUtil.$$$reportNull$$$0(139);
        }
        List list = ((StreamEx)((StreamEx)StreamEx.of(elements).map(PsiElement::getText).append((Stream)StreamEx.of(missingClasses).map(PsiClass::getQualifiedName))).distinct()).toList();
        if (list == null) {
            HighlightFixUtil.$$$reportNull$$$0(140);
        }
        return list;
    }

    @Nullable
    static CommonIntentionAction createVariableTypeFix(PsiJavaCodeReferenceElement ref) {
        PsiElement psiElement = ref.getParent();
        if (!(psiElement instanceof PsiTypeElement)) {
            return null;
        }
        PsiTypeElement typeElement = (PsiTypeElement)psiElement;
        PsiElement psiElement2 = typeElement.getParent();
        if (!(psiElement2 instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable localVariable = (PsiLocalVariable)psiElement2;
        PsiExpression initializer = localVariable.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiType type = initializer.getType();
        if (type == null || !PsiTypesUtil.isDenotableType((PsiType)type, (PsiElement)localVariable)) {
            return null;
        }
        if (PsiTypes.voidType().equals((Object)type) || PsiTypes.nullType().equals(type)) {
            return null;
        }
        if (IncompleteModelUtil.hasUnresolvedComponent((PsiType)type)) {
            return null;
        }
        return PriorityIntentionActionWrapper.highPriority((IntentionAction)QuickFixFactory.getInstance().createSetVariableTypeFix((PsiVariable)localVariable, type));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 19, 66, 88, 89, 90, 91, 92, 93, 102, 103, 104, 107, 108, 109, 110, 123, 133, 140 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 4: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 17: 
            case 25: 
            case 28: 
            case 33: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 18: 
            case 19: 
            case 66: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 102: 
            case 103: 
            case 104: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 123: 
            case 133: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightFixUtil";
                break;
            }
            case 20: 
            case 24: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topBlock";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readPoint";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 36: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 49: 
            case 53: 
            case 64: 
            case 72: 
            case 78: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 37: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprList";
                break;
            }
            case 38: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCandidates";
                break;
            }
            case 47: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 65: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorCall";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedMethod";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 83: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leastValueType";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 94: 
            case 97: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 98: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 101: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceParameterList";
                break;
            }
            case 117: 
            case 119: 
            case 125: 
            case 132: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 120: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorClass";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumElements";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorTypes";
                break;
            }
            case 126: 
            case 129: 
            case 131: 
            case 137: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorClassType";
                break;
            }
            case 130: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorType";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightFixUtil";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeVariableTypeFixes";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "toMethodCandidates";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "lub";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableLevel";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncreaseLanguageLevelFixes";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbstractSealedTypes";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissedClassesInSealedHierarchy";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "collectLabelElementNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerCollectionToArrayFixAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerAccessQuickFixAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeVariableTypeFixes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerUnhandledExceptionFixes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerStaticProblemQuickFixAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceReference";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createChangeReturnTypeFix";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getChangeVariableTypeFixes";
                break;
            }
            case 18: 
            case 19: 
            case 66: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 102: 
            case 103: 
            case 104: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 123: 
            case 133: 
            case 140: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getChangeParameterClassFix";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "registerLambdaReturnTypeFixes";
                break;
            }
            case 23: 
            case 24: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeParameterClassFix";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findInitializingSwitch";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createInsertSwitchDefaultFix";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "registerFixesForExpressionStatement";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "registerSpecifyVarTypeFix";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "registerQualifyMethodCallFix";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "registerStaticMethodQualifierFixes";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "registerUsageFixes";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "registerThisSuperFixes";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodCallIntentions";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodAccessLevelIntentions";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeMethodSignatureFromUsageIntentions";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeMethodSignatureFromUsageIntention";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodReturnFixAction";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "toMethodCandidates";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "registerFixesOnInvalidConstructorCall";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "registerTargetTypeFixesBasedOnApplicabilityInference";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "registerCallInferenceFixes";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "registerImplementsExtendsFix";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "registerVariableParameterizedTypeFixes";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "determineReturnType";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "lub";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "registerAmbiguousCallFixes";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "registerIncompatibleTypeFixes";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableLevel";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getIncreaseLanguageLevelFixes";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "registerFixesOnInvalidSelector";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "createPrimitiveToBoxedPatternFix";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isPotentiallyCompatible";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "addCompletenessFixes";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "addEnumCompletenessFixes";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getAbstractSealedTypes";
                break;
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "addRecordExhaustivenessFixes";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "checkRecordCaseSetNotEmpty";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getMissedClassesInSealedHierarchy";
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "addSealedClassCompletenessFixes";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "collectLabelElementNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 19, 66, 88, 89, 90, 91, 92, 93, 102, 103, 104, 107, 108, 109, 110, 123, 133, 140 -> new IllegalStateException(string);
        };
    }

    private static final class ReturnModel {
        final PsiReturnStatement myStatement;
        final PsiType myType;
        final PsiType myLeastType;

        @Contract(pure=true)
        private ReturnModel(@NotNull PsiReturnStatement statement, @NotNull PsiType type) {
            if (statement == null) {
                ReturnModel.$$$reportNull$$$0(0);
            }
            if (type == null) {
                ReturnModel.$$$reportNull$$$0(1);
            }
            this.myStatement = statement;
            this.myType = this.myLeastType = type;
        }

        @Contract(pure=true)
        private ReturnModel(@NotNull PsiReturnStatement statement, @NotNull PsiType type, @NotNull PsiType leastType) {
            if (statement == null) {
                ReturnModel.$$$reportNull$$$0(2);
            }
            if (type == null) {
                ReturnModel.$$$reportNull$$$0(3);
            }
            if (leastType == null) {
                ReturnModel.$$$reportNull$$$0(4);
            }
            this.myStatement = statement;
            this.myType = type;
            this.myLeastType = leastType;
        }

        @Nullable
        private static ReturnModel create(@NotNull PsiReturnStatement statement) {
            PsiClassType classType;
            PsiExpression value;
            if (statement == null) {
                ReturnModel.$$$reportNull$$$0(5);
            }
            if ((value = statement.getReturnValue()) == null) {
                return new ReturnModel(statement, (PsiType)PsiTypes.voidType());
            }
            if (ExpressionUtils.nonStructuralChildren(value).anyMatch(c -> c instanceof PsiFunctionalExpression)) {
                return null;
            }
            PsiType type = RefactoringChangeUtil.getTypeByExpression((PsiExpression)value);
            if (type == null || type instanceof PsiClassType && (classType = (PsiClassType)type).resolve() == null) {
                return null;
            }
            return new ReturnModel(statement, type, ReturnModel.getLeastValueType(value, type));
        }

        @NotNull
        private static PsiType getLeastValueType(@NotNull PsiExpression returnValue, @NotNull PsiType type) {
            if (returnValue == null) {
                ReturnModel.$$$reportNull$$$0(6);
            }
            if (type == null) {
                ReturnModel.$$$reportNull$$$0(7);
            }
            if (type instanceof PsiPrimitiveType) {
                int rank = TypeConversionUtil.getTypeRank((PsiType)type);
                if (rank < 1 || rank > 4) {
                    PsiType psiType = type;
                    if (psiType == null) {
                        ReturnModel.$$$reportNull$$$0(8);
                    }
                    return psiType;
                }
                PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance((Project)returnValue.getProject()).getConstantEvaluationHelper();
                Object res = evaluator.computeConstantExpression((PsiElement)returnValue);
                if (res instanceof Number) {
                    Number number = (Number)res;
                    long value = number.longValue();
                    if (-128L <= value && value <= 127L) {
                        PsiPrimitiveType psiPrimitiveType = PsiTypes.byteType();
                        if (psiPrimitiveType == null) {
                            ReturnModel.$$$reportNull$$$0(9);
                        }
                        return psiPrimitiveType;
                    }
                    if (-32768L <= value && value <= 32767L) {
                        PsiPrimitiveType psiPrimitiveType = PsiTypes.shortType();
                        if (psiPrimitiveType == null) {
                            ReturnModel.$$$reportNull$$$0(10);
                        }
                        return psiPrimitiveType;
                    }
                    if (0L <= value && value <= 65535L) {
                        PsiPrimitiveType psiPrimitiveType = PsiTypes.charType();
                        if (psiPrimitiveType == null) {
                            ReturnModel.$$$reportNull$$$0(11);
                        }
                        return psiPrimitiveType;
                    }
                }
            }
            PsiType psiType = type;
            if (psiType == null) {
                ReturnModel.$$$reportNull$$$0(12);
            }
            return psiType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leastType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnValue";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightFixUtil$ReturnModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightFixUtil$ReturnModel";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeastValueType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getLeastValueType";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9, 10, 11, 12 -> new IllegalStateException(string);
            };
        }
    }
}

