/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CompilerOptionFix;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\tH\u0014J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/daemon/impl/quickfix/AddModulesOptionFix;", "Lcom/intellij/codeInsight/daemon/impl/quickfix/CompilerOptionFix;", "module", "Lcom/intellij/openapi/module/Module;", "moduleName", "", "<init>", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "getText", "Lorg/jetbrains/annotations/Nls;", "update", "", "options", "", "intellij.java.analysis.impl"})
public final class AddModulesOptionFix
extends CompilerOptionFix {
    @NotNull
    private final String moduleName;

    public AddModulesOptionFix(@NotNull Module module, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        super(module);
        this.moduleName = moduleName;
    }

    @Override
    @NotNull
    protected String getText() {
        Object[] objectArray = new Object[]{"--add-modules " + this.moduleName};
        String string = QuickFixBundle.message("add.compiler.option.fix.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    protected void update(@NotNull List<String> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int idx = -1;
        Iterator iterator = ((Iterable)options).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String option = (String)iterator.next();
            if (!StringsKt.startsWith$default((String)option, (String)"--add-modules", (boolean)false, (int)2, null)) continue;
            if (option.length() == 13) {
                idx = i + 1;
                continue;
            }
            if (option.charAt(13) != '=') continue;
            idx = i;
        }
        int n2 = idx;
        if (n2 == -1) {
            Collection collection = options;
            Object[] objectArray = new String[]{"--add-modules", this.moduleName};
            CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        } else if (n2 == options.size()) {
            ((Collection)options).add(this.moduleName);
        } else {
            String value = options.get(idx);
            options.set(idx, StringsKt.endsWith$default((CharSequence)value, (char)'=', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)value, (char)',', (boolean)false, (int)2, null) ? value + this.moduleName : value + "," + this.moduleName);
        }
    }
}

