/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddPackageAccessibilityFix;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiJavaModule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\u0005H\u0016J!\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/codeInsight/daemon/impl/quickfix/AddOpensDirectiveFix;", "Lcom/intellij/codeInsight/daemon/impl/quickfix/AddPackageAccessibilityFix;", "module", "Lcom/intellij/psi/PsiJavaModule;", "packageName", "", "targetName", "<init>", "(Lcom/intellij/psi/PsiJavaModule;Ljava/lang/String;Ljava/lang/String;)V", "getText", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.java.analysis.impl"})
public final class AddOpensDirectiveFix
extends AddPackageAccessibilityFix {
    @NotNull
    private final String packageName;

    public AddOpensDirectiveFix(@NotNull PsiJavaModule module, @NotNull String packageName, @NotNull String targetName) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        super("opens", module, packageName, targetName);
        this.packageName = packageName;
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.packageName};
        String string = QuickFixBundle.message("module.info.add.opens.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiJavaModule module, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Project project = context.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        Iterable iterable = module.getOpens();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getOpens(...)");
        this.addPackageAccessibility(project, module, iterable);
    }
}

