/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddModuleDirectiveFix;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiJavaModule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/daemon/impl/quickfix/AddRequiresDirectiveFix;", "Lcom/intellij/codeInsight/daemon/impl/quickfix/AddModuleDirectiveFix;", "module", "Lcom/intellij/psi/PsiJavaModule;", "requiredName", "", "<init>", "(Lcom/intellij/psi/PsiJavaModule;Ljava/lang/String;)V", "getText", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.java.analysis.impl"})
public final class AddRequiresDirectiveFix
extends AddModuleDirectiveFix {
    @NotNull
    private final String requiredName;

    public AddRequiresDirectiveFix(@NotNull PsiJavaModule module, @NotNull String requiredName) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredName, (String)"requiredName");
        super(module);
        this.requiredName = requiredName;
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.requiredName};
        String string = QuickFixBundle.message("module.info.add.requires.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiJavaModule module, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        JavaModuleGraphUtil.addDependency(module, this.requiredName, null, false);
    }
}

