/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public enum CreateClassKind implements ClassKind
{
    CLASS(JavaElementKind.CLASS),
    INTERFACE(JavaElementKind.INTERFACE),
    ENUM(JavaElementKind.ENUM),
    ANNOTATION(JavaElementKind.ANNOTATION),
    RECORD(JavaElementKind.RECORD);

    private final JavaElementKind myKind;

    private CreateClassKind(JavaElementKind kind) {
        this.myKind = kind;
    }

    @Override
    @Nls
    public String getDescription() {
        return this.myKind.subject();
    }

    @Override
    public String getDescriptionAccusative() {
        return this.myKind.object();
    }

    @NotNull
    public Icon getKindIcon() {
        IconManager iconManager = IconManager.getInstance();
        Icon icon = switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> iconManager.getPlatformIcon(PlatformIcons.Class);
            case 1 -> iconManager.getPlatformIcon(PlatformIcons.Interface);
            case 2 -> iconManager.getPlatformIcon(PlatformIcons.Enum);
            case 3 -> iconManager.getPlatformIcon(PlatformIcons.Annotation);
            case 4 -> iconManager.getPlatformIcon(PlatformIcons.Record);
        };
        if (icon == null) {
            CreateClassKind.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public PsiClass create(PsiElementFactory factory, String name) {
        PsiClass psiClass = switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> factory.createClass(name);
            case 1 -> factory.createInterface(name);
            case 2 -> factory.createEnum(name);
            case 3 -> factory.createAnnotationType(name);
            case 4 -> factory.createRecord(name);
        };
        if (psiClass == null) {
            CreateClassKind.$$$reportNull$$$0(1);
        }
        return psiClass;
    }

    @NotNull
    public PsiClass createInDirectory(PsiDirectory directory, String name) {
        JavaDirectoryService service = JavaDirectoryService.getInstance();
        PsiClass psiClass = switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> service.createInterface(directory, name);
            case 0 -> service.createClass(directory, name);
            case 2 -> service.createEnum(directory, name);
            case 4 -> service.createRecord(directory, name);
            case 3 -> service.createAnnotationType(directory, name);
        };
        if (psiClass == null) {
            CreateClassKind.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateClassKind";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createInDirectory";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

