/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.MergePackageAccessibilityStatementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeProvidesStatementsFix;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeModuleStatementsFix<T extends PsiStatement>
extends PsiUpdateModCommandAction<PsiJavaModule> {
    protected static final Logger LOG = Logger.getInstance(MergeModuleStatementsFix.class);

    protected MergeModuleStatementsFix(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)javaModule);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiJavaModule element) {
        if (context == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(2);
        }
        return PsiUtil.isAvailable((JavaFeature)JavaFeature.MODULES, (PsiElement)element) ? Presentation.of((String)this.getText()) : null;
    }

    @IntentionName
    @NotNull
    abstract String getText();

    protected void invoke(@NotNull ActionContext context, @NotNull PsiJavaModule javaModule, @NotNull ModPsiUpdater updater) {
        List<T> statementsToMerge;
        if (context == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(3);
        }
        if (javaModule == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(!(statementsToMerge = this.getStatementsToMerge(javaModule)).isEmpty());
        String text = this.getReplacementText(statementsToMerge);
        PsiStatement replacement = JavaPsiFacade.getElementFactory((Project)context.project()).createModuleStatementFromText(text, null);
        PsiStatement firstStatement = (PsiStatement)statementsToMerge.get(0);
        CommentTracker commentTracker = new CommentTracker();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)context.project());
        PsiElement resultingStatement = codeStyleManager.reformat(commentTracker.replace((PsiElement)firstStatement, (PsiElement)replacement));
        for (int i = 1; i < statementsToMerge.size(); ++i) {
            PsiStatement statement = (PsiStatement)statementsToMerge.get(i);
            commentTracker.delete((PsiElement)statement);
        }
        commentTracker.insertCommentsBefore(resultingStatement);
        updater.moveCaretTo(resultingStatement.getTextRange().getEndOffset());
    }

    @NotNull
    protected abstract String getReplacementText(List<? extends T> var1);

    @NotNull
    protected abstract List<T> getStatementsToMerge(@NotNull PsiJavaModule var1);

    @NotNull
    protected static String joinUniqueNames(@NotNull List<String> names) {
        if (names == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(6);
        }
        HashSet unique = new HashSet();
        String string = names.stream().filter(name -> unique.add(name)).collect(Collectors.joining(","));
        if (string == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static MergeModuleStatementsFix<?> createFix(@Nullable PsiElement statement) {
        if (statement instanceof PsiPackageAccessibilityStatement) {
            return MergePackageAccessibilityStatementsFix.createFix((PsiPackageAccessibilityStatement)statement);
        }
        if (statement instanceof PsiProvidesStatement) {
            return MergeProvidesStatementsFix.createFix((PsiProvidesStatement)statement);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModule";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "joinUniqueNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "joinUniqueNames";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

