/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RedundantLambdaCodeBlockInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(RedundantLambdaCodeBlockInspection.class);
    @NonNls
    private static final String SHORT_NAME = "CodeBlock2Expr";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
        if (string == null) {
            RedundantLambdaCodeBlockInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.LAMBDA_EXPRESSIONS);
        if (set == null) {
            RedundantLambdaCodeBlockInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantLambdaCodeBlockInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(this){

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                PsiElement body;
                PsiExpression psiExpression;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((psiExpression = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(body = expression.getBody())) != null) {
                    PsiElement parent = psiExpression.getParent();
                    PsiElement errorElement = parent instanceof PsiReturnStatement ? parent.getFirstChild() : body.getFirstChild();
                    holder.registerProblem(errorElement, JavaAnalysisBundle.message((String)"statement.lambda.can.be.replaced.with.expression.lambda", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithExprFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$1", "visitLambdaExpression"));
            }
        };
    }

    public static PsiExpression isCodeBlockRedundant(PsiElement body) {
        PsiExpression psiExpression;
        if (body instanceof PsiCodeBlock && (psiExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body)) != null && !RedundantLambdaCodeBlockInspection.findCommentsOutsideExpression(body, psiExpression)) {
            if (LambdaUtil.isExpressionStatementExpression((PsiElement)psiExpression) && !LambdaUtil.isSafeLambdaBodyReplacement((PsiLambdaExpression)((PsiLambdaExpression)body.getParent()), () -> psiExpression)) {
                return null;
            }
            return psiExpression;
        }
        return null;
    }

    private static boolean findCommentsOutsideExpression(PsiElement body, PsiExpression psiExpression) {
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiComment.class);
        for (PsiComment comment : comments) {
            if (PsiTreeUtil.isAncestor((PsiElement)psiExpression, (PsiElement)comment, (boolean)true) || RedundantLambdaCodeBlockInspection.isSelfSuppressionComment(comment)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSelfSuppressionComment(PsiComment comment) {
        String[] suppressIds;
        String suppressString = JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)comment);
        return suppressString != null && (suppressIds = suppressString.split(",")).length == 1 && SHORT_NAME.equals(suppressIds[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithExprFix
    extends PsiUpdateModCommandQuickFix
    implements HighPriorityAction {
        private ReplaceWithExprFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"replace.with.expression.lambda", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithExprFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiExpression expression;
            PsiElement body;
            PsiLambdaExpression lambdaExpression;
            if (project == null) {
                ReplaceWithExprFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithExprFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithExprFix.$$$reportNull$$$0(3);
            }
            if ((lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class)) != null && (body = lambdaExpression.getBody()) != null && (expression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body)) != null) {
                body.replace((PsiElement)expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

