/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Equations;
import com.intellij.codeInspection.bytecodeAnalysis.EquationsLimitException;
import com.intellij.codeInspection.bytecodeAnalysis.FieldAccess;
import com.intellij.codeInspection.bytecodeAnalysis.HMember;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.ParameterAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.PuritySolver;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Solver;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class ProjectBytecodeAnalysis {
    private static final boolean SKIP_INDEX = false;
    public static final Logger LOG = Logger.getInstance(ProjectBytecodeAnalysis.class);
    public static final int EQUATIONS_LIMIT = 1000;
    private final Project myProject;
    private final EquationProvider<?> myEquationProvider;
    private final NullableNotNullManager myNullabilityManager;

    public static ProjectBytecodeAnalysis getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(0);
        }
        return (ProjectBytecodeAnalysis)project.getService(ProjectBytecodeAnalysis.class);
    }

    public ProjectBytecodeAnalysis(Project project) {
        this.myProject = project;
        this.myNullabilityManager = NullableNotNullManager.getInstance((Project)project);
        this.myEquationProvider = new IndexedEquationProvider(this.myProject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public PsiField findFieldForAccessor(@NotNull PsiMethod accessor) {
        String fieldName;
        Equations equation;
        Object var10_9;
        int count;
        if (accessor == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(1);
        }
        Direction direction = (count = accessor.getParameterList().getParametersCount()) == 0 ? Direction.Out : new Direction.In(0, true);
        EKey eKey = this.getKey((PsiModifierListOwner)accessor);
        if (eKey == null) {
            return null;
        }
        EKey accessKey = this.myEquationProvider.adaptKey(eKey);
        Iterator<Equations> iterator = this.myEquationProvider.getEquations(accessKey.member).iterator();
        do {
            if (!iterator.hasNext()) return null;
        } while (!((var10_9 = (equation = iterator.next()).find(direction).orElse(null)) instanceof FieldAccess));
        FieldAccess fieldAccess = var10_9;
        try {
            String string;
            fieldName = string = fieldAccess.name();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        PsiClass containingClass = accessor.getContainingClass();
        if (containingClass == null) return null;
        PsiField psiField = containingClass.findFieldByName(fieldName, false);
        return psiField;
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(2);
        }
        if (annotationFQN == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(3);
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            return null;
        }
        if (annotationFQN.equals(this.myNullabilityManager.getDefaultNotNull()) || annotationFQN.equals(this.myNullabilityManager.getDefaultNullable()) || annotationFQN.equals(JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = this.findInferredAnnotations(listOwner)) {
                if (!annotation.hasQualifiedName(annotationFQN)) continue;
                return annotation;
            }
        }
        return null;
    }

    public PsiAnnotation @NotNull [] findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(4);
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(5);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)listOwner, () -> CachedValueProvider.Result.create((Object)this.collectInferredAnnotations(listOwner), (Object[])new Object[]{listOwner}));
        if (psiAnnotationArray == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(6);
        }
        return psiAnnotationArray;
    }

    /*
     * Unable to fully structure code
     */
    private PsiAnnotation @NotNull [] collectInferredAnnotations(PsiModifierListOwner listOwner) {
        block16: {
            block14: {
                block15: {
                    block12: {
                        block13: {
                            block10: {
                                block11: {
                                    psiFile = listOwner.getContainingFile();
                                    v0 = file = psiFile == null ? null : psiFile.getVirtualFile();
                                    if (file != null && ClassDataIndexer.isFileExcluded(file)) {
                                        if (PsiAnnotation.EMPTY_ARRAY == null) {
                                            ProjectBytecodeAnalysis.$$$reportNull$$$0(7);
                                        }
                                        return PsiAnnotation.EMPTY_ARRAY;
                                    }
                                    try {
                                        primaryKey = this.getKey(listOwner);
                                        if (primaryKey != null) break block10;
                                        if (PsiAnnotation.EMPTY_ARRAY != null) break block11;
                                    }
                                    catch (EquationsLimitException e) {
                                        if (ProjectBytecodeAnalysis.LOG.isDebugEnabled()) {
                                            externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)false, (int)0x7FFFFFFF);
                                            ProjectBytecodeAnalysis.LOG.debug("Too many equations for " + externalName);
                                        }
                                        if (PsiAnnotation.EMPTY_ARRAY == null) {
                                            ProjectBytecodeAnalysis.$$$reportNull$$$0(12);
                                        }
                                        return PsiAnnotation.EMPTY_ARRAY;
                                    }
                                    ProjectBytecodeAnalysis.$$$reportNull$$$0(8);
                                }
                                return PsiAnnotation.EMPTY_ARRAY;
                            }
                            if (listOwner instanceof PsiMethod) {
                                allKeys = ProjectBytecodeAnalysis.collectMethodKeys((PsiMethod)listOwner, primaryKey);
                                methodAnnotations = this.loadMethodAnnotations((PsiMethod)listOwner, primaryKey, allKeys);
                                ProjectBytecodeAnalysis.correctMethodAnnotations((PsiMethod)listOwner, primaryKey, methodAnnotations);
                                return this.toPsi(primaryKey, methodAnnotations);
                            }
                            if (!(listOwner instanceof PsiParameter)) ** GOTO lbl38
                            parameterAnnotations = this.loadParameterAnnotations(primaryKey);
                            if (!this.hasFailContract((PsiParameter)listOwner, parameterAnnotations)) break block12;
                            if (PsiAnnotation.EMPTY_ARRAY != null) break block13;
                            ProjectBytecodeAnalysis.$$$reportNull$$$0(9);
                        }
                        return PsiAnnotation.EMPTY_ARRAY;
                    }
                    return this.toPsi(parameterAnnotations);
lbl38:
                    // 1 sources

                    if (!(listOwner instanceof PsiField) || !listOwner.hasModifierProperty("static")) break block14;
                    outSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Top), Value.Top);
                    this.collectEquations(Collections.singletonList(primaryKey), outSolver);
                    solutions = outSolver.solve();
                    value = solutions.get(primaryKey);
                    if (value != Value.NotNull) break block14;
                    v1 = new PsiAnnotation[]{this.getNotNullAnnotation()};
                    if (v1 != null) break block15;
                    ProjectBytecodeAnalysis.$$$reportNull$$$0(10);
                }
                return v1;
            }
            if (PsiAnnotation.EMPTY_ARRAY != null) break block16;
            ProjectBytecodeAnalysis.$$$reportNull$$$0(11);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    private static void correctMethodAnnotations(PsiMethod listOwner, EKey primaryKey, MethodAnnotations methodAnnotations) {
        if (methodAnnotations.mutates.isPure()) {
            List<StandardMethodContract> contracts;
            String contractValues = methodAnnotations.contractsValues.get(primaryKey);
            if (contractValues == null) {
                return;
            }
            try {
                contracts = StandardMethodContract.parseContract(contractValues);
            }
            catch (StandardMethodContract.ParseException ignore) {
                return;
            }
            if (!ContainerUtil.exists(contracts, c -> c.getReturnValue().equals(ContractReturnValue.returnNew()))) {
                return;
            }
            PsiType returnType = listOwner.getReturnType();
            if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.Map")) {
                methodAnnotations.contractsValues.remove(primaryKey);
            }
        }
    }

    private boolean hasFailContract(PsiParameter listOwner, ParameterAnnotations parameterAnnotations) {
        if (!parameterAnnotations.notNull) {
            return false;
        }
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)listOwner.getDeclarationScope(), PsiMethod.class);
        if (method == null) {
            return false;
        }
        int index = method.getParameterList().getParameterIndex(listOwner);
        PsiAnnotation anno = this.findInferredAnnotation((PsiModifierListOwner)method, JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT);
        if (anno == null) {
            return false;
        }
        for (StandardMethodContract contract : JavaMethodContractUtil.parseContracts(method, anno)) {
            StandardMethodContract.ValueConstraint constraint;
            if (!contract.getReturnValue().isFail() || (constraint = contract.getParameterConstraint(index)) != StandardMethodContract.ValueConstraint.NULL_VALUE) continue;
            return true;
        }
        return false;
    }

    private PsiAnnotation @NotNull [] toPsi(EKey primaryKey, MethodAnnotations methodAnnotations) {
        PsiAnnotation psiAnnotation;
        boolean notNull = methodAnnotations.notNulls.contains(primaryKey);
        boolean nullable = methodAnnotations.nullables.contains(primaryKey);
        MutationSignature mutationSignature = methodAnnotations.mutates;
        LinkedHashMap<String, String> annotationParameters = new LinkedHashMap<String, String>();
        String contractValues = methodAnnotations.contractsValues.getOrDefault(primaryKey, "");
        if (!contractValues.isEmpty()) {
            annotationParameters.put("value", "\"" + contractValues + "\"");
        }
        if (mutationSignature.isPure()) {
            annotationParameters.put("pure", "true");
        } else if (mutationSignature != MutationSignature.unknown()) {
            annotationParameters.put("mutates", "\"" + String.valueOf(mutationSignature) + "\"");
        }
        String contractPsiText = ProjectBytecodeAnalysis.generateAnnotationAttributesText(annotationParameters);
        PsiAnnotation psiAnnotation2 = psiAnnotation = contractPsiText == null ? null : this.createContractAnnotation(contractPsiText);
        if (notNull && psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation(), psiAnnotation};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(13);
            }
            return psiAnnotationArray;
        }
        if (nullable && psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation(), psiAnnotation};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(14);
            }
            return psiAnnotationArray;
        }
        if (notNull) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(15);
            }
            return psiAnnotationArray;
        }
        if (nullable) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(16);
            }
            return psiAnnotationArray;
        }
        if (psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{psiAnnotation};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(17);
            }
            return psiAnnotationArray;
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(18);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @Nullable
    private static String generateAnnotationAttributesText(Map<String, String> attributesMap) {
        if (attributesMap.isEmpty()) {
            return null;
        }
        if (attributesMap.keySet().equals(Collections.singleton("value"))) {
            return (String)ContainerUtil.getOnlyItem(attributesMap.values());
        }
        return EntryStream.of(attributesMap).join((CharSequence)"=").joining((CharSequence)",");
    }

    private PsiAnnotation @NotNull [] toPsi(ParameterAnnotations parameterAnnotations) {
        if (parameterAnnotations.notNull) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(19);
            }
            return psiAnnotationArray;
        }
        if (parameterAnnotations.nullable) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(20);
            }
            return psiAnnotationArray;
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(21);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    public PsiAnnotation getNotNullAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)this.createAnnotationFromText("@" + this.myNullabilityManager.getDefaultNotNull()), (Object[])new Object[]{this.myNullabilityManager}));
    }

    public PsiAnnotation getNullableAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)this.createAnnotationFromText("@" + this.myNullabilityManager.getDefaultNullable()), (Object[])new Object[]{this.myNullabilityManager}));
    }

    public PsiAnnotation createContractAnnotation(String contractValue) {
        Map cache = (Map)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(attrs -> this.createAnnotationFromText("@org.jetbrains.annotations.Contract(" + attrs + ")"));
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        });
        return (PsiAnnotation)cache.get(contractValue);
    }

    @Nullable
    public EKey getKey(@NotNull PsiModifierListOwner owner) {
        PsiElement gParent;
        PsiElement parent;
        if (owner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(22);
        }
        LOG.assertTrue(owner instanceof PsiCompiledElement, (Object)owner);
        EKey key = null;
        if (owner instanceof PsiMethod) {
            key = BytecodeAnalysisConverter.psiKey((PsiMember)((PsiMethod)owner), Direction.Out);
        } else if (owner instanceof PsiField) {
            key = BytecodeAnalysisConverter.psiKey((PsiMember)((PsiField)owner), Direction.Out);
        } else if (owner instanceof PsiParameter && (parent = owner.getParent()) instanceof PsiParameterList && (gParent = parent.getParent()) instanceof PsiMethod) {
            int index = ((PsiParameterList)parent).getParameterIndex((PsiParameter)owner);
            key = BytecodeAnalysisConverter.psiKey((PsiMember)((PsiMethod)gParent), new Direction.In(index, false));
        }
        return key == null ? null : this.myEquationProvider.adaptKey(key);
    }

    public static List<EKey> collectMethodKeys(@NotNull PsiMethod method, EKey primaryKey) {
        if (method == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(23);
        }
        return BytecodeAnalysisConverter.mkInOutKeys(method, primaryKey);
    }

    private ParameterAnnotations loadParameterAnnotations(@NotNull EKey notNullKey) throws EquationsLimitException {
        if (notNullKey == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(24);
        }
        Solver notNullSolver = new Solver(new ELattice<Value>(Value.NotNull, Value.Top), Value.Top);
        this.collectEquations(Collections.singletonList(notNullKey), notNullSolver);
        Map<EKey, Value> notNullSolutions = notNullSolver.solve();
        boolean notNull = Value.NotNull == notNullSolutions.get(notNullKey) || Value.NotNull == notNullSolutions.get(notNullKey.mkUnstable());
        Solver nullableSolver = new Solver(new ELattice<Value>(Value.Null, Value.Top), Value.Top);
        EKey nullableKey = new EKey(notNullKey.member, notNullKey.dirKey + 1, true, false);
        this.collectEquations(Collections.singletonList(nullableKey), nullableSolver);
        Map<EKey, Value> nullableSolutions = nullableSolver.solve();
        boolean nullable = Value.Null == nullableSolutions.get(nullableKey) || Value.Null == nullableSolutions.get(nullableKey.mkUnstable());
        return new ParameterAnnotations(notNull, nullable);
    }

    private MethodAnnotations loadMethodAnnotations(@NotNull PsiMethod owner, @NotNull EKey key, List<EKey> allKeys) throws EquationsLimitException {
        if (owner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(25);
        }
        if (key == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(26);
        }
        MethodAnnotations result = new MethodAnnotations();
        EKey pureKey = key.withDirection(Direction.Pure);
        PuritySolver puritySolver = ProjectBytecodeAnalysis.collectPurityEquations(pureKey, this.myEquationProvider);
        Map<EKey, Effects> puritySolutions = puritySolver.solve();
        int arity = owner.getParameterList().getParametersCount();
        BytecodeAnalysisConverter.addEffectAnnotations(puritySolutions, result, pureKey, owner.isConstructor());
        EKey failureKey = key.withDirection(Direction.Throw);
        Solver failureSolver = new Solver(new ELattice<Value>(Value.Fail, Value.Top), Value.Top);
        this.collectEquations(Collections.singletonList(failureKey), failureSolver);
        Map<EKey, Value> failureData = failureSolver.solve();
        if (failureData.get(failureKey.mkStable()) == Value.Fail || failureData.get(failureKey.mkUnstable()) == Value.Fail) {
            result.contractsValues.put(key, StreamEx.constant((Object)"_", (long)arity).joining((CharSequence)",", (CharSequence)"", (CharSequence)"->fail"));
        } else {
            Solver outSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Top), Value.Top);
            this.collectEquations(allKeys, outSolver);
            Map<EKey, Value> solutions = outSolver.solve();
            this.addMethodAnnotations(solutions, result, key, arity);
        }
        return result;
    }

    private static EKey withStability(EKey key, boolean stability) {
        return new EKey(key.member, key.dirKey, stability, false);
    }

    private static PuritySolver collectPurityEquations(EKey key, EquationProvider<?> provider) throws EquationsLimitException {
        PuritySolver puritySolver = new PuritySolver();
        HashSet<EKey> queued = new HashSet<EKey>();
        ArrayDeque<EKey> queue = new ArrayDeque<EKey>();
        queue.push(key);
        queued.add(key);
        DataValue returnValue = null;
        while (!queue.isEmpty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            EKey curKey = (EKey)queue.pop();
            boolean stable = true;
            Effects combined = null;
            for (Equations equations : provider.getEquations(curKey.member)) {
                stable &= equations.stable;
                Effects effects = (Effects)equations.find(curKey.getDirection()).orElseGet(() -> new Effects(DataValue.UnknownDataValue1, curKey.getDirection() == Direction.Volatile ? Collections.emptySet() : Effects.TOP_EFFECTS));
                combined = combined == null ? effects : combined.combine(effects);
            }
            if (combined == null) continue;
            if (curKey == key && combined.returnValue.dependencies().findFirst().isEmpty()) {
                returnValue = combined.returnValue;
                if (combined.isTop()) {
                    return puritySolver;
                }
            } else if (returnValue != null && combined.isTop()) {
                PuritySolver trivialSolver = new PuritySolver();
                trivialSolver.addEquation(key, new Effects(returnValue, Effects.TOP_EFFECTS));
                return trivialSolver;
            }
            combined.processDependencies(dep -> {
                if (queued.add((EKey)dep)) {
                    queue.push((EKey)dep);
                }
            });
            puritySolver.addEquation(ProjectBytecodeAnalysis.withStability(curKey, stable), combined);
        }
        puritySolver.addPlainFieldEquations(md -> true);
        return puritySolver;
    }

    private void collectEquations(List<EKey> keys, Solver solver) throws EquationsLimitException {
        HashSet<EKey> queued = new HashSet<EKey>();
        Stack queue = new Stack();
        for (EKey key : keys) {
            queue.push((Object)key);
            queued.add(key);
        }
        while (!queue.empty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            EKey curKey = (EKey)queue.pop();
            for (Equations equations : this.myEquationProvider.getEquations(curKey.member)) {
                Result result = equations.find(curKey.getDirection()).orElseGet(solver::getUnknownResult);
                if (result instanceof FieldAccess) continue;
                solver.addEquation(new Equation(ProjectBytecodeAnalysis.withStability(curKey, equations.stable), result));
                result.processDependencies(dep -> {
                    if (queued.add((EKey)dep)) {
                        queue.push(dep);
                    }
                });
            }
        }
    }

    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(27);
        }
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)this.myProject).createAnnotationFromText(text, null);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        PsiAnnotation psiAnnotation = annotation;
        if (psiAnnotation == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(28);
        }
        return psiAnnotation;
    }

    BitSet findAlwaysNotNullParameters(@NotNull EKey methodKey, BitSet possiblyNotNullParameters) throws EquationsLimitException {
        if (methodKey == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(29);
        }
        BitSet alwaysNotNullParameters = new BitSet();
        if (possiblyNotNullParameters.cardinality() != 0) {
            List keys = IntStreamEx.of((BitSet)possiblyNotNullParameters).mapToObj(idx -> methodKey.withDirection(new Direction.In(idx, false))).toList();
            Solver notNullSolver = new Solver(new ELattice<Value>(Value.NotNull, Value.Top), Value.Top);
            this.collectEquations(keys, notNullSolver);
            Map<EKey, Value> notNullSolutions = notNullSolver.solve();
            alwaysNotNullParameters = IntStreamEx.of((BitSet)possiblyNotNullParameters).filter(idx -> {
                EKey key = methodKey.withDirection(new Direction.In(idx, false));
                return notNullSolutions.get(key) == Value.NotNull || notNullSolutions.get(key.mkUnstable()) == Value.NotNull;
            }).toBitSet();
        }
        return alwaysNotNullParameters;
    }

    private void addMethodAnnotations(@NotNull Map<EKey, Value> solution, @NotNull MethodAnnotations methodAnnotations, @NotNull EKey methodKey, int arity) throws EquationsLimitException {
        StandardMethodContract contract;
        if (solution == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(30);
        }
        if (methodAnnotations == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(31);
        }
        if (methodKey == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(32);
        }
        ArrayList<StandardMethodContract> contractClauses = new ArrayList<StandardMethodContract>();
        Set<EKey> notNulls = methodAnnotations.notNulls;
        Map<EKey, String> contracts = methodAnnotations.contractsValues;
        ContractReturnValue fullReturnValue = methodAnnotations.returnValue.asContractReturnValue();
        for (Map.Entry<EKey, Value> entry : solution.entrySet()) {
            Value value = entry.getValue();
            if (value == Value.Top || value == Value.Bot) continue;
            EKey key = entry.getKey().mkStable();
            Direction direction = key.getDirection();
            EKey baseKey = key.mkBase();
            if (!methodKey.equals(baseKey) || value == Value.Fail && direction.isNullFail() && !methodAnnotations.mutates.isPure() && !this.isPureModuloFailCause(solution, key, direction)) continue;
            if (value == Value.NotNull && direction == Direction.Out) {
                notNulls.add(methodKey);
                continue;
            }
            if (!(direction instanceof Direction.ParamValueBasedDirection)) continue;
            ContractReturnValue contractReturnValue = fullReturnValue.equals(ContractReturnValue.returnAny()) || value == Value.Fail ? value.toReturnValue() : fullReturnValue;
            contractClauses.add(ProjectBytecodeAnalysis.contractElement(arity, (Direction.ParamValueBasedDirection)direction, contractReturnValue));
        }
        Map partition = StreamEx.of(contractClauses).partitioningBy(c -> c.getReturnValue().isFail());
        List<StandardMethodContract> failingContracts = ProjectBytecodeAnalysis.squashContracts((List)partition.get(true));
        List<StandardMethodContract> nonFailingContracts = ProjectBytecodeAnalysis.squashContracts((List)partition.get(false));
        if (nonFailingContracts.size() == 1 && (contract = nonFailingContracts.getFirst()).getReturnValue().equals(ContractReturnValue.returnNotNull()) && contract.isTrivial()) {
            nonFailingContracts = Collections.emptyList();
            notNulls.add(methodKey);
        }
        List allContracts = StreamEx.of((Object[])new List[]{failingContracts, nonFailingContracts}).toFlatList(Function.identity());
        this.removeConstraintFromNonNullParameter(methodKey, allContracts);
        if (allContracts.isEmpty() && !fullReturnValue.equals(ContractReturnValue.returnAny())) {
            allContracts.add(StandardMethodContract.trivialContract(arity, fullReturnValue));
        }
        if (notNulls.contains(methodKey)) {
            allContracts.removeIf(smc -> smc.getReturnValue().equals(ContractReturnValue.returnNotNull()));
        }
        String result = ((StreamEx)((StreamEx)StreamEx.of((Collection)allContracts).sorted(Comparator.comparingInt(smc -> smc.getReturnValue().isFail() ? 0 : 1).thenComparing(MethodContract::toString))).map(Object::toString).distinct()).map(str -> str.replace(" ", "")).joining((CharSequence)";");
        contracts.put(methodKey, result);
    }

    private boolean isPureModuloFailCause(@NotNull Map<EKey, Value> solution, @NotNull EKey key, @NotNull Direction direction) throws EquationsLimitException {
        if (solution == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(33);
        }
        if (key == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(34);
        }
        if (direction == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(35);
        }
        EKey pureKey = key.withDirection(Direction.Pure);
        final Set resetKeys = ((StreamEx)StreamEx.of(this.myEquationProvider.getEquations(key.member)).mapPartial(eq -> eq.find(direction)).flatMap(Result::dependencies).filter(k -> !k.getDirection().isNullFail() && solution.get(k) == Value.Fail)).map(k -> k.member).toSet();
        if (resetKeys.isEmpty()) {
            return false;
        }
        PuritySolver puritySolver = ProjectBytecodeAnalysis.collectPurityEquations(pureKey, new EquationProvider<MemberDescriptor>(this.myEquationProvider.myProject){

            @Override
            EKey adaptKey(@NotNull EKey key) {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ProjectBytecodeAnalysis.this.myEquationProvider.adaptKey(key);
            }

            @Override
            List<Equations> getEquations(MemberDescriptor method) {
                if (resetKeys.contains(method)) {
                    return Collections.singletonList(new Equations(Collections.singletonList(new DirectionResultPair(Direction.Pure.asInt(), new Effects(DataValue.UnknownDataValue2, Collections.emptySet()))), true));
                }
                return ProjectBytecodeAnalysis.this.myEquationProvider.getEquations(method);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis$1", "adaptKey"));
            }
        });
        Map<EKey, Effects> solve = puritySolver.solve();
        Effects effects = solve.get(pureKey);
        return effects != null && !effects.isTop() && effects.effects.isEmpty();
    }

    private void removeConstraintFromNonNullParameter(@NotNull EKey methodKey, List<StandardMethodContract> allContracts) throws EquationsLimitException {
        BitSet possiblyNotNullParameters;
        BitSet alwaysNotNullParameters;
        if (methodKey == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(36);
        }
        if ((alwaysNotNullParameters = this.findAlwaysNotNullParameters(methodKey, possiblyNotNullParameters = StreamEx.of(allContracts).flatMapToInt(smc -> IntStreamEx.range((int)smc.getParameterCount()).filter(idx -> smc.getParameterConstraint(idx) == StandardMethodContract.ValueConstraint.NOT_NULL_VALUE)).toBitSet())).cardinality() != 0) {
            allContracts.replaceAll(smc -> {
                StandardMethodContract.ValueConstraint[] constraints = smc.getConstraints().toArray(new StandardMethodContract.ValueConstraint[0]);
                for (int i = 0; i < constraints.length; ++i) {
                    if (!alwaysNotNullParameters.get(i)) continue;
                    if (constraints[i] == StandardMethodContract.ValueConstraint.NULL_VALUE) {
                        return null;
                    }
                    constraints[i] = StandardMethodContract.ValueConstraint.ANY_VALUE;
                }
                return new StandardMethodContract(constraints, smc.getReturnValue());
            });
            allContracts.removeIf(Objects::isNull);
        }
    }

    @NotNull
    private static List<StandardMethodContract> squashContracts(List<StandardMethodContract> contractClauses) {
        StandardMethodContract soleContract = StreamEx.ofPairs(contractClauses, (c1, c2) -> {
            if (c1.getReturnValue() != c2.getReturnValue()) {
                return null;
            }
            int idx = -1;
            for (int i = 0; i < c1.getParameterCount(); ++i) {
                StandardMethodContract.ValueConstraint left = c1.getParameterConstraint(i);
                StandardMethodContract.ValueConstraint right = c2.getParameterConstraint(i);
                if (left == StandardMethodContract.ValueConstraint.ANY_VALUE && right == StandardMethodContract.ValueConstraint.ANY_VALUE) continue;
                if (idx >= 0 || !right.canBeNegated() || left != right.negate()) {
                    return null;
                }
                idx = i;
            }
            return c1;
        }).nonNull().findFirst().orElse(null);
        if (soleContract != null) {
            contractClauses = Collections.singletonList(StandardMethodContract.trivialContract(soleContract.getParameterCount(), soleContract.getReturnValue()));
        }
        List<StandardMethodContract> list = contractClauses;
        if (list == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(37);
        }
        return list;
    }

    private static StandardMethodContract contractElement(int arity, Direction.ParamValueBasedDirection inOut, ContractReturnValue returnValue) {
        StandardMethodContract.ValueConstraint[] constraints = new StandardMethodContract.ValueConstraint[arity];
        Arrays.fill((Object[])constraints, (Object)StandardMethodContract.ValueConstraint.ANY_VALUE);
        constraints[inOut.paramIndex] = inOut.inValue.toValueConstraint();
        return new StandardMethodContract(constraints, returnValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 28, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notNullKey";
                break;
            }
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 29: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodKey";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "solution";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodAnnotations";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findInferredAnnotations";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInferredAnnotations";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsi";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationFromText";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "squashContracts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFieldForAccessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotations";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 37: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectMethodKeys";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadParameterAnnotations";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadMethodAnnotations";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationFromText";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findAlwaysNotNullParameters";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addMethodAnnotations";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isPureModuloFailCause";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeConstraintFromNonNullParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 28, 37 -> new IllegalStateException(string);
        };
    }

    static class IndexedEquationProvider
    extends EquationProvider<HMember> {
        IndexedEquationProvider(Project project) {
            super(project);
        }

        @Override
        public EKey adaptKey(@NotNull EKey key) {
            if (key == null) {
                IndexedEquationProvider.$$$reportNull$$$0(0);
            }
            return key.hashed();
        }

        @Override
        public List<Equations> getEquations(MemberDescriptor method) {
            HMember key = method.hashed();
            return this.myEquationCache.computeIfAbsent(key, m -> ClassDataIndexer.getEquations(ProjectScope.getLibrariesScope((Project)this.myProject), m));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis$IndexedEquationProvider", "adaptKey"));
        }
    }

    static abstract class EquationProvider<T extends MemberDescriptor> {
        final Map<T, List<Equations>> myEquationCache = ContainerUtil.createConcurrentSoftValueMap();
        final Project myProject;

        EquationProvider(Project project) {
            this.myProject = project;
            project.getMessageBus().connect().subscribe(PsiModificationTracker.TOPIC, this.myEquationCache::clear);
        }

        abstract EKey adaptKey(@NotNull EKey var1);

        abstract List<Equations> getEquations(MemberDescriptor var1);
    }

    static class PlainEquationProvider
    extends EquationProvider<Member> {
        PlainEquationProvider(Project project) {
            super(project);
        }

        @Override
        public EKey adaptKey(@NotNull EKey key) {
            if (key == null) {
                PlainEquationProvider.$$$reportNull$$$0(0);
            }
            assert (key.member instanceof Member);
            return key;
        }

        @Override
        public List<Equations> getEquations(MemberDescriptor memberDescriptor) {
            assert (memberDescriptor instanceof Member);
            Member method = (Member)memberDescriptor;
            List<Equations> equations = (List<Equations>)this.myEquationCache.get(method);
            return equations == null ? this.loadEquations(method) : equations;
        }

        private VirtualFile findClassFile(String internalClassName) {
            String packageName = StringUtil.getPackageName((String)internalClassName, (char)'/').replace('/', '.');
            String className = StringUtil.getShortName((String)internalClassName, (char)'/');
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
            if (aPackage == null) {
                PsiModifierListOwner compiledClass;
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(StringUtil.getQualifiedName((String)packageName, (String)className), GlobalSearchScope.allScope((Project)this.myProject));
                if (psiClass != null && (compiledClass = PsiUtil.preferCompiledElement((PsiModifierListOwner)psiClass)) instanceof ClsClassImpl) {
                    return compiledClass.getContainingFile().getVirtualFile();
                }
                return null;
            }
            String classFileName = className + ".class";
            for (PsiDirectory directory : aPackage.getDirectories()) {
                VirtualFile file = directory.getVirtualFile().findChild(classFileName);
                if (file == null || ClassDataIndexer.isFileExcluded(file)) continue;
                return file;
            }
            return null;
        }

        private List<Equations> loadEquations(Member method) {
            VirtualFile file = this.findClassFile(method.internalClassName);
            if (file == null) {
                return Collections.emptyList();
            }
            try {
                Map<EKey, Equations> map = ClassDataIndexer.processClass(new ClassReader(file.contentsToByteArray(false)), file.getPresentableUrl());
                Map groups = EntryStream.of(map).mapKeys(key -> (Member)key.member).grouping();
                this.myEquationCache.putAll(groups);
                return groups.getOrDefault(method, Collections.emptyList());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis$PlainEquationProvider", "adaptKey"));
        }
    }
}

