/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.canBeFinal;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.canBeFinal.CanBeFinalAnnotator;
import com.intellij.codeInspection.canBeFinal.CanBeFinalHandler;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CanBeFinalInspection
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance(CanBeFinalInspection.class);
    public boolean REPORT_CLASSES;
    public boolean REPORT_METHODS;
    public boolean REPORT_FIELDS = true;
    @NonNls
    public static final String SHORT_NAME = "CanBeFinal";

    private boolean isReportClasses() {
        return this.REPORT_CLASSES;
    }

    private boolean isReportMethods() {
        return this.REPORT_METHODS;
    }

    private boolean isReportFields() {
        return this.REPORT_FIELDS;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"REPORT_CLASSES", (String)JavaAnalysisBundle.message((String)"inspection.can.be.final.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"REPORT_METHODS", (String)JavaAnalysisBundle.message((String)"inspection.can.be.final.option1", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"REPORT_FIELDS", (String)JavaAnalysisBundle.message((String)"inspection.can.be.final.option2", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            CanBeFinalInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            CanBeFinalInspection.$$$reportNull$$$0(1);
        }
        return new CanBeFinalAnnotator(refManager);
    }

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            CanBeFinalInspection.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            CanBeFinalInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            CanBeFinalInspection.$$$reportNull$$$0(4);
        }
        if (globalContext == null) {
            CanBeFinalInspection.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            CanBeFinalInspection.$$$reportNull$$$0(6);
        }
        if (refEntity instanceof RefJavaElement) {
            PsiMember psiMember;
            RefJavaElement refElement = (RefJavaElement)refEntity;
            if (refElement instanceof RefParameter) {
                return null;
            }
            if (!refElement.isReferenced()) {
                return null;
            }
            if (refElement.isSyntheticJSP()) {
                return null;
            }
            if (refElement.isFinal()) {
                return null;
            }
            if (!((RefElementImpl)refElement).checkFlag(CanBeFinalAnnotator.CAN_BE_FINAL_MASK)) {
                return null;
            }
            if (refElement instanceof RefClass) {
                RefClass refClass = (RefClass)refElement;
                if (!this.isReportClasses()) {
                    return null;
                }
                if (refClass.isInterface() || refClass.isAnonymous() || refClass.isAbstract()) {
                    return null;
                }
            } else if (refElement instanceof RefMethod) {
                RefMethod refMethod = (RefMethod)refElement;
                if (!this.isReportMethods()) {
                    return null;
                }
                RefClass ownerClass = refMethod.getOwnerClass();
                if (ownerClass == null || ownerClass.isFinal()) {
                    return null;
                }
                if ("private".equals(refMethod.getAccessModifier())) {
                    return null;
                }
            } else if (refElement instanceof RefField) {
                RefField field = (RefField)refElement;
                if (!this.isReportFields()) {
                    return null;
                }
                if (!field.isUsedForWriting()) {
                    return null;
                }
            } else {
                return null;
            }
            if ((psiMember = (PsiMember)ObjectUtils.tryCast((Object)refElement.getPsiElement(), PsiMember.class)) == null || !CanBeFinalHandler.allowToBeFinal(psiMember)) {
                return null;
            }
            PsiElement psiIdentifier = ((PsiNameIdentifierOwner)psiMember).getNameIdentifier();
            if (psiIdentifier != null) {
                return new ProblemDescriptor[]{manager.createProblemDescriptor(psiIdentifier, JavaAnalysisBundle.message((String)"inspection.export.results.can.be.final.description", (Object[])new Object[0]), (LocalQuickFix)new AcceptSuggested(globalContext.getRefManager()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
            }
        }
        return null;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemsProcessor) {
        if (manager == null) {
            CanBeFinalInspection.$$$reportNull$$$0(7);
        }
        if (globalContext == null) {
            CanBeFinalInspection.$$$reportNull$$$0(8);
        }
        if (problemsProcessor == null) {
            CanBeFinalInspection.$$$reportNull$$$0(9);
        }
        for (RefElement entryPoint : globalContext.getEntryPointsManager(manager).getEntryPoints(manager)) {
            problemsProcessor.ignoreElement((RefEntity)entryPoint);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(this){

            public void visitMethod(@NotNull RefMethod refMethod) {
                if (refMethod == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (problemsProcessor.getDescriptions((RefEntity)refMethod) == null) {
                    return;
                }
                if (!(refMethod.isStatic() || "private".equals(refMethod.getAccessModifier()) || refMethod instanceof RefImplicitConstructor)) {
                    globalContext.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                        ((RefElementImpl)refMethod).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                        problemsProcessor.ignoreElement((RefEntity)refMethod);
                        return false;
                    });
                }
            }

            public void visitClass(@NotNull RefClass refClass) {
                if (refClass == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (problemsProcessor.getDescriptions((RefEntity)refClass) == null) {
                    return;
                }
                if (!refClass.isAnonymous() && !"private".equals(refClass.getAccessModifier())) {
                    globalContext.enqueueDerivedClassesProcessor(refClass, inheritor -> {
                        ((RefClassImpl)refClass).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                        problemsProcessor.ignoreElement((RefEntity)refClass);
                        return false;
                    });
                }
            }

            public void visitField(final @NotNull RefField refField) {
                if (refField == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (problemsProcessor.getDescriptions((RefEntity)refField) == null) {
                    return;
                }
                if ("private".equals(refField.getAccessModifier())) {
                    return;
                }
                globalContext.enqueueFieldUsagesProcessor(refField, new GlobalJavaInspectionContext.UsagesProcessor(){

                    public boolean process(PsiReference psiReference) {
                        PsiElement expression = psiReference.getElement();
                        if (expression instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)expression))) {
                            ((RefFieldImpl)refField).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                            problemsProcessor.ignoreElement((RefEntity)refField);
                            return false;
                        }
                        return true;
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refMethod";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refClass";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refField";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return false;
    }

    @Nullable
    public QuickFix<ProblemDescriptor> getQuickFix(String hint) {
        return new AcceptSuggested(null);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
        if (string == null) {
            CanBeFinalInspection.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }

    private static class AcceptSuggested
    extends PsiUpdateModCommandQuickFix {
        private final RefManager myManager;

        AcceptSuggested(RefManager manager) {
            this.myManager = manager;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.can.be.final.accept.quickfix", (Object[])new Object[0]);
            if (string == null) {
                AcceptSuggested.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiModifierListOwner psiElement;
            if (project == null) {
                AcceptSuggested.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AcceptSuggested.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AcceptSuggested.$$$reportNull$$$0(3);
            }
            if ((psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class)) != null) {
                RefJavaElement refElement = (RefJavaElement)(this.myManager != null ? this.myManager.getReference((PsiElement)psiElement) : null);
                try {
                    PsiModifierList modifierList;
                    if (psiElement instanceof PsiVariable) {
                        ((PsiVariable)psiElement).normalizeDeclaration();
                    }
                    LOG.assertTrue((modifierList = psiElement.getModifierList()) != null);
                    modifierList.setModifierProperty("final", true);
                    modifierList.setModifierProperty("volatile", false);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                if (refElement != null) {
                    RefJavaUtil.getInstance().setIsFinal(refElement, true);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$AcceptSuggested";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$AcceptSuggested";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

