/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaCallState;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsParameterImpl;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.OptionalInt;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContractValue {
    ContractValue() {
    }

    abstract DfaValue makeDfaValue(DfaValueFactory var1, DfaCallArguments var2);

    @NotNull
    public DfaCondition makeCondition(DfaValueFactory factory, DfaCallArguments arguments) {
        DfaCondition dfaCondition = DfaCondition.getUnknown();
        if (dfaCondition == null) {
            ContractValue.$$$reportNull$$$0(0);
        }
        return dfaCondition;
    }

    public DfaCondition fromCall(DfaValueFactory factory, PsiCallExpression call) {
        DfaCallArguments arguments = DfaCallArguments.fromCall(factory, call);
        if (arguments == null) {
            return DfaCondition.getUnknown();
        }
        return this.makeCondition(factory, arguments);
    }

    public boolean isExclusive(ContractValue other) {
        return false;
    }

    public ContractValue invert() {
        return null;
    }

    public boolean isBoundCheckingCondition() {
        return false;
    }

    public OptionalInt getNullCheckedArgument(boolean equalToNull) {
        return this.getArgumentComparedTo(ContractValue.nullValue(), equalToNull);
    }

    public OptionalInt getArgumentComparedTo(ContractValue value, boolean equal) {
        return OptionalInt.empty();
    }

    public String getPresentationText(PsiCallExpression call) {
        return this.toString();
    }

    public PsiExpression findPlace(PsiCallExpression call) {
        return null;
    }

    @NotNull
    public DfaCallState updateState(@NotNull DfaCallState state) {
        if (state == null) {
            ContractValue.$$$reportNull$$$0(1);
        }
        DfaCallState dfaCallState = state;
        if (dfaCallState == null) {
            ContractValue.$$$reportNull$$$0(2);
        }
        return dfaCallState;
    }

    public static ContractValue qualifier() {
        return Qualifier.INSTANCE;
    }

    public static ContractValue argument(int index) {
        return new Argument(index);
    }

    public ContractValue specialField(@NotNull SpecialField field) {
        if (field == null) {
            ContractValue.$$$reportNull$$$0(3);
        }
        return new Spec(this, field);
    }

    public static ContractValue constant(Object value, @NotNull PsiType type) {
        if (type == null) {
            ContractValue.$$$reportNull$$$0(4);
        }
        return new IndependentValue(String.valueOf(value), factory -> factory.fromDfType(DfTypes.constant(TypeConversionUtil.computeCastTo((Object)value, (PsiType)type), type)));
    }

    public static ContractValue booleanValue(boolean value) {
        return value ? IndependentValue.TRUE : IndependentValue.FALSE;
    }

    public static ContractValue nullValue() {
        return IndependentValue.NULL;
    }

    public static ContractValue zero() {
        return IndependentValue.ZERO;
    }

    public static ContractValue condition(ContractValue left, RelationType relation, ContractValue right) {
        return new Condition(left, relation, right);
    }

    @NotNull
    DfaVariableValue makeVariable(@NotNull DfaCallState state, DfaValueFactory factory, DfaValue value) {
        DfType type;
        if (state == null) {
            ContractValue.$$$reportNull$$$0(5);
        }
        if ((type = value.getDfType()) instanceof DfReferenceType) {
            if (type.isLocal()) {
                type = ((DfReferenceType)type).dropLocality();
                value = factory.fromDfType(type);
            }
            if (((DfReferenceType)type).getNullability() == DfaNullability.NULLABLE) {
                type = ((DfReferenceType)type).dropNullability();
            }
        }
        DfaVariableValue var = factory.getVarFactory().createVariableValue((VariableDescriptor)new ContractTempDescriptor(this, type));
        state.getMemoryState().setVarValue(var, value);
        DfaVariableValue dfaVariableValue = var;
        if (dfaVariableValue == null) {
            ContractValue.$$$reportNull$$$0(6);
        }
        return dfaVariableValue;
    }

    public static void flushContractTempVariables(DfaMemoryState state) {
        state.flushVariables(var -> var.getDescriptor() instanceof ContractTempDescriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractValue";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "makeCondition";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "updateState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "makeVariable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "specialField";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "constant";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static class Qualifier
    extends ContractValue {
        static final Qualifier INSTANCE = new Qualifier();

        private Qualifier() {
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return arguments.myQualifier;
        }

        @Override
        public PsiExpression findPlace(PsiCallExpression call) {
            if (call instanceof PsiMethodCallExpression) {
                return ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression();
            }
            return null;
        }

        @Override
        public String getPresentationText(PsiCallExpression call) {
            PsiExpression place = this.findPlace(call);
            if (place != null) {
                return PsiExpressionTrimRenderer.render((PsiExpression)place);
            }
            return super.getPresentationText(call);
        }

        @Override
        @NotNull
        public DfaCallState updateState(@NotNull DfaCallState state) {
            if (state == null) {
                Qualifier.$$$reportNull$$$0(0);
            }
            DfaValueFactory factory = state.getReturnValue().getFactory();
            DfaCallArguments callArguments = state.getCallArguments();
            DfaValue value = callArguments.myQualifier;
            if (!(value instanceof DfaVariableValue || DfaTypeValue.isUnknown((DfaValue)value) || value.getDfType() instanceof DfConstantType)) {
                DfaVariableValue var = this.makeVariable(state, factory, value);
                DfaCallState dfaCallState = state.withArguments(new DfaCallArguments((DfaValue)var, callArguments.myArguments, callArguments.myMutation));
                if (dfaCallState == null) {
                    Qualifier.$$$reportNull$$$0(1);
                }
                return dfaCallState;
            }
            DfaCallState dfaCallState = state;
            if (dfaCallState == null) {
                Qualifier.$$$reportNull$$$0(2);
            }
            return dfaCallState;
        }

        public String toString() {
            return "this";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractValue$Qualifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractValue$Qualifier";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "updateState";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Argument
    extends ContractValue {
        private final int myIndex;

        Argument(int index) {
            this.myIndex = index;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            if (arguments.myArguments.length <= this.myIndex) {
                return factory.getUnknown();
            }
            return arguments.myArguments[this.myIndex];
        }

        @Override
        @NotNull
        public DfaCallState updateState(@NotNull DfaCallState state) {
            DfaCallArguments callArguments;
            DfaValueFactory factory;
            DfaValue value;
            if (state == null) {
                Argument.$$$reportNull$$$0(0);
            }
            if (!((value = this.makeDfaValue(factory = state.getReturnValue().getFactory(), callArguments = state.getCallArguments())) instanceof DfaVariableValue || DfaTypeValue.isUnknown((DfaValue)value) || value.getDfType() instanceof DfConstantType)) {
                DfaVariableValue var = this.makeVariable(state, factory, value);
                DfaValue[] newArgs = (DfaValue[])callArguments.getArguments().clone();
                newArgs[this.myIndex] = var;
                DfaCallState dfaCallState = state.withArguments(new DfaCallArguments(callArguments.myQualifier, newArgs, callArguments.myMutation));
                if (dfaCallState == null) {
                    Argument.$$$reportNull$$$0(1);
                }
                return dfaCallState;
            }
            DfaCallState dfaCallState = state;
            if (dfaCallState == null) {
                Argument.$$$reportNull$$$0(2);
            }
            return dfaCallState;
        }

        @Override
        public PsiExpression findPlace(PsiCallExpression call) {
            PsiExpression[] args;
            PsiExpressionList list = call.getArgumentList();
            if (list != null && (this.myIndex < (args = list.getExpressions()).length - 1 || this.myIndex == args.length - 1 && !MethodCallUtils.isVarArgCall((PsiCall)call))) {
                return args[this.myIndex];
            }
            return null;
        }

        @Override
        public String getPresentationText(PsiCallExpression call) {
            PsiExpression place = this.findPlace(call);
            if (place != null && !ExpressionUtils.isNullLiteral(place)) {
                return PsiExpressionTrimRenderer.render((PsiExpression)place);
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return this.toString();
            }
            PsiParameter[] params = method.getParameterList().getParameters();
            if (this.myIndex == 0 && params.length == 1) {
                return JavaElementKind.PARAMETER.subject();
            }
            if (this.myIndex < params.length) {
                PsiParameter param = params[this.myIndex];
                if (param instanceof ClsParameterImpl && ((ClsParameterImpl)param).isAutoGeneratedName()) {
                    return "param" + (this.myIndex + 1);
                }
                return param.getName();
            }
            return this.toString();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Argument && this.myIndex == ((Argument)obj).myIndex;
        }

        public String toString() {
            return "param" + (this.myIndex + 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractValue$Argument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractValue$Argument";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "updateState";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Spec
    extends ContractValue {
        @NotNull
        private final ContractValue myQualifier;
        @NotNull
        private final SpecialField myField;

        Spec(@NotNull ContractValue qualifier, @NotNull SpecialField field) {
            if (qualifier == null) {
                Spec.$$$reportNull$$$0(0);
            }
            if (field == null) {
                Spec.$$$reportNull$$$0(1);
            }
            this.myQualifier = qualifier;
            this.myField = field;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return this.myField.createValue(factory, this.myQualifier.makeDfaValue(factory, arguments));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Spec)) return false;
            Spec that = (Spec)obj;
            if (!this.myQualifier.equals(that.myQualifier)) return false;
            if (this.myField != that.myField) return false;
            return true;
        }

        @Override
        public PsiExpression findPlace(PsiCallExpression call) {
            return this.myQualifier.findPlace(call);
        }

        @Override
        public String getPresentationText(PsiCallExpression call) {
            return JavaAnalysisBundle.message((String)"dfa.find.cause.special.field.of.something", (Object[])new Object[]{this.myField, this.myQualifier.getPresentationText(call)});
        }

        public String toString() {
            return String.valueOf(this.myQualifier) + "." + String.valueOf((Object)this.myField) + "()";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "field";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/ContractValue$Spec";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IndependentValue
    extends ContractValue {
        static final IndependentValue NULL = new IndependentValue("null", factory -> factory.fromDfType((DfType)DfTypes.NULL));
        static final IndependentValue TRUE = new IndependentValue("true", factory -> factory.fromDfType((DfType)DfTypes.TRUE)){

            @Override
            public boolean isExclusive(ContractValue other) {
                return other == FALSE;
            }
        };
        static final IndependentValue FALSE = new IndependentValue("false", factory -> factory.fromDfType((DfType)DfTypes.FALSE)){

            @Override
            public boolean isExclusive(ContractValue other) {
                return other == TRUE;
            }
        };
        static final IndependentValue ZERO = new IndependentValue("0", factory -> factory.fromDfType((DfType)DfTypes.intValue(0)));
        private final Function<? super DfaValueFactory, ? extends DfaValue> mySupplier;
        private final String myPresentation;

        IndependentValue(String presentation, Function<? super DfaValueFactory, ? extends DfaValue> supplier) {
            this.mySupplier = supplier;
            this.myPresentation = presentation;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return this.mySupplier.apply((DfaValueFactory)factory);
        }

        public String toString() {
            return this.myPresentation;
        }
    }

    public static class Condition
    extends ContractValue {
        private final ContractValue myLeft;
        private final ContractValue myRight;
        private final RelationType myRelationType;

        Condition(ContractValue left, RelationType type, ContractValue right) {
            this.myLeft = left;
            this.myRight = right;
            this.myRelationType = type;
        }

        @Override
        public boolean isBoundCheckingCondition() {
            return switch (this.myRelationType) {
                case RelationType.LE, RelationType.LT, RelationType.GE, RelationType.GT -> true;
                default -> false;
            };
        }

        @Override
        public boolean isExclusive(ContractValue other) {
            if (!(other instanceof Condition)) {
                return false;
            }
            Condition that = (Condition)other;
            if (that.myLeft.equals(this.myLeft) && that.myRight.equals(this.myRight) && that.myRelationType.getNegated() == this.myRelationType) {
                return true;
            }
            if (that.myLeft.equals(this.myRight) && that.myRight.equals(this.myLeft) && that.myRelationType.getNegated() == this.myRelationType.getFlipped()) {
                return true;
            }
            if (that.myRelationType == this.myRelationType) {
                if (that.myLeft.equals(this.myLeft) && that.myRight.isExclusive(this.myRight)) {
                    return true;
                }
                if (that.myLeft.equals(this.myRight) && that.myRight.isExclusive(this.myLeft)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        @NotNull
        public DfaCallState updateState(@NotNull DfaCallState state) {
            if (state == null) {
                Condition.$$$reportNull$$$0(0);
            }
            DfaCallState dfaCallState = this.myRight.updateState(this.myLeft.updateState(state));
            if (dfaCallState == null) {
                Condition.$$$reportNull$$$0(1);
            }
            return dfaCallState;
        }

        @Nullable
        private ContractValue getValueComparedTo(ContractValue value, boolean equal) {
            if (this.myRelationType == RelationType.equivalence((boolean)equal)) {
                ContractValue other;
                if (this.myLeft == value) {
                    other = this.myRight;
                } else if (this.myRight == value) {
                    other = this.myLeft;
                } else {
                    return null;
                }
                return other;
            }
            if (value == IndependentValue.FALSE) {
                return this.getValueComparedTo(IndependentValue.TRUE, !equal);
            }
            return null;
        }

        @Override
        public OptionalInt getArgumentComparedTo(ContractValue value, boolean equal) {
            ContractValue other = this.getValueComparedTo(value, equal);
            return other instanceof Argument ? OptionalInt.of(((Argument)other).myIndex) : OptionalInt.empty();
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return factory.getUnknown();
        }

        @Override
        @NotNull
        public DfaCondition makeCondition(DfaValueFactory factory, DfaCallArguments arguments) {
            DfPrimitiveType primitiveType;
            DfaValue left = this.myLeft.makeDfaValue(factory, arguments);
            DfaValue right = this.myRight.makeDfaValue(factory, arguments);
            DfType dfType = left.getDfType();
            if (dfType instanceof DfPrimitiveType) {
                primitiveType = (DfPrimitiveType)dfType;
                right = DfaUtil.boxUnbox(right, DfTypes.typedObject((PsiType)primitiveType.getPsiType(), Nullability.UNKNOWN));
            }
            if ((dfType = right.getDfType()) instanceof DfPrimitiveType) {
                primitiveType = (DfPrimitiveType)dfType;
                left = DfaUtil.boxUnbox(left, DfTypes.typedObject((PsiType)primitiveType.getPsiType(), Nullability.UNKNOWN));
            }
            DfaCondition dfaCondition = left.cond(this.myRelationType, right);
            if (dfaCondition == null) {
                Condition.$$$reportNull$$$0(2);
            }
            return dfaCondition;
        }

        @Override
        public String getPresentationText(PsiCallExpression call) {
            if (this.myLeft instanceof IndependentValue) {
                return this.myRight.getPresentationText(call) + " " + String.valueOf(this.myRelationType.getFlipped()) + " " + this.myLeft.getPresentationText(call);
            }
            return this.myLeft.getPresentationText(call) + " " + String.valueOf(this.myRelationType) + " " + this.myRight.getPresentationText(call);
        }

        @NotNull
        public RelationType getRelationType() {
            RelationType relationType = this.myRelationType;
            if (relationType == null) {
                Condition.$$$reportNull$$$0(3);
            }
            return relationType;
        }

        @NotNull
        public ContractValue getLeft() {
            ContractValue contractValue = this.myLeft;
            if (contractValue == null) {
                Condition.$$$reportNull$$$0(4);
            }
            return contractValue;
        }

        @NotNull
        public ContractValue getRight() {
            ContractValue contractValue = this.myRight;
            if (contractValue == null) {
                Condition.$$$reportNull$$$0(5);
            }
            return contractValue;
        }

        @Override
        public ContractValue invert() {
            return new Condition(this.myLeft, this.myRelationType.getNegated(), this.myRight);
        }

        public String toString() {
            return String.valueOf(this.myLeft) + " " + String.valueOf(this.myRelationType) + " " + String.valueOf(this.myRight);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractValue$Condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractValue$Condition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeCondition";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelationType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeft";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRight";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "updateState";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class ContractTempDescriptor
    implements VariableDescriptor {
        @NotNull
        private final ContractValue myValue;
        @NotNull
        private final DfType myType;

        private ContractTempDescriptor(@NotNull ContractValue value, @NotNull DfType type) {
            if (value == null) {
                ContractTempDescriptor.$$$reportNull$$$0(0);
            }
            if (type == null) {
                ContractTempDescriptor.$$$reportNull$$$0(1);
            }
            this.myValue = value;
            this.myType = type;
        }

        public boolean isStable() {
            return true;
        }

        @NotNull
        public DfType getDfType(@Nullable DfaVariableValue qualifier) {
            DfType dfType = this.myType;
            if (dfType == null) {
                ContractTempDescriptor.$$$reportNull$$$0(2);
            }
            return dfType;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ContractTempDescriptor && ((ContractTempDescriptor)obj).myValue == this.myValue && ((ContractTempDescriptor)obj).myType.equals((Object)this.myType);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }

        public String toString() {
            return "contract$" + String.valueOf(this.myValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractValue$ContractTempDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractValue$ContractTempDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

