/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.jvm.problems.JvmDfaProblem;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class NullabilityProblemKind<T extends PsiElement> {
    private static final String NPE = "java.lang.NullPointerException";
    private static final String RE = "java.lang.RuntimeException";
    private final String myName;
    private final Supplier<@Nls String> myAlwaysNullMessage;
    private final Supplier<@Nls String> myNormalMessage;
    @Nullable
    private final String myException;
    public static final NullabilityProblemKind<PsiMethodCallExpression> callNPE = new NullabilityProblemKind("java.lang.NullPointerException", "callNPE", "dataflow.message.npe.method.invocation.sure", "dataflow.message.npe.method.invocation");
    public static final NullabilityProblemKind<PsiMethodReferenceExpression> callMethodRefNPE = new NullabilityProblemKind("java.lang.NullPointerException", "callMethodRefNPE", "dataflow.message.npe.methodref.invocation");
    public static final NullabilityProblemKind<PsiNewExpression> innerClassNPE = new NullabilityProblemKind("java.lang.NullPointerException", "innerClassNPE", "dataflow.message.npe.inner.class.construction.sure", "dataflow.message.npe.inner.class.construction");
    public static final NullabilityProblemKind<PsiTemplateExpression> templateNPE = new NullabilityProblemKind("java.lang.NullPointerException", "templateNPE", "dataflow.message.npe.template.invocation.sure", "dataflow.message.npe.template.invocation");
    public static final NullabilityProblemKind<PsiExpression> fieldAccessNPE = new NullabilityProblemKind("java.lang.NullPointerException", "fieldAccessNPE", "dataflow.message.npe.field.access.sure", "dataflow.message.npe.field.access");
    public static final NullabilityProblemKind<PsiArrayAccessExpression> arrayAccessNPE = new NullabilityProblemKind("java.lang.NullPointerException", "arrayAccessNPE", "dataflow.message.npe.array.access.sure", "dataflow.message.npe.array.access");
    public static final NullabilityProblemKind<PsiElement> unboxingNullable = new NullabilityProblemKind("java.lang.NullPointerException", "unboxingNullable", "dataflow.message.unboxing");
    public static final NullabilityProblemKind<PsiExpression> assigningToNotNull = new NullabilityProblemKind(null, "assigningToNotNull", "dataflow.message.assigning.null", "dataflow.message.assigning.nullable");
    public static final NullabilityProblemKind<PsiExpression> assigningToNonAnnotatedField = new NullabilityProblemKind(null, "assigningToNonAnnotatedField", "dataflow.message.assigning.null.notannotated", "dataflow.message.assigning.nullable.notannotated");
    public static final NullabilityProblemKind<PsiExpression> storingToNotNullArray = new NullabilityProblemKind(null, "storingToNotNullArray", "dataflow.message.storing.array.null", "dataflow.message.storing.array.nullable");
    public static final NullabilityProblemKind<PsiExpression> nullableReturn = new NullabilityProblemKind(null, "nullableReturn");
    public static final NullabilityProblemKind<PsiExpression> nullableFunctionReturn = new NullabilityProblemKind("java.lang.RuntimeException", "nullableFunctionReturn", "dataflow.message.return.nullable.from.notnull.function", "dataflow.message.return.nullable.from.notnull.function");
    public static final NullabilityProblemKind<PsiExpression> passingToNotNullParameter = new NullabilityProblemKind("java.lang.RuntimeException", "passingToNotNullParameter", "dataflow.message.passing.null.argument", "dataflow.message.passing.nullable.argument");
    public static final NullabilityProblemKind<PsiMethodReferenceExpression> unboxingMethodRefParameter = new NullabilityProblemKind("java.lang.NullPointerException", "unboxingMethodRefParameter", "dataflow.message.passing.nullable.argument.methodref");
    public static final NullabilityProblemKind<PsiMethodReferenceExpression> passingToNotNullMethodRefParameter = new NullabilityProblemKind("java.lang.RuntimeException", "passingToNotNullMethodRefParameter", "dataflow.message.passing.nullable.argument.methodref");
    public static final NullabilityProblemKind<PsiExpression> passingToNonAnnotatedParameter = new NullabilityProblemKind(null, "passingToNonAnnotatedParameter", "dataflow.message.passing.null.argument.nonannotated", "dataflow.message.passing.nullable.argument.nonannotated");
    public static final NullabilityProblemKind<PsiMethodReferenceExpression> passingToNonAnnotatedMethodRefParameter = new NullabilityProblemKind(null, "passingToNonAnnotatedMethodRefParameter", "dataflow.message.passing.nullable.argument.methodref.nonannotated");
    public static final NullabilityProblemKind<PsiExpression> assumeNotNull = new NullabilityProblemKind("java.lang.RuntimeException", "assumeNotNull");
    public static final NullabilityProblemKind<PsiExpression> noProblem = new NullabilityProblemKind(null, "noProblem");

    private NullabilityProblemKind(@Nullable String exception, @NotNull String name) {
        if (name == null) {
            NullabilityProblemKind.$$$reportNull$$$0(0);
        }
        this.myException = exception;
        this.myName = name;
        this.myAlwaysNullMessage = null;
        this.myNormalMessage = null;
    }

    private NullabilityProblemKind(@Nullable String exception, @NotNull String name, @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String message) {
        if (name == null) {
            NullabilityProblemKind.$$$reportNull$$$0(1);
        }
        if (message == null) {
            NullabilityProblemKind.$$$reportNull$$$0(2);
        }
        this(exception, name, message, message);
    }

    private NullabilityProblemKind(@Nullable String exception, @NotNull String name, @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String alwaysNullMessage, @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String normalMessage) {
        if (name == null) {
            NullabilityProblemKind.$$$reportNull$$$0(3);
        }
        if (alwaysNullMessage == null) {
            NullabilityProblemKind.$$$reportNull$$$0(4);
        }
        if (normalMessage == null) {
            NullabilityProblemKind.$$$reportNull$$$0(5);
        }
        this.myException = exception;
        this.myName = name;
        this.myAlwaysNullMessage = JavaAnalysisBundle.messagePointer((String)alwaysNullMessage, (Object[])new Object[0]);
        this.myNormalMessage = JavaAnalysisBundle.messagePointer((String)normalMessage, (Object[])new Object[0]);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public NullabilityProblem<T> problem(@Nullable T anchor, @Nullable PsiExpression expression) {
        return anchor == null || this == noProblem ? null : new NullabilityProblem<T>(this, anchor, expression, false);
    }

    @Nullable
    public NullabilityProblem<T> asMyProblem(NullabilityProblem<?> problem) {
        return problem != null && problem.myKind == this ? problem : null;
    }

    public void ifMyProblem(NullabilityProblem<?> problem, Consumer<? super T> consumer) {
        NullabilityProblem<T> myProblem = this.asMyProblem(problem);
        if (myProblem != null) {
            consumer.accept(myProblem.getAnchor());
        }
    }

    public String toString() {
        return this.myName;
    }

    @Nullable
    public static NullabilityProblem<?> fromContext(@NotNull PsiExpression expression, Map<PsiExpression, NullabilityProblemKind<? super PsiExpression>> customNullabilityProblems) {
        PsiAssertStatement assertStatement;
        PsiForStatement forStatement;
        PsiTemplateExpression templateExpression;
        if (expression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(6);
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expression.getType()) || expression instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).resolve() instanceof PsiClass) {
            return null;
        }
        PsiExpression context = NullabilityProblemKind.findTopExpression(expression);
        NullabilityProblemKind<? super PsiExpression> kind = customNullabilityProblems.get(context);
        if (kind != null) {
            return kind.problem((PsiExpression)context, expression);
        }
        PsiElement parent = context.getParent();
        if (parent instanceof PsiReferenceExpression) {
            PsiMember member;
            PsiReferenceExpression ref = (PsiReferenceExpression)parent;
            PsiElement psiElement = ref.resolve();
            if (psiElement instanceof PsiMember && (member = (PsiMember)psiElement).hasModifierProperty("static")) {
                return null;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiMethodCallExpression) {
                PsiParameter parameter = MethodCallUtils.getParameterForArgument(context);
                if (parameter != null) {
                    return NullabilityProblemKind.getParameterProblem(parameter, expression, context);
                }
                return callNPE.problem((PsiMethodCallExpression)grandParent, expression);
            }
            return fieldAccessNPE.problem(context, expression);
        }
        PsiType targetType = null;
        if (parent instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)parent;
            targetType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda);
        } else if (parent instanceof PsiReturnStatement) {
            targetType = PsiTypesUtil.getMethodReturnType((PsiElement)parent);
        }
        if (targetType != null && !PsiTypes.voidType().equals((Object)targetType)) {
            if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)targetType)) {
                return NullabilityProblemKind.createUnboxingProblem(context, expression);
            }
            return nullableReturn.problem(context, expression);
        }
        if (parent instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)parent;
            if (var.getType() instanceof PsiPrimitiveType) {
                return NullabilityProblemKind.createUnboxingProblem(context, expression);
            }
            Nullability nullability = DfaPsiUtil.getElementNullabilityForWrite(var.getType(), (PsiModifierListOwner)var);
            if (nullability == Nullability.NOT_NULL) {
                return assigningToNotNull.problem(context, expression);
            }
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            return NullabilityProblemKind.getAssignmentProblem(assignment, expression, context);
        }
        if (parent instanceof PsiTemplateExpression && (templateExpression = (PsiTemplateExpression)parent).getProcessor() == expression) {
            return templateNPE.problem(templateExpression, expression);
        }
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            return NullabilityProblemKind.getExpressionListProblem(expressionList, expression, context);
        }
        if (parent instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializer = (PsiArrayInitializerExpression)parent;
            return NullabilityProblemKind.getArrayInitializerProblem(arrayInitializer, expression, context);
        }
        if (parent instanceof PsiTypeCastExpression) {
            if (TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)context.getType())) {
                return unboxingNullable.problem((PsiElement)context, expression);
            }
        } else if (parent instanceof PsiIfStatement || parent instanceof PsiWhileStatement || parent instanceof PsiDoWhileStatement || parent instanceof PsiUnaryExpression || parent instanceof PsiConditionalExpression || parent instanceof PsiForStatement && (forStatement = (PsiForStatement)parent).getCondition() == context || parent instanceof PsiAssertStatement && (assertStatement = (PsiAssertStatement)parent).getAssertCondition() == context) {
            return NullabilityProblemKind.createUnboxingProblem(context, expression);
        }
        if (parent instanceof PsiSwitchBlock) {
            PsiSwitchBlock switchBlock = (PsiSwitchBlock)parent;
            return NullabilityProblemKind.getSwitchBlockProblem(switchBlock, expression, context);
        }
        if (parent instanceof PsiForeachStatement || parent instanceof PsiThrowStatement || parent instanceof PsiSynchronizedStatement) {
            return fieldAccessNPE.problem(context, expression);
        }
        if (parent instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)parent;
            return newExpression.getQualifier() == context ? innerClassNPE.problem(newExpression, expression) : NullabilityProblemKind.createUnboxingProblem(context, expression);
        }
        if (parent instanceof PsiPolyadicExpression) {
            boolean noUnboxing;
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)parent;
            IElementType type = polyadic.getOperationTokenType();
            boolean bl = noUnboxing = type == JavaTokenType.PLUS && TypeUtils.isJavaLangString(polyadic.getType()) || (type == JavaTokenType.EQEQ || type == JavaTokenType.NE) && !ContainerUtil.exists((Object[])polyadic.getOperands(), op -> TypeConversionUtil.isPrimitiveAndNotNull((PsiType)op.getType()));
            if (!noUnboxing) {
                return NullabilityProblemKind.createUnboxingProblem(context, expression);
            }
        }
        if (parent instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parent;
            if (arrayAccessExpression.getArrayExpression() == context) {
                return arrayAccessNPE.problem(arrayAccessExpression, expression);
            }
            return NullabilityProblemKind.createUnboxingProblem(context, expression);
        }
        return null;
    }

    @Nullable
    private static NullabilityProblem<?> getExpressionListProblem(@NotNull PsiExpressionList expressionList, @NotNull PsiExpression expression, @NotNull PsiExpression context) {
        Nullability nullability;
        if (expressionList == null) {
            NullabilityProblemKind.$$$reportNull$$$0(7);
        }
        if (expression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(8);
        }
        if (context == null) {
            NullabilityProblemKind.$$$reportNull$$$0(9);
        }
        if (expressionList.getParent() instanceof PsiSwitchLabelStatementBase) {
            return fieldAccessNPE.problem(context, expression);
        }
        PsiParameter parameter = MethodCallUtils.getParameterForArgument(context);
        PsiElement grandParent = expressionList.getParent();
        if (parameter != null) {
            return NullabilityProblemKind.getParameterProblem(parameter, expression, context);
        }
        if (grandParent instanceof PsiCall && MethodCallUtils.isVarArgCall((PsiCall)grandParent) && (nullability = DfaPsiUtil.getVarArgComponentNullability(((PsiCall)grandParent).resolveMethod())) == Nullability.NOT_NULL) {
            return passingToNotNullParameter.problem(context, expression);
        }
        return null;
    }

    @Nullable
    private static NullabilityProblem<? extends PsiElement> getParameterProblem(@NotNull PsiParameter parameter, @NotNull PsiExpression expression, @NotNull PsiExpression context) {
        if (parameter == null) {
            NullabilityProblemKind.$$$reportNull$$$0(10);
        }
        if (expression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(11);
        }
        if (context == null) {
            NullabilityProblemKind.$$$reportNull$$$0(12);
        }
        if (parameter.getType() instanceof PsiPrimitiveType) {
            return NullabilityProblemKind.createUnboxingProblem(context, expression);
        }
        PsiElement grandParent = context.getParent().getParent();
        if (grandParent instanceof PsiAnonymousClass) {
            grandParent = grandParent.getParent();
        }
        if (grandParent instanceof PsiCall) {
            PsiCall call = (PsiCall)grandParent;
            PsiSubstitutor substitutor = call.resolveMethodGenerics().getSubstitutor();
            PsiType paramType = substitutor.substitute(parameter.getType());
            if (NullabilityProblemKind.assignableTypeParameter(paramType, expression.getType())) {
                return null;
            }
            Nullability nullability = DfaPsiUtil.getElementNullabilityForWrite(paramType, (PsiModifierListOwner)parameter);
            if (nullability == Nullability.NOT_NULL) {
                return passingToNotNullParameter.problem(context, expression);
            }
            if (nullability == Nullability.UNKNOWN) {
                return passingToNonAnnotatedParameter.problem(context, expression);
            }
        }
        return null;
    }

    private static boolean assignableTypeParameter(@NotNull PsiType leftType, @Nullable PsiType rightType) {
        PsiTypeParameter leftTp;
        PsiClass psiClass;
        if (leftType == null) {
            NullabilityProblemKind.$$$reportNull$$$0(13);
        }
        if (rightType == null) {
            return false;
        }
        if (rightType.getNullability().nullability() == Nullability.NOT_NULL) {
            return false;
        }
        PsiClass psiClass2 = PsiUtil.resolveClassInClassTypeOnly((PsiType)rightType);
        if (!(psiClass2 instanceof PsiTypeParameter)) {
            return false;
        }
        PsiTypeParameter tp = (PsiTypeParameter)psiClass2;
        if (leftType instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType captured = (PsiCapturedWildcardType)leftType;
            leftType = captured.getLowerBound();
        }
        return (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)leftType)) instanceof PsiTypeParameter && (leftTp = (PsiTypeParameter)psiClass).isEquivalentTo((PsiElement)tp) && rightType.getNullability().equals((Object)leftType.getNullability());
    }

    @Nullable
    private static NullabilityProblem<?> getArrayInitializerProblem(@NotNull PsiArrayInitializerExpression initializer, @NotNull PsiExpression expression, @NotNull PsiExpression context) {
        PsiType type;
        if (initializer == null) {
            NullabilityProblemKind.$$$reportNull$$$0(14);
        }
        if (expression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(15);
        }
        if (context == null) {
            NullabilityProblemKind.$$$reportNull$$$0(16);
        }
        if ((type = initializer.getType()) instanceof PsiArrayType) {
            PsiType expectedType;
            PsiType componentType = ((PsiArrayType)type).getComponentType();
            if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)componentType)) {
                return NullabilityProblemKind.createUnboxingProblem(context, expression);
            }
            Nullability nullability = DfaPsiUtil.getTypeNullability(componentType);
            if (nullability == Nullability.UNKNOWN && initializer.getParent() instanceof PsiNewExpression && (expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)initializer.getParent(), false)) instanceof PsiArrayType) {
                nullability = DfaPsiUtil.getTypeNullability(((PsiArrayType)expectedType).getComponentType());
            }
            if (nullability == Nullability.NOT_NULL) {
                return storingToNotNullArray.problem(context, expression);
            }
        }
        return null;
    }

    @Nullable
    private static NullabilityProblem<?> getSwitchBlockProblem(@NotNull PsiSwitchBlock switchBlock, @NotNull PsiExpression expression, @NotNull PsiExpression context) {
        NullabilityProblem<PsiElement> problem;
        PsiCodeBlock body;
        if (switchBlock == null) {
            NullabilityProblemKind.$$$reportNull$$$0(17);
        }
        if (expression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(18);
        }
        if (context == null) {
            NullabilityProblemKind.$$$reportNull$$$0(19);
        }
        if ((body = switchBlock.getBody()) != null) {
            PsiStatement[] statements;
            for (PsiStatement statement : statements = body.getStatements()) {
                PsiCaseLabelElementList labelElementList;
                PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)ObjectUtils.tryCast((Object)statement, PsiSwitchLabelStatementBase.class);
                if (labelStatement == null || (labelElementList = labelStatement.getCaseLabelElementList()) == null) continue;
                for (PsiCaseLabelElement element : labelElementList.getElements()) {
                    PsiExpression caseExpression;
                    if (!(element instanceof PsiExpression) || !TypeConversionUtil.isNullType((PsiType)(caseExpression = (PsiExpression)element).getType())) continue;
                    return null;
                }
            }
        }
        return (problem = NullabilityProblemKind.createUnboxingProblem(context, expression)) == null ? fieldAccessNPE.problem(context, expression) : problem;
    }

    @Nullable
    private static NullabilityProblem<?> getAssignmentProblem(@NotNull PsiAssignmentExpression assignment, @NotNull PsiExpression expression, @NotNull PsiExpression context) {
        PsiExpression lho;
        if (assignment == null) {
            NullabilityProblemKind.$$$reportNull$$$0(20);
        }
        if (expression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(21);
        }
        if (context == null) {
            NullabilityProblemKind.$$$reportNull$$$0(22);
        }
        IElementType tokenType = assignment.getOperationTokenType();
        if (assignment.getRExpression() == context && (lho = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression())) != null) {
            PsiReferenceExpression ref;
            PsiField field;
            boolean forceDeclaredNullity;
            PsiType type = lho.getType();
            if (tokenType.equals(JavaTokenType.PLUSEQ) && TypeUtils.isJavaLangString(type)) {
                return null;
            }
            if (type instanceof PsiPrimitiveType) {
                return NullabilityProblemKind.createUnboxingProblem(context, expression);
            }
            Nullability nullability = Nullability.UNKNOWN;
            PsiVariable target = null;
            if (lho instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref2 = (PsiReferenceExpression)lho;
                target = (PsiVariable)ObjectUtils.tryCast((Object)ref2.resolve(), PsiVariable.class);
                if (target != null) {
                    nullability = DfaPsiUtil.getElementNullabilityForWrite(type, (PsiModifierListOwner)target);
                }
            } else {
                nullability = DfaPsiUtil.getTypeNullability(type);
            }
            boolean bl = forceDeclaredNullity = !(target instanceof PsiParameter) || !(target.getParent() instanceof PsiParameterList);
            if (forceDeclaredNullity && nullability == Nullability.NOT_NULL) {
                return (lho instanceof PsiArrayAccessExpression ? storingToNotNullArray : assigningToNotNull).problem(context, expression);
            }
            if (nullability == Nullability.UNKNOWN && lho instanceof PsiReferenceExpression && (field = (PsiField)ObjectUtils.tryCast((Object)(ref = (PsiReferenceExpression)lho).resolve(), PsiField.class)) != null && !field.hasModifierProperty("final")) {
                return assigningToNonAnnotatedField.problem(context, expression);
            }
        }
        return null;
    }

    @NotNull
    static PsiExpression findTopExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(23);
        }
        PsiExpression context = expression;
        while (true) {
            PsiSwitchExpression enclosing;
            PsiSwitchBlock block;
            PsiElement grandParent;
            PsiElement parent;
            if ((parent = context.getParent()) instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != context) {
                if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)((PsiExpression)parent).getType())) {
                    PsiExpression psiExpression = context;
                    if (psiExpression == null) {
                        NullabilityProblemKind.$$$reportNull$$$0(24);
                    }
                    return psiExpression;
                }
                context = (PsiExpression)parent;
                continue;
            }
            if (parent instanceof PsiExpressionStatement && (grandParent = parent.getParent()) instanceof PsiSwitchLabeledRuleStatement && (block = ((PsiSwitchLabeledRuleStatement)grandParent).getEnclosingSwitchBlock()) instanceof PsiSwitchExpression) {
                context = (PsiExpression)block;
                continue;
            }
            if (!(parent instanceof PsiYieldStatement) || (enclosing = ((PsiYieldStatement)parent).findEnclosingExpression()) == null) break;
            context = enclosing;
        }
        PsiExpression psiExpression = context;
        if (psiExpression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(25);
        }
        return psiExpression;
    }

    private static NullabilityProblem<PsiElement> createUnboxingProblem(@NotNull PsiExpression context, @NotNull PsiExpression expression) {
        if (context == null) {
            NullabilityProblemKind.$$$reportNull$$$0(26);
        }
        if (expression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(27);
        }
        if (!TypeConversionUtil.isPrimitiveWrapper((PsiType)context.getType())) {
            return null;
        }
        return unboxingNullable.problem((PsiElement)context, expression);
    }

    static List<NullabilityProblem<?>> postprocessNullabilityProblems(Collection<NullabilityProblem<?>> problems) {
        ArrayList unchanged = new ArrayList();
        HashMap expressionToProblem = new HashMap();
        for (NullabilityProblem<?> problem : problems) {
            PsiExpression top;
            PsiConditionalExpression ternary;
            PsiExpression expression = problem.getDereferencedExpression();
            NullabilityProblemKind<?> kind = problem.getKind();
            if (expression == null) {
                unchanged.add(problem);
                continue;
            }
            if (innerClassNPE == kind || callNPE == kind || arrayAccessNPE == kind || fieldAccessNPE == kind) {
                boolean unknown = problem.hasUnknownNullability();
                problem = problem.withExpression(NullabilityProblemKind.findTopExpression(expression));
                if (unknown) {
                    problem = problem.makeUnknown();
                }
                unchanged.add(problem);
                continue;
            }
            while ((ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)(top = NullabilityProblemKind.skipParenthesesAndObjectCastsUp(expression)).getParent(), PsiConditionalExpression.class)) != null) {
                NullabilityProblem otherBranchProblem;
                PsiExpression otherBranch = null;
                if (ternary.getThenExpression() == top) {
                    otherBranch = ternary.getElseExpression();
                } else if (ternary.getElseExpression() == top) {
                    otherBranch = ternary.getThenExpression();
                }
                if (otherBranch == null || (otherBranchProblem = (NullabilityProblem)expressionToProblem.remove(otherBranch = NullabilityProblemKind.skipParenthesesAndObjectCastsDown(otherBranch))) == null) break;
                expression = ternary;
                boolean unknown = problem.hasUnknownNullability() && otherBranchProblem.hasUnknownNullability();
                problem = problem.withExpression((PsiExpression)ternary);
                if (!unknown) continue;
                problem = problem.makeUnknown();
            }
            expressionToProblem.put(expression, problem);
        }
        return StreamEx.of((Object[])new Collection[]{unchanged, expressionToProblem.values()}).toFlatList(Function.identity());
    }

    private static PsiExpression skipParenthesesAndObjectCastsDown(PsiExpression expression) {
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiTypeCastExpression) || expression.getType() instanceof PsiPrimitiveType) break;
            expression = ((PsiTypeCastExpression)expression).getOperand();
        }
        return expression;
    }

    @NotNull
    private static PsiExpression skipParenthesesAndObjectCastsUp(PsiExpression expression) {
        PsiElement parent;
        PsiExpression top = expression;
        while ((parent = top.getParent()) instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression && !(((PsiTypeCastExpression)parent).getType() instanceof PsiPrimitiveType)) {
            top = (PsiExpression)parent;
        }
        PsiExpression psiExpression = top;
        if (psiExpression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(28);
        }
        return psiExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24, 25, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alwaysNullMessage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalMessage";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionList";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullabilityProblemKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullabilityProblemKind";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopExpression";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "skipParenthesesAndObjectCastsUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionListProblem";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParameterProblem";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "assignableTypeParameter";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getArrayInitializerProblem";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchBlockProblem";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentProblem";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findTopExpression";
                break;
            }
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createUnboxingProblem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 24, 25, 28 -> new IllegalStateException(string);
        };
    }

    public static final class NullabilityProblem<T extends PsiElement>
    extends JvmDfaProblem<T> {
        @NotNull
        private final NullabilityProblemKind<T> myKind;
        @Nullable
        private final PsiExpression myDereferencedExpression;
        private final boolean myFromUnknown;

        NullabilityProblem(@NotNull NullabilityProblemKind<T> kind, @NotNull T anchor, @Nullable PsiExpression dereferencedExpression, boolean unknown) {
            if (kind == null) {
                NullabilityProblem.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                NullabilityProblem.$$$reportNull$$$0(1);
            }
            super(anchor);
            this.myKind = kind;
            this.myDereferencedExpression = dereferencedExpression;
            this.myFromUnknown = unknown;
        }

        @Nullable
        public String thrownException() {
            return this.myKind.myException;
        }

        @Nullable
        public PsiExpression getDereferencedExpression() {
            return this.myDereferencedExpression;
        }

        public boolean hasUnknownNullability() {
            return this.myFromUnknown;
        }

        public boolean isAlwaysNull(boolean ignoreAssertions) {
            PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)this.getDereferencedExpression());
            return expression != null && (ExpressionUtils.isNullLiteral(expression) || CommonDataflow.getDfType(expression, ignoreAssertions) == DfTypes.NULL);
        }

        @NotNull
        @InspectionMessage
        public String getMessage(boolean ignoreAssertions) {
            if (this.myKind.myAlwaysNullMessage == null || this.myKind.myNormalMessage == null) {
                throw new IllegalStateException("This problem kind has no message associated: " + String.valueOf(this.myKind));
            }
            String suffix = this.myFromUnknown ? JavaAnalysisBundle.message((String)"dataflow.message.unknown.nullability", (Object[])new Object[0]) : "";
            Supplier<@Nls String> msg = this.isAlwaysNull(ignoreAssertions) ? this.myKind.myAlwaysNullMessage : this.myKind.myNormalMessage;
            String string = msg.get() + suffix;
            if (string == null) {
                NullabilityProblem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public NullabilityProblemKind<T> getKind() {
            NullabilityProblemKind<T> nullabilityProblemKind = this.myKind;
            if (nullabilityProblemKind == null) {
                NullabilityProblem.$$$reportNull$$$0(3);
            }
            return nullabilityProblemKind;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NullabilityProblem)) {
                return false;
            }
            NullabilityProblem problem = (NullabilityProblem)o;
            return this.myKind.equals(problem.myKind) && this.getAnchor().equals(problem.getAnchor()) && Objects.equals(this.myDereferencedExpression, problem.myDereferencedExpression);
        }

        public int hashCode() {
            return Objects.hash(this.myKind, this.getAnchor(), this.myDereferencedExpression);
        }

        public String toString() {
            return "[" + String.valueOf(this.myKind) + "] " + this.getAnchor().getText();
        }

        public NullabilityProblem<T> withExpression(PsiExpression expression) {
            return expression == this.myDereferencedExpression ? this : new NullabilityProblem<T>(this.myKind, this.getAnchor(), expression, false);
        }

        public NullabilityProblem<T> makeUnknown() {
            return new NullabilityProblem<T>(this.myKind, this.getAnchor(), this.myDereferencedExpression, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullabilityProblemKind$NullabilityProblem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullabilityProblemKind$NullabilityProblem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

