/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NullabilityUtil {
    public static Pair<PsiExpression, Nullability> getNullabilityFromFieldInitializers(PsiField field) {
        if (DfaPsiUtil.isFinalField((PsiVariable)field) && PsiAugmentProvider.canTrustFieldInitializer((PsiField)field)) {
            PsiExpression initializer = field.getInitializer();
            if (initializer != null) {
                return Pair.create((Object)initializer, (Object)NullabilityUtil.getExpressionNullability(initializer));
            }
            List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers(field);
            if (initializers.isEmpty()) {
                return Pair.create(null, (Object)Nullability.UNKNOWN);
            }
            for (PsiExpression expression : initializers) {
                Nullability nullability = NullabilityUtil.getExpressionNullability(expression);
                if (nullability != Nullability.NULLABLE) continue;
                return Pair.create((Object)expression, (Object)Nullability.NULLABLE);
            }
            if (DfaPsiUtil.isInitializedNotNull(field)) {
                return Pair.create((Object)((PsiExpression)ContainerUtil.getOnlyItem(initializers)), (Object)Nullability.NOT_NULL);
            }
        } else if (NullabilityUtil.isOnlyImplicitlyInitialized(field)) {
            return Pair.create(null, (Object)Nullability.NOT_NULL);
        }
        return Pair.create(null, (Object)Nullability.UNKNOWN);
    }

    private static boolean isOnlyImplicitlyInitialized(PsiField field) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)(NullabilityUtil.isImplicitlyInitializedNotNull(field) && NullabilityUtil.weAreSureThereAreNoExplicitWrites(field) ? 1 : 0), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean isImplicitlyInitializedNotNull(PsiField field) {
        return ContainerUtil.exists((Iterable)ImplicitUsageProvider.EP_NAME.getExtensionList(), p -> p.isImplicitlyNotNullInitialized((PsiElement)field));
    }

    private static boolean weAreSureThereAreNoExplicitWrites(PsiField field) {
        if (field.hasInitializer()) {
            return false;
        }
        if (!field.hasModifierProperty("private")) {
            return false;
        }
        return !VariableAccessUtils.variableIsAssigned((PsiVariable)field);
    }

    public static Nullability getExpressionNullability(@Nullable PsiExpression expression) {
        return NullabilityUtil.getExpressionNullability(expression, false);
    }

    public static Nullability getExpressionNullability(@Nullable PsiExpression expression, boolean useDataflow) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
            return Nullability.UNKNOWN;
        }
        if (PsiTypes.nullType().equals(expression.getType())) {
            return Nullability.NULLABLE;
        }
        if (expression instanceof PsiNewExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiPolyadicExpression || expression instanceof PsiFunctionalExpression || expression.getType() instanceof PsiPrimitiveType) {
            return Nullability.NOT_NULL;
        }
        boolean dumb = DumbService.isDumb((Project)expression.getProject());
        if (expression instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            if (thenExpression == null || elseExpression == null) {
                return Nullability.UNKNOWN;
            }
            PsiExpression condition = ((PsiConditionalExpression)expression).getCondition();
            PsiReferenceExpression ref = ExpressionUtils.getReferenceExpressionFromNullComparison(condition, true);
            if (ref != null && JavaPsiEquivalenceUtil.areExpressionsEquivalent((PsiExpression)ref, (PsiExpression)elseExpression)) {
                return NullabilityUtil.getExpressionNullability(thenExpression, useDataflow);
            }
            ref = ExpressionUtils.getReferenceExpressionFromNullComparison(condition, false);
            if (ref != null && JavaPsiEquivalenceUtil.areExpressionsEquivalent((PsiExpression)ref, (PsiExpression)thenExpression)) {
                return NullabilityUtil.getExpressionNullability(elseExpression, useDataflow);
            }
            if (useDataflow && !dumb) {
                return DfaNullability.toNullability(DfaNullability.fromDfType(CommonDataflow.getDfType(expression)));
            }
            Nullability left = NullabilityUtil.getExpressionNullability(thenExpression, false);
            if (left == Nullability.UNKNOWN) {
                return Nullability.UNKNOWN;
            }
            Nullability right = NullabilityUtil.getExpressionNullability(elseExpression, false);
            return left == right ? left : Nullability.UNKNOWN;
        }
        if (expression instanceof PsiTypeCastExpression) {
            return NullabilityUtil.getExpressionNullability(((PsiTypeCastExpression)expression).getOperand(), useDataflow);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            if (assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                return NullabilityUtil.getExpressionNullability(assignment.getRExpression(), useDataflow);
            }
            return Nullability.NOT_NULL;
        }
        if (useDataflow && !dumb) {
            return DfaNullability.toNullability(DfaNullability.fromDfType(CommonDataflow.getDfType(expression)));
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiElement block;
            PsiPatternVariable patternVariable;
            PsiReferenceExpression ref = (PsiReferenceExpression)expression;
            PsiElement target = ref.resolve();
            if (target instanceof PsiPatternVariable && !((patternVariable = (PsiPatternVariable)target).getPattern().getParent() instanceof PsiDeconstructionList)) {
                return Nullability.NOT_NULL;
            }
            if (dumb) {
                return Nullability.UNKNOWN;
            }
            if (!(!(target instanceof PsiLocalVariable) && !(target instanceof PsiParameter) || (block = PsiUtil.getVariableCodeBlock((PsiVariable)((PsiVariable)target), null)) != null && ControlFlowUtil.isEffectivelyFinal((PsiVariable)((PsiVariable)target), (PsiElement)block))) {
                return Nullability.UNKNOWN;
            }
            return DfaPsiUtil.getElementNullabilityForRead(expression.getType(), (PsiModifierListOwner)target);
        }
        if (expression instanceof PsiMethodCallExpression || expression instanceof PsiTemplateExpression) {
            if (dumb) {
                return Nullability.UNKNOWN;
            }
            PsiMethod method = ((PsiCall)expression).resolveMethod();
            return method != null ? DfaPsiUtil.getElementNullabilityForRead(expression.getType(), (PsiModifierListOwner)method) : Nullability.UNKNOWN;
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    public static PsiType removeTopLevelNullabilityAnnotations(@NotNull Project project, @NotNull PsiType type) {
        Object[] annotations;
        if (project == null) {
            NullabilityUtil.$$$reportNull$$$0(0);
        }
        if (type == null) {
            NullabilityUtil.$$$reportNull$$$0(1);
        }
        if ((annotations = type.getAnnotations()).length == 0) {
            PsiType psiType = type;
            if (psiType == null) {
                NullabilityUtil.$$$reportNull$$$0(2);
            }
            return psiType;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
        for (PsiAnnotation psiAnnotation : annotations) {
            if (!manager.getAnnotationNullability(psiAnnotation.getQualifiedName()).isPresent()) continue;
            PsiType psiType = type.annotate(TypeAnnotationProvider.Static.create((PsiAnnotation[])((PsiAnnotation[])((StreamEx)StreamEx.of((Object[])annotations).remove(a -> manager.getAnnotationNullability(a.getQualifiedName()).isPresent())).toArray((Object[])PsiAnnotation.EMPTY_ARRAY))));
            if (psiType == null) {
                NullabilityUtil.$$$reportNull$$$0(3);
            }
            return psiType;
        }
        PsiType psiType = type;
        if (psiType == null) {
            NullabilityUtil.$$$reportNull$$$0(4);
        }
        return psiType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullabilityUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullabilityUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTopLevelNullabilityAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeTopLevelNullabilityAnnotations";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

