/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface TypeConstraint
permits Constrained, Exact, TypeConstraints.BottomConstraint, TypeConstraints.TopConstraint {
    @NotNull
    public TypeConstraint join(@NotNull TypeConstraint var1);

    @Nullable
    public TypeConstraint tryJoinExactly(TypeConstraint var1);

    @NotNull
    public TypeConstraint meet(@NotNull TypeConstraint var1);

    public boolean isSuperConstraintOf(@NotNull TypeConstraint var1);

    @Nullable
    default public TypeConstraint tryNegate() {
        return null;
    }

    @Nullable
    default public PsiType getPsiType(Project project) {
        return null;
    }

    @NotNull
    @NlsSafe
    default public String getPresentationText(@Nullable PsiType type) {
        String string = this.toShortString();
        if (string == null) {
            TypeConstraint.$$$reportNull$$$0(0);
        }
        return string;
    }

    default public boolean isExact() {
        return false;
    }

    default public boolean isExact(@NotNull String className) {
        if (className == null) {
            TypeConstraint.$$$reportNull$$$0(1);
        }
        return false;
    }

    default public boolean isSingleton() {
        return false;
    }

    public boolean isSubtypeOf(@NotNull String var1);

    default public boolean isComparedByEquals() {
        return false;
    }

    default public boolean isResolved() {
        return true;
    }

    @Nullable
    @Nls
    default public String getAssignabilityExplanation(@NotNull TypeConstraint otherType, boolean expectedAssignable, @Nls String elementTitle) {
        if (otherType == null) {
            TypeConstraint.$$$reportNull$$$0(2);
        }
        return null;
    }

    default public StreamEx<Exact> instanceOfTypes() {
        return StreamEx.empty();
    }

    default public StreamEx<Exact> notInstanceOfTypes() {
        return StreamEx.empty();
    }

    @NotNull
    default public DfType asDfType() {
        Object object = this == TypeConstraints.BOTTOM ? DfType.BOTTOM : DfTypes.customObject(this, DfaNullability.UNKNOWN, Mutability.UNKNOWN, null, DfType.BOTTOM);
        if (object == null) {
            TypeConstraint.$$$reportNull$$$0(3);
        }
        return object;
    }

    default public String toShortString() {
        return this.toString();
    }

    @NotNull
    default public TypeConstraint arrayOf() {
        TypeConstraint typeConstraint = TypeConstraints.TOP;
        if (typeConstraint == null) {
            TypeConstraint.$$$reportNull$$$0(4);
        }
        return typeConstraint;
    }

    @NotNull
    default public DfType getArrayComponentType() {
        DfType dfType = DfType.BOTTOM;
        if (dfType == null) {
            TypeConstraint.$$$reportNull$$$0(5);
        }
        return dfType;
    }

    default public boolean isArray() {
        return false;
    }

    default public DfType getUnboxedType() {
        return DfType.BOTTOM;
    }

    default public boolean isPrimitiveWrapper() {
        return false;
    }

    default public boolean isEnum() {
        return false;
    }

    @Nullable
    default public PsiEnumConstant getEnumConstant(int ordinal) {
        return null;
    }

    @NotNull
    default public TypeConstraint convert(TypeConstraints.TypeConstraintFactory factory) {
        TypeConstraint typeConstraint = this;
        if (typeConstraint == null) {
            TypeConstraint.$$$reportNull$$$0(6);
        }
        return typeConstraint;
    }

    default public String debugInfo() {
        return this.toString();
    }

    @NotNull
    public static TypeConstraint fromDfType(@NotNull DfType type) {
        if (type == null) {
            TypeConstraint.$$$reportNull$$$0(7);
        }
        TypeConstraint typeConstraint = type instanceof DfReferenceType ? ((DfReferenceType)type).getConstraint() : (type == DfType.BOTTOM ? TypeConstraints.BOTTOM : TypeConstraints.TOP);
        if (typeConstraint == null) {
            TypeConstraint.$$$reportNull$$$0(8);
        }
        return typeConstraint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asDfType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayOf";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayComponentType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDfType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isExact";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAssignabilityExplanation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromDfType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 7 -> new IllegalArgumentException(string);
        };
    }

    public static final class Constrained
    implements TypeConstraint {
        private static final Set<String> WRAPPER_SUPER_TYPES = Set.of("java.lang.Object", "java.lang.Number", "java.io.Serializable", "java.lang.Comparable", "java.lang.constant.Constable", "java.lang.constant.ConstantDesc");
        @NotNull
        private final Set<Exact> myInstanceOf;
        @NotNull
        private final Set<Exact> myNotInstanceOf;

        Constrained(@NotNull Set<Exact> instanceOf, @NotNull Set<Exact> notInstanceOf) {
            if (instanceOf == null) {
                Constrained.$$$reportNull$$$0(0);
            }
            if (notInstanceOf == null) {
                Constrained.$$$reportNull$$$0(1);
            }
            assert (!instanceOf.isEmpty() || !notInstanceOf.isEmpty());
            this.myInstanceOf = instanceOf;
            this.myNotInstanceOf = notInstanceOf;
        }

        @Override
        public boolean isResolved() {
            return ContainerUtil.and(this.myInstanceOf, TypeConstraint::isResolved);
        }

        @Override
        @Nullable
        public PsiType getPsiType(Project project) {
            PsiType[] conjuncts = (PsiType[])StreamEx.of(this.myInstanceOf).map(exact -> exact.getPsiType(project)).nonNull().toArray((Object[])PsiType.EMPTY_ARRAY);
            return conjuncts.length == 0 ? null : PsiIntersectionType.createIntersection((boolean)true, (PsiType[])conjuncts);
        }

        @Override
        @Nullable
        public TypeConstraint tryNegate() {
            if (this.myInstanceOf.size() == 1 && this.myNotInstanceOf.isEmpty()) {
                return this.myInstanceOf.iterator().next().notInstanceOf();
            }
            if (this.myNotInstanceOf.size() == 1 && this.myInstanceOf.isEmpty()) {
                return this.myNotInstanceOf.iterator().next().instanceOf();
            }
            return null;
        }

        @Override
        @NotNull
        public TypeConstraint join(@NotNull TypeConstraint other) {
            if (other == null) {
                Constrained.$$$reportNull$$$0(2);
            }
            if (this.isSuperConstraintOf(other)) {
                Constrained constrained = this;
                if (constrained == null) {
                    Constrained.$$$reportNull$$$0(3);
                }
                return constrained;
            }
            if (other.isSuperConstraintOf(this)) {
                TypeConstraint typeConstraint = other;
                if (typeConstraint == null) {
                    Constrained.$$$reportNull$$$0(4);
                }
                return typeConstraint;
            }
            if (other instanceof Constrained) {
                return this.joinWithConstrained((Constrained)other);
            }
            if (other instanceof Exact) {
                return this.joinWithConstrained(new Constrained(Collections.singleton((Exact)other), Collections.emptySet()));
            }
            TypeConstraint typeConstraint = TypeConstraints.TOP;
            if (typeConstraint == null) {
                Constrained.$$$reportNull$$$0(5);
            }
            return typeConstraint;
        }

        @Override
        @Nullable
        public TypeConstraint tryJoinExactly(TypeConstraint other) {
            if (this.isSuperConstraintOf(other)) {
                return this;
            }
            if (other.isSuperConstraintOf(this)) {
                return other;
            }
            if (other instanceof Constrained) {
                int size2;
                Constrained constrained = (Constrained)other;
                if (this.myInstanceOf.equals(constrained.myInstanceOf)) {
                    return this.joinWithConstrained(constrained);
                }
                int size1 = this.myInstanceOf.size() + this.myNotInstanceOf.size();
                if (size1 == (size2 = constrained.myInstanceOf.size() + constrained.myNotInstanceOf.size()) && size1 >= 3) {
                    HashSet<Exact> diff;
                    if (this.myInstanceOf.containsAll(constrained.myInstanceOf) && constrained.myNotInstanceOf.containsAll(this.myNotInstanceOf)) {
                        diff = new HashSet<Exact>(this.myInstanceOf);
                        diff.removeAll(constrained.myInstanceOf);
                        if (diff.size() == 1 && constrained.myNotInstanceOf.containsAll(diff)) {
                            return new Constrained(constrained.myInstanceOf, this.myNotInstanceOf);
                        }
                    }
                    if (constrained.myInstanceOf.containsAll(this.myInstanceOf) && this.myNotInstanceOf.containsAll(constrained.myNotInstanceOf)) {
                        diff = new HashSet<Exact>(constrained.myInstanceOf);
                        diff.removeAll(this.myInstanceOf);
                        if (diff.size() == 1 && this.myNotInstanceOf.containsAll(diff)) {
                            return new Constrained(this.myInstanceOf, constrained.myNotInstanceOf);
                        }
                    }
                }
            }
            return null;
        }

        @NotNull
        private TypeConstraint joinWithConstrained(@NotNull Constrained other) {
            Set<Exact> instanceOfTypes;
            if (other == null) {
                Constrained.$$$reportNull$$$0(6);
            }
            HashSet<Exact> notTypes = new HashSet<Exact>(this.myNotInstanceOf);
            notTypes.retainAll(other.myNotInstanceOf);
            if (this.myInstanceOf.containsAll(other.myInstanceOf)) {
                instanceOfTypes = other.myInstanceOf;
            } else if (other.myInstanceOf.containsAll(this.myInstanceOf)) {
                instanceOfTypes = this.myInstanceOf;
            } else {
                instanceOfTypes = Constrained.withSuper(this.myInstanceOf);
                instanceOfTypes.retainAll(Constrained.withSuper(other.myInstanceOf));
            }
            TypeConstraint constraint = TypeConstraints.TOP;
            for (Exact type : instanceOfTypes) {
                constraint = constraint.meet(type.instanceOf());
            }
            for (Exact type : notTypes) {
                constraint = constraint.meet(type.notInstanceOf());
            }
            TypeConstraint typeConstraint = constraint;
            if (typeConstraint == null) {
                Constrained.$$$reportNull$$$0(7);
            }
            return typeConstraint;
        }

        @NotNull
        private static Set<Exact> withSuper(@NotNull Set<Exact> instanceofValues) {
            if (instanceofValues == null) {
                Constrained.$$$reportNull$$$0(8);
            }
            Set set = StreamEx.of(instanceofValues).flatMap(Exact::superTypes).append(instanceofValues).toSet();
            if (set == null) {
                Constrained.$$$reportNull$$$0(9);
            }
            return set;
        }

        @Nullable
        private Constrained withInstanceofValue(@NotNull Exact type) {
            if (type == null) {
                Constrained.$$$reportNull$$$0(10);
            }
            if (this.myInstanceOf.contains(type)) {
                return this;
            }
            for (Exact notInst : this.myNotInstanceOf) {
                if (!notInst.isAssignableFrom(type)) continue;
                return null;
            }
            HashSet<Exact> newInstanceof = new HashSet<Exact>(this.myInstanceOf);
            for (Exact alreadyInstanceof : this.myInstanceOf) {
                if (type.isAssignableFrom(alreadyInstanceof)) {
                    return this;
                }
                if (!type.isConvertibleFrom(alreadyInstanceof)) {
                    return null;
                }
                if (!alreadyInstanceof.isAssignableFrom(type)) continue;
                newInstanceof.remove(alreadyInstanceof);
            }
            newInstanceof.add(type);
            return new Constrained(newInstanceof, this.myNotInstanceOf);
        }

        @Nullable
        private Constrained withNotInstanceofValue(Exact type) {
            if (this.myNotInstanceOf.contains(type)) {
                return this;
            }
            for (Exact dfaTypeValue : this.myInstanceOf) {
                if (!type.isAssignableFrom(dfaTypeValue)) continue;
                return null;
            }
            HashSet<Exact> newNotInstanceof = new HashSet<Exact>(this.myNotInstanceOf);
            for (Exact alreadyNotInstanceof : this.myNotInstanceOf) {
                if (alreadyNotInstanceof.isAssignableFrom(type)) {
                    return this;
                }
                if (!type.isAssignableFrom(alreadyNotInstanceof)) continue;
                newNotInstanceof.remove(alreadyNotInstanceof);
            }
            newNotInstanceof.add(type);
            return new Constrained(this.myInstanceOf, newNotInstanceof);
        }

        @Override
        @NotNull
        public TypeConstraint meet(@NotNull TypeConstraint other) {
            if (other == null) {
                Constrained.$$$reportNull$$$0(11);
            }
            if (this.isSuperConstraintOf(other)) {
                TypeConstraint typeConstraint = other;
                if (typeConstraint == null) {
                    Constrained.$$$reportNull$$$0(12);
                }
                return typeConstraint;
            }
            if (other.isSuperConstraintOf(this)) {
                Constrained constrained = this;
                if (constrained == null) {
                    Constrained.$$$reportNull$$$0(13);
                }
                return constrained;
            }
            if (!(other instanceof Constrained)) {
                TypeConstraint typeConstraint = TypeConstraints.BOTTOM;
                if (typeConstraint == null) {
                    Constrained.$$$reportNull$$$0(14);
                }
                return typeConstraint;
            }
            Constrained right = (Constrained)other;
            Constrained result = this;
            for (Exact type : right.myInstanceOf) {
                if ((result = result.withInstanceofValue(type)) != null) continue;
                TypeConstraint typeConstraint = TypeConstraints.BOTTOM;
                if (typeConstraint == null) {
                    Constrained.$$$reportNull$$$0(15);
                }
                return typeConstraint;
            }
            for (Exact type : right.myNotInstanceOf) {
                if ((result = result.withNotInstanceofValue(type)) != null) continue;
                TypeConstraint typeConstraint = TypeConstraints.BOTTOM;
                if (typeConstraint == null) {
                    Constrained.$$$reportNull$$$0(16);
                }
                return typeConstraint;
            }
            Constrained constrained = result;
            if (constrained == null) {
                Constrained.$$$reportNull$$$0(17);
            }
            return constrained;
        }

        @Override
        public boolean isSuperConstraintOf(@NotNull TypeConstraint other) {
            if (other == null) {
                Constrained.$$$reportNull$$$0(18);
            }
            if (other == TypeConstraints.BOTTOM) {
                return true;
            }
            if (other instanceof Constrained) {
                Constrained that = (Constrained)other;
                if (!that.myNotInstanceOf.containsAll(this.myNotInstanceOf)) {
                    if (that.myInstanceOf.isEmpty()) {
                        return false;
                    }
                    for (Exact thisNotType : this.myNotInstanceOf) {
                        if (that.myNotInstanceOf.contains(thisNotType)) continue;
                        for (Exact thatType : that.myInstanceOf) {
                            if (!thisNotType.isConvertibleFrom(thatType)) continue;
                            return false;
                        }
                    }
                }
                if (that.myInstanceOf.containsAll(this.myInstanceOf)) {
                    return true;
                }
                if (that.myInstanceOf.isEmpty()) {
                    return this.myInstanceOf.isEmpty();
                }
                for (Exact thatType : that.myInstanceOf) {
                    for (Exact thisType : this.myInstanceOf) {
                        if (thisType.isAssignableFrom(thatType)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (other instanceof Exact) {
                Exact otherType = (Exact)other;
                for (Exact thisInstance : this.myInstanceOf) {
                    if (thisInstance.isAssignableFrom(otherType)) continue;
                    return false;
                }
                for (Exact thisNotInstance : this.myNotInstanceOf) {
                    if (!thisNotInstance.isAssignableFrom(otherType)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public String getAssignabilityExplanation(@NotNull TypeConstraint otherType, boolean expectedAssignable, @Nls String elementTitle) {
            Exact exact;
            if (otherType == null) {
                Constrained.$$$reportNull$$$0(19);
            }
            if ((exact = (Exact)((Optional)otherType.instanceOfTypes().collect(MoreCollectors.onlyOne())).orElse(null)) == null) {
                return null;
            }
            if (expectedAssignable) {
                for (Exact inst : this.myInstanceOf) {
                    if (!exact.isAssignableFrom(inst)) continue;
                    if (exact == inst) {
                        return JavaAnalysisBundle.message((String)"type.constraint.assignability.explanation.exact", (Object[])new Object[]{elementTitle, inst.toShortString()});
                    }
                    return JavaAnalysisBundle.message((String)"type.constraint.assignability.explanation.subtype.of.subtype", (Object[])new Object[]{elementTitle, inst.toShortString(), exact.toShortString()});
                }
            } else {
                for (Exact notInst : this.myNotInstanceOf) {
                    if (!notInst.isAssignableFrom(exact)) continue;
                    if (exact == notInst) {
                        return JavaAnalysisBundle.message((String)"type.constraint.assignability.explanation.not.instance.of", (Object[])new Object[]{elementTitle, notInst.toShortString()});
                    }
                    return JavaAnalysisBundle.message((String)"type.constraint.assignability.explanation.not.instance.of.supertype", (Object[])new Object[]{elementTitle, notInst.toShortString(), exact.toShortString()});
                }
                for (Exact inst : this.myInstanceOf) {
                    if (exact.isConvertibleFrom(inst)) continue;
                    return JavaAnalysisBundle.message((String)"type.constraint.assignability.explanation.definitely.inconvertible", (Object[])new Object[]{elementTitle, inst.toShortString(), exact.toShortString()});
                }
            }
            return null;
        }

        @Override
        public StreamEx<Exact> instanceOfTypes() {
            return StreamEx.of(this.myInstanceOf);
        }

        @Override
        public StreamEx<Exact> notInstanceOfTypes() {
            return StreamEx.of(this.myNotInstanceOf);
        }

        @Override
        @NotNull
        public DfType getArrayComponentType() {
            DfType dfType = this.instanceOfTypes().map(TypeConstraint::getArrayComponentType).reduce(DfType::meet).orElse(DfType.BOTTOM);
            if (dfType == null) {
                Constrained.$$$reportNull$$$0(20);
            }
            return dfType;
        }

        @Override
        public DfType getUnboxedType() {
            return this.instanceOfTypes().allMatch(t -> WRAPPER_SUPER_TYPES.contains(t.toString())) ? DfType.TOP : DfType.BOTTOM;
        }

        @Override
        @NotNull
        public TypeConstraint arrayOf() {
            TypeConstraint constraint = this.instanceOfTypes().map(Exact::arrayOf).reduce(TypeConstraint::meet).orElse(TypeConstraints.EXACTLY_OBJECT.arrayOf());
            TypeConstraint typeConstraint = constraint instanceof Exact ? ((Exact)constraint).instanceOf() : constraint;
            if (typeConstraint == null) {
                Constrained.$$$reportNull$$$0(21);
            }
            return typeConstraint;
        }

        @Override
        public boolean isArray() {
            return this.instanceOfTypes().anyMatch(TypeConstraint::isArray);
        }

        @Override
        public boolean isEnum() {
            return this.myInstanceOf.size() == 1 && this.myInstanceOf.iterator().next().isEnum();
        }

        @Override
        @Nullable
        public PsiEnumConstant getEnumConstant(int ordinal) {
            return this.myInstanceOf.size() == 1 ? this.myInstanceOf.iterator().next().getEnumConstant(ordinal) : null;
        }

        @Override
        @NotNull
        public TypeConstraint convert(TypeConstraints.TypeConstraintFactory factory) {
            Set instanceOf = ContainerUtil.map2LinkedSet(this.myInstanceOf, exact -> exact.convert(factory));
            Set notInstanceOf = ContainerUtil.map2LinkedSet(this.myNotInstanceOf, exact -> exact.convert(factory));
            return new Constrained(instanceOf, notInstanceOf);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constrained that = (Constrained)o;
            return Objects.equals(this.myInstanceOf, that.myInstanceOf) && Objects.equals(this.myNotInstanceOf, that.myNotInstanceOf);
        }

        public int hashCode() {
            return 31 * this.myInstanceOf.hashCode() + this.myNotInstanceOf.hashCode();
        }

        @Override
        public String debugInfo() {
            return EntryStream.of((Object)"instanceof ", this.myInstanceOf, (Object)"not instanceof ", this.myNotInstanceOf).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> StreamEx.of((Collection)set).map(e -> e.debugInfo()).joining((CharSequence)", ", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)" ");
        }

        @NotNull
        public String toString() {
            String string = EntryStream.of((Object)"instanceof ", this.myInstanceOf, (Object)"not instanceof ", this.myNotInstanceOf).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> StreamEx.of((Collection)set).joining((CharSequence)", ", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)" ");
            if (string == null) {
                Constrained.$$$reportNull$$$0(22);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPresentationText(@Nullable PsiType type) {
            Exact exact;
            Set instanceOfTypes = this.myInstanceOf;
            Exact exact2 = exact = type == null ? null : (Exact)ObjectUtils.tryCast((Object)TypeConstraints.exact(type), Exact.class);
            if (exact != null) {
                instanceOfTypes = StreamEx.of(instanceOfTypes).without((Object)exact).toSet();
            }
            String string = EntryStream.of((Object)"instanceof ", (Object)instanceOfTypes, (Object)"not instanceof ", this.myNotInstanceOf).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> ((StreamEx)StreamEx.of((Collection)set).map(Exact::toShortString).sorted()).joining((CharSequence)", ", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)"\n");
            if (string == null) {
                Constrained.$$$reportNull$$$0(23);
            }
            return string;
        }

        @Override
        public boolean isSubtypeOf(@NotNull String className) {
            if (className == null) {
                Constrained.$$$reportNull$$$0(24);
            }
            return this.instanceOfTypes().anyMatch(ex -> ex.isSubtypeOf(className));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 7, 9, 12, 13, 14, 15, 16, 17, 20, 21, 22, 23 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instanceOf";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notInstanceOf";
                    break;
                }
                case 2: 
                case 6: 
                case 11: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraint$Constrained";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instanceofValues";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherType";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraint$Constrained";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "joinWithConstrained";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withSuper";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArrayComponentType";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "arrayOf";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "joinWithConstrained";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "withSuper";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "withInstanceofValue";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuperConstraintOf";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getAssignabilityExplanation";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "isSubtypeOf";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 7, 9, 12, 13, 14, 15, 16, 17, 20, 21, 22, 23 -> new IllegalStateException(string);
            };
        }
    }

    public static sealed interface Exact
    extends TypeConstraint
    permits TypeConstraints.ArraySuperInterface, TypeConstraints.ExactArray, TypeConstraints.ExactClass, TypeConstraints.ExactObject, TypeConstraints.ExactSubclass, TypeConstraints.PrimitiveArray, TypeConstraints.Unresolved {
        @Override
        @NotNull
        default public TypeConstraint join(@NotNull TypeConstraint other) {
            if (other == null) {
                Exact.$$$reportNull$$$0(0);
            }
            if (other == TypeConstraints.BOTTOM || this.equals(other)) {
                Exact exact = this;
                if (exact == null) {
                    Exact.$$$reportNull$$$0(1);
                }
                return exact;
            }
            if (other == TypeConstraints.TOP) {
                TypeConstraint typeConstraint = other;
                if (typeConstraint == null) {
                    Exact.$$$reportNull$$$0(2);
                }
                return typeConstraint;
            }
            TypeConstraint typeConstraint = new Constrained(Collections.singleton(this), Collections.emptySet()).join(other);
            if (typeConstraint == null) {
                Exact.$$$reportNull$$$0(3);
            }
            return typeConstraint;
        }

        @Override
        @Nullable
        default public TypeConstraint tryJoinExactly(TypeConstraint other) {
            if (other == TypeConstraints.BOTTOM || this.equals(other)) {
                return this;
            }
            if (other == TypeConstraints.TOP) {
                return other;
            }
            return new Constrained(Collections.singleton(this), Collections.emptySet()).tryJoinExactly(other);
        }

        @Override
        @NotNull
        default public TypeConstraint meet(@NotNull TypeConstraint other) {
            if (other == null) {
                Exact.$$$reportNull$$$0(4);
            }
            if (this.equals(other) || other.isSuperConstraintOf(this)) {
                Exact exact = this;
                if (exact == null) {
                    Exact.$$$reportNull$$$0(5);
                }
                return exact;
            }
            TypeConstraint typeConstraint = TypeConstraints.BOTTOM;
            if (typeConstraint == null) {
                Exact.$$$reportNull$$$0(6);
            }
            return typeConstraint;
        }

        public boolean isFinal();

        @Override
        @NotNull
        default public Exact arrayOf() {
            return new TypeConstraints.ExactArray(this);
        }

        @Override
        default public boolean isExact() {
            return true;
        }

        @Override
        default public boolean isExact(@NotNull String className) {
            if (className == null) {
                Exact.$$$reportNull$$$0(7);
            }
            return className.equals(this.toString());
        }

        @Override
        default public boolean isSubtypeOf(@NotNull String className) {
            if (className == null) {
                Exact.$$$reportNull$$$0(8);
            }
            return this.isExact(className) || this.superTypes().anyMatch(st -> st.isExact(className));
        }

        default public boolean canBeInstantiated() {
            return true;
        }

        public StreamEx<Exact> superTypes();

        public boolean isAssignableFrom(@NotNull Exact var1);

        public boolean isConvertibleFrom(@NotNull Exact var1);

        @Override
        default public StreamEx<Exact> instanceOfTypes() {
            return StreamEx.of((Object)this);
        }

        @Override
        default public String getAssignabilityExplanation(@NotNull TypeConstraint otherType, boolean expectedAssignable, @Nls String elementTitle) {
            Exact exact;
            if (otherType == null) {
                Exact.$$$reportNull$$$0(9);
            }
            if ((exact = (Exact)((Optional)otherType.instanceOfTypes().collect(MoreCollectors.onlyOne())).orElse(null)) == null) {
                return null;
            }
            boolean actual = exact.isAssignableFrom(this);
            if (actual != expectedAssignable) {
                return null;
            }
            if (expectedAssignable) {
                if (this.equals(exact)) {
                    return JavaAnalysisBundle.message((String)"type.constraint.assignability.explanation.exact", (Object[])new Object[]{elementTitle, this.toShortString()});
                }
                return JavaAnalysisBundle.message((String)"type.constraint.assignability.explanation.exact.subtype", (Object[])new Object[]{elementTitle, this.toShortString(), exact.toShortString()});
            }
            return JavaAnalysisBundle.message((String)"type.constraint.assignability.explanation.exact.not.subtype", (Object[])new Object[]{elementTitle, this.toShortString(), exact.toShortString()});
        }

        @Override
        default public boolean isSuperConstraintOf(@NotNull TypeConstraint other) {
            if (other == null) {
                Exact.$$$reportNull$$$0(10);
            }
            return other == TypeConstraints.BOTTOM || this.equals(other);
        }

        @Override
        default public TypeConstraint tryNegate() {
            return this.isFinal() ? this.notInstanceOf() : null;
        }

        @NotNull
        default public TypeConstraint instanceOf() {
            if (this.isFinal()) {
                TypeConstraint typeConstraint = this.canBeInstantiated() ? this : TypeConstraints.BOTTOM;
                if (typeConstraint == null) {
                    Exact.$$$reportNull$$$0(11);
                }
                return typeConstraint;
            }
            return new Constrained(Collections.singleton(this), Collections.emptySet());
        }

        @NotNull
        default public TypeConstraint notInstanceOf() {
            return new Constrained(Collections.emptySet(), Collections.singleton(this));
        }

        @Override
        default public String toShortString() {
            return StringUtil.getShortName((String)this.toString());
        }

        @Override
        default public String debugInfo() {
            return this.toString() + "[" + this.superTypes().joining((CharSequence)",") + "]";
        }

        @Override
        @NotNull
        default public String getPresentationText(@Nullable PsiType type) {
            Object object = type != null && TypeConstraints.exact(type).equals(this) ? "" : "exactly " + this.toShortString();
            if (object == null) {
                Exact.$$$reportNull$$$0(12);
            }
            return object;
        }

        @Override
        @NotNull
        default public Exact convert(TypeConstraints.TypeConstraintFactory factory) {
            Exact exact = this;
            if (exact == null) {
                Exact.$$$reportNull$$$0(13);
            }
            return exact;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 5, 6, 11, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraint$Exact";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraint$Exact";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instanceOf";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isExact";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isSubtypeOf";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getAssignabilityExplanation";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuperConstraintOf";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 5, 6, 11, 12, 13 -> new IllegalStateException(string);
            };
        }
    }
}

