/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.inst.ArrayStoreInstruction;
import com.intellij.codeInspection.dataFlow.jvm.problems.ArrayIndexProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.ArrayStoreProblem;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaArrayStoreInstruction
extends ArrayStoreInstruction {
    @NotNull
    private final PsiArrayAccessExpression myExpression;
    @Nullable
    private final PsiExpression myValueExpression;

    public JavaArrayStoreInstruction(@NotNull PsiArrayAccessExpression expression, @Nullable PsiExpression valueExpression, @Nullable DfaControlTransferValue outOfBoundsTransfer, @Nullable VariableDescriptor staticVariable) {
        if (expression == null) {
            JavaArrayStoreInstruction.$$$reportNull$$$0(0);
        }
        super(JavaArrayStoreInstruction.createAnchor(expression), new ArrayIndexProblem(expression), outOfBoundsTransfer, staticVariable);
        this.myExpression = expression;
        this.myValueExpression = valueExpression;
    }

    @Nullable
    private static JavaExpressionAnchor createAnchor(@NotNull PsiArrayAccessExpression expression) {
        PsiAssignmentExpression assignment;
        if (expression == null) {
            JavaArrayStoreInstruction.$$$reportNull$$$0(1);
        }
        return (assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent()), PsiAssignmentExpression.class)) == null ? null : new JavaExpressionAnchor((PsiExpression)assignment);
    }

    @Override
    @NotNull
    public Instruction bindToFactory(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            JavaArrayStoreInstruction.$$$reportNull$$$0(2);
        }
        DfaControlTransferValue transfer = this.myOutOfBoundsTransfer == null ? null : this.myOutOfBoundsTransfer.bindToFactory(factory);
        return new JavaArrayStoreInstruction(this.myExpression, this.myValueExpression, transfer, this.myStaticVariable);
    }

    @Override
    protected void checkArrayElementAssignability(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState memState, @NotNull DfaValue dfaSource, @NotNull DfaValue qualifier) {
        if (interpreter == null) {
            JavaArrayStoreInstruction.$$$reportNull$$$0(3);
        }
        if (memState == null) {
            JavaArrayStoreInstruction.$$$reportNull$$$0(4);
        }
        if (dfaSource == null) {
            JavaArrayStoreInstruction.$$$reportNull$$$0(5);
        }
        if (qualifier == null) {
            JavaArrayStoreInstruction.$$$reportNull$$$0(6);
        }
        if (this.myValueExpression == null) {
            return;
        }
        PsiType rCodeType = this.myValueExpression.getType();
        PsiType lCodeType = this.myExpression.getType();
        if (rCodeType == null || lCodeType == null || !TypeConversionUtil.areTypesConvertible((PsiType)rCodeType, (PsiType)lCodeType)) {
            return;
        }
        DfType toType = TypeConstraint.fromDfType(memState.getDfType(qualifier)).getArrayComponentType();
        if (toType == DfType.BOTTOM) {
            return;
        }
        DfType fromType = memState.getDfType(dfaSource);
        DfType meet = fromType.meet(toType);
        Project project = interpreter.getFactory().getProject();
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myValueExpression, PsiAssignmentExpression.class);
        PsiType psiFromType = TypeConstraint.fromDfType(fromType).getPsiType(project);
        PsiType psiToType = TypeConstraint.fromDfType(toType).getPsiType(project);
        if (assignmentExpression == null || psiFromType == null || psiToType == null) {
            return;
        }
        interpreter.getListener().onCondition((UnsatisfiedConditionProblem)new ArrayStoreProblem(assignmentExpression, psiFromType, psiToType), dfaSource, meet == DfType.BOTTOM ? ThreeState.YES : ThreeState.UNSURE, memState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaSource";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/JavaArrayStoreInstruction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createAnchor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindToFactory";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArrayElementAssignability";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

