/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.jvm;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.FieldChecker;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfBooleanConstantType;
import com.intellij.codeInspection.dataFlow.types.DfBooleanType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfStreamStateType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public enum SpecialField implements DerivedVariableDescriptor
{
    ARRAY_LENGTH("length", "special.field.array.length", true){

        @Override
        public boolean isMyQualifierType(DfType type) {
            return TypeConstraint.fromDfType(type).isArray();
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiField && "length".equals(accessor.getName()) && PsiUtil.isArrayClass((PsiElement)accessor.getContainingClass());
        }

        @NotNull
        public DfType getInitialDfType(@NotNull DfaVariableValue thisValue, @Nullable PsiElement context) {
            if (thisValue == null) {
                1.$$$reportNull$$$0(0);
            }
            DfType dfType = this.getDfType(thisValue.getQualifier()).meet(1.fromInitializer(thisValue, context, this::fromInitializer));
            if (dfType == null) {
                1.$$$reportNull$$$0(1);
            }
            return dfType;
        }

        @NotNull
        DfType fromInitializer(PsiExpression initializer) {
            if (initializer instanceof PsiArrayInitializerExpression) {
                DfIntConstantType dfIntConstantType = DfTypes.intValue(((PsiArrayInitializerExpression)initializer).getInitializerCount());
                if (dfIntConstantType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return dfIntConstantType;
            }
            if (initializer instanceof PsiNewExpression) {
                Object length;
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer();
                if (arrayInitializer != null) {
                    DfIntConstantType dfIntConstantType = DfTypes.intValue(arrayInitializer.getInitializerCount());
                    if (dfIntConstantType == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return dfIntConstantType;
                }
                PsiExpression[] dimensions = ((PsiNewExpression)initializer).getArrayDimensions();
                if (dimensions.length > 0 && (length = ExpressionUtils.computeConstantExpression(dimensions[0])) instanceof Integer) {
                    DfIntConstantType dfIntConstantType = DfTypes.intValue((Integer)length);
                    if (dfIntConstantType == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return dfIntConstantType;
                }
            }
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                1.$$$reportNull$$$0(5);
            }
            return dfType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thisValue";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialDfType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromInitializer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInitialDfType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
    ,
    STRING_LENGTH("length", "special.field.string.length", true){

        @NotNull
        public DfType getInitialDfType(@NotNull DfaVariableValue thisValue, @Nullable PsiElement context) {
            if (thisValue == null) {
                2.$$$reportNull$$$0(0);
            }
            DfType dfType = this.getDfType(thisValue.getQualifier()).meet(2.fromInitializer(thisValue, context, initializer -> this.fromConstant(ExpressionUtils.computeConstantExpression(initializer))));
            if (dfType == null) {
                2.$$$reportNull$$$0(1);
            }
            return dfType;
        }

        @Override
        public boolean isMyQualifierType(DfType type) {
            return TypeConstraint.fromDfType(type).isExact("java.lang.String");
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            if (!(accessor instanceof PsiMethod && "length".equals(accessor.getName()) && ((PsiMethod)accessor).getParameterList().isEmpty())) {
                return false;
            }
            PsiClass containingClass = accessor.getContainingClass();
            return containingClass != null && "java.lang.String".equals(containingClass.getQualifiedName());
        }

        @Override
        @NotNull
        public DfType fromConstant(@Nullable Object obj) {
            DfType dfType = obj instanceof String ? DfTypes.intValue(((String)obj).length()) : DfType.TOP;
            if (dfType == null) {
                2.$$$reportNull$$$0(2);
            }
            return dfType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thisValue";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialDfType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromConstant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInitialDfType";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
    ,
    COLLECTION_SIZE("size", "special.field.collection.size", false){
        private static final CallMatcher SIZE_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "size").parameterCount(0), CallMatcher.instanceCall("java.util.Map", "size").parameterCount(0));

        @Override
        public boolean isMyQualifierType(DfType type) {
            TypeConstraint constraint = TypeConstraint.fromDfType(type);
            return constraint.isSubtypeOf("java.util.Map") || constraint.isSubtypeOf("java.util.Collection");
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && SIZE_METHODS.methodMatches((PsiMethod)accessor);
        }

        @Override
        @NotNull
        public DfType fromConstant(@Nullable Object obj) {
            if (obj instanceof PsiField && DfaUtil.isEmptyCollectionConstantField((PsiVariable)obj)) {
                DfIntConstantType dfIntConstantType = DfTypes.intValue(0);
                if (dfIntConstantType == null) {
                    3.$$$reportNull$$$0(0);
                }
                return dfIntConstantType;
            }
            DfType dfType = super.fromConstant(obj);
            if (dfType == null) {
                3.$$$reportNull$$$0(1);
            }
            return dfType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/jvm/SpecialField$3", "fromConstant"));
        }
    }
    ,
    UNBOX("value", "special.field.unboxed.value", true){
        private static final CallMatcher UNBOXING_CALL = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.lang.Integer", "intValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Long", "longValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Short", "shortValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Byte", "byteValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Character", "charValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Boolean", "booleanValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Float", "floatValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Double", "doubleValue").parameterCount(0));

        @Override
        @NotNull
        public DfType getDfType(@Nullable DfaVariableValue qualifier) {
            if (qualifier == null) {
                DfType dfType = DfType.TOP;
                if (dfType == null) {
                    4.$$$reportNull$$$0(0);
                }
                return dfType;
            }
            TypeConstraint constraint = TypeConstraint.fromDfType(qualifier.getDfType());
            DfType dfType = constraint.getUnboxedType();
            if (dfType == null) {
                4.$$$reportNull$$$0(1);
            }
            return dfType;
        }

        @NotNull
        public DfType getFromQualifier(@NotNull DfType dfType) {
            if (dfType == null) {
                4.$$$reportNull$$$0(2);
            }
            DfType fromQualifier = super.getFromQualifier(dfType);
            DfType unboxedType = TypeConstraint.fromDfType(dfType).getUnboxedType();
            if (unboxedType != DfType.BOTTOM) {
                DfType dfType2 = fromQualifier.meet(unboxedType);
                if (dfType2 == null) {
                    4.$$$reportNull$$$0(3);
                }
                return dfType2;
            }
            DfType dfType3 = fromQualifier;
            if (dfType3 == null) {
                4.$$$reportNull$$$0(4);
            }
            return dfType3;
        }

        @Override
        @NotNull
        public DfType getDefaultValue() {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                4.$$$reportNull$$$0(5);
            }
            return dfType;
        }

        @Override
        public boolean isMyQualifierType(DfType type) {
            return TypeConstraint.fromDfType(type).isPrimitiveWrapper();
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && UNBOXING_CALL.methodMatches((PsiMethod)accessor);
        }

        public boolean equalityImpliesQualifierEquality() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField$4";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dfType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField$4";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFromQualifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFromQualifier";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }
    ,
    OPTIONAL_VALUE("value", "special.field.optional.value", true){

        @Override
        @NotNull
        public DfType getDfType(@Nullable DfaVariableValue qualifier) {
            if (qualifier == null) {
                DfType dfType = DfType.TOP;
                if (dfType == null) {
                    5.$$$reportNull$$$0(0);
                }
                return dfType;
            }
            TypeConstraint qualifierType = TypeConstraint.fromDfType(qualifier.getDfType());
            String type = null;
            if (qualifierType.isExact("java.util.OptionalInt")) {
                type = "java.lang.Integer";
            } else if (qualifierType.isExact("java.util.OptionalLong")) {
                type = "java.lang.Long";
            } else if (qualifierType.isExact("java.util.OptionalDouble")) {
                type = "java.lang.Double";
            }
            if (type != null) {
                DfType dfType = DfTypes.typedObject(JavaPsiFacade.getElementFactory((Project)qualifier.getFactory().getProject()).createTypeFromText(type, null), Nullability.UNKNOWN);
                if (dfType == null) {
                    5.$$$reportNull$$$0(1);
                }
                return dfType;
            }
            DfReferenceType dfReferenceType = DfTypes.OBJECT_OR_NULL;
            if (dfReferenceType == null) {
                5.$$$reportNull$$$0(2);
            }
            return dfReferenceType;
        }

        @NotNull
        public DfType getInitialDfType(@NotNull DfaVariableValue thisValue, @Nullable PsiElement context) {
            if (thisValue == null) {
                5.$$$reportNull$$$0(3);
            }
            DfType dfType = this.getDfType(thisValue.getQualifier()).meet((DfType)DfaNullability.NULLABLE.asDfType());
            if (dfType == null) {
                5.$$$reportNull$$$0(4);
            }
            return dfType;
        }

        @Override
        @NotNull
        public DfType getDefaultValue() {
            DfReferenceType dfReferenceType = DfaNullability.NULLABLE.asDfType();
            if (dfReferenceType == null) {
                5.$$$reportNull$$$0(5);
            }
            return dfReferenceType;
        }

        @Override
        public boolean isMyQualifierType(DfType type) {
            TypeConstraint constraint = TypeConstraint.fromDfType(type);
            return constraint.isExact("java.util.Optional") || constraint.isExact("java.util.OptionalDouble") || constraint.isExact("java.util.OptionalInt") || constraint.isExact("java.util.OptionalLong") || constraint.isSubtypeOf("com.google.common.base.Optional");
        }

        @Override
        public String getPresentationText(@NotNull DfType dfType, @Nullable PsiType type) {
            if (dfType == null) {
                5.$$$reportNull$$$0(6);
            }
            if (dfType == DfTypes.NULL) {
                return JavaAnalysisBundle.message((String)"dftype.presentation.empty.optional", (Object[])new Object[0]);
            }
            if (!dfType.isSuperType((DfType)DfTypes.NULL)) {
                return JavaAnalysisBundle.message((String)"dftype.presentation.present.optional", (Object[])new Object[0]);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField$5";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thisValue";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dfType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfType";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField$5";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialDfType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getInitialDfType";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 6 -> new IllegalArgumentException(string);
            };
        }
    }
    ,
    ENUM_ORDINAL("ordinal", "special.field.enum.ordinal", true){
        private static final CallMatcher ENUM_ORDINAL_METHOD = CallMatcher.instanceCall("java.lang.Enum", "ordinal").parameterCount(0);

        @Override
        @NotNull
        public DfType getDfType(@Nullable DfaVariableValue qualifier) {
            TypeConstraint constraint;
            if (qualifier != null && (constraint = TypeConstraint.fromDfType(qualifier.getDfType())).isExact()) {
                PsiClass cls = PsiUtil.resolveClassInClassTypeOnly((PsiType)constraint.getPsiType(qualifier.getFactory().getProject()));
                if (cls instanceof PsiEnumConstantInitializer) {
                    cls = cls.getSuperClass();
                }
                if (cls != null) {
                    long count = Arrays.stream(cls.getFields()).filter(field -> field instanceof PsiEnumConstant).count();
                    DfType dfType = DfTypes.intRange(LongRangeSet.range((long)0L, (long)count));
                    if (dfType == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    return dfType;
                }
            }
            DfType dfType = super.getDfType(qualifier);
            if (dfType == null) {
                6.$$$reportNull$$$0(1);
            }
            return dfType;
        }

        @Override
        @NotNull
        public DfType fromConstant(@Nullable Object obj) {
            PsiEnumConstant constant;
            PsiClass psiClass;
            if (obj instanceof PsiEnumConstant && (psiClass = (constant = (PsiEnumConstant)obj).getContainingClass()) != null) {
                int ordinal = 0;
                for (PsiField field : psiClass.getFields()) {
                    if (field == constant) {
                        DfIntConstantType dfIntConstantType = DfTypes.intValue(ordinal);
                        if (dfIntConstantType == null) {
                            6.$$$reportNull$$$0(2);
                        }
                        return dfIntConstantType;
                    }
                    if (!(field instanceof PsiEnumConstant)) continue;
                    ++ordinal;
                }
            }
            DfType dfType = super.fromConstant(obj);
            if (dfType == null) {
                6.$$$reportNull$$$0(3);
            }
            return dfType;
        }

        @Override
        public boolean isMyQualifierType(DfType type) {
            TypeConstraint constraint = TypeConstraint.fromDfType(type);
            return constraint.isEnum() || constraint.isSubtypeOf("java.lang.Enum");
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && ENUM_ORDINAL_METHOD.methodMatches((PsiMethod)accessor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField$6";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromConstant";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
    ,
    CONSUMED_STREAM("linkedOrConsumed", "special.field.consumed.stream", false){

        @Override
        public boolean isMyQualifierType(DfType type) {
            TypeConstraint constraint = TypeConstraint.fromDfType(type);
            return constraint.isSubtypeOf("java.util.stream.BaseStream");
        }

        @Override
        @NotNull
        public DfType getDefaultValue() {
            DfStreamStateType dfStreamStateType = DfStreamStateType.UNKNOWN;
            if (dfStreamStateType == null) {
                7.$$$reportNull$$$0(0);
            }
            return dfStreamStateType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/jvm/SpecialField$7", "getDefaultValue"));
        }
    }
    ,
    INSTANTIABLE_CLASS("instantiable", "special.field.instantiable.class", true){

        @Override
        @NotNull
        public DfType fromConstant(@Nullable Object obj) {
            if (obj instanceof PsiType) {
                PsiType type = (PsiType)obj;
                DfBooleanConstantType dfBooleanConstantType = DfTypes.booleanValue(TypeConstraints.exact(type) != TypeConstraints.BOTTOM);
                if (dfBooleanConstantType == null) {
                    8.$$$reportNull$$$0(0);
                }
                return dfBooleanConstantType;
            }
            DfType dfType = super.fromConstant(obj);
            if (dfType == null) {
                8.$$$reportNull$$$0(1);
            }
            return dfType;
        }

        @Override
        public boolean isMyQualifierType(DfType type) {
            TypeConstraint constraint = TypeConstraint.fromDfType(type);
            return constraint.isExact("java.lang.Class");
        }

        @Override
        @NotNull
        public DfType getDefaultValue() {
            DfBooleanType dfBooleanType = DfTypes.BOOLEAN;
            if (dfBooleanType == null) {
                8.$$$reportNull$$$0(2);
            }
            return dfBooleanType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField$8";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromConstant";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultValue";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    private static final SpecialField[] VALUES;
    private final String myTitle;
    @PropertyKey(resourceBundle="messages.JavaAnalysisBundle")
    private final @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String myTitleKey;
    private final boolean myFinal;

    private SpecialField(String title, String titleKey, boolean isFinal) {
        this.myTitle = title;
        this.myTitleKey = titleKey;
        this.myFinal = isFinal;
    }

    public boolean isStable() {
        return this.myFinal;
    }

    public boolean isImplicitReadPossible() {
        return true;
    }

    public abstract boolean isMyQualifierType(DfType var1);

    boolean isMyAccessor(PsiMember accessor) {
        return false;
    }

    @Nls
    public String getPresentationText(@NotNull DfType dfType, @Nullable PsiType type) {
        if (dfType == null) {
            SpecialField.$$$reportNull$$$0(0);
        }
        if (this.getDefaultValue().equals((Object)dfType)) {
            return "";
        }
        return dfType.toString();
    }

    @Contract(value="null -> null")
    @Nullable
    public static SpecialField findSpecialField(PsiElement accessor) {
        if (!(accessor instanceof PsiMember)) {
            return null;
        }
        PsiMember member = (PsiMember)accessor;
        for (SpecialField sf : VALUES) {
            if (!sf.isMyAccessor(member)) continue;
            return sf;
        }
        return null;
    }

    @NotNull
    static DfType fromInitializer(@NotNull DfaVariableValue thisValue, @Nullable PsiElement context, @NotNull Function<PsiExpression, DfType> typeByInitializer) {
        PsiExpression initializer;
        PsiField psiVariable;
        DfaVariableValue qualifier;
        if (thisValue == null) {
            SpecialField.$$$reportNull$$$0(1);
        }
        if (typeByInitializer == null) {
            SpecialField.$$$reportNull$$$0(2);
        }
        if ((qualifier = thisValue.getQualifier()) != null && (psiVariable = (PsiField)ObjectUtils.tryCast((Object)qualifier.getPsiVariable(), PsiField.class)) != null && FieldChecker.getChecker(context).canTrustFieldInitializer(psiVariable) && psiVariable.hasModifierProperty("static") && psiVariable.hasModifierProperty("final") && (initializer = PsiFieldImpl.getDetachedInitializer((PsiVariable)psiVariable)) != null) {
            DfType dfType = typeByInitializer.apply(initializer);
            if (dfType == null) {
                SpecialField.$$$reportNull$$$0(3);
            }
            return dfType;
        }
        DfType dfType = DfType.TOP;
        if (dfType == null) {
            SpecialField.$$$reportNull$$$0(4);
        }
        return dfType;
    }

    @NotNull
    public DfType getDefaultValue() {
        DfType dfType = DfTypes.intRange(JvmPsiRangeSetUtil.indexRange());
        if (dfType == null) {
            SpecialField.$$$reportNull$$$0(5);
        }
        return dfType;
    }

    @NotNull
    public DfType getDfType(@Nullable DfaVariableValue qualifier) {
        DfType dfType = this.getDefaultValue();
        if (dfType == null) {
            SpecialField.$$$reportNull$$$0(6);
        }
        return dfType;
    }

    @NotNull
    public DfType fromConstant(@Nullable Object obj) {
        DfType dfType = DfType.TOP;
        if (dfType == null) {
            SpecialField.$$$reportNull$$$0(7);
        }
        return dfType;
    }

    public MethodContract[] getEmptyContracts() {
        ContractValue thisValue = ContractValue.qualifier().specialField(this);
        return new MethodContract[]{MethodContract.singleConditionContract(thisValue, RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse())};
    }

    public MethodContract[] getEqualsContracts() {
        return new MethodContract[]{new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE}, ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.qualifier().specialField(this), RelationType.NE, ContractValue.argument(0).specialField(this), ContractReturnValue.returnFalse())};
    }

    @NotNull
    public DfType asDfType(@NotNull DfType fieldValue) {
        DfReferenceType defaultType;
        DfType clamped;
        if (fieldValue == null) {
            SpecialField.$$$reportNull$$$0(8);
        }
        if ((clamped = fieldValue.meet((DfType)(defaultType = this == OPTIONAL_VALUE ? DfTypes.OBJECT_OR_NULL : this.getDefaultValue()))).equals((Object)defaultType)) {
            DfReferenceType dfReferenceType = DfTypes.NOT_NULL_OBJECT;
            if (dfReferenceType == null) {
                SpecialField.$$$reportNull$$$0(9);
            }
            return dfReferenceType;
        }
        if (clamped.equals((Object)DfType.BOTTOM)) {
            DfType dfType = DfType.BOTTOM;
            if (dfType == null) {
                SpecialField.$$$reportNull$$$0(10);
            }
            return dfType;
        }
        DfReferenceType dfReferenceType = DfTypes.customObject(TypeConstraints.TOP, DfaNullability.NOT_NULL, Mutability.UNKNOWN, this, clamped);
        if (dfReferenceType == null) {
            SpecialField.$$$reportNull$$$0(11);
        }
        return dfReferenceType;
    }

    @NotNull
    public DfType asDfType(@NotNull DfType qualifierType, @NotNull DfType fieldValue) {
        TypeConstraint qualifier;
        PsiEnumConstant constant;
        Integer constValue;
        if (qualifierType == null) {
            SpecialField.$$$reportNull$$$0(12);
        }
        if (fieldValue == null) {
            SpecialField.$$$reportNull$$$0(13);
        }
        if (this == STRING_LENGTH && fieldValue.isConst((Object)0)) {
            DfConstantType<?> dfConstantType = DfTypes.referenceConstant((Object)"", TypeConstraint.fromDfType(qualifierType));
            if (dfConstantType == null) {
                SpecialField.$$$reportNull$$$0(14);
            }
            return dfConstantType;
        }
        if (this == ENUM_ORDINAL && (constValue = (Integer)fieldValue.getConstantOfType(Integer.class)) != null && (constant = (qualifier = TypeConstraint.fromDfType(qualifierType)).getEnumConstant(constValue)) != null) {
            DfConstantType<?> dfConstantType = DfTypes.referenceConstant((Object)constant, TypeConstraint.fromDfType(qualifierType));
            if (dfConstantType == null) {
                SpecialField.$$$reportNull$$$0(15);
            }
            return dfConstantType;
        }
        DfType dfType = this.asDfType(fieldValue).meet(qualifierType);
        if (dfType == null) {
            SpecialField.$$$reportNull$$$0(16);
        }
        return dfType;
    }

    @Nullable
    public static SpecialField fromQualifierType(@NotNull DfType type) {
        if (type == null) {
            SpecialField.$$$reportNull$$$0(17);
        }
        if (type instanceof DfReferenceType && ((DfReferenceType)type).getSpecialField() != null) {
            return ((DfReferenceType)type).getSpecialField();
        }
        for (SpecialField value : VALUES) {
            if (!value.isMyQualifierType(type)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    @Nls
    public String getPresentationName() {
        String string = JavaAnalysisBundle.message((String)this.myTitleKey, (Object[])new Object[0]);
        if (string == null) {
            SpecialField.$$$reportNull$$$0(18);
        }
        return string;
    }

    public String toString() {
        return this.myTitle;
    }

    static {
        VALUES = SpecialField.values();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 9, 10, 11, 14, 15, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeByInitializer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/SpecialField";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromInitializer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromConstant";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "asDfType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromInitializer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "asDfType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fromQualifierType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 9, 10, 11, 14, 15, 16, 18 -> new IllegalStateException(string);
        };
    }
}

