/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class Java9ModuleExportsPackageToItselfInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.MODULES);
        if (set == null) {
            Java9ModuleExportsPackageToItselfInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            Java9ModuleExportsPackageToItselfInspection.$$$reportNull$$$0(1);
        }
        Object object = PsiUtil.isModuleFile((PsiFile)holder.getFile()) ? new ExportedToSelfVisitor(holder) : PsiElementVisitor.EMPTY_VISITOR;
        if (object == null) {
            Java9ModuleExportsPackageToItselfInspection.$$$reportNull$$$0(2);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ExportedToSelfVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        ExportedToSelfVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitPackageAccessibilityStatement(@NotNull PsiPackageAccessibilityStatement statement) {
            if (statement == null) {
                ExportedToSelfVisitor.$$$reportNull$$$0(0);
            }
            super.visitPackageAccessibilityStatement(statement);
            PsiJavaModule javaModule = (PsiJavaModule)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiJavaModule.class);
            if (javaModule != null) {
                String moduleName = javaModule.getName();
                ArrayList references = ContainerUtil.newArrayList((Iterable)statement.getModuleReferences());
                for (PsiJavaModuleReferenceElement referenceElement : references) {
                    String fixText;
                    if (!moduleName.equals(referenceElement.getReferenceText())) continue;
                    String message = JavaAnalysisBundle.message((String)"inspection.module.exports.package.to.itself", (Object[])new Object[0]);
                    if (references.size() == 1) {
                        fixText = JavaAnalysisBundle.message((String)"exports.to.itself.delete.statement.fix", (Object[])new Object[0]);
                        this.myHolder.registerProblem((PsiElement)referenceElement, message, new LocalQuickFix[]{QuickFixFactory.getInstance().createDeleteFix((PsiElement)statement, fixText)});
                        continue;
                    }
                    fixText = JavaAnalysisBundle.message((String)"exports.to.itself.delete.module.ref.fix", (Object[])new Object[]{moduleName});
                    this.myHolder.registerProblem((PsiElement)referenceElement, message, new LocalQuickFix[]{QuickFixFactory.getInstance().createDeleteFix((PsiElement)referenceElement, fixText)});
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection$ExportedToSelfVisitor", "visitPackageAccessibilityStatement"));
        }
    }
}

